/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jay.yydebug.yyDebug;

public class yyAnimPanel
extends Panel
implements yyDebug {
    protected transient TextField token;
    protected transient TextField value;
    protected transient TextArea comments;
    protected transient Stack stack;
    protected transient boolean tokenBreak = true;
    protected transient boolean stackBreak;
    protected transient boolean commentsBreak;

    public yyAnimPanel(Font font) {
        super(new BorderLayout());
        Panel panel = new Panel(new BorderLayout());
        Checkbox checkbox = new Checkbox("token ", this.tokenBreak);
        panel.add((Component)checkbox, "West");
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                yyAnimPanel.this.tokenBreak = itemEvent.getStateChange() == 1;
            }
        });
        Panel panel2 = new Panel(new BorderLayout());
        this.token = new TextField(12);
        panel2.add((Component)this.token, "West");
        this.token.setEditable(false);
        this.token.setBackground(Color.white);
        this.token.setFont(font);
        this.value = new TextField(24);
        panel2.add((Component)this.value, "Center");
        this.value.setEditable(false);
        this.value.setBackground(Color.white);
        this.value.setFont(font);
        panel.add((Component)panel2, "Center");
        Button button = new Button(" continue ");
        panel.add((Component)button, "East");
        button.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                yyAnimPanel yyAnimPanel2 = yyAnimPanel.this;
                synchronized (yyAnimPanel2) {
                    yyAnimPanel.this.notify();
                }
            }
        });
        this.add((Component)panel, "North");
        panel = new Panel(new BorderLayout());
        panel2 = new Panel(new BorderLayout());
        checkbox = new Checkbox("stack", this.stackBreak);
        panel2.add((Component)checkbox, "North");
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                yyAnimPanel.this.stackBreak = itemEvent.getStateChange() == 1;
            }
        });
        this.stack = new Stack(font);
        panel2.add((Component)this.stack, "Center");
        panel.add((Component)panel2, "Center");
        panel2 = new Panel(new BorderLayout());
        checkbox = new Checkbox("comments", this.commentsBreak);
        panel2.add((Component)checkbox, "North");
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                yyAnimPanel.this.commentsBreak = itemEvent.getStateChange() == 1;
            }
        });
        this.comments = new TextArea(10, 40);
        panel2.add((Component)this.comments, "Center");
        this.comments.setEditable(false);
        this.comments.setBackground(Color.white);
        this.comments.setFont(font);
        panel.add((Component)panel2, "East");
        this.add((Component)panel, "Center");
    }

    protected synchronized void explain(String string) {
        if (this.comments.getText().length() > 0) {
            this.comments.append("\n");
        }
        this.comments.append(string);
        if (this.commentsBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void lex(int n, int n2, String string, Object object) {
        this.token.setText(string);
        this.value.setText(object == null ? "" : object.toString());
        this.explain("read " + string);
        if (this.tokenBreak && !this.commentsBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void shift(int n, int n2, int n3) {
        switch (n3) {
            default: {
                this.explain("shift to " + n2);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.explain("shift to " + n2 + ", " + n3 + " left to recover");
                break;
            }
            case 3: {
                this.explain("shift to " + n2 + " on error");
            }
        }
    }

    public void discard(int n, int n2, String string, Object object) {
        this.explain("discard token " + string + ", value " + object);
    }

    public void shift(int n, int n2) {
        this.explain("go to " + n2);
    }

    public synchronized void accept(Object object) {
        this.explain("accept, value " + object);
        this.stack.pop();
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void error(String string) {
        this.explain("error message");
    }

    public void reject() {
        this.explain("reject");
        this.stack.pop();
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void push(int n, Object object) {
        this.stack.push(n, object);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void pop(int n) {
        this.explain("pop " + n + " on error");
        this.stack.pop(1);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void reduce(int n, int n2, int n3, String string, int n4) {
        this.explain("reduce (" + n3 + "), uncover " + n2 + "\n(" + n3 + ") " + string);
        this.stack.pop(n4);
        if (this.stackBreak) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected static final class Stack
    extends ScrollPane {
        protected static final GridBagConstraints level = new GridBagConstraints();
        protected final Font font;
        protected final Panel panel;

        public Stack(Font font) {
            super(0);
            this.font = font;
            this.setSize(50, 100);
            this.panel = new Panel(new GridBagLayout());
            this.add(this.panel);
        }

        public void push(int n, Object object) {
            Panel panel = new Panel(new BorderLayout());
            TextField textField = new TextField("" + n, 5);
            panel.add((Component)textField, "West");
            textField.setEditable(false);
            textField.setBackground(Color.white);
            textField.setFont(this.font);
            textField = new TextField(object != null ? object.toString() : "");
            panel.add((Component)textField, "Center");
            textField.setEditable(false);
            textField.setBackground(Color.white);
            textField.setFont(this.font);
            this.panel.add(panel, level, 0);
            this.validate();
        }

        public void pop(int n) {
            for (int i = 0; i < n; ++i) {
                this.panel.remove(0);
                this.validate();
            }
        }

        public void pop() {
            this.panel.removeAll();
            this.validate();
        }

        static {
            Stack.level.anchor = 11;
            Stack.level.fill = 2;
            Stack.level.gridheight = 1;
            Stack.level.gridwidth = 0;
            Stack.level.gridx = 0;
            Stack.level.gridy = -1;
            Stack.level.weightx = 1.0;
        }
    }
}

