/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public final class NewJ2SEPlatform
extends J2SEPlatformImpl
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(NewJ2SEPlatform.class.getName());
    private static Set<String> propertiesToFix = new HashSet<String>();
    private boolean valid;

    public static NewJ2SEPlatform create(FileObject installFolder) throws IOException {
        assert (installFolder != null);
        HashMap<String, String> platformProperties = new HashMap<String, String>();
        return new NewJ2SEPlatform(null, Collections.singletonList(installFolder.getURL()), platformProperties, Collections.<String, String>emptyMap());
    }

    private NewJ2SEPlatform(String name, List<URL> installFolders, Map<String, String> platformProperties, Map<String, String> systemProperties) {
        super(name, name, installFolders, platformProperties, systemProperties, null, null);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void run() {
        try {
            for (String toolName : PlatformConvertor.IMPORTANT_TOOLS) {
                if (this.findTool(toolName) != null) continue;
                return;
            }
            FileObject java = this.findTool("java");
            if (java == null) {
                return;
            }
            File javaFile = FileUtil.toFile((FileObject)java);
            if (javaFile == null) {
                return;
            }
            String javapath = javaFile.getAbsolutePath();
            String filePath = File.createTempFile("nb-platformdetect", "properties").getAbsolutePath();
            String probePath = this.getSDKProperties(javapath, filePath);
            File f = new File(filePath);
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(f);
            p.load(is);
            HashMap<String, String> m = new HashMap<String, String>(p.size());
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                String v = p.getProperty(k);
                if ("java.class.path".equals(k)) {
                    v = NewJ2SEPlatform.filterProbe(v, probePath);
                } else if ("user.dir".equals(k)) {
                    v = "";
                }
                v = this.fixSymLinks(k, v);
                m.put(k, v);
            }
            this.setSystemProperties(m);
            this.valid = true;
            ((InputStream)is).close();
            f.delete();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot execute probe process", ex);
            this.valid = false;
        }
    }

    private String fixSymLinks(String key, String value) {
        if (Utilities.isUnix() && propertiesToFix.contains(key)) {
            try {
                String[] pathElements = value.split(File.pathSeparator);
                boolean changed = false;
                Iterator<FileObject> it = this.getInstallFolders().iterator();
                while (it.hasNext()) {
                    String canonicalPath;
                    String path;
                    File f = FileUtil.toFile((FileObject)it.next());
                    if (f == null || (path = f.getAbsolutePath()).equals(canonicalPath = f.getCanonicalPath())) continue;
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (!pathElements[i].startsWith(canonicalPath)) continue;
                        pathElements[i] = path + pathElements[i].substring(canonicalPath.length());
                        changed = true;
                    }
                }
                if (changed) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (i > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(pathElements[i]);
                    }
                    return sb.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    private String getSDKProperties(String javaPath, String path) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] command = new String[]{javaPath, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-java-j2seplatform-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.java.j2seplatform.wizard.SDKProbe", path};
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Executing: %s %s %s %s %s", command[0], command[1], command[2], command[3], command[4]));
            }
            Process process = runtime.exec(command);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new IOException();
            }
            return command[2];
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    static {
        propertiesToFix.add("sun.boot.class.path");
        propertiesToFix.add("sun.boot.library.path");
        propertiesToFix.add("java.library.path");
        propertiesToFix.add("java.ext.dirs");
        propertiesToFix.add("java.home");
    }
}

