/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.TestUnitRunner;
import org.netbeans.modules.ruby.testrunner.ui.AutotestHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class AutotestRunner
implements TestRunner {
    private static final Logger LOGGER = Logger.getLogger(AutotestRunner.class.getName());
    private static final TestRunner INSTANCE = new AutotestRunner();
    static final String AUTOTEST_LOADER = "nb_autotest_loader.rb";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType type) {
        return TestRunner.TestType.AUTOTEST == type;
    }

    public void runTest(FileObject testFile, boolean debug) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runSingleTest(FileObject testFile, String testMethod, boolean debug) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runAllTests(Project project, boolean debug) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (!platform.hasValidAutoTest(true)) {
            return;
        }
        String displayName = NbBundle.getMessage(AutotestRunner.class, (String)"AutoTest", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        LineConvertors.FileLocator locator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, FileUtil.toFile((FileObject)project.getProjectDirectory()), platform.getAutoTest());
        TestRunnerUtilities.addProperties(desc, project);
        desc.addInitialArgs("-r \"" + AutotestRunner.getLoaderScript().getAbsolutePath() + "\"");
        HashMap<String, String> env = new HashMap<String, String>(2);
        TestUnitRunner.addTestUnitRunnerToEnv(env);
        desc.addAdditionalEnv(env);
        desc.debug(debug);
        desc.allowInput();
        desc.fileLocator(locator);
        desc.addStandardRecognizers();
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)project);
        if (coverageProvider != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        TestSession session = new TestSession(displayName, project, debug ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        TestExecutionManager.getInstance().start(desc, new AutotestHandlerFactory(), session);
    }

    private static File getLoaderScript() {
        File mediatorScript = InstalledFileLocator.getDefault().locate(AUTOTEST_LOADER, "org.netbeans.modules.ruby.testrunner", false);
        if (mediatorScript == null) {
            throw new IllegalStateException("Could not locate nb_autotest_loader.rb");
        }
        return mediatorScript;
    }
}

