/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.spi.DBConnectionProvider;

public final class DBConnectionFactory {
    private static volatile DBConnectionFactory INSTANCE = null;
    private volatile Throwable ex = null;
    private static Logger mLogger = Logger.getLogger(DBConnectionFactory.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnectionFactory getInstance() {
        Class<DBConnectionFactory> clazz = DBConnectionFactory.class;
        synchronized (DBConnectionFactory.class) {
            if (INSTANCE == null && INSTANCE == null) {
                INSTANCE = new DBConnectionFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DBConnectionFactory() {
    }

    public void closeConnection(Connection con) {
        DBConnectionProvider connectionProvider = this.findDBConnectionProvider();
        if (connectionProvider != null) {
            connectionProvider.closeConnection(con);
        }
    }

    public Connection getConnection(DatabaseConnection dbConn) {
        DBConnectionProvider connectionProvider = this.findDBConnectionProvider();
        this.ex = null;
        try {
            if (connectionProvider != null) {
                return connectionProvider.getConnection(dbConn);
            }
            return this.showConnectionDialog(dbConn);
        }
        catch (Exception e) {
            mLogger.log(Level.WARNING, "Failed to set connection:" + e);
            this.ex = e;
            return null;
        }
    }

    public Throwable getLastException() {
        return this.ex;
    }

    private Connection showConnectionDialog(DatabaseConnection dbConn) {
        if (dbConn == null) {
            return null;
        }
        Connection conn = dbConn.getJDBCConnection(!SwingUtilities.isEventDispatchThread());
        if (conn == null) {
            ConnectionManager.getDefault().showConnectionDialog(dbConn);
            return dbConn.getJDBCConnection(!SwingUtilities.isEventDispatchThread());
        }
        return conn;
    }

    private DBConnectionProvider findDBConnectionProvider() {
        Iterator<DBConnectionProvider> it = ServiceRegistry.lookupProviders(DBConnectionProvider.class);
        if (it.hasNext()) {
            return it.next();
        }
        ClassLoader loader = DBConnectionFactory.class.getClassLoader();
        it = ServiceRegistry.lookupProviders(DBConnectionProvider.class, loader);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

