/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.ButtonPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.Models;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CodeEvaluator
extends TopComponent
implements HelpCtx.Provider,
DocumentListener,
KeyListener,
PropertyChangeListener {
    private static final String ID = "evaluator";
    private static final String PROP_RESULT_CHANGED = "resultChanged";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static WeakReference<CodeEvaluator> instanceRef;
    private JEditorPane codePane;
    private volatile String codeText = "";
    private History history;
    private Reference<JPDADebugger> debuggerRef = new WeakReference<Object>(null);
    private DbgManagerListener dbgManagerListener;
    private TopComponent resultView;
    private Set<String> editItemsSet = new HashSet<String>();
    private ArrayList<String> editItemsList = new ArrayList();
    private JButton dropDownButton;
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private HistoryRecord lastEvaluationRecord = null;
    private Variable result;
    private static RequestProcessor rp;
    private RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private RequestProcessor.Task setupContextTask;
    private JScrollPane editorScrollPane;
    private JButton evaluateButton;
    private JPanel rightPanel;
    private JPanel separatorPanel;

    public CodeEvaluator() {
        this.initComponents();
        this.codePane = new JEditorPane();
        this.codePane.setMinimumSize(new Dimension(0, 0));
        this.history = new History();
        this.dropDownButton = this.createDropDownButton();
        GroupLayout groupLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.dropDownButton).addPreferredGap(0, 2, 2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 2, 2).add((Component)this.evaluateButton).addPreferredGap(0, 2, 2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.dropDownButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.evaluateButton)));
        this.editorScrollPane.setViewportView(this.codePane);
        this.codePane.addKeyListener(this);
        this.dbgManagerListener = new DbgManagerListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentSession", (DebuggerManagerListener)this.dbgManagerListener);
        this.checkDebuggerState();
    }

    public static RequestProcessor getRequestProcessor() {
        return rp;
    }

    public void pasteExpression(String string) {
        this.codePane.setText(string);
        this.codeText = string;
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    private JButton createDropDownButton() {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/drop_down_arrow.png", (boolean)false);
        DropDownButton dropDownButton = new DropDownButton();
        dropDownButton.setIcon(imageIcon);
        String string = NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Expressions_Dropdown_tooltip");
        dropDownButton.setToolTipText(string);
        dropDownButton.setEnabled(false);
        Dimension dimension = new Dimension(imageIcon.getIconWidth() + 3, imageIcon.getIconHeight() + 2);
        dropDownButton.setPreferredSize(dimension);
        dropDownButton.setMargin(new Insets(0, 0, 0, 0));
        dropDownButton.setFocusable(false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("pressed".equals(actionEvent.getActionCommand())) {
                    Object object;
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    Point point = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(point, jComponent);
                    if (!ButtonPopupSwitcher.isShown()) {
                        object = CodeEvaluator.this.createSwitcherItems();
                        ButtonPopupSwitcher.selectItem(jComponent, (SwitcherTableItem[])object, point.x, point.y);
                    }
                    if (jComponent instanceof AbstractButton) {
                        object = (AbstractButton)jComponent;
                        ((AbstractButton)object).getModel().setPressed(false);
                        ((AbstractButton)object).getModel().setRollover(false);
                        ((AbstractButton)object).getModel().setArmed(false);
                        ((Component)object).repaint();
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return !CodeEvaluator.this.editItemsList.isEmpty();
            }
        };
        abstractAction.putValue("SmallIcon", imageIcon);
        abstractAction.putValue("ShortDescription", string);
        dropDownButton.setAction(abstractAction);
        return dropDownButton;
    }

    private void setupContext() {
        if (this.setupContextTask == null) {
            this.setupContextTask = rp.create(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluator.this.setupContextLazily();
                }
            });
        }
        this.setupContextTask.schedule(500);
    }

    private void setupContextLazily() {
        final String string = this.codeText;
        final Document[] documentArray = new Document[]{null};
        class ContextUpdated
        implements ActionListener,
        Runnable {
            ContextUpdated() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.run();
            }

            @Override
            public void run() {
                if (CodeEvaluator.this.codePane.getDocument() != documentArray[0]) {
                    CodeEvaluator.this.codePane.getDocument().addDocumentListener(CodeEvaluator.this);
                    if (string != null) {
                        CodeEvaluator.this.codePane.setText(string);
                    }
                }
                documentArray[0] = CodeEvaluator.this.codePane.getDocument();
            }
        }
        ContextUpdated contextUpdated = new ContextUpdated();
        WatchPanel.setupContext(this.codePane, contextUpdated);
        SwingUtilities.invokeLater(contextUpdated);
    }

    private SwitcherTableItem[] createSwitcherItems() {
        SwitcherTableItem[] switcherTableItemArray = new SwitcherTableItem[this.editItemsList.size()];
        int n = 0;
        for (String string : this.editItemsList) {
            switcherTableItemArray[n++] = new SwitcherTableItem(new MenuItemActivatable(string), string);
        }
        return switcherTableItemArray;
    }

    public void recomputeDropDownItems() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String string : CodeEvaluator.this.editItemsList) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    String string2 = "";
                    while (string2.trim().length() == 0 && stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                }
                CodeEvaluator.this.dropDownButton.setEnabled(!CodeEvaluator.this.editItemsList.isEmpty());
            }
        });
    }

    public static synchronized CodeEvaluator getInstance() {
        CodeEvaluator codeEvaluator = (CodeEvaluator)WindowManager.getDefault().findTopComponent(ID);
        if (codeEvaluator == null) {
            codeEvaluator = new CodeEvaluator();
        }
        return codeEvaluator;
    }

    private static CodeEvaluator getDefaultInstance() {
        CodeEvaluator codeEvaluator;
        CodeEvaluator codeEvaluator2 = codeEvaluator = instanceRef != null ? (CodeEvaluator)instanceRef.get() : null;
        if (codeEvaluator != null) {
            return codeEvaluator;
        }
        final CodeEvaluator[] codeEvaluatorArray = new CodeEvaluator[1];
        if (SwingUtilities.isEventDispatchThread()) {
            codeEvaluatorArray[0] = CodeEvaluator.getInstance();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        codeEvaluatorArray[0] = CodeEvaluator.getInstance();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        instanceRef = new WeakReference<CodeEvaluator>(codeEvaluatorArray[0]);
        return codeEvaluatorArray[0];
    }

    public static ArrayList<History.Item> getHistory() {
        CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
        return codeEvaluator != null ? codeEvaluator.history.getItems() : new ArrayList<History.Item>();
    }

    public static Variable getResult() {
        CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
        return codeEvaluator != null ? codeEvaluator.result : null;
    }

    public static String getExpressionText() {
        CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
        HistoryRecord historyRecord = codeEvaluator != null ? codeEvaluator.lastEvaluationRecord : null;
        return historyRecord != null ? historyRecord.expr : "";
    }

    public static void addResultListener(final PropertyChangeListener propertyChangeListener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
                if (codeEvaluator != null) {
                    PropertyChangeSupport propertyChangeSupport = codeEvaluator.pcs;
                    synchronized (propertyChangeSupport) {
                        codeEvaluator.pcs.addPropertyChangeListener(propertyChangeListener);
                    }
                }
            }
        });
    }

    public static void removeResultListener(final PropertyChangeListener propertyChangeListener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
                if (codeEvaluator != null) {
                    PropertyChangeSupport propertyChangeSupport = codeEvaluator.pcs;
                    synchronized (propertyChangeSupport) {
                        codeEvaluator.pcs.removePropertyChangeListener(propertyChangeListener);
                    }
                }
            }
        });
    }

    private static void fireResultChange() {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluator codeEvaluator = CodeEvaluator.getDefaultInstance();
                if (codeEvaluator != null) {
                    PropertyChangeSupport propertyChangeSupport = codeEvaluator.pcs;
                    synchronized (propertyChangeSupport) {
                        codeEvaluator.pcs.firePropertyChange(CodeEvaluator.PROP_RESULT_CHANGED, null, null);
                    }
                }
            }
        });
    }

    private synchronized void checkDebuggerState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPDADebugger jPDADebugger;
                DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
                JPDADebugger jPDADebugger2 = null;
                if (debuggerEngine != null) {
                    jPDADebugger2 = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
                }
                if (jPDADebugger2 != (jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get())) {
                    CodeEvaluator.this.setupContext();
                }
                if (jPDADebugger != null && jPDADebugger2 != jPDADebugger) {
                    jPDADebugger.removePropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)CodeEvaluator.this);
                    jPDADebugger.removePropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                    CodeEvaluator.this.debuggerRef = new WeakReference<Object>(null);
                    CodeEvaluator.this.displayResult(null);
                }
                if (jPDADebugger2 != null) {
                    CodeEvaluator.this.debuggerRef = new WeakReference<JPDADebugger>(jPDADebugger2);
                    jPDADebugger2.addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)CodeEvaluator.this);
                    jPDADebugger2.addPropertyChangeListener("classesFixed", (PropertyChangeListener)CodeEvaluator.this);
                    jPDADebugger2.addPropertyChangeListener("state", (PropertyChangeListener)CodeEvaluator.this);
                } else {
                    CodeEvaluator.this.history.clear();
                }
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    private void computeEvaluationButtonState() {
        JPDADebugger jPDADebugger = this.debuggerRef.get();
        boolean bl = jPDADebugger != null && jPDADebugger.getCurrentThread() != null && jPDADebugger.getState() == 3 && this.codePane.getDocument().getLength() > 0 && this.editorScrollPane.getViewport().getView() == this.codePane;
        this.evaluateButton.setEnabled(bl);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
    }

    private void initComponents() {
        this.evaluateButton = new JButton();
        this.editorScrollPane = new JScrollPane();
        this.separatorPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.evaluateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/jpda/resources/evaluate.png")));
        this.evaluateButton.setText(NbBundle.getMessage(CodeEvaluator.class, (String)"CodeEvaluator.evaluateButton.text"));
        this.evaluateButton.setToolTipText(NbBundle.getMessage(CodeEvaluator.class, (String)"HINT_Evaluate_Button"));
        this.evaluateButton.setEnabled(false);
        this.evaluateButton.setPreferredSize(new Dimension(38, 22));
        this.evaluateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeEvaluator.this.evaluateButtonActionPerformed(actionEvent);
            }
        });
        this.editorScrollPane.setBorder(null);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setMaximumSize(new Dimension(1, Short.MAX_VALUE));
        this.separatorPanel.setMinimumSize(new Dimension(1, 10));
        this.separatorPanel.setPreferredSize(new Dimension(1, 10));
        this.rightPanel.setMinimumSize(new Dimension(0, 0));
        this.rightPanel.setPreferredSize(new Dimension(48, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this.rightPanel);
        this.rightPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 48, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 22, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.editorScrollPane, -1, 450, Short.MAX_VALUE).add((Component)this.separatorPanel, -2, -1, -2).add((Component)this.rightPanel, -2, -1, -2)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.editorScrollPane, -1, 22, Short.MAX_VALUE).add((Component)this.separatorPanel, -1, 22, Short.MAX_VALUE).add((Component)this.rightPanel, -1, 22, Short.MAX_VALUE));
    }

    private void evaluateButtonActionPerformed(ActionEvent actionEvent) {
        this.evaluate();
    }

    public static void openEvaluator() {
        String string = null;
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (jEditorPane != null) {
            string = jEditorPane.getSelectedText();
        }
        CodeEvaluator codeEvaluator = CodeEvaluator.getInstance();
        codeEvaluator.open();
        if (string != null) {
            codeEvaluator.codePane.setText(string);
            codeEvaluator.codeText = string;
        }
        codeEvaluator.codePane.selectAll();
        codeEvaluator.requestActive();
    }

    public boolean requestFocusInWindow() {
        this.codePane.requestFocusInWindow();
        return super.requestFocusInWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_name");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Code_Evaluator_tooltip");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("EvaluateCode");
    }

    public String getExpression() {
        return this.codeText;
    }

    public void evaluate() {
        this.evalTask.schedule(10);
    }

    private void displayResult(Variable variable) {
        this.result = variable;
        if (variable == null) {
            CodeEvaluator.fireResultChange();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CodeEvaluator.this.preferences.getBoolean("show_evaluator_result", true)) {
                    TopComponent topComponent = WindowManager.getDefault().findTopComponent("localsView");
                    topComponent.open();
                    topComponent.requestActive();
                } else {
                    if (CodeEvaluator.this.resultView == null) {
                        CodeEvaluator.this.resultView = CodeEvaluator.this.getResultViewInstance();
                    }
                    if (CodeEvaluator.this.result != null) {
                        CodeEvaluator.this.resultView.open();
                        CodeEvaluator.this.resultView.requestActive();
                    }
                }
                CodeEvaluator.getInstance().requestActive();
                CodeEvaluator.fireResultChange();
            }
        });
    }

    private void addResultToHistory(final String string, Variable variable) {
        if (this.lastEvaluationRecord != null) {
            this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
        }
        if (variable != null) {
            String string2 = variable.getType();
            String string3 = variable.getValue();
            String string4 = "";
            if (variable instanceof ObjectVariable) {
                try {
                    string4 = ((ObjectVariable)variable).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {}
            } else {
                string4 = string3;
            }
            this.lastEvaluationRecord = new HistoryRecord(string, string2, string3, string4);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string3 = string.trim();
                if (CodeEvaluator.this.editItemsSet.contains(string3)) {
                    CodeEvaluator.this.editItemsList.remove(string3);
                    CodeEvaluator.this.editItemsList.add(0, string3);
                } else {
                    CodeEvaluator.this.editItemsList.add(0, string3);
                    CodeEvaluator.this.editItemsSet.add(string3);
                    if (CodeEvaluator.this.editItemsList.size() > 20) {
                        String string2 = (String)CodeEvaluator.this.editItemsList.remove(CodeEvaluator.this.editItemsList.size() - 1);
                        CodeEvaluator.this.editItemsSet.remove(string2);
                    }
                }
                CodeEvaluator.this.recomputeDropDownItems();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
            keyEvent.consume();
            if (this.debuggerRef.get() != null) {
                this.evaluate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    private void updateWatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEvaluator.this.computeEvaluationButtonState();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("currentCallStackFrame".equals(string) || "classesFixed".equals(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    13 var1_1 = this;
                    synchronized (var1_1) {
                        JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (jPDADebugger != null) {
                            CodeEvaluator.this.computeEvaluationButtonState();
                            CodeEvaluator.this.setupContext();
                        }
                    }
                }
            });
        } else if ("state".equals(string)) {
            CodeEvaluator codeEvaluator = this;
            synchronized (codeEvaluator) {
                JPDADebugger jPDADebugger = this.debuggerRef.get();
                if (jPDADebugger != null && jPDADebugger.getState() != 3 && this.result != null) {
                    this.history.addItem(this.lastEvaluationRecord.expr, this.lastEvaluationRecord.type, this.lastEvaluationRecord.value, this.lastEvaluationRecord.toString);
                    this.lastEvaluationRecord = null;
                    this.result = null;
                    CodeEvaluator.fireResultChange();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                        if (jPDADebugger != null && jPDADebugger.getState() == 3) {
                            CodeEvaluator.this.setupContext();
                        }
                        CodeEvaluator.this.computeEvaluationButtonState();
                    }
                });
            }
        }
    }

    public static synchronized TopComponent getResultView() {
        return new ResultView();
    }

    private synchronized TopComponent getResultViewInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("resultsView");
        if (topComponent == null) {
            topComponent = new ResultView();
        }
        return topComponent;
    }

    private void initResult(ResultView resultView) {
        JComponent jComponent = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
        resultView.add(jComponent, "Center");
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = dimension.width / 2;
        jComponent.setPreferredSize(dimension);
        jComponent.setName(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YName"));
        jComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeEvaluator.class, (String)"Evaluator.ResultA11YDescr"));
        JTextField jTextField = new JTextField();
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jComponent.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jComponent.setFocusTraversalKeys(1, set);
    }

    static {
        rp = new RequestProcessor("Debugger Evaluator", 1);
    }

    private static class HistoryRecord {
        String expr;
        String type;
        String value;
        String toString;

        HistoryRecord(String string, String string2, String string3, String string4) {
            this.expr = string;
            this.type = string2;
            this.value = string3;
            this.toString = string4;
        }
    }

    private static class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled() && mouseEvent.getID() == 501) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            }
        }

        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }

        void performAction(ActionEvent actionEvent) {
        }
    }

    private class MenuItemActivatable
    implements SwitcherTableItem.Activatable {
        String text;

        MenuItemActivatable(String string) {
            this.text = string;
        }

        @Override
        public void activate() {
            CodeEvaluator.this.codePane.setText(this.text);
            CodeEvaluator.this.codeText = this.text;
        }
    }

    private static class DbgManagerListener
    extends DebuggerManagerAdapter {
        private Reference<CodeEvaluator> codeEvaluatorRef;

        public DbgManagerListener(CodeEvaluator codeEvaluator) {
            this.codeEvaluatorRef = new WeakReference<CodeEvaluator>(codeEvaluator);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CodeEvaluator codeEvaluator = this.codeEvaluatorRef.get();
            if (codeEvaluator != null) {
                codeEvaluator.checkDebuggerState();
            }
        }
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            String string = CodeEvaluator.this.getExpression();
            if (string == null || "".equals(string)) {
                return;
            }
            try {
                JPDADebugger jPDADebugger = (JPDADebugger)CodeEvaluator.this.debuggerRef.get();
                if (jPDADebugger != null) {
                    Variable variable = jPDADebugger.evaluate(string);
                    CodeEvaluator.this.addResultToHistory(string, variable);
                    CodeEvaluator.this.displayResult(variable);
                }
            }
            catch (InvalidExpressionException invalidExpressionException) {
                String string2 = invalidExpressionException.getLocalizedMessage();
                Throwable throwable = invalidExpressionException.getTargetException();
                if (throwable != null && throwable instanceof ApplicationException) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.close();
                    string2 = string2 + " \n" + stringWriter.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeEvaluator.this.codePane.requestFocusInWindow();
                    }
                });
            }
        }
    }

    private static class ResultView
    extends TopComponent
    implements HelpCtx.Provider {
        private static final String ID = "evaluator_result";

        ResultView() {
            this.setLayout(new BorderLayout());
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public int getPersistenceType() {
            return 0;
        }

        public String getName() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_name");
        }

        public String getToolTipText() {
            return NbBundle.getMessage(CodeEvaluator.class, (String)"CTL_Evaluator_Result_tooltip");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("EvaluationResult");
        }
    }

    public static class History {
        private static final int MAX_ITEMS = 100;
        private ArrayList<Item> historyItems = new ArrayList();

        private void addItem(String string, String string2, String string3, String string4) {
            Item item = new Item(string, string2, string3, string4);
            this.historyItems.add(0, item);
            if (this.historyItems.size() > 100) {
                this.historyItems.remove(100);
            }
        }

        public ArrayList<Item> getItems() {
            return this.historyItems;
        }

        public void clear() {
            this.historyItems.clear();
        }

        public class Item {
            public String expr;
            public String type;
            public String value;
            public String toString;
            public String tooltip;
            public String exprFormatted;

            Item(String string, String string2, String string3, String string4) {
                this.expr = string;
                this.type = string2;
                this.value = string3;
                this.toString = string4;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                String string5 = string.replaceAll("&", "&amp;");
                string5 = string5.replaceAll("<", "&lt;");
                string5 = string5.replaceAll(">", "&gt;");
                string5 = string5.replaceAll("\n", "<br/>");
                string5 = string5.replaceAll("\r", "");
                stringBuffer.append(string5);
                stringBuffer.append("</html>");
                this.tooltip = stringBuffer.toString();
            }

            public String toString() {
                return this.expr;
            }
        }
    }
}

