/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    static final String[] PREDEFINED_COOKIE_CLASSES;
    private static final String[] HARDCODED_IMPORTS;
    private static final Map<String, String> CLASS_TO_CNB;
    private static final String NEW_LINE;
    private static final String INDENT = "    ";
    private static final String INDENT_2X = "        ";
    private CreatedModifiedFiles cmf;
    private boolean alwaysEnabled;
    private String[] cookieClasses;
    private boolean multiSelection;
    private String category;
    private boolean globalMenuItemEnabled;
    private String gmiParentMenuPath;
    private Position gmiPosition;
    private boolean gmiSeparatorAfter;
    private boolean gmiSeparatorBefore;
    private boolean toolbarEnabled;
    private String toolbar;
    private Position toolbarPosition;
    private boolean kbShortcutEnabled;
    private final Set<String> keyStrokes = new HashSet<String>();
    private boolean ftContextEnabled;
    private String ftContextType;
    private Position ftContextPosition;
    private boolean ftContextSeparatorAfter;
    private boolean ftContextSeparatorBefore;
    private boolean edContextEnabled;
    private String edContextType;
    private Position edContextPosition;
    private boolean edContextSeparatorAfter;
    private boolean edContextSeparatorBefore;
    private String className;
    private String displayName;
    private String origIconPath;
    private String largeIconPath;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    private void regenerate() {
        HashMap<String, Object> attrs;
        boolean actionContext;
        boolean actionProxy;
        String dashedPkgName = this.getPackageName().replace('.', '-');
        String dashedFqClassName = dashedPkgName + '-' + this.className;
        String shadow = dashedFqClassName + ".shadow";
        this.cmf = new CreatedModifiedFiles(this.getProject());
        try {
            SpecificationVersion current = this.getModuleInfo().getDependencyVersion("org.openide.awt");
            actionProxy = current == null || current.compareTo((Object)new SpecificationVersion("7.3")) >= 0;
            actionContext = current == null || current.compareTo((Object)new SpecificationVersion("7.10")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(DataModel.class.getName()).log(Level.INFO, null, ex);
            actionProxy = false;
            actionContext = false;
        }
        String actionPath = this.getDefaultPackagePath(this.className + ".java", false);
        FileObject template = CreatedModifiedFiles.getTemplate(this.alwaysEnabled ? (actionProxy ? "actionListener.java" : "callableSystemAction.java") : (actionContext ? "contextAction.java" : "cookieAction.java"));
        assert (template != null);
        String actionNameKey = "CTL_" + this.className;
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.put("CLASS_NAME", this.className);
        replaceTokens.put("PACKAGE_NAME", this.getPackageName());
        replaceTokens.put("DISPLAY_NAME_KEY", actionNameKey);
        replaceTokens.put("MODE", this.getSelectionMode());
        TreeSet<String> imports = new TreeSet<String>();
        String cName = DataModel.parseClassName(this.cookieClasses[0]);
        String cNameVar = Character.toLowerCase(cName.charAt(0)) + cName.substring(1);
        if (!actionContext) {
            imports.addAll(Arrays.asList(HARDCODED_IMPORTS));
        }
        TreeSet<String> addedFQNCs = new TreeSet<String>();
        StringBuffer cookieSB = new StringBuffer();
        if (!this.alwaysEnabled) {
            String impl;
            for (String cookieClass : this.cookieClasses) {
                if (CLASS_TO_CNB.containsKey(cookieClass)) {
                    addedFQNCs.add(cookieClass);
                }
                if (cookieSB.length() > 0) {
                    cookieSB.append(", ");
                }
                cookieSB.append(DataModel.parseClassName(cookieClass) + ".class");
            }
            replaceTokens.put("COOKIE_CLASSES_BLOCK", cookieSB.toString());
            replaceTokens.put("CONTEXT_TYPE", this.multiSelection ? "List<" + cName + ">" : cName);
            if (this.cookieClasses.length == 1) {
                if (actionContext) {
                    if (this.multiSelection) {
                        impl = "for (" + cName + ' ' + cNameVar + " : context) {\n" + INDENT_2X + "// TODO use " + cNameVar + "\n" + INDENT + "}";
                        imports.add("java.util.List");
                    } else {
                        impl = "// TODO use context";
                    }
                } else {
                    impl = cName + ' ' + cNameVar + " = activatedNodes[0].getLookup().lookup(" + cName + ".class);\n" + INDENT_2X + "// TODO use " + cNameVar;
                }
            } else {
                impl = "// TODO implement action body";
            }
            replaceTokens.put("PERFORM_ACTION_CODE", impl);
        }
        imports.addAll(addedFQNCs);
        StringBuffer importsBuffer = new StringBuffer();
        for (String imprt : imports) {
            importsBuffer.append("import " + imprt + ';' + NEW_LINE);
        }
        replaceTokens.put("IMPORTS", importsBuffer.toString());
        this.cmf.add(this.cmf.createFileWithSubstitutions(actionPath, template, replaceTokens));
        String bundlePath = this.getDefaultPackagePath("Bundle.properties", true);
        this.cmf.add(this.cmf.bundleKey(bundlePath, actionNameKey, this.displayName));
        String relativeIconPath = null;
        if (this.origIconPath != null && FileUtil.toFileObject((File)new File(this.origIconPath)) != null) {
            relativeIconPath = this.addCreateIconOperation(this.cmf, this.origIconPath);
            replaceTokens.put("ICON_RESOURCE_METHOD", DataModel.generateIconResourceMethod(relativeIconPath));
            replaceTokens.put("INITIALIZE_METHOD", "");
        } else {
            replaceTokens.put("ICON_RESOURCE_METHOD", "");
            replaceTokens.put("INITIALIZE_METHOD", DataModel.generateNoIconInitializeMethod());
        }
        if (this.isToolbarEnabled() && this.largeIconPath != null) {
            this.addCreateIconOperation(this.cmf, this.largeIconPath);
        }
        String instanceFullPath = this.category + "/" + dashedFqClassName + ".instance";
        if (!this.alwaysEnabled || !actionProxy) {
            if (!actionContext) {
                this.cmf.add(this.cmf.createLayerEntry(instanceFullPath, null, null, null, null));
            } else {
                attrs = new HashMap();
                attrs.put("instanceCreate", "methodvalue:org.openide.awt.Actions.context");
                attrs.put("delegate", "methodvalue:org.openide.awt.Actions.inject");
                attrs.put("injectable", this.getPackageName() + '.' + this.className);
                attrs.put("selectionType", this.multiSelection ? "ANY" : "EXACTLY_ONE");
                attrs.put("type", DataModel.fullClassName(this.cookieClasses[0]));
                attrs.put("noIconInMenu", Boolean.FALSE);
                if (relativeIconPath != null) {
                    attrs.put("iconBase", relativeIconPath);
                }
                attrs.put("displayName", "bundlevalue:" + this.getPackageName() + ".Bundle#" + actionNameKey);
                this.cmf.add(this.cmf.createLayerEntry(instanceFullPath, null, null, null, attrs));
            }
        } else {
            attrs = new HashMap<String, Object>();
            attrs.put("instanceCreate", "methodvalue:org.openide.awt.Actions.alwaysEnabled");
            attrs.put("delegate", "newvalue:" + this.getPackageName() + '.' + this.className);
            attrs.put("noIconInMenu", Boolean.FALSE);
            if (relativeIconPath != null) {
                attrs.put("iconBase", relativeIconPath);
            }
            attrs.put("displayName", "bundlevalue:" + this.getPackageName() + ".Bundle#" + actionNameKey);
            this.cmf.add(this.cmf.createLayerEntry(instanceFullPath, null, null, null, attrs));
        }
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        if (actionProxy) {
            this.cmf.add(this.cmf.addModuleDependency("org.openide.awt"));
        }
        if (!this.alwaysEnabled) {
            this.cmf.add(this.cmf.addModuleDependency("org.openide.nodes"));
            for (String fqn : addedFQNCs) {
                this.cmf.add(this.cmf.addModuleDependency(CLASS_TO_CNB.get(fqn)));
            }
        }
        if (this.globalMenuItemEnabled) {
            this.generateShadowWithOrderAndSeparator(this.gmiParentMenuPath, shadow, dashedFqClassName, instanceFullPath, this.gmiSeparatorBefore, this.gmiSeparatorAfter, this.gmiPosition);
        }
        if (this.toolbarEnabled) {
            this.generateShadow(this.toolbar + "/" + shadow, instanceFullPath);
            this.generateOrder(this.toolbar, this.toolbarPosition.getBefore(), shadow, this.toolbarPosition.getAfter());
        }
        if (this.kbShortcutEnabled) {
            String parentPath = "Shortcuts";
            for (String keyStroke : this.keyStrokes) {
                this.generateShadow(parentPath + "/" + keyStroke + ".shadow", instanceFullPath);
            }
        }
        if (this.ftContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.ftContextType, shadow, dashedFqClassName, instanceFullPath, this.ftContextSeparatorBefore, this.ftContextSeparatorAfter, this.ftContextPosition);
        }
        if (this.edContextEnabled) {
            this.generateShadowWithOrderAndSeparator(this.edContextType, shadow, dashedFqClassName, instanceFullPath, this.edContextSeparatorBefore, this.edContextSeparatorAfter, this.edContextPosition);
        }
    }

    private void generateShadowWithOrderAndSeparator(String parentPath, String shadow, String dashedPkgName, String instanceFullPath, boolean separatorBefore, boolean separatorAfter, Position position) {
        String sepName;
        this.generateShadow(parentPath + "/" + shadow, instanceFullPath);
        this.generateOrder(parentPath, position.getBefore(), shadow, position.getAfter());
        if (separatorBefore) {
            sepName = dashedPkgName + "-separatorBefore.instance";
            this.generateSeparator(parentPath, sepName);
            this.generateOrder(parentPath, position.getBefore(), sepName, shadow);
        }
        if (separatorAfter) {
            sepName = dashedPkgName + "-separatorAfter.instance";
            this.generateSeparator(parentPath, sepName);
            this.generateOrder(parentPath, shadow, sepName, position.getAfter());
        }
    }

    private void generateOrder(String layerPath, String before, String nue, String after) {
        this.cmf.add(this.cmf.orderLayerEntry(layerPath, before, nue, after));
    }

    boolean classExists() {
        FileObject classFO = this.getProject().getProjectDirectory().getFileObject(this.getDefaultPackagePath(this.className + ".java", false));
        return classFO != null;
    }

    private void generateShadow(String itemPath, String origInstance) {
        this.cmf.add(this.cmf.createLayerEntry(itemPath, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(itemPath, "originalFile", origInstance));
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            this.regenerate();
        }
        return this.cmf;
    }

    private void reset() {
        this.cmf = null;
    }

    void setAlwaysEnabled(boolean alwaysEnabled) {
        this.alwaysEnabled = alwaysEnabled;
    }

    boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    void setCookieClasses(String[] cookieClasses) {
        this.cookieClasses = cookieClasses;
    }

    void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    private String getSelectionMode() {
        return this.multiSelection ? "MODE_ALL" : "MODE_EXACTLY_ONE";
    }

    void setCategory(String category) {
        this.category = category;
    }

    void setClassName(String className) {
        this.reset();
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    void setDisplayName(String display) {
        this.displayName = display;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setIconPath(String origIconPath) {
        this.reset();
        this.origIconPath = origIconPath;
    }

    public String getIconPath() {
        return this.origIconPath;
    }

    @Override
    public void setPackageName(String pkg) {
        super.setPackageName(pkg);
        this.reset();
    }

    void setGlobalMenuItemEnabled(boolean globalMenuItemEnabled) {
        this.globalMenuItemEnabled = globalMenuItemEnabled;
    }

    void setGMIParentMenu(String gmiParentMenuPath) {
        this.gmiParentMenuPath = gmiParentMenuPath;
    }

    void setGMISeparatorAfter(boolean gmiSeparatorAfter) {
        this.gmiSeparatorAfter = gmiSeparatorAfter;
    }

    void setGMISeparatorBefore(boolean gmiSeparatorBefore) {
        this.gmiSeparatorBefore = gmiSeparatorBefore;
    }

    void setGMIPosition(Position position) {
        this.gmiPosition = position;
    }

    void setToolbarEnabled(boolean toolbarEnabled) {
        this.toolbarEnabled = toolbarEnabled;
    }

    boolean isToolbarEnabled() {
        return this.toolbarEnabled;
    }

    void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    void setToolbarPosition(Position position) {
        this.toolbarPosition = position;
    }

    void setKeyboardShortcutEnabled(boolean kbShortcutEnabled) {
        this.kbShortcutEnabled = kbShortcutEnabled;
    }

    void setKeyStroke(String keyStroke) {
        this.keyStrokes.add(keyStroke);
    }

    void setFileTypeContextEnabled(boolean contextEnabled) {
        this.ftContextEnabled = contextEnabled;
    }

    void setFTContextType(String contextType) {
        this.ftContextType = contextType;
    }

    void setFTContextPosition(Position position) {
        this.ftContextPosition = position;
    }

    void setFTContextSeparatorAfter(boolean separator) {
        this.ftContextSeparatorAfter = separator;
    }

    void setFTContextSeparatorBefore(boolean separator) {
        this.ftContextSeparatorBefore = separator;
    }

    void setEditorContextEnabled(boolean contextEnabled) {
        this.edContextEnabled = contextEnabled;
    }

    void setEdContextType(String contextType) {
        this.edContextType = contextType;
    }

    void setEdContextPosition(Position position) {
        this.edContextPosition = position;
    }

    void setEdContextSeparatorAfter(boolean separator) {
        this.edContextSeparatorAfter = separator;
    }

    void setEdContextSeparatorBefore(boolean separator) {
        this.edContextSeparatorBefore = separator;
    }

    private void generateSeparator(String parentPath, String sepName) {
        String sepPath = parentPath + "/" + sepName;
        this.cmf.add(this.cmf.createLayerEntry(sepPath, null, null, null, null));
        this.cmf.add(this.cmf.createLayerAttribute(sepPath, "instanceClass", "javax.swing.JSeparator"));
    }

    private static String fullClassName(String type) {
        if (type.contains(".")) {
            return type;
        }
        for (String s : PREDEFINED_COOKIE_CLASSES) {
            if (!s.endsWith(type)) continue;
            return s;
        }
        return type;
    }

    static String parseClassName(String name) {
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? name : name.substring(lastDot + 1);
    }

    private static String generateIconResourceMethod(String relativeIconPath) {
        return NEW_LINE + INDENT + "@Override" + NEW_LINE + INDENT + "protected String iconResource() {" + NEW_LINE + INDENT_2X + "return \"" + relativeIconPath + "\";" + NEW_LINE + INDENT + "}";
    }

    private static String generateNoIconInitializeMethod() {
        return "@Override" + NEW_LINE + INDENT + "protected void initialize() {" + NEW_LINE + INDENT_2X + "super.initialize();" + NEW_LINE + INDENT_2X + "// see org.openide.util.actions.SystemAction.iconResource() Javadoc for more details" + NEW_LINE + INDENT_2X + "putValue(\"noIconInMenu\", Boolean.TRUE);" + NEW_LINE + INDENT + "}" + NEW_LINE;
    }

    public void setLargeIconPath(String largeIconPath) {
        this.largeIconPath = largeIconPath;
    }

    static {
        HARDCODED_IMPORTS = new String[]{"org.openide.nodes.Node", "org.openide.util.HelpCtx", "org.openide.util.NbBundle", "org.openide.util.actions.CookieAction"};
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("org.openide.loaders.DataObject", "org.openide.loaders");
        map.put("org.openide.cookies.EditCookie", "org.openide.nodes");
        map.put("org.openide.cookies.OpenCookie", "org.openide.nodes");
        map.put("org.netbeans.api.project.Project", "org.netbeans.modules.projectapi");
        map.put("org.openide.cookies.EditorCookie", "org.openide.text");
        CLASS_TO_CNB = Collections.unmodifiableMap(map);
        PREDEFINED_COOKIE_CLASSES = new String[5];
        CLASS_TO_CNB.keySet().toArray(PREDEFINED_COOKIE_CLASSES);
        NEW_LINE = System.getProperty("line.separator");
    }

    static final class Position {
        public static final Position PROTOTYPE = new Position(null, null, "One Thing", "Another Thing");
        private String before;
        private String after;
        private String beforeName;
        private String afterName;
        private static final String POSITION_HERE = NbBundle.getMessage(DataModel.class, (String)"CTL_PositionHere");
        private static final String POSITION_SEPARATOR = " - ";

        Position(String before, String after) {
            this(before, after, null, null);
        }

        Position(String before, String after, String beforeName, String afterName) {
            this.before = before;
            this.after = after;
            this.beforeName = beforeName;
            this.afterName = afterName;
        }

        String getBefore() {
            return this.before;
        }

        String getAfter() {
            return this.after;
        }

        String getBeforeName() {
            return this.beforeName;
        }

        String getAfterName() {
            return this.afterName;
        }

        public String toString() {
            String beforeText = this.beforeName == null ? "" : this.beforeName + POSITION_SEPARATOR;
            String afterText = this.afterName == null ? "" : POSITION_SEPARATOR + this.afterName;
            return beforeText + POSITION_HERE + afterText;
        }
    }
}

