/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.netbeans.api.project.SourceGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

final class LibrariesSourceGroup
implements SourceGroup {
    private final FileObject root;
    private final String displayName;
    private final Icon icon;
    private final Icon openIcon;

    LibrariesSourceGroup(FileObject root, String displayName, Icon icon, Icon openIcon) {
        assert (root != null);
        this.root = root;
        this.displayName = displayName;
        this.icon = icon;
        this.openIcon = openIcon;
    }

    public FileObject getRootFolder() {
        return this.root;
    }

    public String getName() {
        try {
            return this.root.getURL().toExternalForm();
        }
        catch (FileStateInvalidException fsi) {
            ErrorManager.getDefault().notify((Throwable)fsi);
            return this.root.toString();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Icon getIcon(boolean opened) {
        return opened ? this.openIcon : this.icon;
    }

    public boolean contains(FileObject file) throws IllegalArgumentException {
        return this.root.equals(file) || FileUtil.isParentOf((FileObject)this.root, (FileObject)file);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LibrariesSourceGroup)) {
            return false;
        }
        LibrariesSourceGroup osg = (LibrariesSourceGroup)other;
        return this.displayName == null ? osg.displayName == null : (this.displayName.equals(osg.displayName) && this.root == null ? osg.root == null : this.root.equals(osg.root));
    }

    public int hashCode() {
        return (this.displayName == null ? 0 : this.displayName.hashCode()) << 16 | (this.root == null ? 0 : this.root.hashCode()) & 0xFFFF;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

