/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.webmvc.SpringWebModuleExtender;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SpringConfigPanelVisual
extends JPanel {
    private boolean libsInitialized = false;
    private List<SpringLibrary> springLibs = new ArrayList<SpringLibrary>();
    private SpringLibrary springLibrary;
    private final SpringWebModuleExtender extender;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DocumentListener docListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SpringConfigPanelVisual.this.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SpringConfigPanelVisual.this.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            SpringConfigPanelVisual.this.fireChange();
        }
    };
    private JComboBox cbSpringVersion;
    private JLabel dispatcherMappingLabel;
    private JTextField dispatcherMappingText;
    private JLabel dispatcherNameLabel;
    private JTextField dispatcherNameText;
    private JCheckBox includeJstlCheckBox;
    private JPanel libPanel;
    private JLabel springVersionLabel;
    private JPanel standardPanel;
    private JTabbedPane tabbedPanel;

    public SpringConfigPanelVisual(SpringWebModuleExtender springWebModuleExtender) {
        this.extender = springWebModuleExtender;
        this.initComponents();
        this.dispatcherNameText.setText(springWebModuleExtender.getDispatcherName());
        this.dispatcherNameText.getDocument().addDocumentListener(this.docListener);
        this.dispatcherMappingText.setText(springWebModuleExtender.getDispatcherMapping());
        this.dispatcherMappingText.getDocument().addDocumentListener(this.docListener);
        this.includeJstlCheckBox.setSelected(springWebModuleExtender.getIncludeJstl());
        this.changeSupport.addChangeListener((ChangeListener)springWebModuleExtender);
        this.initLibraries();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.tabbedPanel.setEnabled(bl);
        this.dispatcherNameText.setEnabled(bl);
        this.dispatcherMappingText.setEnabled(bl);
        this.includeJstlCheckBox.setEnabled(bl);
        this.springVersionLabel.setEnabled(bl);
        this.cbSpringVersion.setEnabled(bl);
        super.setEnabled(bl);
    }

    public String getDispatcherName() {
        return this.dispatcherNameText.getText();
    }

    public String getDispatcherMapping() {
        return this.dispatcherMappingText.getText();
    }

    public boolean getIncludeJstl() {
        return this.includeJstlCheckBox.isSelected();
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.tabbedPanel = new JTabbedPane();
        this.libPanel = new JPanel();
        this.includeJstlCheckBox = new JCheckBox();
        this.springVersionLabel = new JLabel();
        this.cbSpringVersion = new JComboBox();
        this.standardPanel = new JPanel();
        this.dispatcherNameText = new JTextField();
        this.dispatcherNameLabel = new JLabel();
        this.dispatcherMappingLabel = new JLabel();
        this.dispatcherMappingText = new JTextField();
        this.setLayout(new BorderLayout());
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        Mnemonics.setLocalizedText((AbstractButton)this.includeJstlCheckBox, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_IncludeJstl"));
        this.includeJstlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpringConfigPanelVisual.this.includeJstlCheckBoxActionPerformed(actionEvent);
            }
        });
        this.springVersionLabel.setLabelFor(this.cbSpringVersion);
        Mnemonics.setLocalizedText((JLabel)this.springVersionLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.springVersionLabel.text"));
        this.cbSpringVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"No Library found"}));
        this.cbSpringVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpringConfigPanelVisual.this.cbSpringVersionActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.libPanel);
        this.libPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.springVersionLabel).add(18, 18, 18).add((Component)this.cbSpringVersion, -2, -1, -2)).add((Component)this.includeJstlCheckBox)).addContainerGap(330, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.springVersionLabel).add((Component)this.cbSpringVersion, -2, -1, -2)).add(18, 18, 18).add((Component)this.includeJstlCheckBox).addContainerGap(301, Short.MAX_VALUE)));
        this.includeJstlCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.includeJstlCheckBox.AccessibleContext.accessibleDescription"));
        this.tabbedPanel.addTab(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_Libraries"), this.libPanel);
        Mnemonics.setLocalizedText((JLabel)this.dispatcherNameLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_DispatcherName"));
        Mnemonics.setLocalizedText((JLabel)this.dispatcherMappingLabel, (String)NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_DispatcherMapping"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.standardPanel);
        this.standardPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.dispatcherNameLabel).add((Component)this.dispatcherMappingLabel)).add(8, 8, 8).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.dispatcherNameText, -1, 431, Short.MAX_VALUE).add((Component)this.dispatcherMappingText, -1, 431, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.dispatcherNameLabel).add((Component)this.dispatcherNameText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.dispatcherMappingLabel).add((Component)this.dispatcherMappingText, -2, -1, -2)).addContainerGap(308, Short.MAX_VALUE)));
        this.tabbedPanel.addTab(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"LBL_Configuration"), this.standardPanel);
        this.add((Component)this.tabbedPanel, "Center");
        this.tabbedPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"SpringConfigPanelVisual.tabbedPanel.AccessibleContext.accessibleName"));
    }

    private void includeJstlCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private void cbSpringVersionActionPerformed(ActionEvent actionEvent) {
        this.springLibrary = this.springLibs.get(this.cbSpringVersion.getSelectedIndex());
    }

    public void enableComponents(boolean bl) {
        this.standardPanel.setEnabled(bl);
        this.dispatcherMappingLabel.setEnabled(bl);
        this.dispatcherMappingText.setEnabled(bl);
        this.dispatcherNameLabel.setEnabled(bl);
        this.dispatcherNameText.setEnabled(bl);
        this.tabbedPanel.setEnabled(bl);
        this.springVersionLabel.setEnabled(bl);
        this.cbSpringVersion.setEnabled(bl);
    }

    public Library getSpringLibrary() {
        return this.springLibrary.getLibrary();
    }

    public String getSpringLibraryVersion() {
        return this.springLibrary.getVersion();
    }

    private void initLibraries() {
        if (this.libsInitialized) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        this.springLibs.clear();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!SpringUtilities.isSpringLibrary((Library)library)) continue;
            vector.add(library.getDisplayName());
            this.springLibs.add(new SpringLibrary(library));
        }
        this.cbSpringVersion.setModel(new DefaultComboBoxModel(vector));
        int n = this.cbSpringVersion.getSelectedIndex();
        if (n < this.springLibs.size()) {
            this.springLibrary = this.springLibs.get(n);
            this.libsInitialized = true;
            this.repaint();
        }
    }

    private class SpringLibrary {
        private Library springLibrary;
        private String version;

        public SpringLibrary(Library library) {
            this.springLibrary = library;
        }

        public String getVersion() {
            if (this.version == null) {
                this.version = SpringUtilities.getSpringLibraryVersion((Library)this.springLibrary);
            }
            return this.version;
        }

        public Library getLibrary() {
            return this.springLibrary;
        }

        public String toString() {
            return this.springLibrary.getDisplayName();
        }
    }
}

