/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.Base64;
import org.jruby.ext.openssl.impl.Mime;
import org.jruby.ext.openssl.impl.MimeHeader;
import org.jruby.ext.openssl.impl.MimeParam;
import org.jruby.ext.openssl.impl.PKCS7;
import org.jruby.ext.openssl.impl.PKCS7Exception;

public class SMIME {
    public static final int MAX_SMLEN = 1024;
    public static final byte[] NEWLINE = new byte[]{13, 10};
    private Mime mime;

    public SMIME() {
        this(Mime.DEFAULT);
    }

    public SMIME(Mime mime) {
        this.mime = mime;
    }

    private static boolean equals(byte[] first, int firstIndex, byte[] second, int secondIndex, int length) {
        int len = length;
        int i = firstIndex;
        int flen = first.length;
        int slen = second.length;
        for (int j = secondIndex; i < flen && j < slen && len > 0; ++i, ++j, --len) {
            if (first[i] == second[j]) continue;
            return false;
        }
        return len == 0;
    }

    public static boolean stripEol(byte[] linebuf, int[] plen) {
        int len = plen[0];
        boolean isEol = false;
        int p = len - 1;
        while (len > 0) {
            byte c = linebuf[p];
            if (c == 10) {
                isEol = true;
            } else if (c != 13) break;
            --len;
            --p;
        }
        plen[0] = len;
        return isEol;
    }

    public void text(BIO input, BIO output) {
    }

    private int boundCheck(byte[] line, int linelen, byte[] bound, int blen) {
        if (linelen == -1) {
            linelen = line.length;
        }
        if (blen == -1) {
            blen = bound.length;
        }
        if (blen + 2 > linelen) {
            return 0;
        }
        if (line[0] == 45 && line[1] == 45 && SMIME.equals(line, 2, bound, 0, blen)) {
            if (line.length >= blen + 4 && line[2 + blen] == 45 && line[2 + blen + 1] == 45) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public PKCS7 readPKCS7Base64(BIO bio) throws IOException, PKCS7Exception {
        BIO bio64 = BIO.base64Filter(bio);
        return PKCS7.fromASN1(bio64);
    }

    private List<BIO> multiSplit(BIO bio, byte[] bound) throws IOException {
        ArrayList<BIO> parts = new ArrayList<BIO>();
        byte[] linebuf = new byte[1024];
        int blen = bound.length;
        boolean eol = false;
        int len = 0;
        int part = 0;
        int state = 0;
        boolean first = true;
        BIO bpart = null;
        while ((len = bio.gets(linebuf, 1024)) > 0) {
            state = this.boundCheck(linebuf, len, bound, blen);
            if (state == 1) {
                first = true;
                ++part;
                continue;
            }
            if (state == 2) {
                parts.add(bpart);
                return parts;
            }
            if (part == 0) continue;
            int[] tmp = new int[]{len};
            boolean nextEol = SMIME.stripEol(linebuf, tmp);
            len = tmp[0];
            if (first) {
                first = false;
                if (bpart != null) {
                    parts.add(bpart);
                }
                bpart = BIO.mem();
                bpart.setMemEofReturn(0);
            } else if (eol) {
                bpart.write(NEWLINE, 0, 2);
            }
            eol = nextEol;
            if (len == 0) continue;
            bpart.write(linebuf, 0, len);
        }
        return parts;
    }

    public PKCS7 readPKCS7(BIO bio, BIO[] bcont) throws IOException, PKCS7Exception {
        List<MimeHeader> headers;
        if (bcont != null && bcont.length > 0) {
            bcont[0] = null;
        }
        if ((headers = this.mime.parseHeaders(bio)) == null) {
            throw new PKCS7Exception(122, 133);
        }
        MimeHeader hdr = this.mime.findHeader(headers, "content-type");
        if (hdr == null || hdr.getValue() == null) {
            throw new PKCS7Exception(122, 135);
        }
        if ("multipart/signed".equals(hdr.getValue())) {
            MimeParam prm = this.mime.findParam(hdr, "boundary");
            if (prm == null || prm.getParamValue() == null) {
                throw new PKCS7Exception(122, 137);
            }
            byte[] boundary = null;
            try {
                boundary = prm.getParamValue().getBytes("ISO8859-1");
            }
            catch (Exception e) {
                throw new PKCS7Exception(122, 137, e);
            }
            List<BIO> parts = this.multiSplit(bio, boundary);
            if (parts == null || parts.size() != 2) {
                throw new PKCS7Exception(122, 136);
            }
            BIO p7in = parts.get(1);
            headers = this.mime.parseHeaders(p7in);
            if (headers == null) {
                throw new PKCS7Exception(122, 134);
            }
            hdr = this.mime.findHeader(headers, "content-type");
            if (hdr == null || hdr.getValue() == null) {
                throw new PKCS7Exception(122, 138);
            }
            if (!("application/x-pkcs7-signature".equals(hdr.getValue()) || "application/pkcs7-signature".equals(hdr.getValue()) || "application/x-pkcs7-mime".equals(hdr.getValue()) || "application/pkcs7-mime".equals(hdr.getValue()))) {
                throw new PKCS7Exception(122, 141, "type: " + hdr.getValue());
            }
            PKCS7 p7 = this.readPKCS7Base64(p7in);
            if (bcont != null && bcont.length > 0) {
                bcont[0] = parts.get(0);
            }
            return p7;
        }
        if (!"application/x-pkcs7-mime".equals(hdr.getValue()) && !"application/pkcs7-mime".equals(hdr.getValue())) {
            throw new PKCS7Exception(122, 131, "type: " + hdr.getValue());
        }
        return this.readPKCS7Base64(bio);
    }

    public String writePKCS7(PKCS7 p7, String data, int flags) throws PKCS7Exception, IOException {
        int ctype = p7.getType();
        Set<AlgorithmIdentifier> mdAlgs = null;
        if (ctype == 22) {
            mdAlgs = p7.getSign().getMdAlgs();
        }
        if (data != null && p7.isDetached()) {
            flags |= 0x40;
        }
        String mimePrefix = "application/pkcs7-";
        String cName = "smime.p7s";
        String mimeEOL = (flags & 0x800) > 0 ? "\r\n" : "\n";
        StringBuilder output = new StringBuilder(512);
        output.append("MIME-Version: 1.0").append(mimeEOL);
        if ((flags & 0x40) > 0 && data != null) {
            String mimeBoundary = SMIME.generateMIMEBoundary(32);
            output.append("Content-Type: multipart/signed;");
            output.append(" protocol=\"").append(mimePrefix).append("signature\";");
            output.append(" micalg=\"");
            SMIME.appendMICalg(output, mdAlgs);
            output.append("\";");
            output.append(" boundary=\"----").append(mimeBoundary).append("\"");
            output.append(mimeEOL).append(mimeEOL);
            output.append("This is an S/MIME signed message.");
            output.append(mimeEOL).append(mimeEOL);
            output.append("------").append(mimeBoundary).append(mimeEOL);
            if ((flags & 1) > 0) {
                output.append("Content-Type: text/plain;").append(mimeEOL).append(mimeEOL);
            }
            output.append(data);
            output.append(mimeEOL);
            output.append("------").append(mimeBoundary).append(mimeEOL);
            output.append("Content-Type: application/x-pkcs7-signature; name=").append(cName).append(mimeEOL);
            output.append("Content-Transfer-Encoding: base64").append(mimeEOL);
            output.append("Content-Description: S/MIME Signature").append(mimeEOL);
            output.append("Content-Disposition: attachment; filename=").append(cName);
            output.append(mimeEOL).append(mimeEOL);
            String p7Base64 = Base64.encodeBytes(p7.toASN1(), 8);
            output.append(p7Base64).append(mimeEOL);
            output.append("------").append(mimeBoundary).append("--").append(mimeEOL);
            return output.toString();
        }
        String msgType = null;
        if (ctype == 23) {
            msgType = "enveloped-data";
        } else if (ctype == 22) {
            msgType = mdAlgs != null && mdAlgs.size() > 0 ? "signed-data" : "certs-only";
        } else if (ctype == 786) {
            msgType = "compressed-data";
            cName = "smime.p7z";
        }
        output.append("Content-Disposition: attachment;");
        output.append(" filename=\"").append(cName).append("\"").append(mimeEOL);
        output.append("Content-Type: ").append(mimePrefix).append("mime;");
        if (msgType != null) {
            output.append(" smime-type=").append(msgType).append(";");
        }
        output.append(" name=").append(cName).append(mimeEOL);
        output.append("Content-Transfer-Encoding: base64").append(mimeEOL).append(mimeEOL);
        byte[] p7Bytes = p7.toASN1();
        String p7Base64 = Base64.encodeBytes(p7Bytes, 8);
        output.append(p7Base64).append(mimeEOL);
        return output.toString();
    }

    private static void appendMICalg(StringBuilder output, Set<AlgorithmIdentifier> mdAlgs) {
        Iterator<AlgorithmIdentifier> it = mdAlgs.iterator();
        boolean writeComma = false;
        while (it.hasNext()) {
            AlgorithmIdentifier algId;
            String ln;
            if (writeComma) {
                output.append(',');
            }
            if ((ln = ASN1Registry.nid2ln(ASN1Registry.obj2nid((algId = it.next()).getAlgorithm()))) == null) {
                ln = "unknown";
            }
            output.append(ln);
            writeComma = true;
        }
    }

    private static String generateMIMEBoundary(int length) {
        char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        Random random = new Random();
        StringBuilder output = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            output.append(alphabet[random.nextInt(length)]);
        }
        return output.toString();
    }
}

