/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.cert.X509CRL;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.ext.openssl.impl.PKCS7;
import org.jruby.ext.openssl.impl.PKCS7Data;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.Signed;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class PKCS7DataSigned
extends PKCS7Data {
    private Signed sign;

    public PKCS7DataSigned() {
        this.sign = new Signed();
        this.sign.setVersion(1);
    }

    public PKCS7DataSigned(Signed sign) {
        this.sign = sign;
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public Object ctrl(int cmd, Object v, Object ignored) {
        int ret = 0;
        switch (cmd) {
            case 1: {
                ret = (Integer)v;
                if (ret == 0 || !this.sign.contents.isData()) break;
                this.sign.contents.setData(null);
                break;
            }
            case 2: {
                if (this.sign == null || this.sign.contents.getData() == null) {
                    ret = 1;
                    break;
                }
                ret = 0;
                break;
            }
            default: {
                throw new RuntimeException("TODO: implement error handling");
            }
        }
        return ret;
    }

    @Override
    public void setSign(Signed sign) {
        this.sign = sign;
    }

    @Override
    public Signed getSign() {
        return this.sign;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public void addSigner(SignerInfoWithPkey psi) {
        this.sign.getMdAlgs().add(psi.getDigestAlgorithm());
        this.sign.getSignerInfo().add(psi);
    }

    @Override
    public void setContent(PKCS7 p7) {
        this.sign.setContents(p7);
    }

    @Override
    public Collection<SignerInfoWithPkey> getSignerInfo() {
        return this.sign.getSignerInfo();
    }

    @Override
    public void addCertificate(X509AuxCertificate cert) {
        this.sign.getCert().add(cert);
    }

    @Override
    public void addCRL(X509CRL crl) {
        this.sign.getCrl().add(crl);
    }

    public String toString() {
        return this.sign.toString();
    }

    public static PKCS7DataSigned fromASN1(ASN1Encodable content) throws PKCS7Exception {
        return new PKCS7DataSigned(Signed.fromASN1(content));
    }

    @Override
    public ASN1Encodable asASN1() {
        return this.sign.asASN1();
    }
}

