/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.jruby.ext.openssl.impl.BIOFilter;
import org.jruby.ext.openssl.impl.PKCS7Exception;

public class CipherBIOFilter
extends BIOFilter {
    private Cipher cipher;
    private byte[] bufRead = new byte[4096];
    private int fillLen = 0;
    private int fillOffset = 0;
    private byte[] tmpBuf = new byte[1024];
    private boolean finalized = false;

    public CipherBIOFilter(Cipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public void flush() throws IOException, PKCS7Exception {
        try {
            byte[] result = this.cipher.doFinal();
            if (result == null) {
                return;
            }
            this.next().write(result, 0, result.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new PKCS7Exception(-1, -1, e);
        }
        catch (BadPaddingException e) {
            throw new PKCS7Exception(-1, -1, e);
        }
    }

    @Override
    public int read(byte[] into, int offset, int len) throws IOException {
        try {
            int read = 0;
            if (this.fillLen > 0) {
                read = Math.min(this.fillLen, len);
                System.arraycopy(this.bufRead, this.fillOffset, into, offset, read);
                this.fillOffset += read;
                this.fillLen -= read;
                if (this.fillLen == 0) {
                    this.fillOffset = 0;
                }
                if (read == len) {
                    return read;
                }
            }
            int req = len - read;
            int off = offset + read;
            if (this.finalized) {
                return 0;
            }
            while (req > 0) {
                int required;
                int readFromNext = this.next().read(this.tmpBuf, 0, 1024);
                if (readFromNext > 0) {
                    required = this.cipher.getOutputSize(readFromNext);
                    if (required > this.bufRead.length - (this.fillOffset + this.fillLen)) {
                        byte[] newBuf = new byte[required + this.fillOffset + this.fillLen];
                        System.arraycopy(this.bufRead, this.fillOffset, newBuf, 0, this.fillLen);
                        this.fillOffset = 0;
                        this.bufRead = newBuf;
                    }
                    int outputted = this.cipher.update(this.tmpBuf, 0, readFromNext, this.bufRead, this.fillOffset + this.fillLen);
                    this.fillLen += outputted;
                    read = Math.min(this.fillLen, req);
                    System.arraycopy(this.bufRead, this.fillOffset, into, off, read);
                    this.fillOffset += read;
                    this.fillLen -= read;
                    if (this.fillLen == 0) {
                        this.fillOffset = 0;
                    }
                    req -= read;
                    off += read;
                    continue;
                }
                required = this.cipher.getOutputSize(0);
                if (required > this.bufRead.length - (this.fillOffset + this.fillLen)) {
                    byte[] newBuf = new byte[required + this.fillOffset + this.fillLen];
                    System.arraycopy(this.bufRead, this.fillOffset, newBuf, 0, this.fillLen);
                    this.fillOffset = 0;
                    this.bufRead = newBuf;
                }
                int outputted = this.cipher.doFinal(this.bufRead, this.fillOffset + this.fillLen);
                this.finalized = true;
                this.fillLen += outputted;
                read = Math.min(this.fillLen, req);
                System.arraycopy(this.bufRead, this.fillOffset, into, off, read);
                this.fillOffset += read;
                this.fillLen -= read;
                if (this.fillLen == 0) {
                    this.fillOffset = 0;
                }
                return len - (req -= read);
            }
            return len;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int write(byte[] out, int offset, int len) throws IOException {
        byte[] result = this.cipher.update(out, offset, len);
        if (result == null) {
            return len;
        }
        this.next().write(result, 0, result.length);
        return len;
    }

    @Override
    public int getType() {
        return 522;
    }
}

