/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyDSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 2359742219218350277L;
    private static ObjectAllocator PKEYDSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDSA(runtime, klass);
        }
    };
    private DSAPrivateKey privKey;
    private DSAPublicKey pubKey;
    private BigInteger[] specValues;
    private static final int SPEC_Y = 0;
    private static final int SPEC_P = 1;
    private static final int SPEC_Q = 2;
    private static final int SPEC_G = 3;

    public static void createPKeyDSA(Ruby runtime, RubyModule _PKey) {
        RubyClass _DSA = _PKey.defineClassUnder("DSA", _PKey.getClass("PKey"), PKEYDSA_ALLOCATOR);
        RubyClass _PKeyError = _PKey.getClass("PKeyError");
        _PKey.defineClassUnder("DSAError", _PKeyError, _PKeyError.getAllocator());
        _DSA.defineAnnotatedMethods(PKeyDSA.class);
    }

    static RubyClass _DSA(Ruby runtime) {
        return PKeyDSA._PKey(runtime).getClass("DSA");
    }

    public static RaiseException newDSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyDSA._PKey(runtime).getClass("DSAError"), message);
    }

    public PKeyDSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyDSA(Ruby runtime, RubyClass type, DSAPrivateKey privKey, DSAPublicKey pubKey) {
        super(runtime, type);
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public PKeyDSA(Ruby runtime, RubyClass type, DSAPublicKey pubKey) {
        this(runtime, type, null, pubKey);
    }

    @Override
    PublicKey getPublicKey() {
        return this.pubKey;
    }

    @Override
    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    @Override
    String getAlgorithm() {
        return "DSA";
    }

    @JRubyMethod(name={"generate"}, meta=true)
    public static IRubyObject generate(IRubyObject self, IRubyObject arg) {
        int keysize = RubyNumeric.fix2int((IRubyObject)arg);
        PKeyDSA dsa = new PKeyDSA(self.getRuntime(), (RubyClass)self);
        PKeyDSA.dsaGenerate(dsa, keysize);
        return dsa;
    }

    private static void dsaGenerate(PKeyDSA dsa, int keysize) throws RaiseException {
        try {
            KeyPairGenerator gen = SecurityHelper.getKeyPairGenerator("DSA");
            gen.initialize(keysize, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            dsa.privKey = (DSAPrivateKey)pair.getPrivate();
            dsa.pubKey = (DSAPublicKey)pair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage());
        }
        catch (RuntimeException e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage());
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
        KeyFactory dsaFactory;
        Ruby runtime = context.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privKey = null;
            this.pubKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        IRubyObject pass = null;
        if (args.length > 1) {
            pass = args[1];
        }
        if (arg instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)arg));
            PKeyDSA.dsaGenerate(this, keysize);
            return this;
        }
        char[] passwd = PKeyDSA.password(pass);
        RubyString str = PKeyDSA.readInitArg(context, arg);
        Serializable key = null;
        try {
            dsaFactory = SecurityHelper.getKeyFactory("DSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (DSA)");
        }
        catch (RuntimeException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (DSA) " + e);
        }
        boolean noClassDef = false;
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readDSAPrivateKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readDSAPublicKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readDSAPubKey(new StringReader(str.toString()));
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readDSAPrivateKey(dsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSLReal.debug(runtime, "PKeyDSA could not read private key", e);
            }
            catch (IOException e) {
                OpenSSLReal.debug(runtime, "PKeyDSA could not read private key", e);
            }
            catch (RuntimeException e) {
                if (PKeyDSA.isKeyGenerationFailure(e)) {
                    OpenSSLReal.debug(runtime, "PKeyDSA could not read private key", e);
                }
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readDSAPublicKey(dsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSLReal.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSLReal.debug(runtime, "PKeyDSA could not read public key", e);
            }
            catch (IOException e) {
                OpenSSLReal.debug(runtime, "PKeyDSA could not read public key", e);
            }
            catch (RuntimeException e) {
                if (PKeyDSA.isKeyGenerationFailure(e)) {
                    OpenSSLReal.debug(runtime, "PKeyDSA could not read public key", e);
                }
                OpenSSLReal.debugStackTrace(runtime, e);
            }
        }
        if (key == null) {
            key = this.tryPKCS8EncodedKey(runtime, dsaFactory, str.getBytes());
        }
        if (key == null) {
            key = this.tryX509EncodedKey(runtime, dsaFactory, str.getBytes());
        }
        if (key == null) {
            throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key:");
        }
        if (key instanceof KeyPair) {
            PublicKey publicKey = ((KeyPair)key).getPublic();
            PrivateKey privateKey = ((KeyPair)key).getPrivate();
            if (!(privateKey instanceof DSAPrivateKey)) {
                if (privateKey == null) {
                    throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: (private key is null)");
                }
                throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: (invalid key type " + privateKey.getClass().getName() + ")");
            }
            this.privKey = (DSAPrivateKey)privateKey;
            this.pubKey = (DSAPublicKey)publicKey;
        } else if (key instanceof DSAPrivateKey) {
            this.privKey = (DSAPrivateKey)key;
        } else if (key instanceof DSAPublicKey) {
            this.pubKey = (DSAPublicKey)key;
            this.privKey = null;
        } else {
            throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: " + key.getClass().getName());
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_der() {
        byte[] bytes;
        try {
            bytes = PKey.toDerDSAKey(this.pubKey, this.privKey);
        }
        catch (NoClassDefFoundError e) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(e));
        }
        catch (IOException e) {
            throw PKeyDSA.newDSAError(this.getRuntime(), e.getMessage());
        }
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])bytes);
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getParams().getP().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result.append("priv:");
            PKeyDSA.addSplittedAndFormatted(result, this.privKey.getX());
        }
        result.append("pub:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getY());
        result.append("P:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getP());
        result.append("Q:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getQ());
        result.append("G:");
        PKeyDSA.addSplittedAndFormatted(result, this.pubKey.getParams().getG());
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyDSA val = new PKeyDSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args) {
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        CipherSpec spec = null;
        char[] passwd = null;
        if (args.length > 0 && !args[0].isNil()) {
            Cipher c = (Cipher)args[0];
            spec = new CipherSpec(c.getCipher(), c.getName(), c.getKeyLen() * 8);
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        try {
            StringWriter writer = new StringWriter();
            if (this.privKey != null) {
                PEMInputOutput.writeDSAPrivateKey(writer, this.privKey, spec, passwd);
            } else {
                PEMInputOutput.writeDSAPublicKey(writer, this.pubKey);
            }
            return this.getRuntime().newString(writer.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syssign(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject sysverify(IRubyObject arg, IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getP();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[1]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject p) {
        return this.setKeySpecComponent(1, p);
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getQ();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[2]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject q) {
        return this.setKeySpecComponent(2, q);
    }

    @JRubyMethod(name={"g"})
    public synchronized IRubyObject get_g() {
        BigInteger param;
        DSAKey key = this.pubKey;
        if (key != null || (key = this.privKey) != null) {
            BigInteger param2 = key.getParams().getG();
            if (param2 != null) {
                return BN.newBN(this.getRuntime(), param2);
            }
        } else if (this.specValues != null && (param = this.specValues[3]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject set_g(IRubyObject g) {
        return this.setKeySpecComponent(3, g);
    }

    @JRubyMethod(name={"pub_key"})
    public synchronized IRubyObject get_pub_key() {
        BigInteger param;
        DSAPublicKey key = this.pubKey;
        if (key != null) {
            return BN.newBN(this.getRuntime(), key.getY());
        }
        if (this.specValues != null && (param = this.specValues[0]) != null) {
            return BN.newBN(this.getRuntime(), param);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"priv_key"})
    public synchronized IRubyObject get_priv_key() {
        DSAPrivateKey key = this.privKey;
        if (key != null) {
            return BN.newBN(this.getRuntime(), key.getX());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject set_pub_key(IRubyObject pub_key) {
        return this.setKeySpecComponent(0, pub_key);
    }

    private IRubyObject setKeySpecComponent(int index, IRubyObject value) {
        BigInteger[] vals;
        block10: {
            block9: {
                if (this.pubKey != null || this.privKey != null) break block9;
                vals = this.specValues;
                if (this.specValues == null || vals[index] == null) break block10;
            }
            throw PKeyDSA.newDSAError(this.getRuntime(), "illegal modification");
        }
        BigInteger bival = BN.getBigInteger(value);
        if (vals != null) {
            vals[index] = bival;
            int i = vals.length;
            while (--i >= 0) {
                if (vals[i] != null) continue;
                return value;
            }
            DSAPublicKeySpec spec = new DSAPublicKeySpec(vals[0], vals[1], vals[2], vals[3]);
            try {
                this.pubKey = (DSAPublicKey)SecurityHelper.getKeyFactory("DSA").generatePublic(spec);
            }
            catch (InvalidKeySpecException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "invalid keyspec");
            }
            catch (NoSuchAlgorithmException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "unsupported key algorithm (DSA)");
            }
            this.specValues = null;
        } else {
            this.specValues = new BigInteger[4];
            this.specValues[index] = bival;
        }
        return value;
    }
}

