/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKeyDH;
import org.jruby.ext.openssl.PKeyDSA;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class PKey
extends RubyObject {
    private static final long serialVersionUID = 6114668087816965720L;

    public static void createPKey(Ruby runtime, RubyModule ossl) {
        RubyModule _PKey = ossl.defineModuleUnder("PKey");
        _PKey.defineAnnotatedMethods(PKeyModule.class);
        RubyClass _PKeyPkey = _PKey.defineClassUnder("PKey", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass _OpenSSLError = ossl.getClass("OpenSSLError");
        _PKey.defineClassUnder("PKeyError", _OpenSSLError, _OpenSSLError.getAllocator());
        _PKeyPkey.defineAnnotatedMethods(PKey.class);
        PKeyRSA.createPKeyRSA(runtime, _PKey);
        PKeyDSA.createPKeyDSA(runtime, _PKey);
        PKeyDH.createPKeyDH(runtime, _PKey, _PKeyPkey);
    }

    public static RaiseException newPKeyError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKey._PKey(runtime).getClass("PKeyError"), message);
    }

    static RubyModule _PKey(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("PKey");
    }

    public PKey(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    PublicKey getPublicKey() {
        return null;
    }

    PrivateKey getPrivateKey() {
        return null;
    }

    String getAlgorithm() {
        return "NONE";
    }

    public abstract IRubyObject to_der();

    @JRubyMethod(name={"sign"})
    public IRubyObject sign(IRubyObject digest, IRubyObject data) {
        if (!this.callMethod(this.getRuntime().getCurrentContext(), "private?").isTrue()) {
            throw this.getRuntime().newArgumentError("Private key is needed.");
        }
        String digAlg = ((Digest)digest).getShortAlgorithm();
        try {
            Signature signature = SecurityHelper.getSignature(digAlg + "WITH" + this.getAlgorithm());
            signature.initSign(this.getPrivateKey());
            byte[] inp = data.convertToString().getBytes();
            signature.update(inp);
            byte[] sigge = signature.sign();
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])sigge);
        }
        catch (GeneralSecurityException gse) {
            throw PKey.newPKeyError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(name={"verify"})
    public IRubyObject verify(IRubyObject digest, IRubyObject sig, IRubyObject data) {
        boolean valid;
        if (!(digest instanceof Digest)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid digest");
        }
        if (!(sig instanceof RubyString)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid signature");
        }
        if (!(data instanceof RubyString)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid data");
        }
        byte[] sigBytes = ((RubyString)sig).getBytes();
        byte[] dataBytes = ((RubyString)data).getBytes();
        String algorithm = ((Digest)digest).getShortAlgorithm() + "WITH" + this.getAlgorithm();
        try {
            Signature signature = SecurityHelper.getSignature(algorithm);
            signature.initVerify(this.getPublicKey());
            signature.update(dataBytes);
            valid = signature.verify(sigBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw PKey.newPKeyError(this.getRuntime(), "unsupported algorithm: " + algorithm);
        }
        catch (SignatureException e) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid signature");
        }
        catch (InvalidKeyException e) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid key");
        }
        return this.getRuntime().newBoolean(valid);
    }

    protected PrivateKey tryPKCS8EncodedKey(Ruby runtime, KeyFactory keyFactory, byte[] encodedKey) {
        try {
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (InvalidKeySpecException e) {
            if (OpenSSLReal.isDebug(runtime)) {
                OpenSSLReal.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (PKCS8) private key", e);
            }
        }
        catch (RuntimeException e) {
            if (PKey.isKeyGenerationFailure(e)) {
                if (OpenSSLReal.isDebug(runtime)) {
                    OpenSSLReal.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (PKCS8) private key", e);
                }
            }
            OpenSSLReal.debugStackTrace(runtime, e);
        }
        return null;
    }

    protected static boolean isKeyGenerationFailure(RuntimeException e) {
        String msg;
        return e instanceof ClassCastException && (msg = e.getMessage()) != null && msg.contains("DLSequence cannot be cast to");
    }

    protected PublicKey tryX509EncodedKey(Ruby runtime, KeyFactory keyFactory, byte[] encodedKey) {
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (InvalidKeySpecException e) {
            if (OpenSSLReal.isDebug(runtime)) {
                OpenSSLReal.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (X509) public key", e);
            }
        }
        catch (RuntimeException e) {
            if (PKey.isKeyGenerationFailure(e)) {
                if (OpenSSLReal.isDebug(runtime)) {
                    OpenSSLReal.debug(runtime, ((Object)((Object)this)).getClass().getSimpleName() + " could not generate (X509) public key", e);
                }
            }
            OpenSSLReal.debugStackTrace(runtime, e);
        }
        return null;
    }

    protected static void addSplittedAndFormatted(StringBuilder result, BigInteger value) {
        String v = value.toString(16);
        if (v.length() % 2 != 0) {
            v = "0" + v;
        }
        String sep = "";
        for (int i = 0; i < v.length(); i += 2) {
            result.append(sep);
            if (i % 30 == 0) {
                result.append("\n    ");
            }
            result.append(v.substring(i, i + 2));
            sep = ":";
        }
        result.append("\n");
    }

    protected static char[] password(IRubyObject pass) {
        if (pass != null && !pass.isNil()) {
            return pass.toString().toCharArray();
        }
        return null;
    }

    protected static RubyString readInitArg(ThreadContext context, IRubyObject arg) {
        if ((arg = OpenSSLImpl.to_der_if_possible(context, arg)) instanceof RubyFile) {
            return (RubyString)((RubyFile)arg.dup()).read(context);
        }
        return arg.convertToString();
    }

    public static class PKeyModule {
        @JRubyMethod(name={"read"}, meta=true, required=1, optional=1)
        public static IRubyObject read(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
            char[] pass;
            IRubyObject data;
            Ruby runtime = context.runtime;
            switch (args.length) {
                case 1: {
                    data = args[0];
                    pass = null;
                    break;
                }
                default: {
                    data = args[0];
                    pass = args[1].isNil() ? null : args[1].toString().toCharArray();
                }
            }
            byte[] input = OpenSSLImpl.readX509PEM(context, data);
            KeyPair key = null;
            try {
                key = org.jruby.ext.openssl.impl.PKey.readPrivateKey(input);
            }
            catch (IOException ioe) {
            }
            catch (GeneralSecurityException gse) {
                // empty catch block
            }
            if (key == null) {
                try {
                    key = PEMInputOutput.readPrivateKey(new InputStreamReader(new ByteArrayInputStream(input)), pass);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (key != null) {
                if (key.getPublic().getAlgorithm().equals("RSA")) {
                    return new PKeyRSA(runtime, PKey._PKey(runtime).getClass("RSA"), (RSAPrivateCrtKey)key.getPrivate(), (RSAPublicKey)key.getPublic());
                }
                if (key.getPublic().getAlgorithm().equals("DSA")) {
                    return new PKeyDSA(runtime, PKey._PKey(runtime).getClass("DSA"), (DSAPrivateKey)key.getPrivate(), (DSAPublicKey)key.getPublic());
                }
            }
            PublicKey pubKey = null;
            try {
                pubKey = org.jruby.ext.openssl.impl.PKey.readPublicKey(input);
            }
            catch (IOException ioe) {
            }
            catch (GeneralSecurityException gse) {
                // empty catch block
            }
            if (pubKey == null) {
                try {
                    pubKey = PEMInputOutput.readPubKey(new InputStreamReader(new ByteArrayInputStream(input)));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (pubKey != null) {
                if (pubKey.getAlgorithm().equals("RSA")) {
                    return new PKeyRSA(runtime, PKey._PKey(runtime).getClass("RSA"), (RSAPublicKey)pubKey);
                }
                if (key.getPublic().getAlgorithm().equals("DSA")) {
                    return new PKeyDSA(runtime, PKey._PKey(runtime).getClass("DSA"), (DSAPublicKey)pubKey);
                }
            }
            throw runtime.newArgumentError("Could not parse PKey");
        }
    }
}

