/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.SimpleSecretKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Cipher
extends RubyObject {
    private static final long serialVersionUID = 7727377435222646536L;
    private static ObjectAllocator CIPHER_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Cipher(runtime, klass);
        }
    };
    private static boolean supportedCiphersInitialized = false;
    static final Collection<String> supportedCiphers = new LinkedHashSet<String>(72);
    private javax.crypto.Cipher cipher;
    private String name;
    private String cryptoBase;
    private String cryptoVersion;
    private String cryptoMode;
    private String padding_type;
    private String realName;
    private int keyLen = -1;
    private int generateKeyLen = -1;
    private int ivLen = -1;
    private boolean encryptMode = true;
    private boolean ciphInited = false;
    private byte[] key;
    private byte[] realIV;
    private byte[] orgIV;
    private String padding;
    private byte[] lastIv = null;

    public static void createCipher(Ruby runtime, RubyModule _OpenSSL) {
        RubyClass _Cipher = _OpenSSL.defineClassUnder("Cipher", runtime.getObject(), CIPHER_ALLOCATOR);
        _Cipher.defineAnnotatedMethods(Cipher.class);
        RubyClass _OpenSSLError = _OpenSSL.getClass("OpenSSLError");
        _Cipher.defineClassUnder("CipherError", _OpenSSLError, _OpenSSLError.getAllocator());
    }

    static RubyClass _Cipher(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstant("Cipher");
    }

    public static boolean isSupportedCipher(String name) {
        Collection<String> ciphers = Cipher.getSupportedCiphers();
        return ciphers.contains(name.toUpperCase());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ciphers(ThreadContext context, IRubyObject self) {
        Ruby runtime = context.runtime;
        Collection<String> ciphers = Cipher.getSupportedCiphers();
        RubyArray result = runtime.newArray(ciphers.size() * 2);
        for (String cipher : ciphers) {
            result.append((IRubyObject)runtime.newString(cipher));
            result.append((IRubyObject)runtime.newString(cipher.toLowerCase()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getSupportedCiphers() {
        if (supportedCiphersInitialized) {
            return supportedCiphers;
        }
        Collection<String> collection = supportedCiphers;
        synchronized (collection) {
            int i;
            if (supportedCiphersInitialized) {
                return supportedCiphers;
            }
            String[] other = new String[]{"AES128", "AES192", "AES256", "BLOWFISH", "RC2-40-CBC", "RC2-64-CBC", "RC4", "RC4-40", "CAST", "CAST-CBC"};
            String[] bases = new String[]{"AES-128", "AES-192", "AES-256", "BF", "DES", "DES-EDE", "DES-EDE3", "RC2", "CAST5"};
            String[] suffixes = new String[]{"", "-CBC", "-CFB", "-CFB1", "-CFB8", "-ECB", "-OFB"};
            for (i = 0; i < bases.length; ++i) {
                for (int k = 0; k < suffixes.length; ++k) {
                    String cipher = bases[i] + suffixes[k];
                    if (!Cipher.tryCipher(cipher)) continue;
                    supportedCiphers.add(cipher.toUpperCase());
                }
            }
            for (i = 0; i < other.length; ++i) {
                String cipher = other[i];
                if (!Cipher.tryCipher(cipher)) continue;
                supportedCiphers.add(cipher.toUpperCase());
            }
            supportedCiphersInitialized = true;
            return supportedCiphers;
        }
    }

    private static boolean tryCipher(String osslName) {
        String realName = Algorithm.osslToJsse(osslName, null)[3];
        try {
            return Cipher.getCipher(realName, true) != null;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private static javax.crypto.Cipher getCipher(String transformation, boolean silent) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return SecurityHelper.getCipher(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            if (silent) {
                return null;
            }
            throw e;
        }
        catch (NoSuchPaddingException e) {
            if (silent) {
                return null;
            }
            throw e;
        }
    }

    public Cipher(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private void dumpVars(PrintStream out) {
        out.println("***** Cipher instance vars ****");
        out.println("name = " + this.name);
        out.println("cryptoBase = " + this.cryptoBase);
        out.println("cryptoVersion = " + this.cryptoVersion);
        out.println("cryptoMode = " + this.cryptoMode);
        out.println("padding_type = " + this.padding_type);
        out.println("realName = " + this.realName);
        out.println("keyLen = " + this.keyLen);
        out.println("ivLen = " + this.ivLen);
        out.println("ciph block size = " + this.cipher.getBlockSize());
        out.println("encryptMode = " + this.encryptMode);
        out.println("ciphInited = " + this.ciphInited);
        out.println("key.length = " + (this.key == null ? 0 : this.key.length));
        out.println("iv.length = " + (this.realIV == null ? 0 : this.realIV.length));
        out.println("padding = " + this.padding);
        out.println("ciphAlgo = " + this.cipher.getAlgorithm());
        out.println("*******************************");
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject name) {
        String nameStr = name.toString();
        if (!Cipher.isSupportedCipher(nameStr)) {
            throw Cipher.newCipherError(context.runtime, String.format("unsupported cipher algorithm (%s)", nameStr));
        }
        if (this.cipher != null) {
            throw context.runtime.newRuntimeError("Cipher already inititalized!");
        }
        this.updateCipher(nameStr, this.padding);
        return this;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        Cipher other = (Cipher)obj;
        this.cryptoBase = other.cryptoBase;
        this.cryptoVersion = other.cryptoVersion;
        this.cryptoMode = other.cryptoMode;
        this.padding_type = other.padding_type;
        this.realName = other.realName;
        this.name = other.name;
        this.keyLen = other.keyLen;
        this.ivLen = other.ivLen;
        this.encryptMode = other.encryptMode;
        this.ciphInited = false;
        if (other.key != null) {
            this.key = new byte[other.key.length];
            System.arraycopy(other.key, 0, this.key, 0, this.key.length);
        } else {
            this.key = null;
        }
        if (other.realIV != null) {
            this.realIV = new byte[other.realIV.length];
            System.arraycopy(other.realIV, 0, this.realIV, 0, this.realIV.length);
        } else {
            this.realIV = null;
        }
        this.orgIV = this.realIV;
        this.padding = other.padding;
        this.cipher = this.getCipher();
        return this;
    }

    @JRubyMethod
    public IRubyObject name() {
        return this.getRuntime().newString(this.name);
    }

    @JRubyMethod
    public IRubyObject key_len() {
        return this.getRuntime().newFixnum(this.keyLen);
    }

    @JRubyMethod
    public IRubyObject iv_len() {
        return this.getRuntime().newFixnum(this.ivLen);
    }

    @JRubyMethod(name={"key_len="}, required=1)
    public IRubyObject set_key_len(IRubyObject len) {
        this.keyLen = RubyNumeric.fix2int((IRubyObject)len);
        return len;
    }

    @JRubyMethod(name={"key="}, required=1)
    public IRubyObject set_key(ThreadContext context, IRubyObject key) {
        byte[] keyBytes;
        try {
            keyBytes = key.convertToString().getBytes();
        }
        catch (Exception e) {
            Ruby runtime = context.runtime;
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw Cipher.newCipherError(runtime, e.getMessage());
        }
        if (keyBytes.length < this.keyLen) {
            throw Cipher.newCipherError(context.runtime, "key length too short");
        }
        if (keyBytes.length > this.keyLen) {
            byte[] keys = new byte[this.keyLen];
            System.arraycopy(keyBytes, 0, keys, 0, this.keyLen);
            keyBytes = keys;
        }
        this.key = keyBytes;
        return key;
    }

    @JRubyMethod(name={"iv="}, required=1)
    public IRubyObject set_iv(ThreadContext context, IRubyObject iv) {
        byte[] ivBytes;
        try {
            ivBytes = iv.convertToString().getBytes();
        }
        catch (Exception e) {
            Ruby runtime = context.runtime;
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw Cipher.newCipherError(this.getRuntime(), e.getMessage());
        }
        if (ivBytes.length < this.ivLen) {
            throw Cipher.newCipherError(this.getRuntime(), "iv length to short");
        }
        byte[] iv2 = new byte[this.ivLen];
        System.arraycopy(ivBytes, 0, iv2, 0, this.ivLen);
        this.realIV = iv2;
        this.orgIV = this.realIV;
        if (!this.isStreamCipher()) {
            this.ciphInited = false;
        }
        return iv;
    }

    @JRubyMethod
    public IRubyObject block_size(ThreadContext context) {
        this.checkInitialized();
        if (this.isStreamCipher()) {
            return context.runtime.newFixnum(1);
        }
        return context.runtime.newFixnum(this.cipher.getBlockSize());
    }

    private void init(ThreadContext context, IRubyObject[] args, boolean encrypt) {
        Ruby runtime = context.runtime;
        Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2);
        this.encryptMode = encrypt;
        this.ciphInited = false;
        if (args.length > 0) {
            byte[] iv2;
            byte[] pass = args[0].convertToString().getBytes();
            byte[] iv = null;
            try {
                iv = "OpenSSL for Ruby rulez!".getBytes("ISO8859-1");
                iv2 = new byte[this.ivLen];
                System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                iv = iv2;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (args.length > 1 && !args[1].isNil()) {
                runtime.getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, "key derivation by " + this.getMetaClass().getRealClass().getName() + "#encrypt is deprecated; use " + this.getMetaClass().getRealClass().getName() + "::pkcs5_keyivgen instead");
                iv = args[1].convertToString().getBytes();
                if (iv.length > this.ivLen) {
                    iv2 = new byte[this.ivLen];
                    System.arraycopy(iv, 0, iv2, 0, this.ivLen);
                    iv = iv2;
                }
            }
            MessageDigest digest = Digest.getDigest("MD5", runtime);
            OpenSSLImpl.KeyAndIv result = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest, iv, pass, 2048);
            this.key = result.getKey();
            this.realIV = iv;
            this.orgIV = this.realIV;
        }
    }

    @JRubyMethod(optional=2)
    public IRubyObject encrypt(ThreadContext context, IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(context, args, true);
        return this;
    }

    @JRubyMethod(optional=2)
    public IRubyObject decrypt(ThreadContext context, IRubyObject[] args) {
        this.realIV = this.orgIV;
        this.init(context, args, false);
        return this;
    }

    @JRubyMethod
    public IRubyObject reset(ThreadContext context) {
        this.checkInitialized();
        if (!this.isStreamCipher()) {
            this.realIV = this.orgIV;
            this.doInitialize(context.runtime);
        }
        return this;
    }

    private void updateCipher(String name, String padding) {
        this.name = name.toUpperCase();
        this.padding = padding;
        String[] values = Algorithm.osslToJsse(name, padding);
        this.cryptoBase = values[0];
        this.cryptoVersion = values[1];
        this.cryptoMode = values[2];
        this.realName = values[3];
        this.padding_type = values[4];
        int[] lengths = Algorithm.osslKeyIvLength(name);
        this.keyLen = lengths[0];
        this.ivLen = lengths[1];
        if ("DES".equalsIgnoreCase(this.cryptoBase)) {
            this.generateKeyLen = this.keyLen / 8 * 7;
        }
        this.cipher = this.getCipher();
    }

    javax.crypto.Cipher getCipher() {
        try {
            return Cipher.getCipher(this.realName, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher algorithm (" + this.realName + ")");
        }
        catch (NoSuchPaddingException e) {
            throw Cipher.newCipherError(this.getRuntime(), "unsupported cipher padding (" + this.realName + ")");
        }
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject pkcs5_keyivgen(ThreadContext context, IRubyObject[] args) {
        Ruby runtime = context.runtime;
        Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)4);
        byte[] pass = args[0].convertToString().getBytes();
        byte[] salt = null;
        int iter = 2048;
        IRubyObject vdigest = runtime.getNil();
        if (args.length > 1) {
            if (!args[1].isNil()) {
                salt = args[1].convertToString().getBytes();
            }
            if (args.length > 2) {
                if (!args[2].isNil()) {
                    iter = RubyNumeric.fix2int((IRubyObject)args[2]);
                }
                if (args.length > 3) {
                    vdigest = args[3];
                }
            }
        }
        if (salt != null && salt.length != 8) {
            throw Cipher.newCipherError(runtime, "salt must be an 8-octet string");
        }
        String algorithm = vdigest.isNil() ? "MD5" : ((Digest)vdigest).getAlgorithm();
        MessageDigest digest = Digest.getDigest(algorithm, runtime);
        OpenSSLImpl.KeyAndIv result = OpenSSLImpl.EVP_BytesToKey(this.keyLen, this.ivLen, digest, salt, pass, iter);
        this.key = result.getKey();
        this.realIV = result.getIv();
        this.orgIV = this.realIV;
        this.doInitialize(runtime);
        return runtime.getNil();
    }

    private void doInitialize(Ruby runtime) {
        if (OpenSSLReal.isDebug(runtime)) {
            runtime.getOut().println("*** doInitialize");
            this.dumpVars(runtime.getOut());
        }
        this.checkInitialized();
        if (this.key == null) {
            throw Cipher.newCipherError(runtime, "key not specified");
        }
        try {
            if (!"ECB".equalsIgnoreCase(this.cryptoMode)) {
                if (this.realIV == null) {
                    this.realIV = new byte[this.ivLen];
                }
                if ("RC2".equalsIgnoreCase(this.cryptoBase)) {
                    this.cipher.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey("RC2", this.key), new RC2ParameterSpec(this.key.length * 8, this.realIV));
                } else if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
                    this.cipher.init(this.encryptMode ? 1 : 2, new SimpleSecretKey("RC4", this.key));
                } else {
                    this.cipher.init(this.encryptMode ? 1 : 2, (Key)new SimpleSecretKey(this.realName.split("/")[0], this.key), new IvParameterSpec(this.realIV));
                }
            } else {
                this.cipher.init(this.encryptMode ? 1 : 2, new SimpleSecretKey(this.realName.split("/")[0], this.key));
            }
        }
        catch (InvalidKeyException e) {
            throw Cipher.newCipherError(runtime, e.getMessage() + ": possibly you need to install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files for your JRE");
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw Cipher.newCipherError(runtime, e.getMessage());
        }
        this.ciphInited = true;
    }

    @JRubyMethod
    public IRubyObject update(ThreadContext context, IRubyObject data) {
        Ruby runtime = context.runtime;
        boolean debug = OpenSSLReal.isDebug(runtime);
        if (debug) {
            runtime.getOut().println("*** update [" + data + "]");
        }
        this.checkInitialized();
        byte[] val = data.convertToString().getBytes();
        if (val.length == 0) {
            throw this.getRuntime().newArgumentError("data must not be empty");
        }
        if (!this.ciphInited) {
            this.doInitialize(runtime);
        }
        byte[] str = new byte[]{};
        try {
            byte[] out = this.cipher.update(val);
            if (out != null) {
                str = out;
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    byte[] byArray = tmpIv = this.encryptMode ? out : val;
                    if (tmpIv.length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
        }
        catch (Exception e) {
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw Cipher.newCipherError(runtime, e.getMessage());
        }
        return this.getRuntime().newString(new ByteList(str, false));
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject update_deprecated(ThreadContext context, IRubyObject data) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, this.getMetaClass().getRealClass().getName() + "#<< is deprecated; use " + this.getMetaClass().getRealClass().getName() + "#update instead");
        return this.update(context, data);
    }

    @JRubyMethod(name={"final"})
    public IRubyObject _final(ThreadContext context) {
        Ruby runtime = context.runtime;
        this.checkInitialized();
        if (!this.ciphInited) {
            this.doInitialize(runtime);
        }
        if ("RC4".equalsIgnoreCase(this.cryptoBase)) {
            return runtime.newString("");
        }
        ByteList str = new ByteList(ByteList.NULL_ARRAY);
        try {
            byte[] out = this.cipher.doFinal();
            if (out != null) {
                str = new ByteList(out, false);
                if (this.realIV != null) {
                    byte[] tmpIv;
                    if (this.lastIv == null) {
                        this.lastIv = new byte[this.ivLen];
                    }
                    if ((tmpIv = out).length >= this.ivLen) {
                        System.arraycopy(tmpIv, tmpIv.length - this.ivLen, this.lastIv, 0, this.ivLen);
                    }
                }
            }
            if (this.realIV != null) {
                this.realIV = this.lastIv;
                this.doInitialize(runtime);
            }
        }
        catch (GeneralSecurityException e) {
            throw Cipher.newCipherError(runtime, e.getMessage());
        }
        catch (RuntimeException e) {
            if (OpenSSLReal.isDebug(runtime)) {
                e.printStackTrace(runtime.getOut());
            }
            throw Cipher.newCipherError(runtime, e.getMessage());
        }
        return runtime.newString(str);
    }

    @JRubyMethod(name={"padding="})
    public IRubyObject set_padding(IRubyObject padding) {
        this.updateCipher(this.name, padding.toString());
        return padding;
    }

    String getAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    String getName() {
        return this.name;
    }

    String getCryptoBase() {
        return this.cryptoBase;
    }

    String getCryptoMode() {
        return this.cryptoMode;
    }

    int getKeyLen() {
        return this.keyLen;
    }

    int getGenerateKeyLen() {
        return this.generateKeyLen == -1 ? this.keyLen : this.generateKeyLen;
    }

    private void checkInitialized() {
        if (this.cipher == null) {
            throw this.getRuntime().newRuntimeError("Cipher not inititalized!");
        }
    }

    private boolean isStreamCipher() {
        return this.cipher.getBlockSize() == 0;
    }

    private static RaiseException newCipherError(Ruby runtime, String message) {
        return Utils.newError(runtime, Cipher._Cipher(runtime).getClass("CipherError"), message);
    }

    public static class Algorithm {
        private static final Set<String> BLOCK_MODES = new HashSet<String>(8);

        public static String jsseToOssl(String cipherName, int keyLen) {
            String cryptoVersion = null;
            String cryptoMode = null;
            String[] parts = cipherName.split("/");
            if (parts.length != 1 && parts.length != 3) {
                return null;
            }
            if (parts.length > 2) {
                cryptoMode = parts[1];
            }
            String cryptoBase = parts[0];
            if (!BLOCK_MODES.contains(cryptoMode)) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            }
            if (cryptoMode == null) {
                cryptoMode = "CBC";
            }
            if ("DESede".equals(cryptoBase)) {
                cryptoBase = "DES";
                cryptoVersion = "EDE3";
            } else if ("Blowfish".equals(cryptoBase)) {
                cryptoBase = "BF";
            }
            if (cryptoVersion == null) {
                cryptoVersion = String.valueOf(keyLen);
            }
            return cryptoBase + '-' + cryptoVersion + '-' + cryptoMode;
        }

        public static String getAlgorithmBase(javax.crypto.Cipher cipher) {
            String algorithm = cipher.getAlgorithm();
            int idx = algorithm.indexOf(47);
            if (idx != -1) {
                return algorithm.substring(0, idx);
            }
            return algorithm;
        }

        public static String[] osslToJsse(String osslName) {
            return Algorithm.osslToJsse(osslName, null);
        }

        public static String[] osslToJsse(String osslName, String padding) {
            String cryptoMode;
            String[] split = osslName.split("-");
            String cryptoBase = split[0];
            String cryptoVersion = null;
            String paddingType = padding == null || padding.equalsIgnoreCase("PKCS5Padding") ? "PKCS5Padding" : (padding.equals("0") || padding.equalsIgnoreCase("NoPadding") ? "NoPadding" : (padding.equalsIgnoreCase("ISO10126Padding") ? "ISO10126Padding" : "PKCS5Padding"));
            if ("BF".equalsIgnoreCase(cryptoBase)) {
                cryptoBase = "Blowfish";
            }
            if (split.length == 3) {
                cryptoVersion = split[1];
                cryptoMode = split[2];
            } else {
                cryptoMode = split.length == 2 ? split[1] : "CBC";
            }
            String realName = "CAST".equalsIgnoreCase(cryptoBase) ? "CAST5" : ("DES".equalsIgnoreCase(cryptoBase) && "EDE3".equalsIgnoreCase(cryptoVersion) ? "DESede" : cryptoBase);
            String cryptoModeUpper = cryptoMode.toUpperCase();
            if (!BLOCK_MODES.contains(cryptoModeUpper)) {
                cryptoVersion = cryptoMode;
                cryptoMode = "CBC";
            } else if ("CFB1".equals(cryptoModeUpper)) {
                cryptoMode = "CFB";
            }
            if ("RC4".equalsIgnoreCase(realName)) {
                realName = "RC4";
                cryptoMode = "NONE";
                paddingType = "NoPadding";
            } else {
                realName = realName + "/" + cryptoMode + "/" + paddingType;
            }
            return new String[]{cryptoBase, cryptoVersion, cryptoMode, realName, paddingType};
        }

        public static int[] osslKeyIvLength(String cipherName) {
            boolean hasLen;
            String[] name = Algorithm.osslToJsse(cipherName);
            String cryptoBaseUpper = name[0].toUpperCase();
            String cryptoVersion = name[1];
            int keyLen = -1;
            int ivLen = -1;
            boolean bl = hasLen = "AES".equals(cryptoBaseUpper) || "RC2".equals(cryptoBaseUpper) || "RC4".equals(cryptoBaseUpper);
            if (hasLen && cryptoVersion != null) {
                try {
                    keyLen = Integer.parseInt(cryptoVersion) / 8;
                }
                catch (NumberFormatException e) {
                    keyLen = -1;
                }
            }
            if (keyLen == -1) {
                if ("DES".equals(cryptoBaseUpper)) {
                    ivLen = 8;
                    keyLen = "EDE3".equalsIgnoreCase(cryptoVersion) ? 24 : 8;
                } else if ("RC4".equals(cryptoBaseUpper)) {
                    ivLen = 0;
                    keyLen = 16;
                } else {
                    keyLen = 16;
                    try {
                        int maxLen = javax.crypto.Cipher.getMaxAllowedKeyLength(cipherName) / 8;
                        if (maxLen < keyLen) {
                            keyLen = maxLen;
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        // empty catch block
                    }
                }
            }
            if (ivLen == -1) {
                ivLen = "AES".equals(cryptoBaseUpper) ? 16 : 8;
            }
            return new int[]{keyLen, ivLen};
        }

        static {
            BLOCK_MODES.add("CBC");
            BLOCK_MODES.add("CFB");
            BLOCK_MODES.add("CFB1");
            BLOCK_MODES.add("CFB8");
            BLOCK_MODES.add("ECB");
            BLOCK_MODES.add("OFB");
        }
    }
}

