/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.parser;

import impl.krypt.asn1.ParseException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class DefiniteInputStream
extends FilterInputStream {
    private int read = 0;
    private final int length;

    DefiniteInputStream(InputStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("Length must be positive");
        }
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        if (this.read == this.length) {
            return -1;
        }
        int b = super.read();
        ++this.read;
        return b;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.read == this.length) {
            return -1;
        }
        int toRead = this.length - this.read < len ? this.length - this.read : len;
        int actuallyRead = super.read(b, off, toRead);
        if (actuallyRead == -1) {
            throw new ParseException("Premature end of value detected.");
        }
        this.read += actuallyRead;
        return actuallyRead;
    }
}

