/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;

public final class FileUtils {
    private static final char[] INVALID_CHARS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
    private static final char SANITIZED_CHAR = '_';

    public static String sanitizePath(String path) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (INVALID_CHARS[i] == File.separatorChar || -1 == path.indexOf(INVALID_CHARS[i])) continue;
            path = path.replace(INVALID_CHARS[i], '_');
        }
        return path;
    }

    public static String sanitizeFileName(String filename) {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            if (-1 == filename.indexOf(INVALID_CHARS[i])) continue;
            filename = filename.replace(INVALID_CHARS[i], '_');
        }
        return filename;
    }

    public static void createRestrictedDirectory(File directory) throws IOException {
        FileUtils.createRestrictedFile(directory, true, true);
    }

    public static void createRestrictedFile(File file, boolean writableByOwner) throws IOException {
        FileUtils.createRestrictedFile(file, false, writableByOwner);
    }

    public static void createParentDir(File f, String eMsg) throws IOException {
        File parent = f.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException(Translator.R("RCantCreateDir", eMsg == null ? parent : eMsg));
        }
    }

    public static void createParentDir(File f) throws IOException {
        FileUtils.createParentDir(f, null);
    }

    public static void deleteWithErrMesg(File f, String eMsg) {
        if (f.exists() && !f.delete()) {
            System.err.println(Translator.R("RCantDeleteFile", eMsg == null ? f : eMsg));
        }
    }

    public static void deleteWithErrMesg(File f) {
        FileUtils.deleteWithErrMesg(f, null);
    }

    private static void createRestrictedFile(File file, boolean isDir, boolean writableByOwner) throws IOException {
        File tempFile = null;
        tempFile = new File(file.getCanonicalPath() + ".temp");
        if (isDir) {
            if (!tempFile.mkdir()) {
                throw new IOException(Translator.R("RCantCreateDir", tempFile));
            }
        } else if (!tempFile.createNewFile()) {
            throw new IOException(Translator.R("RCantCreateFile", tempFile));
        }
        if (JNLPRuntime.isWindows()) {
            if (!tempFile.setExecutable(false, false)) {
                System.err.println(Translator.R("RRemoveXPermFailed", tempFile));
            }
            if (!tempFile.setReadable(false, false)) {
                System.err.println(Translator.R("RRemoveRPermFailed", tempFile));
            }
            if (!tempFile.setWritable(false, false)) {
                System.err.println(Translator.R("RRemoveWPermFailed", tempFile));
            }
            if (!tempFile.setReadable(true, true)) {
                System.err.println(Translator.R("RGetRPermFailed", tempFile));
            }
            if (writableByOwner && !tempFile.setWritable(true, true)) {
                System.err.println(Translator.R("RGetWPermFailed", tempFile));
            }
            if (isDir && !tempFile.setExecutable(true, true)) {
                System.err.println(Translator.R("RGetXPermFailed", tempFile));
            }
            if (!tempFile.renameTo(file)) {
                System.err.println(Translator.R("RCantRename", tempFile, file));
            }
        } else {
            if (!tempFile.setExecutable(false, false)) {
                throw new IOException(Translator.R("RRemoveXPermFailed", tempFile));
            }
            if (!tempFile.setReadable(false, false)) {
                throw new IOException(Translator.R("RRemoveRPermFailed", tempFile));
            }
            if (!tempFile.setWritable(false, false)) {
                throw new IOException(Translator.R("RRemoveWPermFailed", tempFile));
            }
            if (!tempFile.setReadable(true, true)) {
                throw new IOException(Translator.R("RGetRPermFailed", tempFile));
            }
            if (writableByOwner && !tempFile.setWritable(true, true)) {
                throw new IOException(Translator.R("RGetWPermFailed", tempFile));
            }
            if (isDir && !tempFile.setExecutable(true, true)) {
                throw new IOException(Translator.R("RGetXPermFailed", tempFile));
            }
            if (!tempFile.renameTo(file)) {
                throw new IOException(Translator.R("RCantRename", tempFile, file));
            }
        }
    }

    public static String displayablePath(String path) {
        int DEFAULT_LENGTH = 40;
        return FileUtils.displayablePath(path, 40);
    }

    public static String displayablePath(String path, int visibleChars) {
        if (path == null || path.length() <= visibleChars) {
            return path;
        }
        String OMITTED = "...";
        int OMITTED_LENGTH = "...".length();
        int MIN_PREFIX_LENGTH = 4;
        int MIN_SUFFIX_LENGTH = 4;
        if (visibleChars < OMITTED_LENGTH + 4 + 4) {
            return path.substring(path.length() - visibleChars);
        }
        int affixLength = (visibleChars - OMITTED_LENGTH) / 2;
        String prefix = path.substring(0, affixLength);
        String suffix = path.substring(path.length() - affixLength);
        return prefix + "..." + suffix;
    }

    public static void recursiveDelete(File file, File base) throws IOException {
        if (JNLPRuntime.isDebug()) {
            System.err.println("Deleting: " + file);
        }
        if (!file.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            throw new IOException("Trying to delete a file outside Netx's basedir: " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.recursiveDelete(children[i], base);
            }
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete file: " + file);
        }
    }

    public static FileLock getFileLock(String path, boolean shared, boolean allowBlock) throws FileNotFoundException {
        RandomAccessFile rafFile = new RandomAccessFile(path, "rw");
        FileChannel fc = rafFile.getChannel();
        FileLock lock = null;
        try {
            if (!shared) {
                lock = allowBlock ? fc.lock(0L, Long.MAX_VALUE, false) : fc.tryLock(0L, Long.MAX_VALUE, false);
            } else {
                lock = fc.lock(0L, 1L, true);
                if (!lock.isShared()) {
                    FileLock tempLock = null;
                    for (long pos = 1L; tempLock == null && pos < 0x7FFFFFFFFFFFFFFEL; ++pos) {
                        tempLock = fc.tryLock(pos, 1L, false);
                    }
                    lock.release();
                    lock = tempLock;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lock;
    }
}

