/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogMessage;

public final class SecurityDialogMessageHandler
implements Runnable {
    private BlockingQueue<SecurityDialogMessage> queue = new LinkedBlockingQueue<SecurityDialogMessage>();

    @Override
    public void run() {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Starting security dialog thread");
        }
        while (true) {
            try {
                while (true) {
                    SecurityDialogMessage msg = this.queue.take();
                    this.handleMessage(msg);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void handleMessage(SecurityDialogMessage message) {
        final SecurityDialogMessage msg = message;
        final SecurityDialog dialog = new SecurityDialog(message.dialogType, message.accessType, message.file, message.certVerifier, message.certificate, message.extras);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                msg.userResponse = dialog.getValue();
                if (msg.toDispose != null) {
                    msg.toDispose.dispose();
                }
                if (msg.lock != null) {
                    msg.lock.release();
                }
            }
        });
        dialog.setVisible(true);
    }

    public void postMessage(SecurityDialogMessage message) {
        try {
            this.queue.put(message);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

