/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.browser;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.browser.FirefoxPreferencesFinder;
import net.sourceforge.jnlp.browser.FirefoxPreferencesParser;
import net.sourceforge.jnlp.runtime.JNLPProxySelector;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.PacEvaluator;
import net.sourceforge.jnlp.runtime.PacEvaluatorFactory;
import net.sourceforge.jnlp.runtime.Translator;

public class BrowserAwareProxySelector
extends JNLPProxySelector {
    public static final int BROWSER_PROXY_TYPE_NONE = 0;
    public static final int BROWSER_PROXY_TYPE_MANUAL = 1;
    public static final int BROWSER_PROXY_TYPE_PAC = 2;
    public static final int BROWSER_PROXY_TYPE_NONE2 = 3;
    public static final int BROWSER_PROXY_TYPE_AUTO = 4;
    public static final int BROWSER_PROXY_TYPE_SYSTEM = 5;
    private int browserProxyType = 0;
    private URL browserAutoConfigUrl;
    private Boolean browserUseSameProxy;
    private String browserHttpProxyHost;
    private int browserHttpProxyPort;
    private String browserHttpsProxyHost;
    private int browserHttpsProxyPort;
    private String browserFtpProxyHost;
    private int browserFtpProxyPort;
    private String browserSocks4ProxyHost;
    private int browserSocks4ProxyPort;
    private PacEvaluator browserProxyAutoConfig = null;

    public BrowserAwareProxySelector() {
        try {
            this.initFromBrowserConfig();
        }
        catch (IOException e) {
            if (JNLPRuntime.isDebug()) {
                e.printStackTrace();
            }
            System.err.println(Translator.R("RProxyFirefoxNotFound"));
            this.browserProxyType = 0;
        }
    }

    private void initFromBrowserConfig() throws IOException {
        File preferencesFile = FirefoxPreferencesFinder.find();
        FirefoxPreferencesParser parser = new FirefoxPreferencesParser(preferencesFile);
        parser.parse();
        Map<String, String> prefs = parser.getPreferences();
        String type = prefs.get("network.proxy.type");
        this.browserProxyType = type != null ? Integer.valueOf(type) : 4;
        try {
            String url = prefs.get("network.proxy.autoconfig_url");
            if (url != null) {
                this.browserAutoConfigUrl = new URL(url);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (this.browserProxyType == 2 && this.browserAutoConfigUrl != null) {
            this.browserProxyAutoConfig = PacEvaluatorFactory.getPacEvaluator(this.browserAutoConfigUrl);
        }
        this.browserUseSameProxy = Boolean.valueOf(prefs.get("network.proxy.share_proxy_settings"));
        this.browserHttpProxyHost = prefs.get("network.proxy.http");
        this.browserHttpProxyPort = this.stringToPort(prefs.get("network.proxy.http_port"));
        this.browserHttpsProxyHost = prefs.get("network.proxy.ssl");
        this.browserHttpsProxyPort = this.stringToPort(prefs.get("network.proxy.ssl_port"));
        this.browserFtpProxyHost = prefs.get("network.proxy.ftp");
        this.browserFtpProxyPort = this.stringToPort(prefs.get("network.proxy.ftp_port"));
        this.browserSocks4ProxyHost = prefs.get("network.proxy.socks");
        this.browserSocks4ProxyPort = this.stringToPort(prefs.get("network.proxy.socks_port"));
    }

    private int stringToPort(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
    }

    @Override
    protected List<Proxy> getFromBrowser(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        String optionDescription = null;
        switch (this.browserProxyType) {
            case 2: {
                proxies.addAll(this.getFromBrowserPAC(uri));
                break;
            }
            case 1: {
                proxies.addAll(this.getFromBrowserConfiguration(uri));
                break;
            }
            case 0: {
                proxies.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                if (optionDescription == null) {
                    optionDescription = "Automatic";
                }
            }
            case 5: {
                if (optionDescription == null) {
                    optionDescription = "System";
                }
            }
            default: {
                if (optionDescription == null) {
                    optionDescription = "Unknown";
                }
                if (JNLPRuntime.isDebug()) {
                    System.err.println(Translator.R("RProxyFirefoxOptionNotImplemented", this.browserProxyType, optionDescription));
                }
                proxies.add(Proxy.NO_PROXY);
            }
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Browser selected proxies: " + ((Object)proxies).toString());
        }
        return proxies;
    }

    private List<Proxy> getFromBrowserPAC(URI uri) {
        if (this.browserAutoConfigUrl == null || uri.getScheme().equals("socket")) {
            return Arrays.asList(Proxy.NO_PROXY);
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        try {
            String proxiesString = this.browserProxyAutoConfig.getProxies(uri.toURL());
            proxies.addAll(BrowserAwareProxySelector.getProxiesFromPacResult(proxiesString));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    private List<Proxy> getFromBrowserConfiguration(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        String scheme = uri.getScheme();
        if (this.browserUseSameProxy.booleanValue()) {
            InetSocketAddress sa = new InetSocketAddress(this.browserHttpProxyHost, this.browserHttpProxyPort);
            Proxy proxy = scheme.equals("socket") ? new Proxy(Proxy.Type.SOCKS, sa) : new Proxy(Proxy.Type.HTTP, sa);
            proxies.add(proxy);
        } else if (scheme.equals("http")) {
            InetSocketAddress sa = new InetSocketAddress(this.browserHttpProxyHost, this.browserHttpProxyPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        } else if (scheme.equals("https")) {
            InetSocketAddress sa = new InetSocketAddress(this.browserHttpsProxyHost, this.browserHttpsProxyPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        } else if (scheme.equals("ftp")) {
            InetSocketAddress sa = new InetSocketAddress(this.browserFtpProxyHost, this.browserFtpProxyPort);
            proxies.add(new Proxy(Proxy.Type.HTTP, sa));
        } else if (scheme.equals("socket")) {
            InetSocketAddress sa = new InetSocketAddress(this.browserSocks4ProxyHost, this.browserSocks4ProxyPort);
            proxies.add(new Proxy(Proxy.Type.SOCKS, sa));
        } else {
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }
}

