/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPCreator;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import sun.misc.BASE64Decoder;

public class PluginBridge
extends JNLPFile {
    private PluginParameters params;
    private Set<String> jars = new HashSet<String>();
    private List<String> codeBaseFolders = new ArrayList<String>();
    private String[] cacheJars = new String[0];
    private String[] cacheExJars = new String[0];
    private boolean usePack;
    private boolean useVersion;
    private boolean useJNLPHref;

    public PluginBridge(URL codebase, URL documentBase, String jar, String main, int width, int height, PluginParameters params) throws Exception {
        this(codebase, documentBase, jar, main, width, height, params, new JNLPCreator());
    }

    private void addArchiveEntries(String[] archives) {
        for (String archiveEntry : archives) {
            if ((archiveEntry = archiveEntry.trim()).endsWith("/") || archiveEntry.endsWith(File.pathSeparator)) {
                this.codeBaseFolders.add(archiveEntry);
                continue;
            }
            this.jars.add(archiveEntry);
        }
    }

    public PluginBridge(URL codebase, URL documentBase, String archive, String main, int width, int height, PluginParameters params, JNLPCreator jnlpCreator) throws Exception {
        String cacheArchiveEx;
        this.specVersion = new Version("1.0");
        this.fileVersion = new Version("1.1");
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        this.params = params;
        if (params.getJNLPHref() != null) {
            this.useJNLPHref = true;
            try {
                JARDesc[] jarDescs;
                URL jnlp = new URL(this.codeBase, params.getJNLPHref());
                JNLPFile jnlpFile = null;
                if (params.getJNLPEmbedded() != null) {
                    ByteArrayInputStream jnlpInputStream = new ByteArrayInputStream(PluginBridge.decodeBase64String(params.getJNLPEmbedded()));
                    jnlpFile = new JNLPFile(jnlpInputStream, this.codeBase, false);
                } else {
                    jnlpFile = jnlpCreator.create(jnlp, null, false, JNLPRuntime.getDefaultUpdatePolicy(), this.codeBase);
                }
                if (jnlpFile.isApplet()) {
                    main = jnlpFile.getApplet().getMainClass();
                }
                Map<String, String> jnlpParams = jnlpFile.getApplet().getParameters();
                this.info = jnlpFile.info;
                for (Map.Entry<String, String> entry : jnlpParams.entrySet()) {
                    this.params.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                for (JARDesc jarDesc : jarDescs = jnlpFile.getResources().getJARs()) {
                    String fileName = jarDesc.getLocation().toExternalForm();
                    this.jars.add(fileName);
                }
            }
            catch (MalformedURLException e) {
                System.err.println("Unable to get JNLP file at: " + params.getJNLPHref() + " with context of URL as: " + this.codeBase.toExternalForm());
            }
        } else {
            this.info = new ArrayList();
            this.useJNLPHref = false;
        }
        String cacheArchive = params.getCacheArchive();
        if (!cacheArchive.isEmpty()) {
            String[] versions = new String[]{};
            String cacheVersion = params.getCacheVersion();
            if (!cacheVersion.isEmpty()) {
                versions = cacheVersion.split(",");
            }
            String[] jars = cacheArchive.split(",");
            this.cacheJars = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                this.cacheJars[i] = jars[i].trim();
                if (versions.length <= 0) continue;
                int n = i;
                this.cacheJars[n] = this.cacheJars[n] + ";" + versions[i].trim();
            }
        }
        if (!(cacheArchiveEx = params.getCacheArchiveEx()).isEmpty()) {
            this.cacheExJars = cacheArchiveEx.split(",");
        }
        if (archive != null && archive.length() > 0) {
            String[] archives = archive.split(",");
            this.addArchiveEntries(archives);
            if (JNLPRuntime.isDebug()) {
                System.err.println("Jar string: " + archive);
                System.err.println("jars length: " + archives.length);
            }
        }
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        String mainClass = main.replace('/', '.');
        this.launchType = new AppletDesc(this.getTitle(), mainClass, documentBase, width, height, params.getUnmodifiableMap());
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
        this.uniqueKey = params.getUniqueKey(codebase);
        this.usePack = false;
        this.useVersion = false;
        String jargs = params.getJavaArguments();
        if (!jargs.isEmpty()) {
            for (String s : jargs.split(" ")) {
                String[] parts = s.trim().split("=");
                if (parts.length != 2 || !Boolean.valueOf(parts[1]).booleanValue()) continue;
                if ("-Djnlp.packEnabled".equals(parts[0])) {
                    this.usePack = true;
                    continue;
                }
                if (!"-Djnlp.versionEnabled".equals(parts[0])) continue;
                this.useVersion = true;
            }
        }
    }

    public List<String> getArchiveJars() {
        return new ArrayList<String>(this.jars);
    }

    public boolean codeBaseLookup() {
        return this.params.useCodebaseLookup();
    }

    public boolean useJNLPHref() {
        return this.useJNLPHref;
    }

    @Override
    public DownloadOptions getDownloadOptions() {
        return new DownloadOptions(this.usePack, this.useVersion);
    }

    @Override
    public String getTitle() {
        String inManifestTitle = super.getTitleFromManifest();
        if (inManifestTitle != null) {
            return inManifestTitle;
        }
        String mainClass = this.getManifestsAttributes().getMainClass();
        if (mainClass != null) {
            return mainClass;
        }
        return this.params.getAppletTitle();
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                if (launchType.equals(JARDesc.class)) {
                    try {
                        Version version;
                        String jar;
                        ArrayList<JARDesc> jarDescs = new ArrayList<JARDesc>();
                        jarDescs.addAll(PluginBridge.this.sharedResources.getResources(JARDesc.class));
                        for (String name : PluginBridge.this.jars) {
                            if (name.length() <= 0) continue;
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, name), null, null, false, true, false, true));
                        }
                        boolean cacheable = true;
                        if (PluginBridge.this.params.getCacheOption().equalsIgnoreCase("no")) {
                            cacheable = false;
                        }
                        for (String cacheJar : PluginBridge.this.cacheJars) {
                            String[] jarAndVer = cacheJar.split(";");
                            jar = jarAndVer[0];
                            version = null;
                            if (jar.length() == 0) continue;
                            if (jarAndVer.length > 1) {
                                version = new Version(jarAndVer[1]);
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, false, true, false, cacheable));
                        }
                        for (String cacheExJar : PluginBridge.this.cacheExJars) {
                            if (cacheExJar.length() == 0) continue;
                            String[] jarInfo = cacheExJar.split(";");
                            jar = jarInfo[0].trim();
                            version = null;
                            boolean lazy = true;
                            if (jarInfo.length > 1) {
                                if (jarInfo[1].equals("preload")) {
                                    lazy = false;
                                } else {
                                    version = new Version(jarInfo[1].trim());
                                }
                                if (jarInfo.length > 2) {
                                    lazy = false;
                                    version = new Version(jarInfo[2].trim());
                                }
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, lazy, true, false, false));
                        }
                        ArrayList<JARDesc> result = jarDescs;
                        return result;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return PluginBridge.this.sharedResources.getResources(launchType);
            }

            @Override
            public JARDesc[] getJARs() {
                List<JARDesc> jarDescs = this.getResources(JARDesc.class);
                return jarDescs.toArray(new JARDesc[jarDescs.size()]);
            }

            @Override
            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    public List<String> getCodeBaseFolders() {
        return new ArrayList<String>(this.codeBaseFolders);
    }

    @Override
    public ResourcesDesc[] getResourcesDescs(Locale locale, String os, String arch) {
        return new ResourcesDesc[]{this.getResources(locale, os, arch)};
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }

    static byte[] decodeBase64String(String encodedString) throws IOException {
        BASE64Decoder base64 = new BASE64Decoder();
        return base64.decodeBuffer(encodedString);
    }
}

