/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;

public class IdUtil {
    public static boolean isValidCompositeID(String name) {
        if (name.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c || c == '_' || i != 0 && i != name.length() - 1 && c == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidSimpleID(String name) {
        if (name.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c || c == '_')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getValidId(String projectName) {
        return projectName.replaceAll("[^a-zA-Z0-9\\._]", "_");
    }

    public static String getValidName(String id, String nameFieldQualifier) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            String name = String.valueOf(Character.toUpperCase(token.charAt(0))) + (token.length() > 1 ? token.substring(1) : "");
            return NLS.bind((String)nameFieldQualifier, (Object)name);
        }
        return "";
    }

    public static String getValidProvider(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        int count = tok.countTokens();
        if (count > 2 && tok.nextToken().equals("com")) {
            return tok.nextToken().toUpperCase();
        }
        return "";
    }
}

