/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LaunchConfigurationInfo {
    private HashMap fAttributes;
    private ILaunchConfigurationType fType;
    private static boolean fgIsSun14x;

    static {
        String version;
        fgIsSun14x = false;
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.startsWith("Sun Microsystems") && (version = System.getProperty("java.vm.version")).startsWith("1.4")) {
            fgIsSun14x = true;
        }
    }

    protected LaunchConfigurationInfo() {
        this.setAttributeTable(new HashMap(10));
    }

    private HashMap getAttributeTable() {
        return this.fAttributes;
    }

    private void setAttributeTable(HashMap table) {
        this.fAttributes = table;
    }

    protected void setAttributes(Map map) {
        if (map == null) {
            this.setAttributeTable(new HashMap());
            return;
        }
        Set entrySet = map.entrySet();
        HashMap attributes = new HashMap(entrySet.size());
        for (Map.Entry entry : entrySet) {
            attributes.put(entry.getKey(), entry.getValue());
        }
        this.setAttributeTable(attributes);
    }

    protected String getStringAttribute(String key, String defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof String) {
                return (String)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_Attribute__0__is_not_of_type_java_lang_String__1, (Object[])new String[]{key}), null));
        }
        return defaultValue;
    }

    protected int getIntAttribute(String key, int defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Integer) {
                return (Integer)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_Attribute__0__is_not_of_type_int__2, (Object[])new String[]{key}), null));
        }
        return defaultValue;
    }

    protected boolean getBooleanAttribute(String key, boolean defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Boolean) {
                return (Boolean)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_Attribute__0__is_not_of_type_boolean__3, (Object[])new String[]{key}), null));
        }
        return defaultValue;
    }

    protected List getListAttribute(String key, List defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof List) {
                return (List)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_Attribute__0__is_not_of_type_java_util_List__1, (Object[])new String[]{key}), null));
        }
        return defaultValue;
    }

    protected Map getMapAttribute(String key, Map defaultValue) throws CoreException {
        Object attr = this.getAttributeTable().get(key);
        if (attr != null) {
            if (attr instanceof Map) {
                return (Map)attr;
            }
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_Attribute__0__is_not_of_type_java_util_Map__1, (Object[])new String[]{key}), null));
        }
        return defaultValue;
    }

    protected void setType(ILaunchConfigurationType type) {
        this.fType = type;
    }

    protected ILaunchConfigurationType getType() {
        return this.fType;
    }

    protected LaunchConfigurationInfo getCopy() {
        LaunchConfigurationInfo copy = new LaunchConfigurationInfo();
        copy.setType(this.getType());
        copy.setAttributeTable(this.getAttributes());
        return copy;
    }

    protected HashMap getAttributes() {
        return (HashMap)this.getAttributeTable().clone();
    }

    protected void setAttribute(String key, Object value) {
        if (value == null) {
            this.getAttributeTable().remove(key);
        } else {
            this.getAttributeTable().put(key, value);
        }
    }

    protected String getAsXML() throws CoreException, IOException, ParserConfigurationException, TransformerException {
        Document doc = LaunchManager.getDocument();
        Element configRootElement = doc.createElement("launchConfiguration");
        doc.appendChild(configRootElement);
        configRootElement.setAttribute("type", this.getType().getIdentifier());
        for (String key : this.getAttributeTable().keySet()) {
            if (key == null) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationInfo_36, null));
            }
            Object value = this.getAttributeTable().get(key);
            if (value == null) continue;
            Element element = null;
            String valueString = null;
            if (value instanceof String) {
                valueString = (String)value;
                element = this.createKeyValueElement(doc, "stringAttribute", key, valueString);
            } else if (value instanceof Integer) {
                valueString = ((Integer)value).toString();
                element = this.createKeyValueElement(doc, "intAttribute", key, valueString);
            } else if (value instanceof Boolean) {
                valueString = ((Boolean)value).toString();
                element = this.createKeyValueElement(doc, "booleanAttribute", key, valueString);
            } else if (value instanceof List) {
                element = this.createListElement(doc, "listAttribute", key, (List)value);
            } else if (value instanceof Map) {
                element = this.createMapElement(doc, "mapAttribute", key, (Map)value);
            }
            configRootElement.appendChild(element);
        }
        return LaunchManager.serializeDocument(doc);
    }

    protected Element createKeyValueElement(Document doc, String elementType, String key, String value) {
        Element element = doc.createElement(elementType);
        element.setAttribute("key", key);
        element.setAttribute("value", value);
        return element;
    }

    protected Element createListElement(Document doc, String elementType, String listKey, List list) {
        Element listElement = doc.createElement(elementType);
        listElement.setAttribute("key", listKey);
        for (String value : list) {
            Element element = doc.createElement("listEntry");
            element.setAttribute("value", value);
            listElement.appendChild(element);
        }
        return listElement;
    }

    protected Element createMapElement(Document doc, String elementType, String mapKey, Map map) {
        Element mapElement = doc.createElement(elementType);
        mapElement.setAttribute("key", mapKey);
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            Element element = doc.createElement("mapEntry");
            element.setAttribute("key", key);
            element.setAttribute("value", value);
            mapElement.appendChild(element);
        }
        return mapElement;
    }

    protected void initializeFromXML(Element root) throws CoreException {
        if (!root.getNodeName().equalsIgnoreCase("launchConfiguration")) {
            throw this.getInvalidFormatDebugException();
        }
        String id = root.getAttribute("type");
        if (id == null) {
            throw this.getInvalidFormatDebugException();
        }
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(id);
        if (type == null) {
            String message = MessageFormat.format((String)DebugCoreMessages.LaunchConfigurationInfo_missing_type, (Object[])new Object[]{id});
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5020, message, null));
        }
        this.setType(type);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase("stringAttribute")) {
                    this.setStringAttribute(element);
                } else if (nodeName.equalsIgnoreCase("intAttribute")) {
                    this.setIntegerAttribute(element);
                } else if (nodeName.equalsIgnoreCase("booleanAttribute")) {
                    this.setBooleanAttribute(element);
                } else if (nodeName.equalsIgnoreCase("listAttribute")) {
                    this.setListAttribute(element);
                } else if (nodeName.equalsIgnoreCase("mapAttribute")) {
                    this.setMapAttribute(element);
                }
            }
            ++i;
        }
    }

    protected void setStringAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, value);
    }

    protected void setIntegerAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, new Integer(value));
    }

    protected void setBooleanAttribute(Element element) throws CoreException {
        String key = this.getKeyAttribute(element);
        String value = this.getValueAttribute(element);
        this.setAttribute(key, Boolean.valueOf(value));
    }

    protected void setListAttribute(Element element) throws CoreException {
        String listKey = element.getAttribute("key");
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        ArrayList<String> list = new ArrayList<String>(entryCount);
        int i = 0;
        while (i < entryCount) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element subElement = (Element)node;
                String nodeName = subElement.getNodeName();
                if (!nodeName.equalsIgnoreCase("listEntry")) {
                    throw this.getInvalidFormatDebugException();
                }
                String value = this.getValueAttribute(subElement);
                list.add(value);
            }
            ++i;
        }
        this.setAttribute(listKey, list);
    }

    protected void setMapAttribute(Element element) throws CoreException {
        String mapKey = element.getAttribute("key");
        NodeList nodeList = element.getChildNodes();
        int entryCount = nodeList.getLength();
        HashMap<String, String> map = new HashMap<String, String>(entryCount);
        int i = 0;
        while (i < entryCount) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                Element subElement = (Element)node;
                String nodeName = subElement.getNodeName();
                if (!nodeName.equalsIgnoreCase("mapEntry")) {
                    throw this.getInvalidFormatDebugException();
                }
                String key = this.getKeyAttribute(subElement);
                String value = this.getValueAttribute(subElement);
                map.put(key, value);
            }
            ++i;
        }
        this.setAttribute(mapKey, map);
    }

    protected String getKeyAttribute(Element element) throws CoreException {
        String key = element.getAttribute("key");
        if (key == null) {
            throw this.getInvalidFormatDebugException();
        }
        return key;
    }

    protected String getValueAttribute(Element element) throws CoreException {
        String value = element.getAttribute("value");
        if (value == null) {
            throw this.getInvalidFormatDebugException();
        }
        return value;
    }

    protected DebugException getInvalidFormatDebugException() {
        return new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationInfo_Invalid_launch_configuration_XML__10, null));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LaunchConfigurationInfo)) {
            return false;
        }
        LaunchConfigurationInfo other = (LaunchConfigurationInfo)obj;
        if (!this.fType.getIdentifier().equals(other.getType().getIdentifier())) {
            return false;
        }
        return this.compareAttributes(this.fAttributes, other.getAttributeTable());
    }

    protected boolean compareAttributes(HashMap map1, HashMap map2) {
        LaunchManager manager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
        if (map1.size() == map2.size()) {
            for (String key : map1.keySet()) {
                Object attr1 = map1.get(key);
                Object attr2 = map2.get(key);
                if (attr2 == null) {
                    return false;
                }
                Comparator comp = manager.getComparator(key);
                if (comp == null) {
                    if (fgIsSun14x && attr2 instanceof String & attr1 instanceof String) {
                        attr1 = ((String)attr1).replaceAll("\\r", "");
                        attr2 = ((String)attr2).replaceAll("\\r", "");
                    }
                    if (attr1.equals(attr2)) continue;
                    return false;
                }
                if (comp.compare(attr1, attr2) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.fType.hashCode() + this.fAttributes.size();
    }
}

