/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configuration
implements IConfigurationConstants {
    private HashMap sites = new HashMap();
    private Date date;
    private long lastModified;
    private URL url;
    private boolean transientConfig;
    private boolean isDirty;
    private Configuration linkedConfig;

    public Configuration() {
        this(new Date());
        this.isDirty = true;
    }

    public Configuration(Date date) {
        this.date = date;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setLinkedConfig(Configuration linkedConfig) {
        this.linkedConfig = linkedConfig;
        SiteEntry[] linkedSites = linkedConfig.getSites();
        int i = 0;
        while (i < linkedSites.length) {
            linkedSites[i].setUpdateable(false);
            ++i;
        }
    }

    public Configuration getLinkedConfig() {
        return this.linkedConfig;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void addSiteEntry(String url, SiteEntry site) {
        if (this.sites.get(url = Utils.canonicalizeURL(url)) == null && (this.linkedConfig == null || this.linkedConfig.sites.get(url) == null)) {
            site.setConfig(this);
            this.sites.put(url, site);
        }
    }

    public void removeSiteEntry(String url) {
        url = Utils.canonicalizeURL(url);
        this.sites.remove(url);
    }

    public SiteEntry getSiteEntry(String url) {
        SiteEntry site = (SiteEntry)this.sites.get(url = Utils.canonicalizeURL(url));
        if (site == null && this.linkedConfig != null) {
            site = this.linkedConfig.getSiteEntry(url);
        }
        return site;
    }

    public SiteEntry[] getSites() {
        if (this.linkedConfig == null) {
            return this.sites.values().toArray(new SiteEntry[this.sites.size()]);
        }
        ArrayList combinedSites = new ArrayList(this.sites.values());
        combinedSites.addAll(this.linkedConfig.sites.values());
        return combinedSites.toArray(new SiteEntry[combinedSites.size()]);
    }

    public Element toXML(Document doc) throws CoreException {
        try {
            Element configElement = doc.createElement("config");
            configElement.setAttribute("version", "3.0");
            configElement.setAttribute("date", String.valueOf(this.date.getTime()));
            String transitory = this.isTransient() ? "true" : "false";
            configElement.setAttribute("transient", transitory);
            if (this.linkedConfig != null) {
                configElement.setAttribute("shared_ur", Utils.makeRelative(Utils.getInstallURL(), this.linkedConfig.getURL()).toExternalForm());
            }
            SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
            int i = 0;
            while (i < list.length) {
                if (this.linkedConfig == null || this.linkedConfig.getSiteEntry(list[i].getURL().toExternalForm()) == null) {
                    Element siteElement = list[i].toXML(doc);
                    configElement.appendChild(siteElement);
                }
                ++i;
            }
            return configElement;
        }
        catch (Exception e) {
            throw Utils.newCoreException("", e);
        }
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void setTransient(boolean isTransient) {
        this.transientConfig = isTransient;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        SiteEntry[] sites = this.getSites();
        int i = 0;
        while (i < sites.length) {
            if (sites[i].unconfigureFeatureEntry(feature)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long lastModified() {
        if (this.lastModified != 0L) {
            return this.lastModified;
        }
        return this.date.getTime();
    }
}

