/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractJavaEditorTextHover {
    private IPreferenceStore fStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
    private DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    private boolean fAllAnnotations;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog(buffer, 0, AbstractAnnotationHover.getStyleSheet());
        buffer.append(HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel model;
        IPath path;
        if (textViewer instanceof ISourceViewer) {
            path = null;
            model = ((ISourceViewer)textViewer).getAnnotationModel();
        } else {
            path = this.getEditorInputPath();
            model = this.getAnnotationModel(path);
        }
        if (model == null) {
            return null;
        }
        try {
            JavaAnnotationIterator e = new JavaAnnotationIterator(model, true, this.fAllAnnotations);
            int layer = -1;
            String message = null;
            while (e.hasNext()) {
                String msg;
                Annotation a = (Annotation)e.next();
                AnnotationPreference preference = this.getAnnotationPreference(a);
                if (preference == null || (preference.getTextPreferenceKey() == null || !this.fStore.getBoolean(preference.getTextPreferenceKey())) && (preference.getHighlightPreferenceKey() == null || !this.fStore.getBoolean(preference.getHighlightPreferenceKey()))) continue;
                Position p = model.getPosition(a);
                int l = this.fAnnotationAccess.getLayer(a);
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                message = msg;
                layer = l;
            }
            if (layer > -1) {
                String string = this.formatMessage(message);
                return string;
            }
        }
        finally {
            try {
                if (path != null) {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.disconnect(path, null);
                }
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    private IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel(IPath path) {
        if (path == null) {
            return null;
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, null);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex.getStatus());
            return null;
        }
        IAnnotationModel model = null;
        try {
            IAnnotationModel iAnnotationModel = model = manager.getTextFileBuffer(path).getAnnotationModel();
            return iAnnotationModel;
        }
        finally {
            if (model == null) {
                try {
                    manager.disconnect(path, null);
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex.getStatus());
                }
            }
        }
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

