/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSMetaModelImpl;
import org.eclipse.wst.css.core.internal.metamodelimpl.ProfileHandler;
import org.eclipse.wst.css.core.internal.metamodelimpl.XMLReaderUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class ProfileLoader {
    CSSMetaModelImpl fMetaModel = null;
    private static final String PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private ResourceBundle fResourceBundle = null;
    private boolean fLogging = false;

    private ProfileLoader() {
    }

    ProfileLoader(ResourceBundle resourceBundle, boolean logging) {
        this.fResourceBundle = resourceBundle;
        this.fLogging = logging;
    }

    static void loadProfile(CSSMetaModelImpl metamodel, InputStream input, ResourceBundle resourceBundle, boolean logging) {
        try {
            XMLReader xmlReader = XMLReaderUtil.createXMLReader(PARSER_NAME);
            xmlReader.setContentHandler(new ProfileHandler(metamodel, resourceBundle, logging));
            xmlReader.parse(new InputSource(input));
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        catch (SAXException e) {
            Logger.logException(e);
        }
    }

    CSSMetaModel loadProfile(InputStream input) {
        if (this.fMetaModel == null) {
            this.fMetaModel = new CSSMetaModelImpl();
        }
        ProfileLoader.loadProfile(this.fMetaModel, input, this.fResourceBundle, this.fLogging);
        this.fMetaModel.loadCompleted();
        return this.fMetaModel;
    }
}

