/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.viewers.NavigableTableViewer;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddEnumerationsCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.ChangeToLocalSimpleTypeCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.SetXSDFacetValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateXSDPatternFacetCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.XSDFacetSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.widgets.EnumerationsDialog;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexWizard;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Element;

public class SpecificConstraintsWidget
implements SelectionListener,
Listener {
    public static int ENUMERATION = 0;
    public static int PATTERN = 1;
    int kind;
    ConstraintsTableViewer constraintsTableViewer;
    Button addButton;
    Button addUsingDialogButton;
    Button deleteButton;
    Button editButton;
    Composite composite;
    boolean isEnabled;
    TabbedPropertySheetWidgetFactory factory;
    XSDSimpleTypeDefinition input;
    XSDFeature feature;
    boolean isReadOnly;
    CommandStack commandStack;
    XSDFacetSection facetSection;

    public SpecificConstraintsWidget(Composite composite, TabbedPropertySheetWidgetFactory factory, XSDFeature feature, XSDSimpleTypeDefinition input, XSDFacetSection facetSection) {
        this.factory = factory;
        this.input = input;
        this.composite = composite;
        this.feature = feature;
        this.facetSection = facetSection;
        this.createControl(composite);
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.addButton.setEnabled(isEnabled);
        this.addUsingDialogButton.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled);
        this.constraintsTableViewer.getTable().setEnabled(isEnabled);
        this.composite.setEnabled(isEnabled);
    }

    public Control createControl(Composite parent) {
        this.composite = this.factory.createFlatFormComposite(parent);
        GridData data = new GridData();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.constraintsTableViewer = new ConstraintsTableViewer(this.getWidgetFactory().createTable(this.composite, 65538));
        this.constraintsTableViewer.setInput(this.input);
        Table table = this.constraintsTableViewer.getTable();
        table.addSelectionListener((SelectionListener)this);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 150;
        data.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)data);
        table.addListener(11, (Listener)this);
        Composite buttonComposite = this.getWidgetFactory().createComposite(this.composite, 0x800000);
        GridLayout buttonCompositeLayout = new GridLayout();
        buttonCompositeLayout.marginTop = 0;
        buttonCompositeLayout.marginBottom = 0;
        buttonCompositeLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        buttonComposite.setLayoutData((Object)data);
        this.addButton = this.getWidgetFactory().createButton(buttonComposite, Messages._UI_ACTION_ADD, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.addUsingDialogButton = this.getWidgetFactory().createButton(buttonComposite, Messages._UI_ACTION_ADD_WITH_DOTS, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.addUsingDialogButton.setLayoutData((Object)data);
        this.addUsingDialogButton.addSelectionListener((SelectionListener)this);
        this.editButton = this.getWidgetFactory().createButton(buttonComposite, Messages._UI_ACTION_EDIT_WITH_DOTS, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.deleteButton = this.getWidgetFactory().createButton(buttonComposite, Messages._UI_ACTION_DELETE, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.deleteButton.setLayoutData((Object)data);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        return this.composite;
    }

    public void handleEvent(Event event) {
        Table table = this.constraintsTableViewer.getTable();
        if (event.type == 11 && event.widget == table) {
            TableColumn tableColumn = table.getColumn(0);
            tableColumn.setWidth(table.getSize().x);
        }
    }

    public void setInput(Object input) {
        this.constraintsTableViewer.setInput(input);
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        XSDSimpleTypeDefinition st = this.input;
        Element element = st.getElement();
        if (e.widget == this.addButton) {
            EList enumList = st.getEnumerationFacets();
            StringBuffer newName = new StringBuffer("value1");
            int suffix = 1;
            Iterator i = enumList.iterator();
            while (i.hasNext()) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)i.next();
                String value = enumFacet.getLexicalValue();
                if (value == null || !value.equals(newName.toString())) continue;
                newName = new StringBuffer("value" + String.valueOf(++suffix));
            }
            if (this.kind == ENUMERATION) {
                CompoundCommand compoundCommand = new CompoundCommand();
                XSDSimpleTypeDefinition targetSimpleType = null;
                if (this.feature != null) {
                    XSDSimpleTypeDefinition anonymousSimpleType = XSDCommonUIUtils.getAnonymousSimpleType(this.feature, this.input);
                    if (anonymousSimpleType == null) {
                        anonymousSimpleType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                        anonymousSimpleType.setBaseTypeDefinition(this.input);
                        ChangeToLocalSimpleTypeCommand changeToAnonymousCommand = new ChangeToLocalSimpleTypeCommand(Messages._UI_ACTION_CHANGE_PATTERN, this.feature);
                        changeToAnonymousCommand.setAnonymousSimpleType(anonymousSimpleType);
                        compoundCommand.add((Command)changeToAnonymousCommand);
                        this.input = anonymousSimpleType;
                    }
                    targetSimpleType = anonymousSimpleType;
                } else {
                    targetSimpleType = this.input;
                }
                AddEnumerationsCommand command = new AddEnumerationsCommand(Messages._UI_ACTION_ADD_ENUMERATION, targetSimpleType);
                command.setValue(newName.toString());
                compoundCommand.add((Command)command);
                this.commandStack.execute((Command)compoundCommand);
                this.setInput(this.input);
                this.constraintsTableViewer.refresh();
                int newItemIndex = this.constraintsTableViewer.getTable().getItemCount() - 1;
                this.constraintsTableViewer.editElement(this.constraintsTableViewer.getElementAt(newItemIndex), 0);
            }
        } else if (e.widget == this.addUsingDialogButton) {
            Display display = Display.getCurrent();
            display = display == null ? Display.getDefault() : display;
            Shell shell = display.getActiveShell();
            if (this.kind == PATTERN) {
                String initialValue = "";
                RegexWizard wizard = new RegexWizard(initialValue);
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                wizardDialog.setBlockOnOpen(true);
                wizardDialog.create();
                int result = wizardDialog.open();
                if (result == 0) {
                    String newPattern = wizard.getPattern();
                    CompoundCommand compoundCommand = new CompoundCommand();
                    XSDSimpleTypeDefinition targetSimpleType = null;
                    if (this.feature != null) {
                        XSDSimpleTypeDefinition anonymousSimpleType = XSDCommonUIUtils.getAnonymousSimpleType(this.feature, this.input);
                        if (anonymousSimpleType == null) {
                            anonymousSimpleType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                            anonymousSimpleType.setBaseTypeDefinition(this.input);
                            ChangeToLocalSimpleTypeCommand changeToAnonymousCommand = new ChangeToLocalSimpleTypeCommand(Messages._UI_ACTION_CHANGE_PATTERN, this.feature);
                            changeToAnonymousCommand.setAnonymousSimpleType(anonymousSimpleType);
                            compoundCommand.add((Command)changeToAnonymousCommand);
                            this.input = anonymousSimpleType;
                        }
                        targetSimpleType = anonymousSimpleType;
                    } else {
                        targetSimpleType = this.input;
                    }
                    UpdateXSDPatternFacetCommand command = new UpdateXSDPatternFacetCommand(Messages._UI_ACTION_ADD_PATTERN, targetSimpleType, 0);
                    command.setValue(newPattern);
                    this.setInput(this.input);
                    compoundCommand.add((Command)command);
                    this.commandStack.execute((Command)compoundCommand);
                    this.facetSection.doSetInput();
                }
                this.constraintsTableViewer.refresh();
            } else {
                EnumerationsDialog dialog = new EnumerationsDialog(shell);
                dialog.setBlockOnOpen(true);
                int result = dialog.open();
                if (result == 0) {
                    String text = dialog.getText();
                    String delimiter = dialog.getDelimiter();
                    StringTokenizer tokenizer = new StringTokenizer(text, delimiter);
                    CompoundCommand compoundCommand = new CompoundCommand(Messages._UI_ACTION_ADD_ENUMERATIONS);
                    XSDSimpleTypeDefinition targetSimpleType = null;
                    if (this.feature != null) {
                        XSDSimpleTypeDefinition anonymousSimpleType = XSDCommonUIUtils.getAnonymousSimpleType(this.feature, this.input);
                        if (anonymousSimpleType == null) {
                            anonymousSimpleType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                            anonymousSimpleType.setBaseTypeDefinition(this.input);
                            ChangeToLocalSimpleTypeCommand changeToAnonymousCommand = new ChangeToLocalSimpleTypeCommand("", this.feature);
                            changeToAnonymousCommand.setAnonymousSimpleType(anonymousSimpleType);
                            compoundCommand.add((Command)changeToAnonymousCommand);
                            this.input = anonymousSimpleType;
                        }
                        targetSimpleType = anonymousSimpleType;
                    } else {
                        targetSimpleType = this.input;
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!dialog.isPreserveWhitespace()) {
                            token = token.trim();
                        }
                        AddEnumerationsCommand command = new AddEnumerationsCommand(Messages._UI_ACTION_ADD_ENUMERATIONS, targetSimpleType);
                        command.setValue(token);
                        compoundCommand.add((Command)command);
                    }
                    this.commandStack.execute((Command)compoundCommand);
                }
                this.facetSection.doSetInput();
                this.constraintsTableViewer.refresh();
            }
        } else if (e.widget == this.deleteButton) {
            StructuredSelection selection = (StructuredSelection)this.constraintsTableViewer.getSelection();
            CompoundCommand compoundCommand = new CompoundCommand();
            if (selection != null) {
                Iterator i = selection.iterator();
                if (selection.size() > 0) {
                    compoundCommand.setLabel(Messages._UI_ACTION_DELETE_CONSTRAINTS);
                } else {
                    compoundCommand.setLabel(Messages._UI_ACTION_DELETE_PATTERN);
                }
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj == null) continue;
                    if (obj instanceof XSDPatternFacet) {
                        UpdateXSDPatternFacetCommand command = new UpdateXSDPatternFacetCommand("", this.input, 1);
                        command.setPatternToEdit((XSDPatternFacet)obj);
                        compoundCommand.add((Command)command);
                        continue;
                    }
                    if (!(obj instanceof XSDEnumerationFacet)) continue;
                    XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)obj;
                    DeleteCommand deleteCommand = new DeleteCommand(Messages._UI_ACTION_DELETE_ENUMERATION, (XSDConcreteComponent)enumFacet);
                    compoundCommand.add((Command)deleteCommand);
                }
                this.commandStack.execute((Command)compoundCommand);
                this.constraintsTableViewer.refresh();
                if (this.constraintsTableViewer.getTable().getItemCount() == 0) {
                    this.editButton.setEnabled(false);
                    this.deleteButton.setEnabled(false);
                }
            }
        } else if (e.widget == this.editButton) {
            Object obj;
            StructuredSelection selection = (StructuredSelection)this.constraintsTableViewer.getSelection();
            if (selection != null && (obj = selection.getFirstElement()) instanceof XSDPatternFacet) {
                XSDPatternFacet pattern = (XSDPatternFacet)obj;
                String initialValue = pattern.getLexicalValue();
                if (initialValue == null) {
                    initialValue = "";
                }
                Shell shell = Display.getCurrent().getActiveShell();
                RegexWizard wizard = new RegexWizard(initialValue);
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                wizardDialog.setBlockOnOpen(true);
                wizardDialog.create();
                int result = wizardDialog.open();
                if (result == 0) {
                    String newPattern = wizard.getPattern();
                    element.setAttribute("value", newPattern);
                    pattern.setLexicalValue(newPattern);
                    this.constraintsTableViewer.refresh();
                }
            }
        } else if (e.widget == this.constraintsTableViewer.getTable()) {
            StructuredSelection selection = (StructuredSelection)this.constraintsTableViewer.getSelection();
            if (selection.getFirstElement() != null) {
                this.editButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setConstraintKind(int kind) {
        this.kind = kind;
        this.constraintsTableViewer.setInput(this.input);
        this.constraintsTableViewer.refresh();
    }

    public void doModify(Object element, String property, Object value) {
        if (element instanceof TableItem && value != null) {
            TableItem item = (TableItem)element;
            if (item.getData() instanceof XSDPatternFacet) {
                XSDPatternFacet patternFacet = (XSDPatternFacet)item.getData();
                patternFacet.setLexicalValue((String)value);
                item.setData((Object)patternFacet);
                item.setText((String)value);
            } else if (item.getData() instanceof XSDEnumerationFacet) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)item.getData();
                SetXSDFacetValueCommand command = new SetXSDFacetValueCommand(Messages._UI_ACTION_SET_ENUMERATION_VALUE, (XSDFacet)enumFacet);
                command.setValue((String)value);
                this.commandStack.execute((Command)command);
                item.setData((Object)enumFacet);
                item.setText((String)value);
            }
        }
    }

    public Object doGetValue(Object element, String property) {
        if (element instanceof XSDPatternFacet) {
            XSDPatternFacet patternFacet = (XSDPatternFacet)element;
            String value = patternFacet.getLexicalValue();
            if (value == null) {
                value = "";
            }
            return value;
        }
        if (element instanceof XSDEnumerationFacet) {
            XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)element;
            String value = enumFacet.getLexicalValue();
            if (value == null) {
                value = "";
            }
            return value;
        }
        return "";
    }

    class ConstraintsContentProvider
    implements IStructuredContentProvider {
        ConstraintsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList();
            if (inputElement instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition st = (XSDSimpleTypeDefinition)inputElement;
                boolean isDefined = false;
                Iterator iter = SpecificConstraintsWidget.this.kind == PATTERN ? st.getPatternFacets().iterator() : st.getEnumerationFacets().iterator();
                while (iter.hasNext()) {
                    XSDFacet facet = (XSDFacet)iter.next();
                    boolean bl = isDefined = facet.getRootContainer() == SpecificConstraintsWidget.this.facetSection.xsdSchema;
                }
                if (SpecificConstraintsWidget.this.kind == PATTERN) {
                    if (isDefined) {
                        return st.getPatternFacets().toArray();
                    }
                } else if (isDefined) {
                    return st.getEnumerationFacets().toArray();
                }
            }
            return list.toArray();
        }

        public void dispose() {
        }
    }

    class ConstraintsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (SpecificConstraintsWidget.this.kind == PATTERN) {
                return XSDEditorPlugin.getXSDImage("icons/XSDSimplePattern.gif");
            }
            return XSDEditorPlugin.getXSDImage("icons/XSDSimpleEnum.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XSDPatternFacet) {
                XSDPatternFacet pattern = (XSDPatternFacet)element;
                String value = pattern.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            if (element instanceof XSDEnumerationFacet) {
                XSDEnumerationFacet enumFacet = (XSDEnumerationFacet)element;
                String value = enumFacet.getLexicalValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }

    class ConstraintsTableViewer
    extends NavigableTableViewer
    implements ICellModifier {
        protected String[] columnProperties = new String[]{Messages._UI_LABEL_PATTERN};
        protected CellEditor[] cellEditors;
        Table table;

        public ConstraintsTableViewer(Table table) {
            super(table);
            table = this.getTable();
            table.setLinesVisible(true);
            this.setContentProvider((IContentProvider)new ConstraintsContentProvider());
            this.setLabelProvider((IBaseLabelProvider)new ConstraintsTableLabelProvider());
            this.setColumnProperties(this.columnProperties);
            this.setCellModifier(this);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setText(this.columnProperties[0]);
            column.setAlignment(16384);
            column.setResizable(true);
            this.cellEditors = new CellEditor[1];
            TableLayout layout = new TableLayout();
            ColumnWeightData data = new ColumnWeightData(100);
            layout.addColumnData((ColumnLayoutData)data);
            this.cellEditors[0] = new TextCellEditor((Composite)table);
            this.getTable().setLayout((Layout)layout);
            this.setCellEditors(this.cellEditors);
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            SpecificConstraintsWidget.this.doModify(element, property, value);
        }

        public Object getValue(Object element, String property) {
            return SpecificConstraintsWidget.this.doGetValue(element, property);
        }
    }
}

