/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.subscriber.CommitSynchronizeOperation;

public class CommitSynchronizeAction
extends SynchronizeModelAction {
    public CommitSynchronizeAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4});
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        String url = null;
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator iter = selection.iterator();
        String proposedComment = "";
        while (iter.hasNext()) {
            IResource resource;
            ISynchronizeModelElement synchronizeModelElement = (ISynchronizeModelElement)iter.next();
            proposedComment = this.getProposedComment(proposedComment, synchronizeModelElement);
            if (synchronizeModelElement instanceof ChangeSetDiffNode || url != null || selection.size() != 1 || (resource = synchronizeModelElement.getResource()) == null) continue;
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                url = svnResource.getStatus().getUrlString();
                if (url != null && resource.getType() != 1) continue;
                url = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
        }
        return new CommitSynchronizeOperation(configuration, elements, url, proposedComment);
    }

    private String getProposedComment(String proposedComment, ISynchronizeModelElement synchronizeModelElement) {
        if (synchronizeModelElement instanceof ChangeSetDiffNode) {
            if (proposedComment.length() > 0) {
                proposedComment = String.valueOf(proposedComment) + System.getProperty("line.separator");
            }
            ChangeSet set = ((ChangeSetDiffNode)synchronizeModelElement).getSet();
            return String.valueOf(proposedComment) + set.getComment();
        }
        IDiffContainer parent = synchronizeModelElement.getParent();
        while (parent != null) {
            if (parent instanceof ChangeSetDiffNode) {
                if (proposedComment.length() > 0) {
                    proposedComment = String.valueOf(proposedComment) + System.getProperty("line.separator");
                }
                ChangeSet set = ((ChangeSetDiffNode)parent).getSet();
                return String.valueOf(proposedComment) + set.getComment();
            }
            parent = parent.getParent();
        }
        return proposedComment;
    }
}

