/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesAccess;
import org.rubypeople.rdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileStore;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyScriptPreview;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.util.SWTUtil;

public class CodeFormatterConfigurationBlock {
    private static final String DIALOGSTORE_LASTLOADPATH = "org.rubypeople.rdt.ui.codeformatter.loadpath";
    private static final String DIALOGSTORE_LASTSAVEPATH = "org.rubypeople.rdt.ui.codeformatter.savepath";
    private static final String PREVIEW = "=begin\n " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n=end\n\n" + "class MyIntStack\n" + "def initialize\n" + "@stack= []\n" + "end\n" + "def pop\n" + "return @stack.shift\n" + "end\n" + "def push(elem)\n" + "@stack << elem\n" + "end\n" + "def empty?\n" + "@stack.empty?\n" + "end\n" + "end";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected final ProfileManager fProfileManager;
    protected RubyScriptPreview fRubyPreview;
    private PixelConverter fPixConv;
    private IScopeContext fCurrContext;
    private IScopeContext fInstanceScope;

    public CodeFormatterConfigurationBlock(IProject iProject, PreferencesAccess preferencesAccess) {
        this.fInstanceScope = preferencesAccess.getInstanceScope();
        ArrayList arrayList = null;
        try {
            arrayList = ProfileStore.readProfiles(this.fInstanceScope);
        }
        catch (CoreException coreException) {
            RubyPlugin.log(coreException);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.fCurrContext = iProject != null ? preferencesAccess.getProjectScope(iProject) : this.fInstanceScope;
        this.fProfileManager = new ProfileManager(arrayList, this.fCurrContext, preferencesAccess);
        new StoreUpdater();
    }

    public Composite createContents(Composite composite) {
        this.fPixConv = new PixelConverter((Control)composite);
        this.fComposite = this.createComposite(composite, 5);
        this.fProfileCombo = CodeFormatterConfigurationBlock.createProfileCombo(this.fComposite, 2, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc, 32);
        this.fRenameButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_rename_button_desc, 32);
        this.fDeleteButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_remove_button_desc, 32);
        Composite composite2 = this.createComposite(this.fComposite, 4);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 5;
        composite2.setLayoutData((Object)gridData);
        this.fNewButton = CodeFormatterConfigurationBlock.createButton(composite2, FormatterMessages.CodingStyleConfigurationBlock_new_button_desc, 32);
        ((GridData)this.createLabel((Composite)composite2, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodeFormatterConfigurationBlock.createButton(composite2, FormatterMessages.CodingStyleConfigurationBlock_load_button_desc, 128);
        this.fSaveButton = CodeFormatterConfigurationBlock.createButton(composite2, FormatterMessages.CodingStyleConfigurationBlock_save_button_desc, 128);
        this.createLabel(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, 5);
        this.configurePreview(this.fComposite, 5);
        new ButtonController();
        new ProfileComboController();
        new PreviewController();
        return this.fComposite;
    }

    private static Button createButton(Composite composite, String string, int n) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        GridData gridData = new GridData(n);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int n, int n2) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        gridData.widthHint = n2;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private Label createLabel(Composite composite, String string, int n) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(string);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    private void configurePreview(Composite composite, int n) {
        this.fRubyPreview = new RubyScriptPreview(this.fProfileManager.getSelected().getSettings(), composite);
        this.fRubyPreview.setPreviewText(PREVIEW);
        GridData gridData = new GridData(1296);
        gridData.horizontalSpan = n;
        gridData.verticalSpan = 7;
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        this.fRubyPreview.getControl().setLayoutData((Object)gridData);
    }

    public final boolean hasProjectSpecificOptions(IProject iProject) {
        if (iProject != null) {
            return ProfileManager.hasProjectSpecificSettings((IScopeContext)new ProjectScope(iProject));
        }
        return false;
    }

    public boolean performOk() {
        return true;
    }

    public void performDefaults() {
        int n;
        ProfileManager.Profile profile = this.fProfileManager.getProfile("org.rubypeople.rdt.ui.default.eclipse_profile");
        if (profile != null && (n = this.fProfileManager.getSortedProfiles().indexOf(profile)) != -1) {
            this.fProfileManager.setSelected(profile);
        }
    }

    public void dispose() {
    }

    public void enableProjectSpecificSettings(boolean bl) {
        if (bl) {
            this.fProfileManager.commitChanges(this.fCurrContext);
        } else {
            this.fProfileManager.clearAllSettings(this.fCurrContext);
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        public void update(Observable observable, Object object) {
            int n = (Integer)object;
            switch (n) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        ProfileStore.writeProfiles(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles(), CodeFormatterConfigurationBlock.this.fInstanceScope);
                        CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                    }
                    catch (CoreException coreException) {
                        RubyPlugin.log(coreException);
                    }
                    break;
                }
                case 1: {
                    CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                }
            }
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles();
            CodeFormatterConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            CodeFormatterConfigurationBlock.this.fProfileManager.setSelected((ProfileManager.Profile)this.fSortedProfiles.get(n));
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void update(Observable observable, Object object) {
            if (object == null) {
                return;
            }
            int n = (Integer)object;
            switch (n) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setItems(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedDisplayNames());
        }

        private void updateSelection() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setText(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodeFormatterConfigurationBlock.this.fProfileManager, null);
        }

        public void update(Observable observable, Object object) {
            ProfileManager.Profile profile = ((ProfileManager)observable).getSelected();
            boolean bl = !profile.isBuiltInProfile();
            CodeFormatterConfigurationBlock.this.fEditButton.setText(bl ? FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc : FormatterMessages.CodingStyleConfigurationBlock_show_button_desc);
            CodeFormatterConfigurationBlock.this.fDeleteButton.setEnabled(bl);
            CodeFormatterConfigurationBlock.this.fSaveButton.setEnabled(bl);
            CodeFormatterConfigurationBlock.this.fRenameButton.setEnabled(bl);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            if (button == CodeFormatterConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        private void renameButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().isBuiltInProfile()) {
                return;
            }
            ProfileManager.CustomProfile customProfile = (ProfileManager.CustomProfile)CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            RenameProfileDialog renameProfileDialog = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), customProfile, CodeFormatterConfigurationBlock.this.fProfileManager);
            if (renameProfileDialog.open() == 0) {
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(renameProfileDialog.getRenamedProfile());
            }
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager.getSelected(), CodeFormatterConfigurationBlock.this.fProfileManager, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_question, CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                CodeFormatterConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog createProfileDialog = new CreateProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager);
            if (createProfileDialog.open() != 0) {
                return;
            }
            if (!createProfileDialog.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), createProfileDialog.getCreatedProfile(), CodeFormatterConfigurationBlock.this.fProfileManager, true);
            modifyDialog.open();
        }

        private void saveButtonPressed() {
            String string;
            Object object;
            ProfileManager.Profile profile = CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            if (profile.isSharedProfile()) {
                object = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), profile, CodeFormatterConfigurationBlock.this.fProfileManager);
                if (object.open() != 0) {
                    return;
                }
                profile = object.getRenamedProfile();
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(profile);
            }
            object = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 8192);
            object.setText(FormatterMessages.CodingStyleConfigurationBlock_save_profile_dialog_title);
            object.setFilterExtensions(new String[]{"*.xml"});
            String string2 = RubyPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH);
            if (string2 != null) {
                object.setFilterPath(string2);
            }
            if ((string = object.open()) == null) {
                return;
            }
            RubyPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH, object.getFilterPath());
            File file = new File(string);
            if (file.exists() && !MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_message, string))) {
                return;
            }
            ArrayList<ProfileManager.Profile> arrayList = new ArrayList<ProfileManager.Profile>();
            arrayList.add(profile);
            try {
                ProfileStore.writeProfilesToFile(arrayList, file);
            }
            catch (CoreException coreException) {
                String string3 = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_title;
                String string4 = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_message;
                ExceptionHandler.handle(coreException, CodeFormatterConfigurationBlock.this.fComposite.getShell(), string3, string4);
            }
        }

        private void loadButtonPressed() {
            String string;
            Object object;
            String string2;
            FileDialog fileDialog = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 4096);
            fileDialog.setText(FormatterMessages.CodingStyleConfigurationBlock_load_profile_dialog_title);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            String string3 = RubyPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH);
            if (string3 != null) {
                fileDialog.setFilterPath(string3);
            }
            if ((string2 = fileDialog.open()) == null) {
                return;
            }
            RubyPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH, fileDialog.getFilterPath());
            File file = new File(string2);
            List list = null;
            try {
                list = ProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException coreException) {
                object = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                string = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_message;
                ExceptionHandler.handle(coreException, CodeFormatterConfigurationBlock.this.fComposite.getShell(), object, string);
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile customProfile = (ProfileManager.CustomProfile)list.iterator().next();
            if (ProfileVersioner.getVersionStatus(customProfile) > 0) {
                object = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_title;
                string = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_message;
                MessageDialog.openWarning((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)object, (String)string);
            }
            if (CodeFormatterConfigurationBlock.this.fProfileManager.containsName(customProfile.getName()) && (object = new AlreadyExistsDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), customProfile, CodeFormatterConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            ProfileVersioner.updateAndComplete(customProfile);
            CodeFormatterConfigurationBlock.this.fProfileManager.addProfile(customProfile);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fRubyPreview.setWorkingValues(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fRubyPreview.update();
        }

        public void update(Observable observable, Object object) {
            int n = (Integer)object;
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fRubyPreview.setWorkingValues(((ProfileManager)observable).getSelected().getSettings());
                    CodeFormatterConfigurationBlock.this.fRubyPreview.update();
                }
            }
        }
    }
}

