/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.event.AbstractTrigger;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.event.Trigger;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.MessageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class AntCallTrigger
extends AbstractTrigger
implements Trigger {
    private boolean _onlyonce = true;
    private String _target = null;
    private Collection _calls = new ArrayList();
    private String _prefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(IvyEvent event) {
        Project project = (Project)IvyContext.getContext().get("ant-project");
        if (project == null) {
            Message.info("ant call trigger can only be used from an ant build. Ignoring.");
            return;
        }
        if (this._onlyonce && this.isTriggered(event)) {
            Message.verbose("call already triggered for this event, skipping: " + event);
        } else {
            CallTarget call = new CallTarget();
            call.setProject(project);
            call.setTaskName("antcall");
            Map attributes = event.getAttributes();
            String target = IvyPatternHelper.substituteTokens(this.getTarget(), attributes);
            call.setTarget(target);
            Iterator iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)attributes.get(key);
                Property p = call.createParam();
                p.setName(this._prefix == null ? key : this._prefix + key);
                p.setValue(value == null ? "" : value);
            }
            Message.verbose("triggering ant call: target=" + target + " for " + event);
            MessageImpl impl = IvyContext.getContext().getMessageImpl();
            try {
                IvyContext.getContext().setMessageImpl(null);
                call.execute();
                this.markTriggered(event);
            }
            finally {
                IvyContext.getContext().setMessageImpl(impl);
            }
            Message.debug("triggered ant call finished: target=" + target + " for " + event);
        }
    }

    private void markTriggered(IvyEvent event) {
        this._calls.add(event);
    }

    private boolean isTriggered(IvyEvent event) {
        return this._calls.contains(event);
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public boolean isOnlyonce() {
        return this._onlyonce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this._onlyonce = onlyonce;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
        if (!prefix.endsWith(".")) {
            this._prefix = this._prefix + ".";
        }
    }
}

