/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe.DerefFinder;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagesRequiringNonNullValues {
    MultiMap<Location, Pair> map = new MultiMap(class$java$util$LinkedList == null ? (class$java$util$LinkedList = UsagesRequiringNonNullValues.class$("java.util.LinkedList")) : class$java$util$LinkedList);
    static /* synthetic */ Class class$java$util$LinkedList;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Location loc : this.map.keySet()) {
            buf.append(new StringBuffer().append(loc.getHandle().getPosition()).append(":").append(loc.getHandle().getInstruction()).append("\n").toString());
            for (Pair pair : this.getPairs(loc)) {
                buf.append("  ").append(pair.vn).append("\n");
            }
        }
        return buf.toString();
    }

    public void add(Location loc, ValueNumber vn, PointerUsageRequiringNonNullValue usage) {
        Pair p = new Pair(vn, usage);
        if (DerefFinder.DEBUG) {
            System.out.println(new StringBuffer().append("At ").append(loc).append(" adding dereference ").append(p).toString());
        }
        this.map.add(loc, p);
    }

    @CheckForNull
    public PointerUsageRequiringNonNullValue get(Location loc, ValueNumber vn) {
        PointerUsageRequiringNonNullValue secondBest = null;
        for (Pair p : this.map.get(loc)) {
            if (p.vn.equals(vn)) {
                return p.pu;
            }
            secondBest = p.pu;
        }
        return secondBest;
    }

    public Collection<? extends Pair> getPairs(Location loc) {
        return this.map.get(loc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public static class Pair {
        public final ValueNumber vn;
        public final PointerUsageRequiringNonNullValue pu;

        Pair(ValueNumber vn, PointerUsageRequiringNonNullValue pu) {
            this.vn = vn;
            this.pu = pu;
        }

        public String toString() {
            return this.vn.toString();
        }
    }
}

