/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.epic.debug.PerlBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;

class BreakpointMap {
    private final Map breakpoints = new HashMap();

    public void add(PerlBreakpoint bp) {
        IPath path = bp.getResourcePath();
        HashSet<PerlBreakpoint> set = (HashSet<PerlBreakpoint>)this.breakpoints.get(path);
        if (set == null) {
            set = new HashSet<PerlBreakpoint>();
            this.breakpoints.put(path, set);
        }
        set.add(bp);
    }

    public boolean contains(PerlBreakpoint bp) {
        IPath path = bp.getResourcePath();
        Set set = (Set)this.breakpoints.get(path);
        if (set == null) {
            return false;
        }
        return set.contains((Object)bp);
    }

    public Set getBreakpoints(IPath path) {
        Set set = (Set)this.breakpoints.get(path);
        return set != null ? set : Collections.EMPTY_SET;
    }

    public PerlBreakpoint getBreakpoint(IPath path, int line) {
        Iterator i = this.getBreakpoints(path).iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof PerlLineBreakpoint)) continue;
            PerlLineBreakpoint bp = (PerlLineBreakpoint)((Object)obj);
            try {
                if (!bp.getResourcePath().equals((Object)path) || line != bp.getLineNumber()) continue;
                return bp;
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
            }
        }
        return null;
    }

    public boolean remove(PerlBreakpoint bp) {
        IPath path = bp.getResourcePath();
        Set set = (Set)this.breakpoints.get(path);
        if (set == null) {
            return false;
        }
        return set.remove((Object)bp);
    }
}

