require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PROC_H_)) {
    eval 'sub _SYS_PROC_H_ () {1;}' unless defined(&_SYS_PROC_H_);
    require 'machine/proc.ph';
    require 'sys/selinfo.ph';
    require 'sys/queue.ph';
    require 'sys/timeout.ph';
    require 'sys/event.ph';
    require 'sys/mutex.ph';
    require 'sys/resource.ph';
    require 'machine/atomic.ph';
    if(defined(&_KERNEL)) {
	eval 'sub __need_process () {1;}' unless defined(&__need_process);
    }
    eval 'sub EMUL_ENABLED () {0x1;}' unless defined(&EMUL_ENABLED);
    eval 'sub EMUL_NATIVE () {0x2;}' unless defined(&EMUL_NATIVE);
    if(defined(&__need_process)) {
	eval 'sub ps_startzero () { &ps_klist;}' unless defined(&ps_startzero);
	eval 'sub ps_endzero () { &ps_startcopy;}' unless defined(&ps_endzero);
	eval 'sub ps_startcopy () { &ps_limit;}' unless defined(&ps_startcopy);
	eval 'sub ps_endcopy () { &ps_refcnt;}' unless defined(&ps_endcopy);
	eval 'sub ps_pid () { ($ps_mainproc->{p_pid});}' unless defined(&ps_pid);
	eval 'sub ps_session () { ($ps_pgrp->{pg_session});}' unless defined(&ps_session);
	eval 'sub ps_pgid () { ($ps_pgrp->{pg_id});}' unless defined(&ps_pgid);
    }
    eval 'sub PS_CONTROLT () {0x1;}' unless defined(&PS_CONTROLT);
    eval 'sub PS_EXEC () {0x2;}' unless defined(&PS_EXEC);
    eval 'sub PS_INEXEC () {0x4;}' unless defined(&PS_INEXEC);
    eval 'sub PS_EXITING () {0x8;}' unless defined(&PS_EXITING);
    eval 'sub PS_SUGID () {0x10;}' unless defined(&PS_SUGID);
    eval 'sub PS_SUGIDEXEC () {0x20;}' unless defined(&PS_SUGIDEXEC);
    eval 'sub PS_PPWAIT () {0x40;}' unless defined(&PS_PPWAIT);
    eval 'sub PS_ISPWAIT () {0x80;}' unless defined(&PS_ISPWAIT);
    eval 'sub PS_PROFIL () {0x100;}' unless defined(&PS_PROFIL);
    eval 'sub PS_TRACED () {0x200;}' unless defined(&PS_TRACED);
    eval 'sub PS_WAITED () {0x400;}' unless defined(&PS_WAITED);
    eval 'sub PS_COREDUMP () {0x800;}' unless defined(&PS_COREDUMP);
    eval 'sub PS_SINGLEEXIT () {0x1000;}' unless defined(&PS_SINGLEEXIT);
    eval 'sub PS_SINGLEUNWIND () {0x2000;}' unless defined(&PS_SINGLEUNWIND);
    eval 'sub PS_NOZOMBIE () {0x4000;}' unless defined(&PS_NOZOMBIE);
    eval 'sub PS_STOPPED () {0x8000;}' unless defined(&PS_STOPPED);
    eval 'sub PS_SYSTEM () {0x10000;}' unless defined(&PS_SYSTEM);
    eval 'sub PS_EMBRYO () {0x20000;}' unless defined(&PS_EMBRYO);
    eval 'sub PS_ZOMBIE () {0x40000;}' unless defined(&PS_ZOMBIE);
    eval 'sub PS_NOBROADCASTKILL () {0x80000;}' unless defined(&PS_NOBROADCASTKILL);
    eval 'sub PS_BITS () {("\\20\\01CONTROLT\\02EXEC\\03INEXEC\\04EXITING\\05SUGID" "\\06SUGIDEXEC\\07PPWAIT\\010ISPWAIT\\011PROFIL\\012TRACED" "\\013WAITED\\014COREDUMP\\015SINGLEEXIT\\016SINGLEUNWIND" "\\017NOZOMBIE\\020STOPPED\\021SYSTEM\\022EMBRYO\\023ZOMBIE\\024NOBROADCASTKILL");}' unless defined(&PS_BITS);
    eval 'sub p_rlimit () { ($p_p->{ps_limit}->{pl_rlimit});}' unless defined(&p_rlimit);
    eval 'sub p_startzero () { &p_dupfd;}' unless defined(&p_startzero);
    eval 'sub p_endzero () { &p_startcopy;}' unless defined(&p_endzero);
    eval 'sub p_startcopy () { &p_sigmask;}' unless defined(&p_startcopy);
    unless(defined(&__HAVE_MD_TCB)) {
	eval 'sub TCB_SET {
	    my($p, $addr) = @_;
    	    eval q((($p)-> &p_tcb = ($addr)));
	}' unless defined(&TCB_SET);
	eval 'sub TCB_GET {
	    my($p) = @_;
    	    eval q((($p)-> &p_tcb));
	}' unless defined(&TCB_GET);
    }
    eval 'sub p_endcopy () { &p_addr;}' unless defined(&p_endcopy);
    eval 'sub SIDL () {1;}' unless defined(&SIDL);
    eval 'sub SRUN () {2;}' unless defined(&SRUN);
    eval 'sub SSLEEP () {3;}' unless defined(&SSLEEP);
    eval 'sub SSTOP () {4;}' unless defined(&SSTOP);
    eval 'sub SZOMB () {5;}' unless defined(&SZOMB);
    eval 'sub SDEAD () {6;}' unless defined(&SDEAD);
    eval 'sub SONPROC () {7;}' unless defined(&SONPROC);
    eval 'sub P_ZOMBIE {
        my($p) = @_;
	    eval q((($p)-> &p_stat ==  &SDEAD));
    }' unless defined(&P_ZOMBIE);
    eval 'sub P_INKTR () {0x1;}' unless defined(&P_INKTR);
    eval 'sub P_PROFPEND () {0x2;}' unless defined(&P_PROFPEND);
    eval 'sub P_ALRMPEND () {0x4;}' unless defined(&P_ALRMPEND);
    eval 'sub P_SIGSUSPEND () {0x8;}' unless defined(&P_SIGSUSPEND);
    eval 'sub P_SELECT () {0x40;}' unless defined(&P_SELECT);
    eval 'sub P_SINTR () {0x80;}' unless defined(&P_SINTR);
    eval 'sub P_SYSTEM () {0x200;}' unless defined(&P_SYSTEM);
    eval 'sub P_TIMEOUT () {0x400;}' unless defined(&P_TIMEOUT);
    eval 'sub P_WEXIT () {0x2000;}' unless defined(&P_WEXIT);
    eval 'sub P_OWEUPC () {0x8000;}' unless defined(&P_OWEUPC);
    eval 'sub P_SUSPSINGLE () {0x80000;}' unless defined(&P_SUSPSINGLE);
    eval 'sub P_SYSTRACE () {0x400000;}' unless defined(&P_SYSTRACE);
    eval 'sub P_CONTINUED () {0x800000;}' unless defined(&P_CONTINUED);
    eval 'sub P_THREAD () {0x4000000;}' unless defined(&P_THREAD);
    eval 'sub P_SUSPSIG () {0x8000000;}' unless defined(&P_SUSPSIG);
    eval 'sub P_SOFTDEP () {0x10000000;}' unless defined(&P_SOFTDEP);
    eval 'sub P_CPUPEG () {0x40000000;}' unless defined(&P_CPUPEG);
    eval 'sub P_BITS () {("\\20\\01INKTR\\02PROFPEND\\03ALRMPEND\\04SIGSUSPEND\\07SELECT" "\\010SINTR\\012SYSTEM" "\\013TIMEOUT\\016WEXIT\\020OWEUPC\\024SUSPSINGLE" "\\027SYSTRACE\\030CONTINUED\\033THREAD" "\\034SUSPSIG\\035SOFTDEP\\037CPUPEG");}' unless defined(&P_BITS);
    eval 'sub THREAD_PID_OFFSET () {1000000;}' unless defined(&THREAD_PID_OFFSET);
    if(defined(&_KERNEL)) {
	eval 'sub PID_MAX () {32766;}' unless defined(&PID_MAX);
	eval 'sub NO_PID () {( &PID_MAX+1);}' unless defined(&NO_PID);
	eval 'sub SESS_LEADER {
	    my($pr) = @_;
    	    eval q((($pr)-> ($ps_session->{s_leader}) == ($pr)));
	}' unless defined(&SESS_LEADER);
	eval 'sub SESSHOLD {
	    my($s) = @_;
    	    eval q((($s)-> &s_count++));
	}' unless defined(&SESSHOLD);
	eval 'sub SESSRELE {
	    my($s) = @_;
    	    eval q( &do {  &if (--($s)-> &s_count == 0)  &pool_put( &session_pool, ($s)); }  &while ( 0));
	}' unless defined(&SESSRELE);
	eval 'sub FORK_FORK () {0x1;}' unless defined(&FORK_FORK);
	eval 'sub FORK_VFORK () {0x2;}' unless defined(&FORK_VFORK);
	eval 'sub FORK_IDLE () {0x4;}' unless defined(&FORK_IDLE);
	eval 'sub FORK_PPWAIT () {0x8;}' unless defined(&FORK_PPWAIT);
	eval 'sub FORK_SHAREFILES () {0x10;}' unless defined(&FORK_SHAREFILES);
	eval 'sub FORK_SYSTEM () {0x20;}' unless defined(&FORK_SYSTEM);
	eval 'sub FORK_NOZOMBIE () {0x40;}' unless defined(&FORK_NOZOMBIE);
	eval 'sub FORK_SHAREVM () {0x80;}' unless defined(&FORK_SHAREVM);
	eval 'sub FORK_TFORK () {0x100;}' unless defined(&FORK_TFORK);
	eval 'sub FORK_SIGHAND () {0x200;}' unless defined(&FORK_SIGHAND);
	eval 'sub FORK_PTRACE () {0x400;}' unless defined(&FORK_PTRACE);
	eval 'sub FORK_THREAD () {0x800;}' unless defined(&FORK_THREAD);
	eval 'sub EXIT_NORMAL () {0x1;}' unless defined(&EXIT_NORMAL);
	eval 'sub EXIT_THREAD () {0x2;}' unless defined(&EXIT_THREAD);
	eval 'sub EXIT_THREAD_NOCHECK () {0x3;}' unless defined(&EXIT_THREAD_NOCHECK);
	eval 'sub PIDHASH {
	    my($pid) = @_;
    	    eval q(( $pidhashtbl[($pid) &  &pidhash]));
	}' unless defined(&PIDHASH);
	eval 'sub PGRPHASH {
	    my($pgid) = @_;
    	    eval q(( $pgrphashtbl[($pgid) &  &pgrphash]));
	}' unless defined(&PGRPHASH);
	eval("sub SINGLE_SUSPEND () { 0; }") unless defined(&SINGLE_SUSPEND);
	eval("sub SINGLE_PTRACE () { 1; }") unless defined(&SINGLE_PTRACE);
	eval("sub SINGLE_UNWIND () { 2; }") unless defined(&SINGLE_UNWIND);
	eval("sub SINGLE_EXIT () { 3; }") unless defined(&SINGLE_EXIT);
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub CPUSET_ASIZE {
	    my($x) = @_;
    	    eval q(((($x) - 1)/32+ 1));
	}' unless defined(&CPUSET_ASIZE);
	eval 'sub CPUSET_SSIZE () { &CPUSET_ASIZE( &MAXCPUS);}' unless defined(&CPUSET_SSIZE);
    }
}
1;
