require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PARAM_H_)) {
    eval 'sub _SYS_PARAM_H_ () {1;}' unless defined(&_SYS_PARAM_H_);
    eval 'sub BSD () {199306;}' unless defined(&BSD);
    eval 'sub BSD4_3 () {1;}' unless defined(&BSD4_3);
    eval 'sub BSD4_4 () {1;}' unless defined(&BSD4_4);
    eval 'sub OpenBSD () {201411;}' unless defined(&OpenBSD);
    eval 'sub OpenBSD5_6 () {1;}' unless defined(&OpenBSD5_6);
    unless(defined(&NULL)) {
	if(defined(&__GNUG__)) {
	    eval 'sub NULL () { &__null;}' unless defined(&NULL);
	} else {
	    eval 'sub NULL () {(( &void *)0);}' unless defined(&NULL);
	}
    }
    unless(defined(&_LOCORE)) {
	require 'sys/types.ph';
    }
    require 'sys/syslimits.ph';
    eval 'sub MAXCOMLEN () {16;}' unless defined(&MAXCOMLEN);
    eval 'sub MAXINTERP () {128;}' unless defined(&MAXINTERP);
    eval 'sub MAXLOGNAME () { &LOGIN_NAME_MAX;}' unless defined(&MAXLOGNAME);
    eval 'sub MAXUPRC () { &CHILD_MAX;}' unless defined(&MAXUPRC);
    eval 'sub NCARGS () { &ARG_MAX;}' unless defined(&NCARGS);
    eval 'sub NGROUPS () { &NGROUPS_MAX;}' unless defined(&NGROUPS);
    eval 'sub NOFILE () { &OPEN_MAX;}' unless defined(&NOFILE);
    eval 'sub NOFILE_MAX () {1024;}' unless defined(&NOFILE_MAX);
    eval 'sub NOGROUP () {65535;}' unless defined(&NOGROUP);
    eval 'sub MAXHOSTNAMELEN () {256;}' unless defined(&MAXHOSTNAMELEN);
    if(defined(&_KERNEL)) {
	require 'sys/errno.ph';
	require 'sys/time.ph';
	require 'sys/resource.ph';
	require 'sys/ucred.ph';
	require 'sys/uio.ph';
    }
    require 'sys/signal.ph';
    require 'sys/limits.ph';
    require 'machine/param.ph';
    if(defined(&_KERNEL)) {
	eval 'sub PSWP () {0;}' unless defined(&PSWP);
	eval 'sub PVM () {4;}' unless defined(&PVM);
	eval 'sub PINOD () {8;}' unless defined(&PINOD);
	eval 'sub PRIBIO () {16;}' unless defined(&PRIBIO);
	eval 'sub PVFS () {20;}' unless defined(&PVFS);
    }
    eval 'sub PZERO () {22;}' unless defined(&PZERO);
    if(defined(&_KERNEL)) {
	eval 'sub PSOCK () {24;}' unless defined(&PSOCK);
	eval 'sub PWAIT () {32;}' unless defined(&PWAIT);
	eval 'sub PLOCK () {36;}' unless defined(&PLOCK);
	eval 'sub PPAUSE () {40;}' unless defined(&PPAUSE);
	eval 'sub PUSER () {50;}' unless defined(&PUSER);
	eval 'sub MAXPRI () {127;}' unless defined(&MAXPRI);
	eval 'sub PRIMASK () {0xff;}' unless defined(&PRIMASK);
	eval 'sub PCATCH () {0x100;}' unless defined(&PCATCH);
	eval 'sub PNORELOCK () {0x200;}' unless defined(&PNORELOCK);
    }
    eval 'sub NODEV () {( &dev_t)(-1);}' unless defined(&NODEV);
    eval 'sub CMASK () {022;}' unless defined(&CMASK);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    if(defined(&_KERNEL)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
	eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
	eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    }
    eval 'sub ALIGNBYTES () { &_ALIGNBYTES;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q( &_ALIGN($p));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q( &_ALIGNED_POINTER($p,$t));
    }' unless defined(&ALIGNED_POINTER);
    if(defined(&_KERNEL)) {
	eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    }
    eval 'sub MAXBSIZE () {(64* 1024);}' unless defined(&MAXBSIZE);
    eval 'sub MAXFRAG () {8;}' unless defined(&MAXFRAG);
    eval 'sub _DEV_BSHIFT () {9;}' unless defined(&_DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &_DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    if(defined(&_KERNEL)) {
	eval 'sub DEV_BSHIFT () { &_DEV_BSHIFT;}' unless defined(&DEV_BSHIFT);
	eval 'sub BLKDEV_IOSIZE () { &PAGE_SIZE;}' unless defined(&BLKDEV_IOSIZE);
    }
    unless(defined(&ctod)) {
	eval 'sub ctod {
	    my($x) = @_;
    	    eval q((($x) << ( &PAGE_SHIFT -  &_DEV_BSHIFT)));
	}' unless defined(&ctod);
    }
    unless(defined(&dtoc)) {
	eval 'sub dtoc {
	    my($x) = @_;
    	    eval q((($x) >> ( &PAGE_SHIFT -  &_DEV_BSHIFT)));
	}' unless defined(&dtoc);
    }
    unless(defined(&btodb)) {
	eval 'sub btodb {
	    my($x) = @_;
    	    eval q((($x) >>  &_DEV_BSHIFT));
	}' unless defined(&btodb);
    }
    unless(defined(&dbtob)) {
	eval 'sub dbtob {
	    my($x) = @_;
    	    eval q((($x) <<  &_DEV_BSHIFT));
	}' unless defined(&dbtob);
    }
    eval 'sub MAXPATHLEN () { &PATH_MAX;}' unless defined(&MAXPATHLEN);
    eval 'sub MAXSYMLINKS () { &SYMLOOP_MAX;}' unless defined(&MAXSYMLINKS);
    if(defined(&_KERNEL)) {
	eval 'sub SET {
	    my($t, $f) = @_;
    	    eval q((($t) |= ($f)));
	}' unless defined(&SET);
	eval 'sub CLR {
	    my($t, $f) = @_;
    	    eval q((($t) &= ~($f)));
	}' unless defined(&CLR);
	eval 'sub ISSET {
	    my($t, $f) = @_;
    	    eval q((($t) & ($f)));
	}' unless defined(&ISSET);
    }
    eval 'sub setbit {
        my($a,$i) = @_;
	    eval q((($a)[($i)>>3] |= 1<<(($i)( &NBBY-1))));
    }' unless defined(&setbit);
    eval 'sub clrbit {
        my($a,$i) = @_;
	    eval q((($a)[($i)>>3] &= ~(1<<(($i)( &NBBY-1)))));
    }' unless defined(&clrbit);
    eval 'sub isset {
        my($a,$i) = @_;
	    eval q((($a)[($i)>>3] & (1<<(($i)( &NBBY-1)))));
    }' unless defined(&isset);
    eval 'sub isclr {
        my($a,$i) = @_;
	    eval q(((($a)[($i)>>3] & (1<<(($i)( &NBBY-1)))) == 0));
    }' unless defined(&isclr);
    unless(defined(&howmany)) {
	eval 'sub howmany {
	    my($x, $y) = @_;
    	    eval q(((($x)+(($y)-1))/($y)));
	}' unless defined(&howmany);
    }
    eval 'sub roundup {
        my($x, $y) = @_;
	    eval q((((($x)+(($y)-1))/($y))*($y)));
    }' unless defined(&roundup);
    eval 'sub powerof2 {
        my($x) = @_;
	    eval q((((($x)-1)($x))==0));
    }' unless defined(&powerof2);
    eval 'sub MIN {
        my($a,$b) = @_;
	    eval q(((($a)<($b))?($a):($b)));
    }' unless defined(&MIN);
    eval 'sub MAX {
        my($a,$b) = @_;
	    eval q(((($a)>($b))?($a):($b)));
    }' unless defined(&MAX);
    if(!defined(&offsetof)  && defined(&_KERNEL)) {
	eval 'sub offsetof {
	    my($s, $e) = @_;
    	    eval q(((($s *)0)->$e));
	}' unless defined(&offsetof);
    }
    eval 'sub nitems {
        my($_a) = @_;
	    eval q(($sizeof{($_a)} / $sizeof{($_a)[0]}));
    }' unless defined(&nitems);
    eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
    eval 'sub FSCALE () {(1<< &FSHIFT);}' unless defined(&FSCALE);
}
1;
