require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub CR0_PE () {0x1;}' unless defined(&CR0_PE);
eval 'sub CR0_MP () {0x2;}' unless defined(&CR0_MP);
eval 'sub CR0_EM () {0x4;}' unless defined(&CR0_EM);
eval 'sub CR0_TS () {0x8;}' unless defined(&CR0_TS);
eval 'sub CR0_ET () {0x10;}' unless defined(&CR0_ET);
eval 'sub CR0_PG () {0x80000000;}' unless defined(&CR0_PG);
eval 'sub CR0_NE () {0x20;}' unless defined(&CR0_NE);
eval 'sub CR0_WP () {0x10000;}' unless defined(&CR0_WP);
eval 'sub CR0_AM () {0x40000;}' unless defined(&CR0_AM);
eval 'sub CR0_NW () {0x20000000;}' unless defined(&CR0_NW);
eval 'sub CR0_CD () {0x40000000;}' unless defined(&CR0_CD);
eval 'sub CCR0 () {0xc0;}' unless defined(&CCR0);
eval 'sub CCR0_NC0 () {0x1;}' unless defined(&CCR0_NC0);
eval 'sub CCR0_NC1 () {0x2;}' unless defined(&CCR0_NC1);
eval 'sub CCR0_A20M () {0x4;}' unless defined(&CCR0_A20M);
eval 'sub CCR0_KEN () {0x8;}' unless defined(&CCR0_KEN);
eval 'sub CCR0_FLUSH () {0x10;}' unless defined(&CCR0_FLUSH);
eval 'sub CCR0_BARB () {0x20;}' unless defined(&CCR0_BARB);
eval 'sub CCR0_CO () {0x40;}' unless defined(&CCR0_CO);
eval 'sub CCR0_SUSPEND () {0x80;}' unless defined(&CCR0_SUSPEND);
eval 'sub CCR1 () {0xc1;}' unless defined(&CCR1);
eval 'sub CCR1_RPL () {0x1;}' unless defined(&CCR1_RPL);
eval 'sub CR4_VME () {0x1;}' unless defined(&CR4_VME);
eval 'sub CR4_PVI () {0x2;}' unless defined(&CR4_PVI);
eval 'sub CR4_TSD () {0x4;}' unless defined(&CR4_TSD);
eval 'sub CR4_DE () {0x8;}' unless defined(&CR4_DE);
eval 'sub CR4_PSE () {0x10;}' unless defined(&CR4_PSE);
eval 'sub CR4_PAE () {0x20;}' unless defined(&CR4_PAE);
eval 'sub CR4_MCE () {0x40;}' unless defined(&CR4_MCE);
eval 'sub CR4_PGE () {0x80;}' unless defined(&CR4_PGE);
eval 'sub CR4_PCE () {0x100;}' unless defined(&CR4_PCE);
eval 'sub CR4_OSFXSR () {0x200;}' unless defined(&CR4_OSFXSR);
eval 'sub CR4_OSXMMEXCPT () {0x400;}' unless defined(&CR4_OSXMMEXCPT);
eval 'sub CR4_VMXE () {0x2000;}' unless defined(&CR4_VMXE);
eval 'sub CR4_SMXE () {0x4000;}' unless defined(&CR4_SMXE);
eval 'sub CR4_PCIDE () {0x20000;}' unless defined(&CR4_PCIDE);
eval 'sub CR4_OSXSAVE () {0x40000;}' unless defined(&CR4_OSXSAVE);
eval 'sub CR4_SMEP () {0x100000;}' unless defined(&CR4_SMEP);
eval 'sub CR4_SMAP () {0x200000;}' unless defined(&CR4_SMAP);
eval 'sub CPUID_FPU () {0x1;}' unless defined(&CPUID_FPU);
eval 'sub CPUID_VME () {0x2;}' unless defined(&CPUID_VME);
eval 'sub CPUID_DE () {0x4;}' unless defined(&CPUID_DE);
eval 'sub CPUID_PSE () {0x8;}' unless defined(&CPUID_PSE);
eval 'sub CPUID_TSC () {0x10;}' unless defined(&CPUID_TSC);
eval 'sub CPUID_MSR () {0x20;}' unless defined(&CPUID_MSR);
eval 'sub CPUID_PAE () {0x40;}' unless defined(&CPUID_PAE);
eval 'sub CPUID_MCE () {0x80;}' unless defined(&CPUID_MCE);
eval 'sub CPUID_CX8 () {0x100;}' unless defined(&CPUID_CX8);
eval 'sub CPUID_APIC () {0x200;}' unless defined(&CPUID_APIC);
eval 'sub CPUID_SYS1 () {0x400;}' unless defined(&CPUID_SYS1);
eval 'sub CPUID_SEP () {0x800;}' unless defined(&CPUID_SEP);
eval 'sub CPUID_MTRR () {0x1000;}' unless defined(&CPUID_MTRR);
eval 'sub CPUID_PGE () {0x2000;}' unless defined(&CPUID_PGE);
eval 'sub CPUID_MCA () {0x4000;}' unless defined(&CPUID_MCA);
eval 'sub CPUID_CMOV () {0x8000;}' unless defined(&CPUID_CMOV);
eval 'sub CPUID_PAT () {0x10000;}' unless defined(&CPUID_PAT);
eval 'sub CPUID_PSE36 () {0x20000;}' unless defined(&CPUID_PSE36);
eval 'sub CPUID_PSN () {0x40000;}' unless defined(&CPUID_PSN);
eval 'sub CPUID_CFLUSH () {0x80000;}' unless defined(&CPUID_CFLUSH);
eval 'sub CPUID_B20 () {0x100000;}' unless defined(&CPUID_B20);
eval 'sub CPUID_DS () {0x200000;}' unless defined(&CPUID_DS);
eval 'sub CPUID_ACPI () {0x400000;}' unless defined(&CPUID_ACPI);
eval 'sub CPUID_MMX () {0x800000;}' unless defined(&CPUID_MMX);
eval 'sub CPUID_FXSR () {0x1000000;}' unless defined(&CPUID_FXSR);
eval 'sub CPUID_SSE () {0x2000000;}' unless defined(&CPUID_SSE);
eval 'sub CPUID_SSE2 () {0x4000000;}' unless defined(&CPUID_SSE2);
eval 'sub CPUID_SS () {0x8000000;}' unless defined(&CPUID_SS);
eval 'sub CPUID_HTT () {0x10000000;}' unless defined(&CPUID_HTT);
eval 'sub CPUID_TM () {0x20000000;}' unless defined(&CPUID_TM);
eval 'sub CPUID_B30 () {0x40000000;}' unless defined(&CPUID_B30);
eval 'sub CPUID_PBE () {0x80000000;}' unless defined(&CPUID_PBE);
eval 'sub CPUIDECX_SSE3 () {0x1;}' unless defined(&CPUIDECX_SSE3);
eval 'sub CPUIDECX_PCLMUL () {0x2;}' unless defined(&CPUIDECX_PCLMUL);
eval 'sub CPUIDECX_DTES64 () {0x4;}' unless defined(&CPUIDECX_DTES64);
eval 'sub CPUIDECX_MWAIT () {0x8;}' unless defined(&CPUIDECX_MWAIT);
eval 'sub CPUIDECX_DSCPL () {0x10;}' unless defined(&CPUIDECX_DSCPL);
eval 'sub CPUIDECX_VMX () {0x20;}' unless defined(&CPUIDECX_VMX);
eval 'sub CPUIDECX_SMX () {0x40;}' unless defined(&CPUIDECX_SMX);
eval 'sub CPUIDECX_EST () {0x80;}' unless defined(&CPUIDECX_EST);
eval 'sub CPUIDECX_TM2 () {0x100;}' unless defined(&CPUIDECX_TM2);
eval 'sub CPUIDECX_SSSE3 () {0x200;}' unless defined(&CPUIDECX_SSSE3);
eval 'sub CPUIDECX_CNXTID () {0x400;}' unless defined(&CPUIDECX_CNXTID);
eval 'sub CPUIDECX_FMA3 () {0x1000;}' unless defined(&CPUIDECX_FMA3);
eval 'sub CPUIDECX_CX16 () {0x2000;}' unless defined(&CPUIDECX_CX16);
eval 'sub CPUIDECX_XTPR () {0x4000;}' unless defined(&CPUIDECX_XTPR);
eval 'sub CPUIDECX_PDCM () {0x8000;}' unless defined(&CPUIDECX_PDCM);
eval 'sub CPUIDECX_PCID () {0x20000;}' unless defined(&CPUIDECX_PCID);
eval 'sub CPUIDECX_DCA () {0x40000;}' unless defined(&CPUIDECX_DCA);
eval 'sub CPUIDECX_SSE41 () {0x80000;}' unless defined(&CPUIDECX_SSE41);
eval 'sub CPUIDECX_SSE42 () {0x100000;}' unless defined(&CPUIDECX_SSE42);
eval 'sub CPUIDECX_X2APIC () {0x200000;}' unless defined(&CPUIDECX_X2APIC);
eval 'sub CPUIDECX_MOVBE () {0x400000;}' unless defined(&CPUIDECX_MOVBE);
eval 'sub CPUIDECX_POPCNT () {0x800000;}' unless defined(&CPUIDECX_POPCNT);
eval 'sub CPUIDECX_DEADLINE () {0x1000000;}' unless defined(&CPUIDECX_DEADLINE);
eval 'sub CPUIDECX_AES () {0x2000000;}' unless defined(&CPUIDECX_AES);
eval 'sub CPUIDECX_XSAVE () {0x4000000;}' unless defined(&CPUIDECX_XSAVE);
eval 'sub CPUIDECX_OSXSAVE () {0x8000000;}' unless defined(&CPUIDECX_OSXSAVE);
eval 'sub CPUIDECX_AVX () {0x10000000;}' unless defined(&CPUIDECX_AVX);
eval 'sub CPUIDECX_F16C () {0x20000000;}' unless defined(&CPUIDECX_F16C);
eval 'sub CPUIDECX_RDRAND () {0x40000000;}' unless defined(&CPUIDECX_RDRAND);
eval 'sub SEFF0EBX_FSGSBASE () {0x1;}' unless defined(&SEFF0EBX_FSGSBASE);
eval 'sub SEFF0EBX_BMI1 () {0x8;}' unless defined(&SEFF0EBX_BMI1);
eval 'sub SEFF0EBX_HLE () {0x10;}' unless defined(&SEFF0EBX_HLE);
eval 'sub SEFF0EBX_AVX2 () {0x20;}' unless defined(&SEFF0EBX_AVX2);
eval 'sub SEFF0EBX_SMEP () {0x80;}' unless defined(&SEFF0EBX_SMEP);
eval 'sub SEFF0EBX_BMI2 () {0x100;}' unless defined(&SEFF0EBX_BMI2);
eval 'sub SEFF0EBX_ERMS () {0x200;}' unless defined(&SEFF0EBX_ERMS);
eval 'sub SEFF0EBX_INVPCID () {0x400;}' unless defined(&SEFF0EBX_INVPCID);
eval 'sub SEFF0EBX_RTM () {0x800;}' unless defined(&SEFF0EBX_RTM);
eval 'sub SEFF0EBX_RDSEED () {0x40000;}' unless defined(&SEFF0EBX_RDSEED);
eval 'sub SEFF0EBX_ADX () {0x80000;}' unless defined(&SEFF0EBX_ADX);
eval 'sub SEFF0EBX_SMAP () {0x100000;}' unless defined(&SEFF0EBX_SMAP);
eval 'sub CPUIDEAX_VERID () {0xff;}' unless defined(&CPUIDEAX_VERID);
unless(defined(&CPUIDEAX_NUM_GC)) {
    sub CPUIDEAX_NUM_GC {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 8) & 0xff));
    }
}
unless(defined(&CPUIDEAX_BIT_GC)) {
    sub CPUIDEAX_BIT_GC {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 16) & 0xff));
    }
}
unless(defined(&CPUIDEAX_LEN_EBX)) {
    sub CPUIDEAX_LEN_EBX {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 24) & 0xff));
    }
}
eval 'sub CPUIDEBX_EVT_CORE () {(1<< 0);}' unless defined(&CPUIDEBX_EVT_CORE);
eval 'sub CPUIDEBX_EVT_INST () {(1<< 1);}' unless defined(&CPUIDEBX_EVT_INST);
eval 'sub CPUIDEBX_EVT_REFR () {(1<< 2);}' unless defined(&CPUIDEBX_EVT_REFR);
eval 'sub CPUIDEBX_EVT_CACHE_REF () {(1<< 3);}' unless defined(&CPUIDEBX_EVT_CACHE_REF);
eval 'sub CPUIDEBX_EVT_CACHE_MIS () {(1<< 4);}' unless defined(&CPUIDEBX_EVT_CACHE_MIS);
eval 'sub CPUIDEBX_EVT_BRANCH_INST () {(1<< 5);}' unless defined(&CPUIDEBX_EVT_BRANCH_INST);
eval 'sub CPUIDEBX_EVT_BRANCH_MISP () {(1<< 6);}' unless defined(&CPUIDEBX_EVT_BRANCH_MISP);
unless(defined(&CPUIDEDX_NUM_FC)) {
    sub CPUIDEDX_NUM_FC {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 0) & 0x1f));
    }
}
unless(defined(&CPUIDEDX_BIT_FC)) {
    sub CPUIDEDX_BIT_FC {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 5) & 0xff));
    }
}
eval 'sub CPUID_MPC () {0x80000;}' unless defined(&CPUID_MPC);
eval 'sub CPUID_NXE () {0x100000;}' unless defined(&CPUID_NXE);
eval 'sub CPUID_MMXX () {0x400000;}' unless defined(&CPUID_MMXX);
eval 'sub CPUID_FFXSR () {0x2000000;}' unless defined(&CPUID_FFXSR);
eval 'sub CPUID_PAGE1GB () {0x4000000;}' unless defined(&CPUID_PAGE1GB);
eval 'sub CPUID_LONG () {0x20000000;}' unless defined(&CPUID_LONG);
eval 'sub CPUID_3DNOW2 () {0x40000000;}' unless defined(&CPUID_3DNOW2);
eval 'sub CPUID_3DNOW () {0x80000000;}' unless defined(&CPUID_3DNOW);
eval 'sub CPUIDECX_LAHF () {0x1;}' unless defined(&CPUIDECX_LAHF);
eval 'sub CPUIDECX_CMPLEG () {0x2;}' unless defined(&CPUIDECX_CMPLEG);
eval 'sub CPUIDECX_SVM () {0x4;}' unless defined(&CPUIDECX_SVM);
eval 'sub CPUIDECX_EAPICSP () {0x8;}' unless defined(&CPUIDECX_EAPICSP);
eval 'sub CPUIDECX_AMCR8 () {0x10;}' unless defined(&CPUIDECX_AMCR8);
eval 'sub CPUIDECX_ABM () {0x20;}' unless defined(&CPUIDECX_ABM);
eval 'sub CPUIDECX_SSE4A () {0x40;}' unless defined(&CPUIDECX_SSE4A);
eval 'sub CPUIDECX_MASSE () {0x80;}' unless defined(&CPUIDECX_MASSE);
eval 'sub CPUIDECX_3DNOWP () {0x100;}' unless defined(&CPUIDECX_3DNOWP);
eval 'sub CPUIDECX_OSVW () {0x200;}' unless defined(&CPUIDECX_OSVW);
eval 'sub CPUIDECX_IBS () {0x400;}' unless defined(&CPUIDECX_IBS);
eval 'sub CPUIDECX_XOP () {0x800;}' unless defined(&CPUIDECX_XOP);
eval 'sub CPUIDECX_SKINIT () {0x1000;}' unless defined(&CPUIDECX_SKINIT);
eval 'sub CPUIDECX_WDT () {0x2000;}' unless defined(&CPUIDECX_WDT);
eval 'sub CPUIDECX_LWP () {0x8000;}' unless defined(&CPUIDECX_LWP);
eval 'sub CPUIDECX_FMA4 () {0x10000;}' unless defined(&CPUIDECX_FMA4);
eval 'sub CPUIDECX_NODEID () {0x80000;}' unless defined(&CPUIDECX_NODEID);
eval 'sub CPUIDECX_TBM () {0x200000;}' unless defined(&CPUIDECX_TBM);
eval 'sub CPUIDECX_TOPEXT () {0x400000;}' unless defined(&CPUIDECX_TOPEXT);
eval 'sub CPUIDEDX_ITSC () {(1<< 8);}' unless defined(&CPUIDEDX_ITSC);
unless(defined(&CPUID2FAMILY)) {
    sub CPUID2FAMILY {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 8) & 15));
    }
}
unless(defined(&CPUID2MODEL)) {
    sub CPUID2MODEL {
	my($cpuid) = @_;
	eval q(((($cpuid) >> 4) & 15));
    }
}
unless(defined(&CPUID2STEPPING)) {
    sub CPUID2STEPPING {
	my($cpuid) = @_;
	eval q((($cpuid) & 15));
    }
}
unless(defined(&CPUID)) {
    sub CPUID {
	my($code, $eax, $ebx, $ecx, $edx) = @_;
	eval q( &__asm(\"cpuid\" : \"=a\" ($eax), \"=b\" ($ebx), \"=c\" ($ecx), \"=d\" ($edx) : \"a\" ($code)););
    }
}
unless(defined(&CPUID_LEAF)) {
    sub CPUID_LEAF {
	my($code, $leaf, $eax, $ebx, $ecx, $edx) = @_;
	eval q( &__asm(\"cpuid\" : \"=a\" ($eax), \"=b\" ($ebx), \"=c\" ($ecx), \"=d\" ($edx) : \"a\" ($code), \"c\" ($leaf)););
    }
}
eval 'sub MSR_P5_MC_ADDR () {0x;}' unless defined(&MSR_P5_MC_ADDR);
eval 'sub MSR_P5_MC_TYPE () {0x1;}' unless defined(&MSR_P5_MC_TYPE);
eval 'sub MSR_TSC () {0x10;}' unless defined(&MSR_TSC);
eval 'sub P5MSR_CTRSEL () {0x11;}' unless defined(&P5MSR_CTRSEL);
eval 'sub P5MSR_CTR0 () {0x12;}' unless defined(&P5MSR_CTR0);
eval 'sub P5MSR_CTR1 () {0x13;}' unless defined(&P5MSR_CTR1);
eval 'sub MSR_APICBASE () {0x1b;}' unless defined(&MSR_APICBASE);
eval 'sub MSR_EBL_CR_POWERON () {0x2a;}' unless defined(&MSR_EBL_CR_POWERON);
eval 'sub MSR_EBC_FREQUENCY_ID () {0x2c;}' unless defined(&MSR_EBC_FREQUENCY_ID);
eval 'sub MSR_TEST_CTL () {0x33;}' unless defined(&MSR_TEST_CTL);
eval 'sub MSR_BIOS_UPDT_TRIG () {0x79;}' unless defined(&MSR_BIOS_UPDT_TRIG);
eval 'sub MSR_BBL_CR_D0 () {0x88;}' unless defined(&MSR_BBL_CR_D0);
eval 'sub MSR_BBL_CR_D1 () {0x89;}' unless defined(&MSR_BBL_CR_D1);
eval 'sub MSR_BBL_CR_D2 () {0x8a;}' unless defined(&MSR_BBL_CR_D2);
eval 'sub MSR_BIOS_SIGN () {0x8b;}' unless defined(&MSR_BIOS_SIGN);
eval 'sub P6MSR_CTR0 () {0xc1;}' unless defined(&P6MSR_CTR0);
eval 'sub P6MSR_CTR1 () {0xc2;}' unless defined(&P6MSR_CTR1);
eval 'sub MSR_FSB_FREQ () {0xcd;}' unless defined(&MSR_FSB_FREQ);
eval 'sub MSR_TEMPERATURE_TARGET () {0xee;}' unless defined(&MSR_TEMPERATURE_TARGET);
eval 'sub MSR_TEMPERATURE_TARGET_LOW_BIT () {0x40000000;}' unless defined(&MSR_TEMPERATURE_TARGET_LOW_BIT);
eval 'sub MSR_MTRRcap () {0xfe;}' unless defined(&MSR_MTRRcap);
eval 'sub MSR_BBL_CR_ADDR () {0x116;}' unless defined(&MSR_BBL_CR_ADDR);
eval 'sub MSR_BBL_CR_DECC () {0x118;}' unless defined(&MSR_BBL_CR_DECC);
eval 'sub MSR_BBL_CR_CTL () {0x119;}' unless defined(&MSR_BBL_CR_CTL);
eval 'sub MSR_BBL_CR_TRIG () {0x11a;}' unless defined(&MSR_BBL_CR_TRIG);
eval 'sub MSR_BBL_CR_BUSY () {0x11b;}' unless defined(&MSR_BBL_CR_BUSY);
eval 'sub MSR_BBL_CR_CTR3 () {0x11e;}' unless defined(&MSR_BBL_CR_CTR3);
eval 'sub MSR_SYSENTER_CS () {0x174;}' unless defined(&MSR_SYSENTER_CS);
eval 'sub MSR_SYSENTER_ESP () {0x175;}' unless defined(&MSR_SYSENTER_ESP);
eval 'sub MSR_SYSENTER_EIP () {0x176;}' unless defined(&MSR_SYSENTER_EIP);
eval 'sub MSR_MCG_CAP () {0x179;}' unless defined(&MSR_MCG_CAP);
eval 'sub MSR_MCG_STATUS () {0x17a;}' unless defined(&MSR_MCG_STATUS);
eval 'sub MSR_MCG_CTL () {0x17b;}' unless defined(&MSR_MCG_CTL);
eval 'sub P6MSR_CTRSEL0 () {0x186;}' unless defined(&P6MSR_CTRSEL0);
eval 'sub P6MSR_CTRSEL1 () {0x187;}' unless defined(&P6MSR_CTRSEL1);
eval 'sub MSR_PERF_STATUS () {0x198;}' unless defined(&MSR_PERF_STATUS);
eval 'sub MSR_PERF_CTL () {0x199;}' unless defined(&MSR_PERF_CTL);
eval 'sub MSR_THERM_CONTROL () {0x19a;}' unless defined(&MSR_THERM_CONTROL);
eval 'sub MSR_THERM_INTERRUPT () {0x19b;}' unless defined(&MSR_THERM_INTERRUPT);
eval 'sub MSR_THERM_STATUS () {0x19c;}' unless defined(&MSR_THERM_STATUS);
eval 'sub MSR_THERM_STATUS_VALID_BIT () {0x80000000;}' unless defined(&MSR_THERM_STATUS_VALID_BIT);
unless(defined(&MSR_THERM_STATUS_TEMP)) {
    sub MSR_THERM_STATUS_TEMP {
	my($msr) = @_;
	eval q((($msr >> 16) & 0x7f));
    }
}
eval 'sub MSR_THERM2_CTL () {0x19d;}' unless defined(&MSR_THERM2_CTL);
eval 'sub MSR_MISC_ENABLE () {0x1a0;}' unless defined(&MSR_MISC_ENABLE);
eval 'sub MSR_DEBUGCTLMSR () {0x1d9;}' unless defined(&MSR_DEBUGCTLMSR);
eval 'sub MSR_LASTBRANCHFROMIP () {0x1db;}' unless defined(&MSR_LASTBRANCHFROMIP);
eval 'sub MSR_LASTBRANCHTOIP () {0x1dc;}' unless defined(&MSR_LASTBRANCHTOIP);
eval 'sub MSR_LASTINTFROMIP () {0x1dd;}' unless defined(&MSR_LASTINTFROMIP);
eval 'sub MSR_LASTINTTOIP () {0x1de;}' unless defined(&MSR_LASTINTTOIP);
eval 'sub MSR_ROB_CR_BKUPTMPDR6 () {0x1e0;}' unless defined(&MSR_ROB_CR_BKUPTMPDR6);
eval 'sub MSR_MTRRvarBase () {0x200;}' unless defined(&MSR_MTRRvarBase);
eval 'sub MSR_MTRRfix64K_00000 () {0x250;}' unless defined(&MSR_MTRRfix64K_00000);
eval 'sub MSR_MTRRfix16K_80000 () {0x258;}' unless defined(&MSR_MTRRfix16K_80000);
eval 'sub MSR_MTRRfix4K_C0000 () {0x268;}' unless defined(&MSR_MTRRfix4K_C0000);
eval 'sub MSR_CR_PAT () {0x277;}' unless defined(&MSR_CR_PAT);
eval 'sub MSR_MTRRdefType () {0x2ff;}' unless defined(&MSR_MTRRdefType);
eval 'sub MSR_PERF_FIXED_CTR1 () {0x30a;}' unless defined(&MSR_PERF_FIXED_CTR1);
eval 'sub MSR_PERF_FIXED_CTR2 () {0x30b;}' unless defined(&MSR_PERF_FIXED_CTR2);
eval 'sub MSR_PERF_FIXED_CTR_CTRL () {0x38d;}' unless defined(&MSR_PERF_FIXED_CTR_CTRL);
eval 'sub MSR_PERF_FIXED_CTR_FC_DIS () {0x;}' unless defined(&MSR_PERF_FIXED_CTR_FC_DIS);
eval 'sub MSR_PERF_FIXED_CTR_FC_1 () {0x1;}' unless defined(&MSR_PERF_FIXED_CTR_FC_1);
eval 'sub MSR_PERF_FIXED_CTR_FC_123 () {0x2;}' unless defined(&MSR_PERF_FIXED_CTR_FC_123);
eval 'sub MSR_PERF_FIXED_CTR_FC_ANY () {0x3;}' unless defined(&MSR_PERF_FIXED_CTR_FC_ANY);
eval 'sub MSR_PERF_FIXED_CTR_FC_MASK () {0x3;}' unless defined(&MSR_PERF_FIXED_CTR_FC_MASK);
unless(defined(&MSR_PERF_FIXED_CTR_FC)) {
    sub MSR_PERF_FIXED_CTR_FC {
	my($_i, $_v) = @_;
	eval q((($_v) << (4* ($_i))));
    }
}
unless(defined(&MSR_PERF_FIXED_CTR_ANYTHR)) {
    sub MSR_PERF_FIXED_CTR_ANYTHR {
	my($_i) = @_;
	eval q((0x4 << (4* ($_i))));
    }
}
unless(defined(&MSR_PERF_FIXED_CTR_INT)) {
    sub MSR_PERF_FIXED_CTR_INT {
	my($_i) = @_;
	eval q((0x8 << (4* ($_i))));
    }
}
eval 'sub MSR_PERF_GLOBAL_CTRL () {0x38f;}' unless defined(&MSR_PERF_GLOBAL_CTRL);
eval 'sub MSR_PERF_GLOBAL_CTR1_EN () {(1 << 33);}' unless defined(&MSR_PERF_GLOBAL_CTR1_EN);
eval 'sub MSR_PERF_GLOBAL_CTR2_EN () {(1 << 34);}' unless defined(&MSR_PERF_GLOBAL_CTR2_EN);
eval 'sub MSR_MC0_CTL () {0x400;}' unless defined(&MSR_MC0_CTL);
eval 'sub MSR_MC0_STATUS () {0x401;}' unless defined(&MSR_MC0_STATUS);
eval 'sub MSR_MC0_ADDR () {0x402;}' unless defined(&MSR_MC0_ADDR);
eval 'sub MSR_MC0_MISC () {0x403;}' unless defined(&MSR_MC0_MISC);
eval 'sub MSR_MC1_CTL () {0x404;}' unless defined(&MSR_MC1_CTL);
eval 'sub MSR_MC1_STATUS () {0x405;}' unless defined(&MSR_MC1_STATUS);
eval 'sub MSR_MC1_ADDR () {0x406;}' unless defined(&MSR_MC1_ADDR);
eval 'sub MSR_MC1_MISC () {0x407;}' unless defined(&MSR_MC1_MISC);
eval 'sub MSR_MC2_CTL () {0x408;}' unless defined(&MSR_MC2_CTL);
eval 'sub MSR_MC2_STATUS () {0x409;}' unless defined(&MSR_MC2_STATUS);
eval 'sub MSR_MC2_ADDR () {0x40a;}' unless defined(&MSR_MC2_ADDR);
eval 'sub MSR_MC2_MISC () {0x40b;}' unless defined(&MSR_MC2_MISC);
eval 'sub MSR_MC4_CTL () {0x40c;}' unless defined(&MSR_MC4_CTL);
eval 'sub MSR_MC4_STATUS () {0x40d;}' unless defined(&MSR_MC4_STATUS);
eval 'sub MSR_MC4_ADDR () {0x40e;}' unless defined(&MSR_MC4_ADDR);
eval 'sub MSR_MC4_MISC () {0x40f;}' unless defined(&MSR_MC4_MISC);
eval 'sub MSR_MC3_CTL () {0x410;}' unless defined(&MSR_MC3_CTL);
eval 'sub MSR_MC3_STATUS () {0x411;}' unless defined(&MSR_MC3_STATUS);
eval 'sub MSR_MC3_ADDR () {0x412;}' unless defined(&MSR_MC3_ADDR);
eval 'sub MSR_MC3_MISC () {0x413;}' unless defined(&MSR_MC3_MISC);
eval 'sub MSR_CENT_TMTEMPERATURE () {0x1423;}' unless defined(&MSR_CENT_TMTEMPERATURE);
eval 'sub MSR_C7M_TMTEMPERATURE () {0x1169;}' unless defined(&MSR_C7M_TMTEMPERATURE);
eval 'sub MSR_K6_EPMR () {0xc0000086;}' unless defined(&MSR_K6_EPMR);
eval 'sub MSR_K7_EVNTSEL0 () {0xc0010000;}' unless defined(&MSR_K7_EVNTSEL0);
eval 'sub MSR_K7_EVNTSEL1 () {0xc0010001;}' unless defined(&MSR_K7_EVNTSEL1);
eval 'sub MSR_K7_EVNTSEL2 () {0xc0010002;}' unless defined(&MSR_K7_EVNTSEL2);
eval 'sub MSR_K7_EVNTSEL3 () {0xc0010003;}' unless defined(&MSR_K7_EVNTSEL3);
eval 'sub MSR_K7_PERFCTR0 () {0xc0010004;}' unless defined(&MSR_K7_PERFCTR0);
eval 'sub MSR_K7_PERFCTR1 () {0xc0010005;}' unless defined(&MSR_K7_PERFCTR1);
eval 'sub MSR_K7_PERFCTR2 () {0xc0010006;}' unless defined(&MSR_K7_PERFCTR2);
eval 'sub MSR_K7_PERFCTR3 () {0xc0010007;}' unless defined(&MSR_K7_PERFCTR3);
eval 'sub MSR_SYSCFG () {0xc0000010;}' unless defined(&MSR_SYSCFG);
eval 'sub MSR_EFER () {0xc0000080;}' unless defined(&MSR_EFER);
eval 'sub EFER_SCE () {0x1;}' unless defined(&EFER_SCE);
eval 'sub EFER_LME () {0x100;}' unless defined(&EFER_LME);
eval 'sub EFER_LMA () {0x400;}' unless defined(&EFER_LMA);
eval 'sub EFER_NXE () {0x800;}' unless defined(&EFER_NXE);
eval 'sub MSR_STAR () {0xc0000081;}' unless defined(&MSR_STAR);
eval 'sub MSR_LSTAR () {0xc0000082;}' unless defined(&MSR_LSTAR);
eval 'sub MSR_CSTAR () {0xc0000083;}' unless defined(&MSR_CSTAR);
eval 'sub MSR_SFMASK () {0xc0000084;}' unless defined(&MSR_SFMASK);
eval 'sub MSR_FSBASE () {0xc0000100;}' unless defined(&MSR_FSBASE);
eval 'sub MSR_GSBASE () {0xc0000101;}' unless defined(&MSR_GSBASE);
eval 'sub MSR_KERNELGSBASE () {0xc0000102;}' unless defined(&MSR_KERNELGSBASE);
eval 'sub MSR_INT_PEN_MSG () {0xc0010055;}' unless defined(&MSR_INT_PEN_MSG);
eval 'sub MSR_DE_CFG () {0xc0011029;}' unless defined(&MSR_DE_CFG);
eval 'sub DE_CFG_721 () {0x1;}' unless defined(&DE_CFG_721);
eval 'sub IPM_C1E_CMP_HLT () {0x10000000;}' unless defined(&IPM_C1E_CMP_HLT);
eval 'sub IPM_SMI_CMP_HLT () {0x8000000;}' unless defined(&IPM_SMI_CMP_HLT);
eval 'sub MSR_HWCR () {0xc0010015;}' unless defined(&MSR_HWCR);
eval 'sub HWCR_FFDIS () {0x40;}' unless defined(&HWCR_FFDIS);
eval 'sub MSR_NB_CFG () {0xc001001f;}' unless defined(&MSR_NB_CFG);
eval 'sub NB_CFG_DISIOREQLOCK () {0x4;}' unless defined(&NB_CFG_DISIOREQLOCK);
eval 'sub NB_CFG_DISDATMSK () {68719476736;}' unless defined(&NB_CFG_DISDATMSK);
eval 'sub MSR_LS_CFG () {0xc0011020;}' unless defined(&MSR_LS_CFG);
eval 'sub LS_CFG_DIS_LS2_SQUISH () {0x2000000;}' unless defined(&LS_CFG_DIS_LS2_SQUISH);
eval 'sub MSR_IC_CFG () {0xc0011021;}' unless defined(&MSR_IC_CFG);
eval 'sub IC_CFG_DIS_SEQ_PREFETCH () {0x800;}' unless defined(&IC_CFG_DIS_SEQ_PREFETCH);
eval 'sub MSR_DC_CFG () {0xc0011022;}' unless defined(&MSR_DC_CFG);
eval 'sub DC_CFG_DIS_CNV_WC_SSO () {0x4;}' unless defined(&DC_CFG_DIS_CNV_WC_SSO);
eval 'sub DC_CFG_DIS_SMC_CHK_BUF () {0x400;}' unless defined(&DC_CFG_DIS_SMC_CHK_BUF);
eval 'sub MSR_BU_CFG () {0xc0011023;}' unless defined(&MSR_BU_CFG);
eval 'sub BU_CFG_THRL2IDXCMPDIS () {8796093022208;}' unless defined(&BU_CFG_THRL2IDXCMPDIS);
eval 'sub BU_CFG_WBPFSMCCHKDIS () {35184372088832;}' unless defined(&BU_CFG_WBPFSMCCHKDIS);
eval 'sub BU_CFG_WBENHWSBDIS () {281474976710656;}' unless defined(&BU_CFG_WBENHWSBDIS);
eval 'sub MTRR_N64K () {8;}' unless defined(&MTRR_N64K);
eval 'sub MTRR_N16K () {16;}' unless defined(&MTRR_N16K);
eval 'sub MTRR_N4K () {64;}' unless defined(&MTRR_N4K);
eval 'sub NCR1 () {0xc4;}' unless defined(&NCR1);
eval 'sub NCR2 () {0xc7;}' unless defined(&NCR2);
eval 'sub NCR3 () {0xca;}' unless defined(&NCR3);
eval 'sub NCR4 () {0xcd;}' unless defined(&NCR4);
eval 'sub NCR_SIZE_0K () {0;}' unless defined(&NCR_SIZE_0K);
eval 'sub NCR_SIZE_4K () {1;}' unless defined(&NCR_SIZE_4K);
eval 'sub NCR_SIZE_8K () {2;}' unless defined(&NCR_SIZE_8K);
eval 'sub NCR_SIZE_16K () {3;}' unless defined(&NCR_SIZE_16K);
eval 'sub NCR_SIZE_32K () {4;}' unless defined(&NCR_SIZE_32K);
eval 'sub NCR_SIZE_64K () {5;}' unless defined(&NCR_SIZE_64K);
eval 'sub NCR_SIZE_128K () {6;}' unless defined(&NCR_SIZE_128K);
eval 'sub NCR_SIZE_256K () {7;}' unless defined(&NCR_SIZE_256K);
eval 'sub NCR_SIZE_512K () {8;}' unless defined(&NCR_SIZE_512K);
eval 'sub NCR_SIZE_1M () {9;}' unless defined(&NCR_SIZE_1M);
eval 'sub NCR_SIZE_2M () {10;}' unless defined(&NCR_SIZE_2M);
eval 'sub NCR_SIZE_4M () {11;}' unless defined(&NCR_SIZE_4M);
eval 'sub NCR_SIZE_8M () {12;}' unless defined(&NCR_SIZE_8M);
eval 'sub NCR_SIZE_16M () {13;}' unless defined(&NCR_SIZE_16M);
eval 'sub NCR_SIZE_32M () {14;}' unless defined(&NCR_SIZE_32M);
eval 'sub NCR_SIZE_4G () {15;}' unless defined(&NCR_SIZE_4G);
eval 'sub PMC5_CESR_EVENT () {0x3f;}' unless defined(&PMC5_CESR_EVENT);
eval 'sub PMC5_CESR_OS () {0x40;}' unless defined(&PMC5_CESR_OS);
eval 'sub PMC5_CESR_USR () {0x80;}' unless defined(&PMC5_CESR_USR);
eval 'sub PMC5_CESR_E () {0x100;}' unless defined(&PMC5_CESR_E);
eval 'sub PMC5_CESR_P () {0x200;}' unless defined(&PMC5_CESR_P);
eval 'sub PMC6_EVTSEL_EVENT () {0xff;}' unless defined(&PMC6_EVTSEL_EVENT);
eval 'sub PMC6_EVTSEL_UNIT () {0xff00;}' unless defined(&PMC6_EVTSEL_UNIT);
eval 'sub PMC6_EVTSEL_UNIT_SHIFT () {8;}' unless defined(&PMC6_EVTSEL_UNIT_SHIFT);
eval 'sub PMC6_EVTSEL_USR () {(1<< 16);}' unless defined(&PMC6_EVTSEL_USR);
eval 'sub PMC6_EVTSEL_OS () {(1<< 17);}' unless defined(&PMC6_EVTSEL_OS);
eval 'sub PMC6_EVTSEL_E () {(1<< 18);}' unless defined(&PMC6_EVTSEL_E);
eval 'sub PMC6_EVTSEL_PC () {(1<< 19);}' unless defined(&PMC6_EVTSEL_PC);
eval 'sub PMC6_EVTSEL_INT () {(1<< 20);}' unless defined(&PMC6_EVTSEL_INT);
eval 'sub PMC6_EVTSEL_EN () {(1<< 22);}' unless defined(&PMC6_EVTSEL_EN);
eval 'sub PMC6_EVTSEL_INV () {(1<< 23);}' unless defined(&PMC6_EVTSEL_INV);
eval 'sub PMC6_EVTSEL_COUNTER_MASK () {0xff000000;}' unless defined(&PMC6_EVTSEL_COUNTER_MASK);
eval 'sub PMC6_EVTSEL_COUNTER_MASK_SHIFT () {24;}' unless defined(&PMC6_EVTSEL_COUNTER_MASK_SHIFT);
eval 'sub PMC6_DATA_MEM_REFS () {0x43;}' unless defined(&PMC6_DATA_MEM_REFS);
eval 'sub PMC6_DCU_LINES_IN () {0x45;}' unless defined(&PMC6_DCU_LINES_IN);
eval 'sub PMC6_DCU_M_LINES_IN () {0x46;}' unless defined(&PMC6_DCU_M_LINES_IN);
eval 'sub PMC6_DCU_M_LINES_OUT () {0x47;}' unless defined(&PMC6_DCU_M_LINES_OUT);
eval 'sub PMC6_DCU_MISS_OUTSTANDING () {0x48;}' unless defined(&PMC6_DCU_MISS_OUTSTANDING);
eval 'sub PMC6_IFU_IFETCH () {0x80;}' unless defined(&PMC6_IFU_IFETCH);
eval 'sub PMC6_IFU_IFETCH_MISS () {0x81;}' unless defined(&PMC6_IFU_IFETCH_MISS);
eval 'sub PMC6_ITLB_MISS () {0x85;}' unless defined(&PMC6_ITLB_MISS);
eval 'sub PMC6_IFU_MEM_STALL () {0x86;}' unless defined(&PMC6_IFU_MEM_STALL);
eval 'sub PMC6_ILD_STALL () {0x87;}' unless defined(&PMC6_ILD_STALL);
eval 'sub PMC6_L2_IFETCH () {0x28;}' unless defined(&PMC6_L2_IFETCH);
eval 'sub PMC6_L2_LD () {0x29;}' unless defined(&PMC6_L2_LD);
eval 'sub PMC6_L2_ST () {0x2a;}' unless defined(&PMC6_L2_ST);
eval 'sub PMC6_L2_LINES_IN () {0x24;}' unless defined(&PMC6_L2_LINES_IN);
eval 'sub PMC6_L2_LINES_OUT () {0x26;}' unless defined(&PMC6_L2_LINES_OUT);
eval 'sub PMC6_L2_M_LINES_INM () {0x25;}' unless defined(&PMC6_L2_M_LINES_INM);
eval 'sub PMC6_L2_M_LINES_OUTM () {0x27;}' unless defined(&PMC6_L2_M_LINES_OUTM);
eval 'sub PMC6_L2_RQSTS () {0x2e;}' unless defined(&PMC6_L2_RQSTS);
eval 'sub PMC6_L2_ADS () {0x21;}' unless defined(&PMC6_L2_ADS);
eval 'sub PMC6_L2_DBUS_BUSY () {0x22;}' unless defined(&PMC6_L2_DBUS_BUSY);
eval 'sub PMC6_L2_DBUS_BUSY_RD () {0x23;}' unless defined(&PMC6_L2_DBUS_BUSY_RD);
eval 'sub PMC6_BUS_DRDY_CLOCKS () {0x62;}' unless defined(&PMC6_BUS_DRDY_CLOCKS);
eval 'sub PMC6_BUS_LOCK_CLOCKS () {0x63;}' unless defined(&PMC6_BUS_LOCK_CLOCKS);
eval 'sub PMC6_BUS_REQ_OUTSTANDING () {0x60;}' unless defined(&PMC6_BUS_REQ_OUTSTANDING);
eval 'sub PMC6_BUS_TRAN_BRD () {0x65;}' unless defined(&PMC6_BUS_TRAN_BRD);
eval 'sub PMC6_BUS_TRAN_RFO () {0x66;}' unless defined(&PMC6_BUS_TRAN_RFO);
eval 'sub PMC6_BUS_TRANS_WB () {0x67;}' unless defined(&PMC6_BUS_TRANS_WB);
eval 'sub PMC6_BUS_TRAN_IFETCH () {0x68;}' unless defined(&PMC6_BUS_TRAN_IFETCH);
eval 'sub PMC6_BUS_TRAN_INVAL () {0x69;}' unless defined(&PMC6_BUS_TRAN_INVAL);
eval 'sub PMC6_BUS_TRAN_PWR () {0x6a;}' unless defined(&PMC6_BUS_TRAN_PWR);
eval 'sub PMC6_BUS_TRANS_P () {0x6b;}' unless defined(&PMC6_BUS_TRANS_P);
eval 'sub PMC6_BUS_TRANS_IO () {0x6c;}' unless defined(&PMC6_BUS_TRANS_IO);
eval 'sub PMC6_BUS_TRAN_DEF () {0x6d;}' unless defined(&PMC6_BUS_TRAN_DEF);
eval 'sub PMC6_BUS_TRAN_BURST () {0x6e;}' unless defined(&PMC6_BUS_TRAN_BURST);
eval 'sub PMC6_BUS_TRAN_ANY () {0x70;}' unless defined(&PMC6_BUS_TRAN_ANY);
eval 'sub PMC6_BUS_TRAN_MEM () {0x6f;}' unless defined(&PMC6_BUS_TRAN_MEM);
eval 'sub PMC6_BUS_DATA_RCV () {0x64;}' unless defined(&PMC6_BUS_DATA_RCV);
eval 'sub PMC6_BUS_BNR_DRV () {0x61;}' unless defined(&PMC6_BUS_BNR_DRV);
eval 'sub PMC6_BUS_HIT_DRV () {0x7a;}' unless defined(&PMC6_BUS_HIT_DRV);
eval 'sub PMC6_BUS_HITM_DRDV () {0x7b;}' unless defined(&PMC6_BUS_HITM_DRDV);
eval 'sub PMC6_BUS_SNOOP_STALL () {0x7e;}' unless defined(&PMC6_BUS_SNOOP_STALL);
eval 'sub PMC6_FLOPS () {0xc1;}' unless defined(&PMC6_FLOPS);
eval 'sub PMC6_FP_COMP_OPS_EXE () {0x10;}' unless defined(&PMC6_FP_COMP_OPS_EXE);
eval 'sub PMC6_FP_ASSIST () {0x11;}' unless defined(&PMC6_FP_ASSIST);
eval 'sub PMC6_MUL () {0x12;}' unless defined(&PMC6_MUL);
eval 'sub PMC6_DIV () {0x12;}' unless defined(&PMC6_DIV);
eval 'sub PMC6_CYCLES_DIV_BUSY () {0x14;}' unless defined(&PMC6_CYCLES_DIV_BUSY);
eval 'sub PMC6_LD_BLOCKS () {0x3;}' unless defined(&PMC6_LD_BLOCKS);
eval 'sub PMC6_SB_DRAINS () {0x4;}' unless defined(&PMC6_SB_DRAINS);
eval 'sub PMC6_MISALIGN_MEM_REF () {0x5;}' unless defined(&PMC6_MISALIGN_MEM_REF);
eval 'sub PMC6_EMON_KNI_PREF_DISPATCHED () {0x7;}' unless defined(&PMC6_EMON_KNI_PREF_DISPATCHED);
eval 'sub PMC6_EMON_KNI_PREF_MISS () {0x4b;}' unless defined(&PMC6_EMON_KNI_PREF_MISS);
eval 'sub PMC6_INST_RETIRED () {0xc0;}' unless defined(&PMC6_INST_RETIRED);
eval 'sub PMC6_UOPS_RETIRED () {0xc2;}' unless defined(&PMC6_UOPS_RETIRED);
eval 'sub PMC6_INST_DECODED () {0xd0;}' unless defined(&PMC6_INST_DECODED);
eval 'sub PMC6_EMON_KNI_INST_RETIRED () {0xd8;}' unless defined(&PMC6_EMON_KNI_INST_RETIRED);
eval 'sub PMC6_EMON_KNI_COMP_INST_RET () {0xd9;}' unless defined(&PMC6_EMON_KNI_COMP_INST_RET);
eval 'sub PMC6_HW_INT_RX () {0xc8;}' unless defined(&PMC6_HW_INT_RX);
eval 'sub PMC6_CYCLES_INT_MASKED () {0xc6;}' unless defined(&PMC6_CYCLES_INT_MASKED);
eval 'sub PMC6_CYCLES_INT_PENDING_AND_MASKED () {0xc7;}' unless defined(&PMC6_CYCLES_INT_PENDING_AND_MASKED);
eval 'sub PMC6_BR_INST_RETIRED () {0xc4;}' unless defined(&PMC6_BR_INST_RETIRED);
eval 'sub PMC6_BR_MISS_PRED_RETIRED () {0xc5;}' unless defined(&PMC6_BR_MISS_PRED_RETIRED);
eval 'sub PMC6_BR_TAKEN_RETIRED () {0xc9;}' unless defined(&PMC6_BR_TAKEN_RETIRED);
eval 'sub PMC6_BR_MISS_PRED_TAKEN_RET () {0xca;}' unless defined(&PMC6_BR_MISS_PRED_TAKEN_RET);
eval 'sub PMC6_BR_INST_DECODED () {0xe0;}' unless defined(&PMC6_BR_INST_DECODED);
eval 'sub PMC6_BTB_MISSES () {0xe2;}' unless defined(&PMC6_BTB_MISSES);
eval 'sub PMC6_BR_BOGUS () {0xe4;}' unless defined(&PMC6_BR_BOGUS);
eval 'sub PMC6_BACLEARS () {0xe6;}' unless defined(&PMC6_BACLEARS);
eval 'sub PMC6_RESOURCE_STALLS () {0xa2;}' unless defined(&PMC6_RESOURCE_STALLS);
eval 'sub PMC6_PARTIAL_RAT_STALLS () {0xd2;}' unless defined(&PMC6_PARTIAL_RAT_STALLS);
eval 'sub PMC6_SEGMENT_REG_LOADS () {0x6;}' unless defined(&PMC6_SEGMENT_REG_LOADS);
eval 'sub PMC6_CPU_CLK_UNHALTED () {0x79;}' unless defined(&PMC6_CPU_CLK_UNHALTED);
eval 'sub PMC6_MMX_INSTR_EXEC () {0xb0;}' unless defined(&PMC6_MMX_INSTR_EXEC);
eval 'sub PMC6_MMX_SAT_INSTR_EXEC () {0xb1;}' unless defined(&PMC6_MMX_SAT_INSTR_EXEC);
eval 'sub PMC6_MMX_UOPS_EXEC () {0xb2;}' unless defined(&PMC6_MMX_UOPS_EXEC);
eval 'sub PMC6_MMX_INSTR_TYPE_EXEC () {0xb3;}' unless defined(&PMC6_MMX_INSTR_TYPE_EXEC);
eval 'sub PMC6_FP_MMX_TRANS () {0xcc;}' unless defined(&PMC6_FP_MMX_TRANS);
eval 'sub PMC6_MMX_ASSIST () {0xcd;}' unless defined(&PMC6_MMX_ASSIST);
eval 'sub PMC6_MMX_INSTR_RET () {0xc3;}' unless defined(&PMC6_MMX_INSTR_RET);
eval 'sub PMC6_SEG_RENAME_STALLS () {0xd4;}' unless defined(&PMC6_SEG_RENAME_STALLS);
eval 'sub PMC6_SEG_REG_RENAMES () {0xd5;}' unless defined(&PMC6_SEG_REG_RENAMES);
eval 'sub PMC6_RET_SEG_RENAMES () {0xd6;}' unless defined(&PMC6_RET_SEG_RENAMES);
eval 'sub C3_HAS_AES () {1;}' unless defined(&C3_HAS_AES);
eval 'sub C3_HAS_SHA () {2;}' unless defined(&C3_HAS_SHA);
eval 'sub C3_HAS_MM () {4;}' unless defined(&C3_HAS_MM);
eval 'sub C3_HAS_AESCTR () {8;}' unless defined(&C3_HAS_AESCTR);
eval 'sub C3_CPUID_HAS_RNG () {0x4;}' unless defined(&C3_CPUID_HAS_RNG);
eval 'sub C3_CPUID_DO_RNG () {0x8;}' unless defined(&C3_CPUID_DO_RNG);
eval 'sub C3_CPUID_HAS_ACE () {0x40;}' unless defined(&C3_CPUID_HAS_ACE);
eval 'sub C3_CPUID_DO_ACE () {0x80;}' unless defined(&C3_CPUID_DO_ACE);
eval 'sub C3_CPUID_HAS_ACE2 () {0x100;}' unless defined(&C3_CPUID_HAS_ACE2);
eval 'sub C3_CPUID_DO_ACE2 () {0x200;}' unless defined(&C3_CPUID_DO_ACE2);
eval 'sub C3_CPUID_HAS_PHE () {0x400;}' unless defined(&C3_CPUID_HAS_PHE);
eval 'sub C3_CPUID_DO_PHE () {0x800;}' unless defined(&C3_CPUID_DO_PHE);
eval 'sub C3_CPUID_HAS_PMM () {0x1000;}' unless defined(&C3_CPUID_HAS_PMM);
eval 'sub C3_CPUID_DO_PMM () {0x2000;}' unless defined(&C3_CPUID_DO_PMM);
eval 'sub C3_CRYPT_CWLO_ROUND_M () {0xf;}' unless defined(&C3_CRYPT_CWLO_ROUND_M);
eval 'sub C3_CRYPT_CWLO_ALG_M () {0x70;}' unless defined(&C3_CRYPT_CWLO_ALG_M);
eval 'sub C3_CRYPT_CWLO_ALG_AES () {0x;}' unless defined(&C3_CRYPT_CWLO_ALG_AES);
eval 'sub C3_CRYPT_CWLO_KEYGEN_M () {0x80;}' unless defined(&C3_CRYPT_CWLO_KEYGEN_M);
eval 'sub C3_CRYPT_CWLO_KEYGEN_HW () {0x;}' unless defined(&C3_CRYPT_CWLO_KEYGEN_HW);
eval 'sub C3_CRYPT_CWLO_KEYGEN_SW () {0x80;}' unless defined(&C3_CRYPT_CWLO_KEYGEN_SW);
eval 'sub C3_CRYPT_CWLO_NORMAL () {0x;}' unless defined(&C3_CRYPT_CWLO_NORMAL);
eval 'sub C3_CRYPT_CWLO_INTERMEDIATE () {0x100;}' unless defined(&C3_CRYPT_CWLO_INTERMEDIATE);
eval 'sub C3_CRYPT_CWLO_ENCRYPT () {0x;}' unless defined(&C3_CRYPT_CWLO_ENCRYPT);
eval 'sub C3_CRYPT_CWLO_DECRYPT () {0x200;}' unless defined(&C3_CRYPT_CWLO_DECRYPT);
eval 'sub C3_CRYPT_CWLO_KEY128 () {0xa;}' unless defined(&C3_CRYPT_CWLO_KEY128);
eval 'sub C3_CRYPT_CWLO_KEY192 () {0x40c;}' unless defined(&C3_CRYPT_CWLO_KEY192);
eval 'sub C3_CRYPT_CWLO_KEY256 () {0x80e;}' unless defined(&C3_CRYPT_CWLO_KEY256);
1;
