require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_AV530_H_)) {
    eval 'sub _MACHINE_AV530_H_ () {1;}' unless defined(&_MACHINE_AV530_H_);
    eval 'sub AV530_PROM () {0xffc00000;}' unless defined(&AV530_PROM);
    eval 'sub AV530_PROM_SIZE () {0x80000;}' unless defined(&AV530_PROM_SIZE);
    eval 'sub AV530_UTILITY () {0xfff00000;}' unless defined(&AV530_UTILITY);
    eval 'sub AV530_UTILITY_SIZE () {0x100000;}' unless defined(&AV530_UTILITY_SIZE);
    eval 'sub AV530_VME32_BASE () {0x;}' unless defined(&AV530_VME32_BASE);
    eval 'sub AV530_VME32_START1 () {0x40000000;}' unless defined(&AV530_VME32_START1);
    eval 'sub AV530_VME32_END1 () {0x7fffffff;}' unless defined(&AV530_VME32_END1);
    eval 'sub AV530_VME32_START2 () {0x90000000;}' unless defined(&AV530_VME32_START2);
    eval 'sub AV530_VME32_END2 () {0xfdffffff;}' unless defined(&AV530_VME32_END2);
    eval 'sub AV530_VME24_BASE () {0xfe000000;}' unless defined(&AV530_VME24_BASE);
    eval 'sub AV530_VME24_START () {0x;}' unless defined(&AV530_VME24_START);
    eval 'sub AV530_VME24_END () {0xffffff;}' unless defined(&AV530_VME24_END);
    eval 'sub AV530_VME16_BASE () {0xffff0000;}' unless defined(&AV530_VME16_BASE);
    eval 'sub AV530_VME16_START () {0x;}' unless defined(&AV530_VME16_START);
    eval 'sub AV530_VME16_END () {0xffff;}' unless defined(&AV530_VME16_END);
    eval 'sub AV530_SETSWI () {0xfff84080;}' unless defined(&AV530_SETSWI);
    eval 'sub AV530_CLRSWI () {0xfff84084;}' unless defined(&AV530_CLRSWI);
    eval 'sub AV530_VIRQLV () {0xfff85000;}' unless defined(&AV530_VIRQLV);
    eval 'sub AV530_VIACK1V () {0xfff85004;}' unless defined(&AV530_VIACK1V);
    eval 'sub AV530_VIACK2V () {0xfff85008;}' unless defined(&AV530_VIACK2V);
    eval 'sub AV530_VIACK3V () {0xfff8500c;}' unless defined(&AV530_VIACK3V);
    eval 'sub AV530_VIACK4V () {0xfff85010;}' unless defined(&AV530_VIACK4V);
    eval 'sub AV530_VIACK5V () {0xfff85014;}' unless defined(&AV530_VIACK5V);
    eval 'sub AV530_VIACK6V () {0xfff85018;}' unless defined(&AV530_VIACK6V);
    eval 'sub AV530_VIACK7V () {0xfff8501c;}' unless defined(&AV530_VIACK7V);
    eval 'sub AV530_VIRQV () {0xfff85020;}' unless defined(&AV530_VIRQV);
    eval 'sub AV530_IRQ_RESERVED () {0x20aa00;}' unless defined(&AV530_IRQ_RESERVED);
    eval 'sub AV530_IRQ_ABORT () {0x80000000;}' unless defined(&AV530_IRQ_ABORT);
    eval 'sub AV530_IRQ_ACF () {0x40000000;}' unless defined(&AV530_IRQ_ACF);
    eval 'sub AV530_IRQ_ARBTO () {0x20000000;}' unless defined(&AV530_IRQ_ARBTO);
    eval 'sub AV530_IRQ_DTI () {0x10000000;}' unless defined(&AV530_IRQ_DTI);
    eval 'sub AV530_IRQ_SWI7 () {0x8000000;}' unless defined(&AV530_IRQ_SWI7);
    eval 'sub AV530_IRQ_SWI6 () {0x4000000;}' unless defined(&AV530_IRQ_SWI6);
    eval 'sub AV530_IRQ_SWI5 () {0x2000000;}' unless defined(&AV530_IRQ_SWI5);
    eval 'sub AV530_IRQ_SWI4 () {0x1000000;}' unless defined(&AV530_IRQ_SWI4);
    eval 'sub AV530_IRQ_VME7 () {0x800000;}' unless defined(&AV530_IRQ_VME7);
    eval 'sub AV530_IRQ_KBD () {0x400000;}' unless defined(&AV530_IRQ_KBD);
    eval 'sub AV530_IRQ_SF () {0x100000;}' unless defined(&AV530_IRQ_SF);
    eval 'sub AV530_IRQ_VME6 () {0x80000;}' unless defined(&AV530_IRQ_VME6);
    eval 'sub AV530_IRQ_MEM () {0x40000;}' unless defined(&AV530_IRQ_MEM);
    eval 'sub AV530_IRQ_DI () {0x20000;}' unless defined(&AV530_IRQ_DI);
    eval 'sub AV530_IRQ_SIGHPI () {0x10000;}' unless defined(&AV530_IRQ_SIGHPI);
    eval 'sub AV530_IRQ_VME5 () {0x4000;}' unless defined(&AV530_IRQ_VME5);
    eval 'sub AV530_IRQ_VME4 () {0x1000;}' unless defined(&AV530_IRQ_VME4);
    eval 'sub AV530_IRQ_VME3 () {0x400;}' unless defined(&AV530_IRQ_VME3);
    eval 'sub AV530_IRQ_LMI () {0x100;}' unless defined(&AV530_IRQ_LMI);
    eval 'sub AV530_IRQ_SIGLPI () {0x80;}' unless defined(&AV530_IRQ_SIGLPI);
    eval 'sub AV530_IRQ_VME2 () {0x40;}' unless defined(&AV530_IRQ_VME2);
    eval 'sub AV530_IRQ_VME1 () {0x10;}' unless defined(&AV530_IRQ_VME1);
    eval 'sub AV530_IRQ_SWI3 () {0x8;}' unless defined(&AV530_IRQ_SWI3);
    eval 'sub AV530_IRQ_SWI2 () {0x4;}' unless defined(&AV530_IRQ_SWI2);
    eval 'sub AV530_IRQ_SWI1 () {0x2;}' unless defined(&AV530_IRQ_SWI1);
    eval 'sub AV530_IRQ_SWI0 () {0x1;}' unless defined(&AV530_IRQ_SWI0);
    eval 'sub AV530_IST_STRING () {"\\20" "\\40ABRT\\37ACF\\36ARBTO\\35DTI\\34SWI7\\33SWI6\\32SWI5\\31SWI4" "\\30IRQ7\\27KBD\\25SF\\24IRQ6\\23MEM\\22DI\\21SIGHPI" "\\17IRQ5\\15IRQ4\\13IRQ3\\11LMI" "\\10SIGLPI\\7IRQ2\\5IRQ1\\4SWI3\\3SWI2\\2SWI1\\1SWI0";}' unless defined(&AV530_IST_STRING);
    eval 'sub AV530_CLOCK_IPI_MASK () {( &AV530_IRQ_SWI7 |  &AV530_IRQ_SWI6 |  &AV530_IRQ_SWI5 |  &AV530_IRQ_SWI4);}' unless defined(&AV530_CLOCK_IPI_MASK);
    eval 'sub AV530_IPI_MASK () {( &AV530_IRQ_SWI3 |  &AV530_IRQ_SWI2 |  &AV530_IRQ_SWI1 |  &AV530_IRQ_SWI0);}' unless defined(&AV530_IPI_MASK);
    eval 'sub AV530_SWI_IPI_BIT {
        my($cpu) = @_;
	    eval q((0x1 << ($cpu)));
    }' unless defined(&AV530_SWI_IPI_BIT);
    eval 'sub AV530_SWI_CLOCK_IPI_BIT {
        my($cpu) = @_;
	    eval q((0x10 << ($cpu)));
    }' unless defined(&AV530_SWI_CLOCK_IPI_BIT);
    eval 'sub AV530_SWI_IPI_MASK {
        my($cpu) = @_;
	    eval q(( &AV530_IRQ_SWI0 << ($cpu)));
    }' unless defined(&AV530_SWI_IPI_MASK);
    eval 'sub AV530_SWI_CLOCK_IPI_MASK {
        my($cpu) = @_;
	    eval q(( &AV530_IRQ_SWI4 << ($cpu)));
    }' unless defined(&AV530_SWI_CLOCK_IPI_MASK);
    eval 'sub AV_EXIEN_BASE () {0xfff8e000;}' unless defined(&AV_EXIEN_BASE);
    eval 'sub AV_EXIEN0 () {0xfff8e004;}' unless defined(&AV_EXIEN0);
    eval 'sub AV_EXIEN1 () {0xfff8e008;}' unless defined(&AV_EXIEN1);
    eval 'sub AV_EXIEN2 () {0xfff8e010;}' unless defined(&AV_EXIEN2);
    eval 'sub AV_EXIEN3 () {0xfff8e020;}' unless defined(&AV_EXIEN3);
    eval 'sub AV_EXIENALL () {0xfff8e03c;}' unless defined(&AV_EXIENALL);
    eval 'sub AV_EXIEN {
        my($cpu) = @_;
	    eval q(( &AV_EXIEN_BASE + (4<< ($cpu))));
    }' unless defined(&AV_EXIEN);
    eval 'sub AV_EXIST () {0xfff8e040;}' unless defined(&AV_EXIST);
    eval 'sub AV530_EXIRQ_RESERVED () {0x4000e9f;}' unless defined(&AV530_EXIRQ_RESERVED);
    eval 'sub AV530_EXIRQ_RTCOF () {0x80000000;}' unless defined(&AV530_EXIRQ_RTCOF);
    eval 'sub AV530_EXIRQ_PIT3OF () {0x40000000;}' unless defined(&AV530_EXIRQ_PIT3OF);
    eval 'sub AV530_EXIRQ_PIT2OF () {0x20000000;}' unless defined(&AV530_EXIRQ_PIT2OF);
    eval 'sub AV530_EXIRQ_PIT1OF () {0x10000000;}' unless defined(&AV530_EXIRQ_PIT1OF);
    eval 'sub AV530_EXIRQ_PIT0OF () {0x8000000;}' unless defined(&AV530_EXIRQ_PIT0OF);
    eval 'sub AV530_EXIRQ_DMA4C () {0x2000000;}' unless defined(&AV530_EXIRQ_DMA4C);
    eval 'sub AV530_EXIRQ_DMA3C () {0x1000000;}' unless defined(&AV530_EXIRQ_DMA3C);
    eval 'sub AV530_EXIRQ_DMA2C () {0x800000;}' unless defined(&AV530_EXIRQ_DMA2C);
    eval 'sub AV530_EXIRQ_DMA1C () {0x400000;}' unless defined(&AV530_EXIRQ_DMA1C);
    eval 'sub AV530_EXIRQ_DMA0C () {0x200000;}' unless defined(&AV530_EXIRQ_DMA0C);
    eval 'sub AV530_EXIRQ_SCC () {0x100000;}' unless defined(&AV530_EXIRQ_SCC);
    eval 'sub AV530_EXIRQ_LAN0 () {0x80000;}' unless defined(&AV530_EXIRQ_LAN0);
    eval 'sub AV530_EXIRQ_LAN1 () {0x40000;}' unless defined(&AV530_EXIRQ_LAN1);
    eval 'sub AV530_EXIRQ_SCSI0 () {0x20000;}' unless defined(&AV530_EXIRQ_SCSI0);
    eval 'sub AV530_EXIRQ_SCSI1 () {0x10000;}' unless defined(&AV530_EXIRQ_SCSI1);
    eval 'sub AV530_EXIRQ_VIDEO () {0x8000;}' unless defined(&AV530_EXIRQ_VIDEO);
    eval 'sub AV530_EXIRQ_ZBUF () {0x4000;}' unless defined(&AV530_EXIRQ_ZBUF);
    eval 'sub AV530_EXIRQ_DUART2 () {0x2000;}' unless defined(&AV530_EXIRQ_DUART2);
    eval 'sub AV530_EXIRQ_VDMA () {0x1000;}' unless defined(&AV530_EXIRQ_VDMA);
    eval 'sub AV530_EXIRQ_IOEXP1 () {0x100;}' unless defined(&AV530_EXIRQ_IOEXP1);
    eval 'sub AV530_EXIRQ_IOEXP2 () {0x40;}' unless defined(&AV530_EXIRQ_IOEXP2);
    eval 'sub AV530_EXIRQ_PDMA () {0x20;}' unless defined(&AV530_EXIRQ_PDMA);
    eval 'sub AV530_EXIST_STRING () {"\\20" "\\40RTCOF\\37PIT3OF\\36PIT2OF\\35PIT1OF\\34PIT0OF\\32DMA4\\31DMA3" "\\30DMA2\\27DMA1\\26DMA0\\25SCC\\24LAN0\\23LAN1\\22SCSI0\\21SCSI1" "\\20VIDEO\\17ZBUF\\16DUART2\\15VDMA\\11IOEXP1" "\\7IOEXP2\\6PDMA";}' unless defined(&AV530_EXIST_STRING);
    eval 'sub AV530_SRST () {0xfff83100;}' unless defined(&AV530_SRST);
    eval 'sub SRST_KBD () {0x8;}' unless defined(&SRST_KBD);
    eval 'sub SRST_DUART2 () {0x2;}' unless defined(&SRST_DUART2);
    eval 'sub SRST_DUART1 () {0x1;}' unless defined(&SRST_DUART1);
    eval 'sub AV530_IOBRDID0 () {0xfffcf000;}' unless defined(&AV530_IOBRDID0);
    eval 'sub AV530_IOBRDID1 () {0xfffcf004;}' unless defined(&AV530_IOBRDID1);
    eval 'sub AV530_CONFIG () {0xfff8fffc;}' unless defined(&AV530_CONFIG);
    eval 'sub AV530_IOFUSE0 () {0xfffb0040;}' unless defined(&AV530_IOFUSE0);
    eval 'sub AV530_IOFUSE1 () {0xfffb00c0;}' unless defined(&AV530_IOFUSE1);
    eval 'sub AV530_IOFUSE_LAN () {0x2;}' unless defined(&AV530_IOFUSE_LAN);
    eval 'sub AV530_IOFUSE_SCSI () {0x1;}' unless defined(&AV530_IOFUSE_SCSI);
    eval 'sub AV530_PIT0_CNT () {0xfff8f004;}' unless defined(&AV530_PIT0_CNT);
    eval 'sub AV530_PIT1_CNT () {0xfff8f008;}' unless defined(&AV530_PIT1_CNT);
    eval 'sub AV530_PIT2_CNT () {0xfff8f010;}' unless defined(&AV530_PIT2_CNT);
    eval 'sub AV530_PIT3_CNT () {0xfff8f020;}' unless defined(&AV530_PIT3_CNT);
    eval 'sub AV530_PIT0_CS () {0xfff8f044;}' unless defined(&AV530_PIT0_CS);
    eval 'sub AV530_PIT1_CS () {0xfff8f048;}' unless defined(&AV530_PIT1_CS);
    eval 'sub AV530_PIT2_CS () {0xfff8f050;}' unless defined(&AV530_PIT2_CS);
    eval 'sub AV530_PIT3_CS () {0xfff8f060;}' unless defined(&AV530_PIT3_CS);
    eval 'sub AV530_PIT_CMD_ALL () {0xfff8f07c;}' unless defined(&AV530_PIT_CMD_ALL);
    eval 'sub AV530_PIT_CTEN () {0x8;}' unless defined(&AV530_PIT_CTEN);
    eval 'sub AV530_PIT_TEST () {0x4;}' unless defined(&AV530_PIT_TEST);
    eval 'sub AV530_PIT_IACK () {0x2;}' unless defined(&AV530_PIT_IACK);
    eval 'sub AV530_PIT_RESET () {0x1;}' unless defined(&AV530_PIT_RESET);
    eval 'sub AV530_RTC_CNT () {0xfff8f084;}' unless defined(&AV530_RTC_CNT);
    eval 'sub AV530_RTC_CS () {0xfff8f088;}' unless defined(&AV530_RTC_CS);
    eval 'sub AV530_RTC_IACK () {0x2;}' unless defined(&AV530_RTC_IACK);
    eval 'sub AV530_RTC_RESET () {0x1;}' unless defined(&AV530_RTC_RESET);
    eval 'sub AV530_SCSI1 () {0xfffb0000;}' unless defined(&AV530_SCSI1);
    eval 'sub AV530_SCSI2 () {0xfffb0080;}' unless defined(&AV530_SCSI2);
    eval 'sub AV530_LAN1 () {0xfffb0100;}' unless defined(&AV530_LAN1);
    eval 'sub AV530_LAN2 () {0xfffb0140;}' unless defined(&AV530_LAN2);
    eval 'sub AV530_CMMU_D0 () {0xfff00000;}' unless defined(&AV530_CMMU_D0);
    eval 'sub AV530_CMMU_I0 () {0xfff01000;}' unless defined(&AV530_CMMU_I0);
    eval 'sub AV530_CMMU_D1 () {0xfff02000;}' unless defined(&AV530_CMMU_D1);
    eval 'sub AV530_CMMU_I1 () {0xfff03000;}' unless defined(&AV530_CMMU_I1);
    eval 'sub AV530_CMMU6_D0 () {0xfff00000;}' unless defined(&AV530_CMMU6_D0);
    eval 'sub AV530_CMMU6_D1 () {0xfff01000;}' unless defined(&AV530_CMMU6_D1);
    eval 'sub AV530_CMMU6_I0 () {0xfff04000;}' unless defined(&AV530_CMMU6_I0);
    eval 'sub AV530_CMMU6_I1 () {0xfff05000;}' unless defined(&AV530_CMMU6_I1);
    eval 'sub AV530_CMMU6_I2 () {0xfff06000;}' unless defined(&AV530_CMMU6_I2);
    eval 'sub AV530_CMMU6_I3 () {0xfff07000;}' unless defined(&AV530_CMMU6_I3);
    eval 'sub AV530_CMMU6_D2 () {0xfff08000;}' unless defined(&AV530_CMMU6_D2);
    eval 'sub AV530_CMMU6_D3 () {0xfff09000;}' unless defined(&AV530_CMMU6_D3);
    eval 'sub AV530_CMMU6_I4 () {0xfff0c000;}' unless defined(&AV530_CMMU6_I4);
    eval 'sub AV530_CMMU6_I5 () {0xfff0d000;}' unless defined(&AV530_CMMU6_I5);
    eval 'sub AV530_CMMU6_I6 () {0xfff0e000;}' unless defined(&AV530_CMMU6_I6);
    eval 'sub AV530_CMMU6_I7 () {0xfff0f000;}' unless defined(&AV530_CMMU6_I7);
}
1;
