/*	$OpenBSD: eh.S,v 1.70 2013/05/17 22:51:59 miod Exp $	*/
/*
 * Copyright (c) 2006, Miodrag Vallat
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <machine/m8820x.h>

/*
 * Save Pbus fault status register from data and inst CMMU.
 *
 * Handlers are invoked with TMP, TMP2 and TMP3 available, and TMP contains
 * curcpu().
 */

#define	PFSR_SAVE \
	NOP;	/* will be changed to	br.n pfsr_handler + 4*/ \
	NOP	/* will be changed to	 first instruction of pfsr_handler */

#include <m88k/m88k/eh_common.S>

#if defined(MVME181) || defined(MVME187)
/*
 * Single-processor with 2 CMMU version (MVME181, MVME187, MVME8120)
 */

ENTRY(pfsr_save_single)
	ld	TMP2, TMP,  CI_PFSR_I0
	ld	TMP3, TMP2, %r0
	st	TMP3, %r31, EF_IPFSR
	ld	TMP2, TMP,  CI_PFSR_D0
	ld	TMP3, TMP2, %r0
	br.n	_ASM_LABEL(pfsr_done)
	 st	TMP3, %r31, EF_DPFSR
#endif

#ifdef MVME188
/*
 * MVME188 versions
 */

#include <machine/mvme188.h>

ENTRY(pfsr_save_188_quad)
	/*
	 * We're in configuration 2 (1 CPU, 8 CMMU).
	 *
	 * Reading the MVME188 error register could tell us which
	 * CMMU faulted, but it's easier to check every one until
	 * we find the first fault.
	 *
	 * If two or more CMMU faulted simultaneously, restarting from
	 * the trap will fault again, and we'll handle the remaining
	 * exceptions here.
	 *
	 * However, to be sure we don't get fooled with already-processed
	 * exceptions, we have to reset the fault status registers
	 * after reading them.
	 *
	 * XXX It will probably be worth changing this so that we can
	 * handle a bunch of CMMU faults at once in trap.c.
	 */
	or.u	TMP,  %r0,  %hi16(VME_CMMU_I0)
	ld	TMP2, TMP,  %lo16(VME_CMMU_I0) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 1f
	 st	%r0,  TMP,  %lo16(VME_CMMU_I0) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_I1)
	ld	TMP2, TMP,  %lo16(VME_CMMU_I1) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 1f
	 st	%r0,  TMP,  %lo16(VME_CMMU_I1) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_I2)
	ld	TMP2, TMP,  %lo16(VME_CMMU_I2) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 1f
	 st	%r0,  TMP,  %lo16(VME_CMMU_I2) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_I3)
	ld	TMP2, TMP,  %lo16(VME_CMMU_I3) + CMMU_PFSR * 4
	st	%r0,  TMP,  %lo16(VME_CMMU_I3) + CMMU_PFSR * 4
1:
	st	TMP2, %r31, EF_IPFSR
	
	or.u	TMP,  %r0,  %hi16(VME_CMMU_D0)
	ld	TMP2, TMP,  %lo16(VME_CMMU_D0) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 2f
	 st	%r0,  TMP,  %lo16(VME_CMMU_D0) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_D1)
	ld	TMP2, TMP,  %lo16(VME_CMMU_D1) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 2f
	 st	%r0,  TMP,  %lo16(VME_CMMU_D1) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_D2)
	ld	TMP2, TMP,  %lo16(VME_CMMU_D2) + CMMU_PFSR * 4
	extu	TMP3, TMP2, 3<16>
	bcnd.n	ne0,  TMP3, 2f
	 st	%r0,  TMP,  %lo16(VME_CMMU_D2) + CMMU_PFSR * 4
	or.u	TMP,  %r0,  %hi16(VME_CMMU_D3)
	ld	TMP2, TMP,  %lo16(VME_CMMU_D3) + CMMU_PFSR * 4
	st	%r0,  TMP,  %lo16(VME_CMMU_D3) + CMMU_PFSR * 4
2:
	br.n	_ASM_LABEL(pfsr_done)
	 st	TMP2, %r31, EF_DPFSR

ENTRY(pfsr_save_188_double)
	/*
	 * 4 CMMUs per CPU. Almost as simple as the 2 CMMUs per CPU
	 * situation...
	 *
	 * However, to be sure we don't get fooled with already-processed
	 * exceptions, we have to reset the fault status registers
	 * after reading them.
	 */
	ld	TMP2, TMP,  CI_PFSR_I0
	ld	TMP3, TMP2, %r0
	extu	TMP3, TMP3, 3<16>
	bcnd	ne0,  TMP3, 1f
	st	%r0,  TMP2, %r0
	ld	TMP2, TMP,  CI_PFSR_I1
1:
	ld	TMP3, TMP2, %r0
	st	%r0,  TMP2, %r0
	st	TMP3, %r31, EF_IPFSR

	ld	TMP2, TMP,  CI_PFSR_D0
	ld	TMP3, TMP2, %r0
	extu	TMP3, TMP3, 3<16>
	bcnd	ne0,  TMP3, 2f
	st	%r0,  TMP2, %r0
	ld	TMP2, TMP,  CI_PFSR_D1
2:
	ld	TMP3, TMP2, %r0
	st	%r0,  TMP2, %r0
	br.n	_ASM_LABEL(pfsr_done)
	 st	TMP3, %r31, EF_DPFSR

ENTRY(pfsr_save_188_straight)
	/*
	 * We have the simple 2 CMMUs per CPU mapping. Pick our couple;
	 * no need to reset fault status registers in this case.
	 * This is similar to the 187/8120 code.
	 */
	ld	TMP2, TMP,  CI_PFSR_I0
	ld	TMP3, TMP2, %r0
	st	TMP3, %r31, EF_IPFSR
	ld	TMP2, TMP,  CI_PFSR_D0
	ld	TMP3, TMP2, %r0
	br.n	_ASM_LABEL(pfsr_done)
	 st	TMP3, %r31,  EF_DPFSR

#endif	/* MVME188 */
