require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPARC64_CTLREG_)) {
    eval 'sub _SPARC64_CTLREG_ () {1;}' unless defined(&_SPARC64_CTLREG_);
    eval 'sub C_Lookaside () {(0);}' unless defined(&C_Lookaside);
    eval 'sub C_MemIssue () {(1);}' unless defined(&C_MemIssue);
    eval 'sub C_Sync () {(2);}' unless defined(&C_Sync);
    eval 'sub M_LoadLoad () {(0);}' unless defined(&M_LoadLoad);
    eval 'sub M_StoreLoad () {(1);}' unless defined(&M_StoreLoad);
    eval 'sub M_LoadStore () {(2);}' unless defined(&M_LoadStore);
    eval 'sub M_StoreStore () {(3);}' unless defined(&M_StoreStore);
    eval 'sub CMASK_SHIFT () {(4);}' unless defined(&CMASK_SHIFT);
    eval 'sub MMASK_SHIFT () {(0);}' unless defined(&MMASK_SHIFT);
    eval 'sub CMASK_GEN {
        my($bit) = @_;
	    eval q(((1<< ($bit)) <<  &CMASK_SHIFT));
    }' unless defined(&CMASK_GEN);
    eval 'sub MMASK_GEN {
        my($bit) = @_;
	    eval q(((1<< ($bit)) <<  &MMASK_SHIFT));
    }' unless defined(&MMASK_GEN);
    eval 'sub ASI_LITTLE () {0x8;}' unless defined(&ASI_LITTLE);
    eval 'sub ASI_NUCLEUS () {0x4;}' unless defined(&ASI_NUCLEUS);
    eval 'sub ASI_NUCLEUS_LITTLE () {0xc;}' unless defined(&ASI_NUCLEUS_LITTLE);
    eval 'sub ASI_AS_IF_USER_PRIMARY () {0x10;}' unless defined(&ASI_AS_IF_USER_PRIMARY);
    eval 'sub ASI_AS_IF_USER_SECONDARY () {0x11;}' unless defined(&ASI_AS_IF_USER_SECONDARY);
    eval 'sub ASI_PHYS_CACHED () {0x14;}' unless defined(&ASI_PHYS_CACHED);
    eval 'sub ASI_PHYS_NON_CACHED () {0x15;}' unless defined(&ASI_PHYS_NON_CACHED);
    eval 'sub ASI_AS_IF_USER_PRIMARY_LITTLE () {0x18;}' unless defined(&ASI_AS_IF_USER_PRIMARY_LITTLE);
    eval 'sub ASI_AS_IF_USER_SECONDARY_LITTIE () {0x19;}' unless defined(&ASI_AS_IF_USER_SECONDARY_LITTIE);
    eval 'sub ASI_PHYS_CACHED_LITTLE () {0x1c;}' unless defined(&ASI_PHYS_CACHED_LITTLE);
    eval 'sub ASI_PHYS_NON_CACHED_LITTLE () {0x1d;}' unless defined(&ASI_PHYS_NON_CACHED_LITTLE);
    eval 'sub ASI_SCRATCHPAD () {0x20;}' unless defined(&ASI_SCRATCHPAD);
    eval 'sub ASI_MMU_CONTEXTID () {0x21;}' unless defined(&ASI_MMU_CONTEXTID);
    eval 'sub ASI_NUCLEUS_QUAD_LDD () {0x24;}' unless defined(&ASI_NUCLEUS_QUAD_LDD);
    eval 'sub ASI_QUEUE () {0x25;}' unless defined(&ASI_QUEUE);
    eval 'sub ASI_NUCLEUS_QUAD_LDD_LITTLE () {0x2c;}' unless defined(&ASI_NUCLEUS_QUAD_LDD_LITTLE);
    eval 'sub ASI_FLUSH_D_PAGE_PRIMARY () {0x38;}' unless defined(&ASI_FLUSH_D_PAGE_PRIMARY);
    eval 'sub ASI_FLUSH_D_PAGE_SECONDARY () {0x39;}' unless defined(&ASI_FLUSH_D_PAGE_SECONDARY);
    eval 'sub ASI_FLUSH_D_CTX_PRIMARY () {0x3a;}' unless defined(&ASI_FLUSH_D_CTX_PRIMARY);
    eval 'sub ASI_FLUSH_D_CTX_SECONDARY () {0x3b;}' unless defined(&ASI_FLUSH_D_CTX_SECONDARY);
    eval 'sub ASI_DCACHE_INVALIDATE () {0x42;}' unless defined(&ASI_DCACHE_INVALIDATE);
    eval 'sub ASI_DCACHE_UTAG () {0x43;}' unless defined(&ASI_DCACHE_UTAG);
    eval 'sub ASI_DCACHE_SNOOP_TAG () {0x44;}' unless defined(&ASI_DCACHE_SNOOP_TAG);
    eval 'sub ASI_LSU_CONTROL_REGISTER () {0x45;}' unless defined(&ASI_LSU_CONTROL_REGISTER);
    eval 'sub ASI_DCACHE_DATA () {0x46;}' unless defined(&ASI_DCACHE_DATA);
    eval 'sub ASI_DCACHE_TAG () {0x47;}' unless defined(&ASI_DCACHE_TAG);
    eval 'sub ASI_INTR_DISPATCH_STATUS () {0x48;}' unless defined(&ASI_INTR_DISPATCH_STATUS);
    eval 'sub ASI_INTR_RECEIVE () {0x49;}' unless defined(&ASI_INTR_RECEIVE);
    eval 'sub ASI_MID_REG () {0x4a;}' unless defined(&ASI_MID_REG);
    eval 'sub ASI_ERROR_EN_REG () {0x4b;}' unless defined(&ASI_ERROR_EN_REG);
    eval 'sub ASI_AFSR () {0x4c;}' unless defined(&ASI_AFSR);
    eval 'sub ASI_AFAR () {0x4d;}' unless defined(&ASI_AFAR);
    eval 'sub ASI_SCRATCH () {0x4f;}' unless defined(&ASI_SCRATCH);
    eval 'sub ASI_ICACHE_DATA () {0x66;}' unless defined(&ASI_ICACHE_DATA);
    eval 'sub ASI_ICACHE_TAG () {0x67;}' unless defined(&ASI_ICACHE_TAG);
    eval 'sub ASI_FLUSH_I_PAGE_PRIMARY () {0x68;}' unless defined(&ASI_FLUSH_I_PAGE_PRIMARY);
    eval 'sub ASI_FLUSH_I_PAGE_SECONDARY () {0x69;}' unless defined(&ASI_FLUSH_I_PAGE_SECONDARY);
    eval 'sub ASI_FLUSH_I_CTX_PRIMARY () {0x6a;}' unless defined(&ASI_FLUSH_I_CTX_PRIMARY);
    eval 'sub ASI_FLUSH_I_CTX_SECONDARY () {0x6b;}' unless defined(&ASI_FLUSH_I_CTX_SECONDARY);
    eval 'sub ASI_BLOCK_AS_IF_USER_PRIMARY () {0x70;}' unless defined(&ASI_BLOCK_AS_IF_USER_PRIMARY);
    eval 'sub ASI_BLOCK_AS_IF_USER_SECONDARY () {0x71;}' unless defined(&ASI_BLOCK_AS_IF_USER_SECONDARY);
    eval 'sub ASI_ECACHE_DIAG () {0x76;}' unless defined(&ASI_ECACHE_DIAG);
    eval 'sub ASI_DATAPATH_ERR_REG_WRITE () {0x77;}' unless defined(&ASI_DATAPATH_ERR_REG_WRITE);
    eval 'sub ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE () {0x78;}' unless defined(&ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE);
    eval 'sub ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE () {0x79;}' unless defined(&ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE);
    eval 'sub ASI_INTERRUPT_RECEIVE_DATA () {0x7f;}' unless defined(&ASI_INTERRUPT_RECEIVE_DATA);
    eval 'sub ASI_DATAPATH_ERR_REG_READ () {0x7f;}' unless defined(&ASI_DATAPATH_ERR_REG_READ);
    eval 'sub ASI_PRIMARY () {0x80;}' unless defined(&ASI_PRIMARY);
    eval 'sub ASI_SECONDARY () {0x81;}' unless defined(&ASI_SECONDARY);
    eval 'sub ASI_PRIMARY_NOFAULT () {0x82;}' unless defined(&ASI_PRIMARY_NOFAULT);
    eval 'sub ASI_SECONDARY_NOFAULT () {0x83;}' unless defined(&ASI_SECONDARY_NOFAULT);
    eval 'sub ASI_PRIMARY_LITTLE () {0x88;}' unless defined(&ASI_PRIMARY_LITTLE);
    eval 'sub ASI_SECONDARY_LITTLE () {0x89;}' unless defined(&ASI_SECONDARY_LITTLE);
    eval 'sub ASI_PRIMARY_NOFAULT_LITTLE () {0x8a;}' unless defined(&ASI_PRIMARY_NOFAULT_LITTLE);
    eval 'sub ASI_SECONDARY_NOFAULT_LITTLE () {0x8b;}' unless defined(&ASI_SECONDARY_NOFAULT_LITTLE);
    eval 'sub ASI_PST8_PRIMARY () {0xc0;}' unless defined(&ASI_PST8_PRIMARY);
    eval 'sub ASI_PST8_SECONDARY () {0xc1;}' unless defined(&ASI_PST8_SECONDARY);
    eval 'sub ASI_PST16_PRIMARY () {0xc2;}' unless defined(&ASI_PST16_PRIMARY);
    eval 'sub ASI_PST16_SECONDARY () {0xc3;}' unless defined(&ASI_PST16_SECONDARY);
    eval 'sub ASI_PST32_PRIMARY () {0xc4;}' unless defined(&ASI_PST32_PRIMARY);
    eval 'sub ASI_PST32_SECONDARY () {0xc5;}' unless defined(&ASI_PST32_SECONDARY);
    eval 'sub ASI_PST8_PRIMARY_LITTLE () {0xc8;}' unless defined(&ASI_PST8_PRIMARY_LITTLE);
    eval 'sub ASI_PST8_SECONDARY_LITTLE () {0xc9;}' unless defined(&ASI_PST8_SECONDARY_LITTLE);
    eval 'sub ASI_PST16_PRIMARY_LITTLE () {0xca;}' unless defined(&ASI_PST16_PRIMARY_LITTLE);
    eval 'sub ASI_PST16_SECONDARY_LITTLE () {0xcb;}' unless defined(&ASI_PST16_SECONDARY_LITTLE);
    eval 'sub ASI_PST32_PRIMARY_LITTLE () {0xcc;}' unless defined(&ASI_PST32_PRIMARY_LITTLE);
    eval 'sub ASI_PST32_SECONDARY_LITTLE () {0xcd;}' unless defined(&ASI_PST32_SECONDARY_LITTLE);
    eval 'sub ASI_FL8_PRIMARY () {0xd0;}' unless defined(&ASI_FL8_PRIMARY);
    eval 'sub ASI_FL8_SECONDARY () {0xd1;}' unless defined(&ASI_FL8_SECONDARY);
    eval 'sub ASI_FL16_PRIMARY () {0xd2;}' unless defined(&ASI_FL16_PRIMARY);
    eval 'sub ASI_FL16_SECONDARY () {0xd3;}' unless defined(&ASI_FL16_SECONDARY);
    eval 'sub ASI_FL8_PRIMARY_LITTLE () {0xd8;}' unless defined(&ASI_FL8_PRIMARY_LITTLE);
    eval 'sub ASI_FL8_SECONDARY_LITTLE () {0xd9;}' unless defined(&ASI_FL8_SECONDARY_LITTLE);
    eval 'sub ASI_FL16_PRIMARY_LITTLE () {0xda;}' unless defined(&ASI_FL16_PRIMARY_LITTLE);
    eval 'sub ASI_FL16_SECONDARY_LITTLE () {0xdb;}' unless defined(&ASI_FL16_SECONDARY_LITTLE);
    eval 'sub ASI_BLOCK_COMMIT_PRIMARY () {0xe0;}' unless defined(&ASI_BLOCK_COMMIT_PRIMARY);
    eval 'sub ASI_BLOCK_COMMIT_SECONDARY () {0xe1;}' unless defined(&ASI_BLOCK_COMMIT_SECONDARY);
    eval 'sub ASI_BLOCK_PRIMARY () {0xf0;}' unless defined(&ASI_BLOCK_PRIMARY);
    eval 'sub ASI_BLOCK_SECONDARY () {0xf1;}' unless defined(&ASI_BLOCK_SECONDARY);
    eval 'sub ASI_BLOCK_PRIMARY_LITTLE () {0xf8;}' unless defined(&ASI_BLOCK_PRIMARY_LITTLE);
    eval 'sub ASI_BLOCK_SECONDARY_LITTLE () {0xf9;}' unless defined(&ASI_BLOCK_SECONDARY_LITTLE);
    eval 'sub ASI_N () { &ASI_NUCLEUS;}' unless defined(&ASI_N);
    eval 'sub ASI_NL () { &ASI_NUCLEUS_LITTLE;}' unless defined(&ASI_NL);
    eval 'sub ASI_AIUP () { &ASI_AS_IF_USER_PRIMARY;}' unless defined(&ASI_AIUP);
    eval 'sub ASI_AIUS () { &ASI_AS_IF_USER_SECONDARY;}' unless defined(&ASI_AIUS);
    eval 'sub ASI_AIUPL () { &ASI_AS_IF_USER_PRIMARY_LITTLE;}' unless defined(&ASI_AIUPL);
    eval 'sub ASI_AIUSL () { &ASI_AS_IF_USER_SECONDARY_LITTLE;}' unless defined(&ASI_AIUSL);
    eval 'sub ASI_P () { &ASI_PRIMARY;}' unless defined(&ASI_P);
    eval 'sub ASI_S () { &ASI_SECONDARY;}' unless defined(&ASI_S);
    eval 'sub ASI_PNF () { &ASI_PRIMARY_NOFAULT;}' unless defined(&ASI_PNF);
    eval 'sub ASI_SNF () { &ASI_SECONDARY_NOFAULT;}' unless defined(&ASI_SNF);
    eval 'sub ASI_PL () { &ASI_PRIMARY_LITTLE;}' unless defined(&ASI_PL);
    eval 'sub ASI_SL () { &ASI_SECONDARY_LITTLE;}' unless defined(&ASI_SL);
    eval 'sub ASI_PNFL () { &ASI_PRIMARY_NOFAULT_LITTLE;}' unless defined(&ASI_PNFL);
    eval 'sub ASI_SNFL () { &ASI_SECONDARY_NOFAULT_LITTLE;}' unless defined(&ASI_SNFL);
    eval 'sub ASI_FL8_P () { &ASI_FL8_PRIMARY;}' unless defined(&ASI_FL8_P);
    eval 'sub ASI_FL8_S () { &ASI_FL8_SECONDARY;}' unless defined(&ASI_FL8_S);
    eval 'sub ASI_FL16_P () { &ASI_FL16_PRIMARY;}' unless defined(&ASI_FL16_P);
    eval 'sub ASI_FL16_S () { &ASI_FL16_SECONDARY;}' unless defined(&ASI_FL16_S);
    eval 'sub ASI_FL8_PL () { &ASI_FL8_PRIMARY_LITTLE;}' unless defined(&ASI_FL8_PL);
    eval 'sub ASI_FL8_SL () { &ASI_FL8_SECONDARY_LITTLE;}' unless defined(&ASI_FL8_SL);
    eval 'sub ASI_FL16_PL () { &ASI_FL16_PRIMARY_LITTLE;}' unless defined(&ASI_FL16_PL);
    eval 'sub ASI_FL16_SL () { &ASI_FL16_SECONDARY_LITTLE;}' unless defined(&ASI_FL16_SL);
    eval 'sub ASI_BLK_AIUP () { &ASI_BLOCK_AS_IF_USER_PRIMARY;}' unless defined(&ASI_BLK_AIUP);
    eval 'sub ASI_BLK_AIUPL () { &ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE;}' unless defined(&ASI_BLK_AIUPL);
    eval 'sub ASI_BLK_AIUS () { &ASI_BLOCK_AS_IF_USER_SECONDARY;}' unless defined(&ASI_BLK_AIUS);
    eval 'sub ASI_BLK_AIUSL () { &ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE;}' unless defined(&ASI_BLK_AIUSL);
    eval 'sub ASI_BLK_COMMIT_P () { &ASI_BLOCK_COMMIT_PRIMARY;}' unless defined(&ASI_BLK_COMMIT_P);
    eval 'sub ASI_BLK_COMMIT_PRIMARY () { &ASI_BLOCK_COMMIT_PRIMARY;}' unless defined(&ASI_BLK_COMMIT_PRIMARY);
    eval 'sub ASI_BLK_COMMIT_S () { &ASI_BLOCK_COMMIT_SECONDARY;}' unless defined(&ASI_BLK_COMMIT_S);
    eval 'sub ASI_BLK_COMMIT_SECONDARY () { &ASI_BLOCK_COMMIT_SECONDARY;}' unless defined(&ASI_BLK_COMMIT_SECONDARY);
    eval 'sub ASI_BLK_P () { &ASI_BLOCK_PRIMARY;}' unless defined(&ASI_BLK_P);
    eval 'sub ASI_BLK_PL () { &ASI_BLOCK_PRIMARY_LITTLE;}' unless defined(&ASI_BLK_PL);
    eval 'sub ASI_BLK_S () { &ASI_BLOCK_SECONDARY;}' unless defined(&ASI_BLK_S);
    eval 'sub ASI_BLK_SL () { &ASI_BLOCK_SECONDARY_LITTLE;}' unless defined(&ASI_BLK_SL);
    eval 'sub ASI_PRIMARY_NO_FAULT () { &ASI_PRIMARY_NOFAULT;}' unless defined(&ASI_PRIMARY_NO_FAULT);
    eval 'sub ASI_PRIMARY_NO_FAULT_LITTLE () { &ASI_PRIMARY_NOFAULT_LITTLE;}' unless defined(&ASI_PRIMARY_NO_FAULT_LITTLE);
    eval 'sub ASI_SECONDARY_NO_FAULT () { &ASI_SECONDARY_NOFAULT;}' unless defined(&ASI_SECONDARY_NO_FAULT);
    eval 'sub ASI_SECONDARY_NO_FAULT_LITTLE () { &ASI_SECONDARY_NOFAULT_LITTLE;}' unless defined(&ASI_SECONDARY_NO_FAULT_LITTLE);
    eval 'sub PHYS_ASI {
        my($x) = @_;
	    eval q(((($x) | 0x9) == 0x1d));
    }' unless defined(&PHYS_ASI);
    eval 'sub LITTLE_ASI {
        my($x) = @_;
	    eval q((($x) &  &ASI_LITTLE));
    }' unless defined(&LITTLE_ASI);
    eval 'sub TICK_NPT () {0x8000000000000000;}' unless defined(&TICK_NPT);
    eval 'sub TICK_TICKS () {0x7fffffffffffffff;}' unless defined(&TICK_TICKS);
    eval 'sub UPA_CR_MID {
        my($x) = @_;
	    eval q(((($x) >> 17) & 0x1f));
    }' unless defined(&UPA_CR_MID);
    eval 'sub CPU_UPAID () { &UPA_CR_MID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_UPAID);
    eval 'sub FIREPLANE_CR_AID {
        my($x) = @_;
	    eval q(((($x) >> 17) & 0x3ff));
    }' unless defined(&FIREPLANE_CR_AID);
    eval 'sub CPU_FIREPLANEID () { &FIREPLANE_CR_AID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_FIREPLANEID);
    eval 'sub JUPITER_CR_ITID {
        my($x) = @_;
	    eval q((($x) & 0x3ff));
    }' unless defined(&JUPITER_CR_ITID);
    eval 'sub CPU_JUPITERID () { &JUPITER_CR_ITID( &ldxa(0,  &ASI_MID_REG));}' unless defined(&CPU_JUPITERID);
    eval 'sub ASI_MCCR () { &ASI_LSU_CONTROL_REGISTER;}' unless defined(&ASI_MCCR);
    eval 'sub MCCR () {0x;}' unless defined(&MCCR);
    eval 'sub MCCR_DMMU_EN () {0x8;}' unless defined(&MCCR_DMMU_EN);
    eval 'sub MCCR_IMMU_EN () {0x4;}' unless defined(&MCCR_IMMU_EN);
    eval 'sub MCCR_DCACHE_EN () {0x2;}' unless defined(&MCCR_DCACHE_EN);
    eval 'sub MCCR_ICACHE_EN () {0x1;}' unless defined(&MCCR_ICACHE_EN);
    eval 'sub ASI_DMMU () {0x58;}' unless defined(&ASI_DMMU);
    eval 'sub ASI_IMMU () {0x50;}' unless defined(&ASI_IMMU);
    eval 'sub ASI_IMMU_8KPTR () {0x51;}' unless defined(&ASI_IMMU_8KPTR);
    eval 'sub ASI_IMMU_64KPTR () {0x52;}' unless defined(&ASI_IMMU_64KPTR);
    eval 'sub ASI_IMMU_DATA_IN () {0x54;}' unless defined(&ASI_IMMU_DATA_IN);
    eval 'sub ASI_IMMU_TLB_DATA () {0x55;}' unless defined(&ASI_IMMU_TLB_DATA);
    eval 'sub ASI_IMMU_TLB_TAG () {0x56;}' unless defined(&ASI_IMMU_TLB_TAG);
    eval 'sub ASI_DMMU_8KPTR () {0x59;}' unless defined(&ASI_DMMU_8KPTR);
    eval 'sub ASI_DMMU_64KPTR () {0x5a;}' unless defined(&ASI_DMMU_64KPTR);
    eval 'sub ASI_DMMU_DATA_IN () {0x5c;}' unless defined(&ASI_DMMU_DATA_IN);
    eval 'sub ASI_DMMU_TLB_DATA () {0x5d;}' unless defined(&ASI_DMMU_TLB_DATA);
    eval 'sub ASI_DMMU_TLB_TAG () {0x5e;}' unless defined(&ASI_DMMU_TLB_TAG);
    eval 'sub TSB_TAG_TARGET () {0x;}' unless defined(&TSB_TAG_TARGET);
    eval 'sub TLB_DATA_IN () {0x;}' unless defined(&TLB_DATA_IN);
    eval 'sub CTX_PRIMARY () {0x8;}' unless defined(&CTX_PRIMARY);
    eval 'sub CTX_SECONDARY () {0x10;}' unless defined(&CTX_SECONDARY);
    eval 'sub SFSR () {0x18;}' unless defined(&SFSR);
    eval 'sub SFAR () {0x20;}' unless defined(&SFAR);
    eval 'sub TSB () {0x28;}' unless defined(&TSB);
    eval 'sub TLB_TAG_ACCESS () {0x30;}' unless defined(&TLB_TAG_ACCESS);
    eval 'sub VIRTUAL_WATCHPOINT () {0x38;}' unless defined(&VIRTUAL_WATCHPOINT);
    eval 'sub PHYSICAL_WATCHPOINT () {0x40;}' unless defined(&PHYSICAL_WATCHPOINT);
    eval 'sub TSB_PEXT () {0x48;}' unless defined(&TSB_PEXT);
    eval 'sub TSB_SEXT () {0x50;}' unless defined(&TSB_SEXT);
    eval 'sub TSB_NEXT () {0x58;}' unless defined(&TSB_NEXT);
    eval 'sub TAG_TARGET_VA_MASK () {0x3ffffffffffffffff;}' unless defined(&TAG_TARGET_VA_MASK);
    eval 'sub TAG_TARGET_VA {
        my($x) = @_;
	    eval q(((($x)<<22) &TAG_TARGET_VA_MASK));
    }' unless defined(&TAG_TARGET_VA);
    eval 'sub TAG_TARGET_CONTEXT {
        my($x) = @_;
	    eval q((($x)>>48));
    }' unless defined(&TAG_TARGET_CONTEXT);
    eval 'sub TAG_TARGET {
        my($c,$v) = @_;
	    eval q((((( &uint64_t)$c)<<48)|((( &uint64_t)$v) &TAG_TARGET_VA_MASK)));
    }' unless defined(&TAG_TARGET);
    eval 'sub SFSR_NF () {0x1000000;}' unless defined(&SFSR_NF);
    eval 'sub SFSR_ASI {
        my($x) = @_;
	    eval q((($x)>>16));
    }' unless defined(&SFSR_ASI);
    eval 'sub SFSR_TM () {0x8000;}' unless defined(&SFSR_TM);
    eval 'sub SFSR_FT_VA_OOR_2 () {0x2000;}' unless defined(&SFSR_FT_VA_OOR_2);
    eval 'sub SFSR_FT_VA_OOR_1 () {0x1000;}' unless defined(&SFSR_FT_VA_OOR_1);
    eval 'sub SFSR_FT_NFO () {0x800;}' unless defined(&SFSR_FT_NFO);
    eval 'sub SFSR_ILL_ASI () {0x400;}' unless defined(&SFSR_ILL_ASI);
    eval 'sub SFSR_FT_IO_ATOMIC () {0x200;}' unless defined(&SFSR_FT_IO_ATOMIC);
    eval 'sub SFSR_FT_ILL_NF () {0x100;}' unless defined(&SFSR_FT_ILL_NF);
    eval 'sub SFSR_FT_PRIV () {0x80;}' unless defined(&SFSR_FT_PRIV);
    eval 'sub SFSR_FT_E () {0x40;}' unless defined(&SFSR_FT_E);
    eval 'sub SFSR_CTXT {
        my($x) = @_;
	    eval q(((($x)>>4)&0x3));
    }' unless defined(&SFSR_CTXT);
    eval 'sub SFSR_CTXT_IS_PRIM {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x));
    }' unless defined(&SFSR_CTXT_IS_PRIM);
    eval 'sub SFSR_CTXT_IS_SECOND {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x1));
    }' unless defined(&SFSR_CTXT_IS_SECOND);
    eval 'sub SFSR_CTXT_IS_NUCLEUS {
        my($x) = @_;
	    eval q(( &SFSR_CTXT($x)==0x2));
    }' unless defined(&SFSR_CTXT_IS_NUCLEUS);
    eval 'sub SFSR_PRIV () {0x8;}' unless defined(&SFSR_PRIV);
    eval 'sub SFSR_W () {0x4;}' unless defined(&SFSR_W);
    eval 'sub SFSR_OW () {0x2;}' unless defined(&SFSR_OW);
    eval 'sub SFSR_FV () {0x1;}' unless defined(&SFSR_FV);
    eval 'sub SFSR_FT () {( &SFSR_FT_VA_OOR_2| &SFSR_FT_VA_OOR_1| &SFSR_FT_NFO| &SFSR_ILL_ASI| &SFSR_FT_IO_ATOMIC| &SFSR_FT_ILL_NF| &SFSR_FT_PRIV);}' unless defined(&SFSR_FT);
    eval 'sub SFSR_BITS () {"\\20\\31NF\\20TM\\16VAT\\15VAD\\14NFO\\13ASI\\12A\\11NF\\10PRIV\\7E\\6NUCLEUS\\5SECONDCTX\\4PRIV\\3W\\2OW\\1FV";}' unless defined(&SFSR_BITS);
    eval 'sub ASFR_ME () {0x100000000;}' unless defined(&ASFR_ME);
    eval 'sub ASFR_PRIV () {0x80000000;}' unless defined(&ASFR_PRIV);
    eval 'sub ASFR_ISAP () {0x40000000;}' unless defined(&ASFR_ISAP);
    eval 'sub ASFR_ETP () {0x20000000;}' unless defined(&ASFR_ETP);
    eval 'sub ASFR_IVUE () {0x10000000;}' unless defined(&ASFR_IVUE);
    eval 'sub ASFR_TO () {0x8000000;}' unless defined(&ASFR_TO);
    eval 'sub ASFR_BERR () {0x4000000;}' unless defined(&ASFR_BERR);
    eval 'sub ASFR_LDP () {0x2000000;}' unless defined(&ASFR_LDP);
    eval 'sub ASFR_CP () {0x1000000;}' unless defined(&ASFR_CP);
    eval 'sub ASFR_WP () {0x800000;}' unless defined(&ASFR_WP);
    eval 'sub ASFR_EDP () {0x400000;}' unless defined(&ASFR_EDP);
    eval 'sub ASFR_UE () {0x200000;}' unless defined(&ASFR_UE);
    eval 'sub ASFR_CE () {0x100000;}' unless defined(&ASFR_CE);
    eval 'sub ASFR_ETS () {0xf0000;}' unless defined(&ASFR_ETS);
    eval 'sub ASFT_P_SYND () {0xffff;}' unless defined(&ASFT_P_SYND);
    eval 'sub AFSR_BITS () {"\\20" "\\20ME\\37PRIV\\36ISAP\\35ETP\\34IVUE\\33TO\\32BERR\\31LDP\\30CP\\27WP\\26EDP" "\\25UE\\24CE";}' unless defined(&AFSR_BITS);
    eval 'sub TSB_SIZE_512 () {0x;}' unless defined(&TSB_SIZE_512);
    eval 'sub TSB_SIZE_1K () {0x1;}' unless defined(&TSB_SIZE_1K);
    eval 'sub TSB_SIZE_2K () {0x2;}' unless defined(&TSB_SIZE_2K);
    eval 'sub TSB_SIZE_4K () {0x3;}' unless defined(&TSB_SIZE_4K);
    eval 'sub TSB_SIZE_8K () {0x4;}' unless defined(&TSB_SIZE_8K);
    eval 'sub TSB_SIZE_16K () {0x5;}' unless defined(&TSB_SIZE_16K);
    eval 'sub TSB_SIZE_32K () {0x6;}' unless defined(&TSB_SIZE_32K);
    eval 'sub TSB_SIZE_64K () {0x7;}' unless defined(&TSB_SIZE_64K);
    eval 'sub TSB_SPLIT () {0x1000;}' unless defined(&TSB_SPLIT);
    eval 'sub TSB_BASE () {0xffffffffffffe000;}' unless defined(&TSB_BASE);
    eval 'sub TLB_TAG_ACCESS_VA () {0xffffffffffffe000;}' unless defined(&TLB_TAG_ACCESS_VA);
    eval 'sub TLB_TAG_ACCESS_CTX () {0x1fff;}' unless defined(&TLB_TAG_ACCESS_CTX);
    eval 'sub ASI_IMMU_DEMAP () {0x57;}' unless defined(&ASI_IMMU_DEMAP);
    eval 'sub ASI_DMMU_DEMAP () {0x5f;}' unless defined(&ASI_DMMU_DEMAP);
    eval 'sub DEMAP_PAGE_NUCLEUS () {((0x2)<<4);}' unless defined(&DEMAP_PAGE_NUCLEUS);
    eval 'sub DEMAP_PAGE_PRIMARY () {((0x)<<4);}' unless defined(&DEMAP_PAGE_PRIMARY);
    eval 'sub DEMAP_PAGE_SECONDARY () {((0x1)<<4);}' unless defined(&DEMAP_PAGE_SECONDARY);
    eval 'sub DEMAP_CTX_NUCLEUS () {((0x6)<<4);}' unless defined(&DEMAP_CTX_NUCLEUS);
    eval 'sub DEMAP_CTX_PRIMARY () {((0x4)<<4);}' unless defined(&DEMAP_CTX_PRIMARY);
    eval 'sub DEMAP_CTX_SECONDARY () {((0x5)<<4);}' unless defined(&DEMAP_CTX_SECONDARY);
    eval 'sub ASI_IRSR () {0x49;}' unless defined(&ASI_IRSR);
    eval 'sub IRSR () {0x;}' unless defined(&IRSR);
    eval 'sub IRSR_BUSY () {0x20;}' unless defined(&IRSR_BUSY);
    eval 'sub IRSR_MID {
        my($x) = @_;
	    eval q(($x&0x1f));
    }' unless defined(&IRSR_MID);
    eval 'sub ASI_IRDR () {0x7f;}' unless defined(&ASI_IRDR);
    eval 'sub IRDR_0H () {0x40;}' unless defined(&IRDR_0H);
    eval 'sub IRDR_0L () {0x48;}' unless defined(&IRDR_0L);
    eval 'sub IRDR_1H () {0x50;}' unless defined(&IRDR_1H);
    eval 'sub IRDR_1L () {0x58;}' unless defined(&IRDR_1L);
    eval 'sub IRDR_2H () {0x60;}' unless defined(&IRDR_2H);
    eval 'sub IRDR_2L () {0x68;}' unless defined(&IRDR_2L);
    eval 'sub IRDR_3H () {0x70;}' unless defined(&IRDR_3H);
    eval 'sub IRDR_3L () {0x78;}' unless defined(&IRDR_3L);
    eval 'sub SET_SOFTINT () {% &asr20;}' unless defined(&SET_SOFTINT);
    eval 'sub CLEAR_SOFTINT () {% &asr21;}' unless defined(&CLEAR_SOFTINT);
    eval 'sub SOFTINT () {% &asr22;}' unless defined(&SOFTINT);
    eval 'sub TICK_CMPR () {% &asr23;}' unless defined(&TICK_CMPR);
    eval 'sub TICK_INT () {0x1;}' unless defined(&TICK_INT);
    eval 'sub SOFTINT1 () {(0x1<<1);}' unless defined(&SOFTINT1);
    eval 'sub SOFTINT2 () {(0x1<<2);}' unless defined(&SOFTINT2);
    eval 'sub SOFTINT3 () {(0x1<<3);}' unless defined(&SOFTINT3);
    eval 'sub SOFTINT4 () {(0x1<<4);}' unless defined(&SOFTINT4);
    eval 'sub SOFTINT5 () {(0x1<<5);}' unless defined(&SOFTINT5);
    eval 'sub SOFTINT6 () {(0x1<<6);}' unless defined(&SOFTINT6);
    eval 'sub SOFTINT7 () {(0x1<<7);}' unless defined(&SOFTINT7);
    eval 'sub SOFTINT8 () {(0x1<<8);}' unless defined(&SOFTINT8);
    eval 'sub SOFTINT9 () {(0x1<<9);}' unless defined(&SOFTINT9);
    eval 'sub SOFTINT10 () {(0x1<<10);}' unless defined(&SOFTINT10);
    eval 'sub SOFTINT11 () {(0x1<<11);}' unless defined(&SOFTINT11);
    eval 'sub SOFTINT12 () {(0x1<<12);}' unless defined(&SOFTINT12);
    eval 'sub SOFTINT13 () {(0x1<<13);}' unless defined(&SOFTINT13);
    eval 'sub SOFTINT14 () {(0x1<<14);}' unless defined(&SOFTINT14);
    eval 'sub SOFTINT15 () {(0x1<<15);}' unless defined(&SOFTINT15);
    eval 'sub STICK_INT () {(0x1<<16);}' unless defined(&STICK_INT);
    eval 'sub ASR_IDSR () {0x48;}' unless defined(&ASR_IDSR);
    eval 'sub IDSR () {0x;}' unless defined(&IDSR);
    eval 'sub IDSR_NACK () {0x2;}' unless defined(&IDSR_NACK);
    eval 'sub IDSR_BUSY () {0x1;}' unless defined(&IDSR_BUSY);
    eval 'sub ASI_INTERRUPT_DISPATCH () {0x77;}' unless defined(&ASI_INTERRUPT_DISPATCH);
    eval 'sub IDCR {
        my($x) = @_;
	    eval q((((( &u_int64_t)($x)) << 14) | 0x70));
    }' unless defined(&IDCR);
    eval 'sub IDDR_0H () {0x40;}' unless defined(&IDDR_0H);
    eval 'sub IDDR_0L () {0x48;}' unless defined(&IDDR_0L);
    eval 'sub IDDR_1H () {0x50;}' unless defined(&IDDR_1H);
    eval 'sub IDDR_1L () {0x58;}' unless defined(&IDDR_1L);
    eval 'sub IDDR_2H () {0x60;}' unless defined(&IDDR_2H);
    eval 'sub IDDR_2L () {0x68;}' unless defined(&IDDR_2L);
    eval 'sub IDDR_3H () {0x80;}' unless defined(&IDDR_3H);
    eval 'sub IDDR_3L () {0x88;}' unless defined(&IDDR_3L);
    eval 'sub ASI_AFAR () {0x4d;}' unless defined(&ASI_AFAR);
    eval 'sub AFAR () {0x;}' unless defined(&AFAR);
    eval 'sub ASI_AFSR () {0x4c;}' unless defined(&ASI_AFSR);
    eval 'sub AFSR () {0x;}' unless defined(&AFSR);
    eval 'sub ASI_P_EER () {0x4b;}' unless defined(&ASI_P_EER);
    eval 'sub P_EER () {0x;}' unless defined(&P_EER);
    eval 'sub P_EER_ISAPEN () {0x4;}' unless defined(&P_EER_ISAPEN);
    eval 'sub P_EER_NCEEN () {0x2;}' unless defined(&P_EER_NCEEN);
    eval 'sub P_EER_CEEN () {0x1;}' unless defined(&P_EER_CEEN);
    eval 'sub ASI_DATAPATH_READ () {0x7f;}' unless defined(&ASI_DATAPATH_READ);
    eval 'sub ASI_DATAPATH_WRITE () {0x77;}' unless defined(&ASI_DATAPATH_WRITE);
    eval 'sub P_DPER_0 () {0x;}' unless defined(&P_DPER_0);
    eval 'sub P_DPER_1 () {0x18;}' unless defined(&P_DPER_1);
    eval 'sub P_DCR_0 () {0x20;}' unless defined(&P_DCR_0);
    eval 'sub P_DCR_1 () {0x38;}' unless defined(&P_DCR_1);
    unless(defined(&_LOCORE)) {
	eval 'sub sparc_membar {
	    my($mask) = @_;
    	    eval q( &do {  &if ($mask)  &__asm  &__volatile(\\"membar %0\\" : : \\"n\\" ($mask) : \\"memory\\");  &else  &__asm  &__volatile(\\"\\" : : : \\"memory\\"); }  &while(0));
	}' unless defined(&sparc_membar);
	eval 'sub membar () { &sparc_membar;}' unless defined(&membar);
	eval 'sub Lookaside () { &CMASK_GEN( &C_Lookaside);}' unless defined(&Lookaside);
	eval 'sub MemIssue () { &CMASK_GEN( &C_MemIssue);}' unless defined(&MemIssue);
	eval 'sub Sync () { &CMASK_GEN( &C_Sync);}' unless defined(&Sync);
	eval 'sub LoadLoad () { &MMASK_GEN( &M_LoadLoad);}' unless defined(&LoadLoad);
	eval 'sub StoreLoad () { &MMASK_GEN( &M_StoreLoad);}' unless defined(&StoreLoad);
	eval 'sub LoadStore () { &MMASK_GEN( &M_LoadStore);}' unless defined(&LoadStore);
	eval 'sub StoreStore () { &MMASK_GEN( &M_StoreStore);}' unless defined(&StoreStore);
	eval 'sub sparc_wr {
	    my($name, $val, $xor) = @_;
    	    eval q( &do {  &if ( &__builtin_constant_p($xor))  &__asm  &__volatile(\\"wr %%g0, %0, %%\\" $name : : \\"rI\\" (($val) ^ ($xor)) : \\"%g0\\");  &else  &__asm  &__volatile(\\"wr %0, %1, %%\\" $name : : \\"r\\" ($val), \\"rI\\" ($xor) : \\"%g0\\"); }  &while(0));
	}' unless defined(&sparc_wr);
	eval 'sub sparc_wrpr {
	    my($name, $val, $xor) = @_;
    	    eval q( &do {  &if ( &__builtin_constant_p($xor))  &__asm  &__volatile(\\"wrpr %%g0, %0, %%\\" $name : : \\"rI\\" (($val) ^ ($xor)) : \\"%g0\\");  &else  &__asm  &__volatile(\\"wrpr %0, %1, %%\\" $name : : \\"r\\" ($val), \\"rI\\" ($xor) : \\"%g0\\");  &__asm  &__volatile(\\"\\" : : : \\"memory\\"); }  &while(0));
	}' unless defined(&sparc_wrpr);
	eval 'sub sparc_rd {
	    my($name) = @_;
    	    eval q( &sparc_rd_  $name());
	}' unless defined(&sparc_rd);
	eval 'sub GEN_RD {
	    my($name) = @_;
    	    eval q( &extern  &__inline  &u_int64_t  &sparc_rd_  $name( &void);  &extern  &__inline  &u_int64_t  &sparc_rd_  $name() {  &u_int64_t  &r;  &__asm  &__volatile(\\"rd %%\\" $name \\", %0\\" : \\"=r\\" ( &r) : : \\"%g0\\");  &return ( &r); });
	}' unless defined(&GEN_RD);
	eval 'sub sparc_rdpr {
	    my($name) = @_;
    	    eval q( &sparc_rdpr_  $name());
	}' unless defined(&sparc_rdpr);
	eval 'sub GEN_RDPR {
	    my($name) = @_;
    	    eval q( &extern  &__inline  &u_int64_t  &sparc_rdpr_  $name( &void);  &extern  &__inline  &u_int64_t  &sparc_rdpr_  $name() {  &u_int64_t  &r;  &__asm  &__volatile(\\"rdpr %%\\" $name \\", %0\\" : \\"=r\\" ( &r) : : \\"%g0\\");  &return ( &r); });
	}' unless defined(&GEN_RDPR);
	eval 'sub LDNC_GEN {
	    my($tp, $o) = @_;
    	    eval q( &extern  &__inline $tp $o   &_asi( &paddr_t);  &extern  &__inline $tp $o   &_asi( &paddr_t  &va) { $tp  &r;  &__asm  &__volatile( $o \\" [%1] %%asi, %0\\" : \\"=r\\" ( &r) : \\"r\\" (( &volatile $tp *) &va) : \\"%g0\\");  &return ( &r); }  &extern  &__inline $tp $o   &_nc( &paddr_t, \'int\');  &extern  &__inline $tp $o   &_nc( &paddr_t  &va, \'int\'  &asi) {  &sparc_wr( &asi,  &asi, 0);  &return ($o   &_asi( &va)); });
	}' unless defined(&LDNC_GEN);
	eval 'sub LDC_GEN {
	    my($va, $asi, $op, $opa, $type) = @_;
    	    eval q(({ $type  &__r  $op  $type;  &if($asi ==  &ASI_PRIMARY || ($sizeof{$type} == 1 && $asi ==  &ASI_PRIMARY_LITTLE))  &__r  $op  $type = *(( &volatile $type *)$va);  &else  &__asm  &__volatile($opa \\" [%1] \\" $asi \\", %0\\" : \\"=r\\" ( &__r  $op  $type) : \\"r\\" (( &volatile $type *)$va) : \\"%g0\\");  &__r  $op  $type; }));
	}' unless defined(&LDC_GEN);
	if(defined(&__OPTIMIZE__)) {
	    eval 'sub LD_GENERIC {
	        my($va, $asi, $op, $type) = @_;
    		eval q(( &__builtin_constant_p($asi) ?  &LDC_GEN(($va), $asi, $op, $op   &a, $type) : $op   &a_nc(($va), $asi)));
	    }' unless defined(&LD_GENERIC);
	} else {
	    eval 'sub LD_GENERIC {
	        my($va, $asi, $op, $type) = @_;
    		eval q(($op   &a_nc(($va), $asi)));
	    }' unless defined(&LD_GENERIC);
	}
	eval 'sub lduba {
	    my($va, $asi) = @_;
    	    eval q( &LD_GENERIC($va, $asi,  &ldub,  &u_int8_t));
	}' unless defined(&lduba);
	eval 'sub lduha {
	    my($va, $asi) = @_;
    	    eval q( &LD_GENERIC($va, $asi,  &lduh,  &u_int16_t));
	}' unless defined(&lduha);
	eval 'sub lduwa {
	    my($va, $asi) = @_;
    	    eval q( &LD_GENERIC($va, $asi,  &lduw,  &u_int32_t));
	}' unless defined(&lduwa);
	eval 'sub ldxa {
	    my($va, $asi) = @_;
    	    eval q( &LD_GENERIC($va, $asi,  &ldx,  &u_int64_t));
	}' unless defined(&ldxa);
	eval 'sub STNC_GEN {
	    my($tp, $o) = @_;
    	    eval q( &extern  &__inline  &void $o   &_asi( &paddr_t, $tp);  &extern  &__inline  &void $o   &_asi( &paddr_t  &va, $tp  &val) {  &__asm  &__volatile( $o \\" %0, [%1] %%asi\\" : : \\"r\\" ( &val), \\"r\\" (( &volatile $tp *) &va) : \\"memory\\"); }  &extern  &__inline  &void $o   &_nc( &paddr_t, \'int\', $tp);  &extern  &__inline  &void $o   &_nc( &paddr_t  &va, \'int\'  &asi, $tp  &val) {  &sparc_wr( &asi,  &asi, 0); $o   &_asi( &va,  &val); });
	}' unless defined(&STNC_GEN);
	eval 'sub STC_GEN {
	    my($va, $asi, $val, $op, $opa, $type) = @_;
    	    eval q(({  &if($asi ==  &ASI_PRIMARY || ($sizeof{$type} == 1 && $asi ==  &ASI_PRIMARY_LITTLE)) *(( &volatile $type *)$va) = $val;  &else  &__asm  &__volatile($opa \\" %0, [%1] \\" $asi : : \\"r\\" ($val), \\"r\\" (( &volatile $type *)$va) : \\"memory\\"); }));
	}' unless defined(&STC_GEN);
	if(defined(&__OPTIMIZE__)) {
	    eval 'sub ST_GENERIC {
	        my($va, $asi, $val, $op, $type) = @_;
    		eval q(( &__builtin_constant_p($asi) ?  &STC_GEN(($va), ($asi), ($val), $op, $op   &a, $type) : $op   &a_nc(($va), $asi, ($val))));
	    }' unless defined(&ST_GENERIC);
	} else {
	    eval 'sub ST_GENERIC {
	        my($va, $asi, $val, $op, $type) = @_;
    		eval q(($op   &a_nc(($va), $asi, ($val))));
	    }' unless defined(&ST_GENERIC);
	}
	eval 'sub stba {
	    my($va, $asi, $val) = @_;
    	    eval q( &ST_GENERIC($va, $asi, $val,  &stb,  &u_int8_t));
	}' unless defined(&stba);
	eval 'sub stha {
	    my($va, $asi, $val) = @_;
    	    eval q( &ST_GENERIC($va, $asi, $val,  &sth,  &u_int16_t));
	}' unless defined(&stha);
	eval 'sub stwa {
	    my($va, $asi, $val) = @_;
    	    eval q( &ST_GENERIC($va, $asi, $val,  &stw,  &u_int32_t));
	}' unless defined(&stwa);
	eval 'sub stxa {
	    my($va, $asi, $val) = @_;
    	    eval q( &ST_GENERIC($va, $asi, $val,  &stx,  &u_int64_t));
	}' unless defined(&stxa);
	eval 'sub tick () {
	    eval q(( &sparc_rdpr( &tick) &  &TICK_TICKS));
	}' unless defined(&tick);
	eval 'sub sys_tick () {
	    eval q(( &sparc_rd( &sys_tick) &  &TICK_TICKS));
	}' unless defined(&sys_tick);
    }
}
1;
