require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__DEV_ACPI_DSDT_H__)) {
    eval 'sub __DEV_ACPI_DSDT_H__ () {1;}' unless defined(&__DEV_ACPI_DSDT_H__);
    eval 'sub SRT_IRQ2 () {0x22;}' unless defined(&SRT_IRQ2);
    eval 'sub SRT_IRQ3 () {0x23;}' unless defined(&SRT_IRQ3);
    eval 'sub SRT_DMA () {0x2a;}' unless defined(&SRT_DMA);
    eval 'sub SRT_STARTDEP0 () {0x30;}' unless defined(&SRT_STARTDEP0);
    eval 'sub SRT_STARTDEP1 () {0x31;}' unless defined(&SRT_STARTDEP1);
    eval 'sub SRT_ENDDEP () {0x38;}' unless defined(&SRT_ENDDEP);
    eval 'sub SRT_IOPORT () {0x47;}' unless defined(&SRT_IOPORT);
    eval 'sub SRT_FIXEDPORT () {0x4b;}' unless defined(&SRT_FIXEDPORT);
    eval 'sub SRT_ENDTAG () {0x78;}' unless defined(&SRT_ENDTAG);
    eval 'sub SR_IRQ () {0x4;}' unless defined(&SR_IRQ);
    eval 'sub SR_DMA () {0x5;}' unless defined(&SR_DMA);
    eval 'sub SR_STARTDEP () {0x6;}' unless defined(&SR_STARTDEP);
    eval 'sub SR_ENDDEP () {0x7;}' unless defined(&SR_ENDDEP);
    eval 'sub SR_IOPORT () {0x8;}' unless defined(&SR_IOPORT);
    eval 'sub SR_FIXEDPORT () {0x9;}' unless defined(&SR_FIXEDPORT);
    eval 'sub SR_ENDTAG () {0xf;}' unless defined(&SR_ENDTAG);
    eval 'sub LR_24BIT () {0x81;}' unless defined(&LR_24BIT);
    eval 'sub LR_GENREGISTER () {0x82;}' unless defined(&LR_GENREGISTER);
    eval 'sub LR_32BIT () {0x85;}' unless defined(&LR_32BIT);
    eval 'sub LR_32BITFIXED () {0x86;}' unless defined(&LR_32BITFIXED);
    eval 'sub LR_DWORD () {0x87;}' unless defined(&LR_DWORD);
    eval 'sub LR_WORD () {0x88;}' unless defined(&LR_WORD);
    eval 'sub LR_EXTIRQ () {0x89;}' unless defined(&LR_EXTIRQ);
    eval 'sub LR_QWORD () {0x8a;}' unless defined(&LR_QWORD);
    eval 'sub __amlflagbit {
        my($v,$s,$l) = @_;
	    eval q();
    }' unless defined(&__amlflagbit);
    eval 'sub SR_IRQ_SHR () {(1 << 4);}' unless defined(&SR_IRQ_SHR);
    eval 'sub SR_IRQ_POLARITY () {(1 << 3);}' unless defined(&SR_IRQ_POLARITY);
    eval 'sub SR_IRQ_MODE () {(1 << 0);}' unless defined(&SR_IRQ_MODE);
    eval 'sub SR_DMA_TYP_MASK () {0x3;}' unless defined(&SR_DMA_TYP_MASK);
    eval 'sub SR_DMA_TYP_SHIFT () {5;}' unless defined(&SR_DMA_TYP_SHIFT);
    eval 'sub SR_DMA_BM () {(1 << 2);}' unless defined(&SR_DMA_BM);
    eval 'sub SR_DMA_SIZE_MASK () {0x3;}' unless defined(&SR_DMA_SIZE_MASK);
    eval 'sub SR_DMA_SIZE_SHIFT () {0;}' unless defined(&SR_DMA_SIZE_SHIFT);
    eval 'sub SR_IOPORT_DEC () {(1 << 0);}' unless defined(&SR_IOPORT_DEC);
    eval 'sub AML_CRSTYPE {
        my($x) = @_;
	    eval q((($x)-> ($hdr->{typecode}) & 0x80 ? ($x)-> ($hdr->{typecode}) : ($x)-> ($hdr->{typecode}) >> 3));
    }' unless defined(&AML_CRSTYPE);
    eval 'sub AML_CRSLEN {
        my($x) = @_;
	    eval q((($x)-> ($hdr->{typecode}) & 0x80 ? 3+($x)-> ($hdr->{length}) : 1+(($x)-> ($hdr->{typecode}) & 0x7)));
    }' unless defined(&AML_CRSLEN);
    eval 'sub ACPI_E_NOERROR () {0x;}' unless defined(&ACPI_E_NOERROR);
    eval 'sub ACPI_E_BADVALUE () {0x1;}' unless defined(&ACPI_E_BADVALUE);
    eval 'sub AML_MAX_ARG () {7;}' unless defined(&AML_MAX_ARG);
    eval 'sub AML_MAX_LOCAL () {8;}' unless defined(&AML_MAX_LOCAL);
    eval 'sub AML_WALK_PRE () {0x;}' unless defined(&AML_WALK_PRE);
    eval 'sub AML_WALK_POST () {0x1;}' unless defined(&AML_WALK_POST);
    eval 'sub aml_get8 {
        my($p) = @_;
	    eval q(*( &uint8_t *)($p));
    }' unless defined(&aml_get8);
    eval 'sub aml_get16 {
        my($p) = @_;
	    eval q(*( &uint16_t *)($p));
    }' unless defined(&aml_get16);
    eval 'sub aml_get32 {
        my($p) = @_;
	    eval q(*( &uint32_t *)($p));
    }' unless defined(&aml_get32);
    eval 'sub aml_get64 {
        my($p) = @_;
	    eval q(*( &uint64_t *)($p));
    }' unless defined(&aml_get64);
    unless(defined(&SMALL_KERNEL)) {
    }
}
1;
