#!/bin/sh
# Script to install rrdtool inside apache chroot

RRD_CMD=${RRD_CMD:-/usr/local/bin/rrdtool}
PREFIX=${PREFIX:-/var/www}

if [ ! -x ${RRD_CMD} ]; then
    echo cannot find rrdtool - exiting
    exit 0
fi

FORMAT=`file ${RRD_CMD} 2>/dev/null`
if [ "${FORMAT}x" = x ]; then
    echo cannot determine executable format for rrdtool - exiting
    exit 0
fi

ELF=`echo ${FORMAT} | grep ELF`
if [ "${ELF}x" = x ]; then
    LIBS=`ldd "${RRD_CMD}" | sed -e '1d' -e '$d' -e 's/^.* \([^ ]*\)$/\1/g'`
else
    LIBS=`ldd "${RRD_CMD}" | sed -e '1,3d' -e '$d' -e 's/^.* \([^ ]*\)$/\1/g'`
fi

if [ "${LIBS}x" = x ]; then
    echo cannot determine library dependencies for ${RRD_CMD} - exiting
    exit 0
fi

cd ${PREFIX}
mkdir -p bin usr/lib usr/libexec usr/local/share/rrdtool/fonts
cp -f $LIBS usr/lib
cp -f ${RRD_CMD} bin
cp -f /usr/libexec/ld.so usr/libexec
cp -f /bin/sh bin/sh
cp -f /usr/local/share/rrdtool/fonts/DejaVuSansMono-Roman.ttf usr/local/share/rrdtool/fonts
echo rrdtool, fonts and libs installed in apache root
exit 1
