/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SyntaxHighlighter {
    static String[] reserved = new String[]{"!", "!=", "$", "$0", "$1", "$10", "$11", "$12", "$13", "$14", "$15", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$args", "$error-event", "$idx", "$it", "$main-args", "$x", "%", "&", "*", "+", "-", "/", "<", "<<", "<=", "=", ">", ">=", ">>", "?", "@", "MAIN", "NaN?", "^", "abort", "abs", "acos", "acosh", "add", "address", "amb", "and", "append", "append-file", "apply", "args", "array", "array-list", "array?", "asin", "asinh", "assoc", "atan", "atan2", "atanh", "atom?", "base64-dec", "base64-enc", "bayes-query", "bayes-train", "begin", "beta", "betai", "bind", "binomial", "bits", "callback", "case", "catch", "ceil", "change-dir", "char", "chop", "clean", "close", "command-event", "command-line", "cond", "cons", "constant", "context", "context?", "copy", "copy-file", "corr", "cos", "cosh", "count", "cpymem", "crc32", "crit-chi2", "crit-f", "crit-t", "crit-z", "current-line", "curry", "date", "date-parse", "date-list", "date-value", "debug", "dec", "def-new", "default", "define", "define-macro", "delete", "delete-file", "delete-url", "destroy", "det", "device", "difference", "directory", "directory?", "div", "do-until", "do-while", "doargs", "dolist", "dostring", "dotimes", "dotree", "dump", "dup", "empty?", "encrypt", "ends-with", "env", "erf", "error-event", "estack", "eval", "eval-string", "even?", "exec", "exists", "exit", "exp", "expand", "explode", "extend", "factor", "fft", "file-info", "file?", "filter", "find", "find-all", "first", "flat", "float", "float?", "floor", "flt", "for", "for-all", "fork", "format", "fv", "gammai", "gammaln", "gcd", "get-char", "get-float", "get-int", "get-long", "get-string", "get-url", "global", "global?", "if", "if-not", "ifft", "import", "inc", "index", "inf?", "int", "integer", "integer?", "intersect", "invert", "irr", "join", "json-error", "json-parse", "lambda?", "last", "last-error", "legal?", "length", "let", "letex", "letn", "list", "list?", "load", "local", "log", "lookup", "lower-case", "macro?", "main-args", "make-dir", "map", "mat", "match", "max", "member", "min", "mod", "mul", "multiply", "net-accept", "net-close", "net-connect", "net-error", "net-eval", "net-interface", "net-listen", "net-local", "net-lookup", "net-packet", "net-ipv", "net-peek", "net-peer", "net-ping", "net-receive", "net-receive-from", "net-receive-udp", "net-select", "net-send", "net-send-to", "net-send-udp", "net-service", "net-sessions", "new", "nil", "nil?", "normal", "not", "now", "nper", "npv", "nth", "null?", "number?", "odd?", "open", "or", "ostype", "pack", "parse", "parse-date", "path", "peek", "pipe", "pmt", "pop", "pop-assoc", "post-url", "pow", "prefix", "pretty-print", "primitive?", "print", "println", "prob-chi2", "prob-f", "prob-t", "prob-z", "process", "prompt-event", "protected?", "push", "put-url", "pv", "quote", "quote?", "rand", "random", "randomize", "read", "read-buffer", "read-char", "read-expr", "read-file", "read-key", "read-line", "reader-event", "read-utf8", "real-path", "receive", "ref", "ref-all", "regex", "regex-comp", "remove-dir", "rename-file", "replace", "replace-assoc", "reset", "rest", "reverse", "rotate", "round", "save", "search", "seed", "seek", "select", "self", "semaphore", "send", "sequence", "series", "set", "set-locale", "set-ref", "set-ref-all", "setq", "setf", "sgn", "share", "signal", "silent", "sin", "sinh", "sleep", "slice", "sort", "source", "spawn", "sqrt", "starts-with", "stats", "string", "string?", "struct", "sub", "sync", "swap", "sym", "symbol?", "symbols", "sys-error", "sys-info", "t-test", "tan", "tanh", "term", "throw", "throw-error", "time", "time-of-day", "timer", "title-case", "trace", "trace-highlight", "transpose", "trim", "true", "true?", "unicode", "unify", "union", "unique", "unless", "unpack", "until", "upper-case", "utf8", "utf8len", "uuid", "wait-pid", "when", "while", "write", "write-buffer", "write-char", "write-file", "write-line", "xfer-event", "xml-error", "xml-parse", "xml-type-tags", "zero?", "|", "~"};
    static SimpleAttributeSet comment;
    static SimpleAttributeSet keyword;
    static SimpleAttributeSet string;
    static SimpleAttributeSet number;
    static SimpleAttributeSet paren;
    static SimpleAttributeSet quoted;
    static SimpleAttributeSet normal;
    static Color normalColor;
    static Color commentColor;
    static Color keywordColor;
    static Color stringColor;
    static Color numberColor;
    static Color parenColor;
    static Color quotedColor;
    static String numberPattern;
    static Pattern compiledPattern;
    static StyledDocument doc;
    static String text;
    static String token;
    static Vector topLevels;
    static HashSet keys;
    static boolean active;

    public static void color(TextPaneWidget textPaneWidget, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        active = true;
        doc = textPaneWidget.styledDoc;
        topLevels = textPaneWidget.shTopLevels;
        normal = new SimpleAttributeSet();
        StyleConstants.setForeground(normal, textPaneWidget.foreground);
        try {
            text = doc.getText(0, textPaneWidget.documentLength);
        }
        catch (Exception exception) {
            text = null;
        }
        if (keys == null) {
            SyntaxHighlighter.init();
        }
        block11: while (n5 < n2) {
            int n6;
            char c = text.charAt(n5++);
            while (c <= ' ' && n5 < n2) {
                c = text.charAt(n5++);
            }
            switch (c) {
                case '#': 
                case ';': {
                    n6 = n5 - 1;
                    while (c != '\n' && n5 < n2) {
                        c = text.charAt(n5++);
                    }
                    doc.setCharacterAttributes(n6, n5 - n6, comment, false);
                    continue block11;
                }
                case '(': {
                    ++n3;
                    doc.setCharacterAttributes(n5 - 1, 1, paren, false);
                    continue block11;
                }
                case ')': {
                    doc.setCharacterAttributes(n5 - 1, 1, paren, false);
                    if (--n3 != 0) continue block11;
                    topLevels.addElement(n);
                    n = n5;
                    continue block11;
                }
                case '\'': {
                    n6 = n5 - 1;
                    while (c > ' ' && c != '(' && c != ')' && n5 < n2) {
                        c = text.charAt(n5++);
                    }
                    if (c == ' ' || c == '(' || c == ')') {
                        doc.setCharacterAttributes(n6, n5 - n6 - 1, quoted, false);
                        --n5;
                        continue block11;
                    }
                    doc.setCharacterAttributes(n6, n5 - n6, quoted, false);
                    continue block11;
                }
                case '\"': {
                    n6 = n5 - 1;
                    while (n5 < n2) {
                        if ((c = text.charAt(n5++)) == '\"') {
                            doc.setCharacterAttributes(n6, n5 - n6, string, false);
                            continue block11;
                        }
                        if (c != '\\') continue;
                        ++n5;
                    }
                    continue block11;
                }
                case '{': {
                    n6 = n5 - 1;
                    n4 = 1;
                    while (n4 != 0 && n5 < n2) {
                        if ((c = text.charAt(n5++)) == '}') {
                            --n4;
                            continue;
                        }
                        if (c != '{') continue;
                        ++n4;
                    }
                    doc.setCharacterAttributes(n6, n5 - n6, string, false);
                    continue block11;
                }
                case '[': {
                    n6 = n5 - 1;
                    if (!text.startsWith("[text]", n6)) continue block11;
                    n5 = text.indexOf("[/text]", n6 + 6);
                    n5 = n5 < 0 ? n2 : (n5 += 7);
                    doc.setCharacterAttributes(n6, n5 - n6, string, false);
                    continue block11;
                }
            }
            n6 = n5 - 1;
            while (c > ' ' && c != '(' && c != ')' && c != '\'' && n5 < n2) {
                c = text.charAt(n5++);
            }
            token = c == '(' || c == ')' || c == ' ' ? text.substring(n6, n5 - 1) : text.substring(n6, n5);
            int n7 = token.length();
            if (keys.contains(token)) {
                doc.setCharacterAttributes(n6, n7, keyword, false);
            } else if (compiledPattern.matcher(token).matches()) {
                doc.setCharacterAttributes(n6, n7, number, false);
            } else {
                doc.setCharacterAttributes(n6, n7, normal, false);
            }
            if (c == '(') {
                ++n3;
                doc.setCharacterAttributes(n5 - 1, 1, paren, false);
                continue;
            }
            if (c == ')') {
                doc.setCharacterAttributes(n5 - 1, 1, paren, false);
                if (--n3 != 0) continue;
                topLevels.addElement(n);
                n = n5;
                continue;
            }
            if (c != '\'') continue;
            doc.setCharacterAttributes(n5 - 1, 1, paren, false);
        }
        active = false;
    }

    static void init() {
        if (keys == null) {
            keys = new HashSet();
            for (int i = 0; i < reserved.length; ++i) {
                keys.add(reserved[i]);
            }
        }
        compiledPattern = Pattern.compile(numberPattern);
        comment = new SimpleAttributeSet();
        StyleConstants.setForeground(comment, commentColor);
        keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(keyword, keywordColor);
        string = new SimpleAttributeSet();
        StyleConstants.setForeground(string, stringColor);
        number = new SimpleAttributeSet();
        StyleConstants.setForeground(number, numberColor);
        quoted = new SimpleAttributeSet();
        StyleConstants.setForeground(quoted, quotedColor);
        paren = new SimpleAttributeSet();
        StyleConstants.setForeground(paren, parenColor);
    }

    public static void setSyntaxColors(StringTokenizer stringTokenizer) {
        commentColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        keywordColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        stringColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        numberColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        quotedColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        parenColor = new Color(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()));
        SyntaxHighlighter.init();
        SyntaxHighlighterC.init();
    }

    static {
        normalColor = Color.black;
        commentColor = Color.gray;
        keywordColor = new Color(0, 0, 192);
        stringColor = new Color(0, 128, 0);
        numberColor = new Color(192, 128, 0);
        parenColor = new Color(192, 0, 0);
        quotedColor = new Color(96, 96, 192);
        numberPattern = "^-?\\d+$|^-?\\d+\\.\\d+$|^0x[0-9a-fA-F]+$|^0b[01]+$";
        keys = null;
        active = false;
    }
}

