# A ticker object.
import gtk
import pango
import gobject

class Ticker(gtk.DrawingArea):
    def __init__(self, timeout):
        gtk.DrawingArea.__init__(self)
        self.timeout = timeout
        self.init_widgets()
        self.init_vars()
        self.init_handlers()

    def init_widgets(self):
        self.layout = self.create_pango_layout("")
        self.show_all()

    def init_handlers(self):
        self.connect("expose-event", self.expose_cb)
        self.connect("configure-event", self.configure_cb)
        gobject.timeout_add(self.timeout, self.scroll_cb)

    def init_vars(self):
        self.first_exposed = True
        self.new_timeout = False
        self.scroll = True
        self.x = self.y = 0
        self.x_inc = self.y_inc = 1
        self.x_pix = self.y_pix = 0
    
    def set_text(self, text):
        self.layout.set_text(text)
        self.x_pix, self.y_pix = self.layout.get_pixel_size()

    def set_markup(self, text):
        self.layout.set_markup(text)
        self.x_pix, self.y_pix = self.layout.get_pixel_size()

    def get_text(self):
        return self.layout.get_text()

    def set_font(self, desc):
        if type(desc) == str:
            desc = pango.FontDescription(desc)
        if type(desc) == pango.FontDescription:
            self.layout.set_font_description(desc)
        self.x_pix, self.y_pix = self.layout.get_pixel_size()
    
    def set_speed(self, timeout):
        self.new_timeout = True
        self.timeout = timeout

    def get_speed(self):
        return self.timeout

    def set_scroll(self, bool):
        self.scroll = bool

    def get_scroll(self):
        return self.scroll

    def reset(self):
        self.x = self.y = 0
        self.max_x, self.max_y = self.drawable.get_size()
        self.x_pix, self.y_pix = self.layout.get_pixel_size()
    
    def display(self):
        self.drawable.draw_layout(self.gc, self.x, self.y, self.layout)
        if (self.x < 0):
            if self.x_pix > self.max_x:
                self.drawable.draw_layout(self.gc, self.x_pix + self.x, self.y, self.layout)
            else:
                self.drawable.draw_layout(self.gc, self.max_x + self.x, self.y, self.layout)
            
    
    def scroll_cb(self):
        if self.scroll:
            if self.x == 0 - self.x_pix:
                if self.x_pix > self.max_x:
                    self.x = self.x_pix + self.x
                else:
                    self.x = self.max_x + self.x
            self.x -= self.x_inc
            self.queue_draw()
        if self.new_timeout:
            self.new_timeout = False
            gobject.timeout_add(self.timeout, self.scroll_cb)
            return False
        return True

    def expose_cb(self, area, event):
        if (self.first_exposed):
            self.drawable = self.window
            self.max_x, self.max_y = self.drawable.get_size()
            self.gc = self.style.fg_gc[gtk.STATE_NORMAL]
            self.first_exposed = False
        self.display()
        return True

    def configure_cb(self, area, event):
        try:
            self.max_x, self.max_y = self.drawable.get_size()
        except:
            pass
        return True
