/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.PDBChain;
import MCview.myAtom;
import jalview.DrawableSequence;
import jalview.FileParse;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PDBfile
extends FileParse {
    public Vector chains = new Vector();

    public PDBfile(String string, String string2) throws IOException {
        super(string, string2);
        this.readLines();
        this.parse();
    }

    public void parse() {
        System.out.println("Parsing");
        int n = 0;
        while (n < this.lineArray.size()) {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(this.lineArray.elementAt(n).toString());
            if (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).indexOf("ATOM") != -1) {
                try {
                    myAtom myAtom2 = new myAtom(stringTokenizer);
                    if (this.findChain(myAtom2.chain) != null) {
                        this.findChain((String)myAtom2.chain).atoms.addElement(myAtom2);
                    } else {
                        PDBChain pDBChain = new PDBChain(myAtom2.chain);
                        this.chains.addElement(pDBChain);
                        pDBChain.atoms.addElement(myAtom2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Caught" + numberFormatException);
                    System.out.println("Atom not added");
                }
            }
            ++n;
        }
        this.makeResidueList();
        this.makeCaBondList();
    }

    public void makeResidueList() {
        int n = 0;
        while (n < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(n)).makeResidueList();
            ++n;
        }
    }

    public void makeCaBondList() {
        int n = 0;
        while (n < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(n)).makeCaBondList();
            ++n;
        }
    }

    public PDBChain findChain(String string) {
        int n = 0;
        while (n < this.chains.size()) {
            if (((PDBChain)this.chains.elementAt((int)n)).id.equals(string)) {
                return (PDBChain)this.chains.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public void setChargeColours() {
        int n = 0;
        while (n < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(n)).setChargeColours();
            ++n;
        }
    }

    public void setHydrophobicityColours() {
        int n = 0;
        while (n < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(n)).setHydrophobicityColours();
            ++n;
        }
    }

    public void colourBySequence(DrawableSequence drawableSequence) {
        int n = drawableSequence.maxchain;
        if (drawableSequence.maxchain != -1) {
            ((PDBChain)this.chains.elementAt(n)).colourBySequence(drawableSequence);
        }
    }

    public void setChainColours() {
        int n = 0;
        while (n < this.chains.size()) {
            ((PDBChain)this.chains.elementAt(n)).setChainColours();
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            new PDBfile("enkp1.pdb", "File");
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(0);
            return;
        }
    }
}

