#!/bin/sh
echo 'name: convertible
version: 1.0.11.1
id: convertible-1.0.11.1-5508624561c204cf1c5d742d6f492a2b

license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
synopsis: Typeclasses and instances for converting between types
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
library-dirs: /usr/local/lib/ghc/convertible-1.0.11.1
hs-libraries: HSconvertible-1.0.11.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         bytestring-0.10.0.2-f858e0cb19bca2e9549882fc8424f656
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         old-locale-1.0.0.5-753125cfaf463057d163a0cefde5b58f
         old-time-1.1.0.1-8b10e3f99ed8611456aa344014a88da2
         text-0.11.3.1-bda2125c8335eaa4aca16bb46c88465a
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.11.1/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.11.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
