/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.graphics.CalRGB;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.Lab;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.util.Library;

public abstract class PColorSpace
extends Dictionary {
    private static final Logger logger = Logger.getLogger(PColorSpace.class.toString());

    public abstract int getNumComponents();

    PColorSpace(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public static PColorSpace getColorSpace(Library library, Object object) {
        if (object != null) {
            if (object instanceof Reference) {
                object = library.getObject((Reference)object);
            }
            if (object instanceof Name) {
                if (object.equals("DeviceGray") || object.equals("G")) {
                    return new DeviceGray(library, null);
                }
                if (object.equals("DeviceRGB") || object.equals("RGB")) {
                    return new DeviceRGB(library, null);
                }
                if (object.equals("DeviceCMYK") || object.equals("CMYK")) {
                    return new DeviceCMYK(library, null);
                }
                if (object.equals("Pattern")) {
                    return new PatternColor(library, null);
                }
            } else if (object instanceof Vector) {
                Vector vector = (Vector)object;
                if (vector.elementAt(0).equals("Indexed") || vector.elementAt(0).equals("I")) {
                    return new Indexed(library, null, vector);
                }
                if (vector.elementAt(0).equals("CalRGB")) {
                    return new CalRGB(library, (Hashtable)vector.elementAt(1));
                }
                if (vector.elementAt(0).equals("Lab")) {
                    return new Lab(library, (Hashtable)vector.elementAt(1));
                }
                if (vector.elementAt(0).equals("Separation")) {
                    return new Separation(library, null, vector.elementAt(1), vector.elementAt(2), vector.elementAt(3));
                }
                if (vector.elementAt(0).equals("DeviceN")) {
                    return new DeviceN(library, null, vector.elementAt(1), vector.elementAt(2), vector.elementAt(3), vector.size() > 4 ? vector.elementAt(4) : null);
                }
                if (vector.elementAt(0).equals("ICCBased")) {
                    return library.getICCBased((Reference)vector.elementAt(1));
                }
                if (vector.elementAt(0).equals("DeviceRGB")) {
                    return new DeviceRGB(library, null);
                }
                if (vector.elementAt(0).equals("DeviceCMYK")) {
                    return new DeviceCMYK(library, null);
                }
                if (vector.elementAt(0).equals("DeviceGray")) {
                    return new DeviceRGB(library, null);
                }
                if (vector.elementAt(0).equals("Pattern")) {
                    PatternColor patternColor = new PatternColor(library, null);
                    if (vector.size() > 1) {
                        patternColor.setPColorSpace(PColorSpace.getColorSpace(library, vector.elementAt(1)));
                    }
                    return patternColor;
                }
            } else if (object instanceof Hashtable) {
                return new PatternColor(library, (Hashtable)object);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unsupported Colorspace: " + object);
            }
        }
        return new DeviceGray(library, null);
    }

    public static PColorSpace getColorSpace(Library library, float f) {
        if (f == 3.0f) {
            return new DeviceRGB(library, null);
        }
        if (f == 4.0f) {
            return new DeviceCMYK(library, null);
        }
        return new DeviceGray(library, null);
    }

    public abstract Color getColor(float[] var1);

    public void normaliseComponentsToFloats(int[] nArray, float[] fArray, float f) {
        int n = this.getNumComponents();
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)nArray[i] / f;
        }
    }

    public static float[] reverse(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[fArray.length - i - 1];
        }
        return fArray2;
    }

    public static void reverseInPlace(float[] fArray) {
        int n = fArray.length / 2;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            fArray[i] = fArray[fArray.length - 1 - i];
            fArray[fArray.length - 1 - i] = f;
        }
    }

    public static void reverseInPlace(int[] nArray) {
        int n = nArray.length / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            nArray[i] = nArray[nArray.length - 1 - i];
            nArray[nArray.length - 1 - i] = n2;
        }
    }
}

