/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.functions.Function_0;
import org.icepdf.core.pobjects.functions.Function_2;
import org.icepdf.core.pobjects.functions.Function_3;
import org.icepdf.core.util.Library;

public abstract class Function {
    private static final Logger logger = Logger.getLogger(Function.class.toString());
    protected float[] domain;
    protected float[] range;
    protected int functionType;

    public static Function getFunction(Library library, Object object) {
        Dictionary dictionary = null;
        if (object instanceof Reference) {
            object = library.getObject((Reference)object);
        }
        if (object instanceof Dictionary) {
            dictionary = (Dictionary)object;
        } else if (object instanceof Hashtable) {
            dictionary = new Dictionary(library, (Hashtable)object);
        }
        if (dictionary != null) {
            int n = dictionary.getInt("FunctionType");
            switch (n) {
                case 0: {
                    return new Function_0(dictionary);
                }
                case 2: {
                    return new Function_2(dictionary);
                }
                case 3: {
                    return new Function_3(dictionary);
                }
                case 4: {
                    logger.finer("Function type 4 (PostScript calculator) is not supported");
                }
            }
        }
        return null;
    }

    protected Function(Dictionary dictionary) {
        Vector vector = (Vector)dictionary.getObject("Domain");
        this.domain = new float[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.domain[i] = ((Number)vector.elementAt(i)).floatValue();
        }
        Vector vector2 = (Vector)dictionary.getObject("Range");
        if (vector2 != null) {
            this.range = new float[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                this.range[i] = ((Number)vector2.elementAt(i)).floatValue();
            }
        }
    }

    public int getFunctionType() {
        return this.functionType;
    }

    protected float interpolate(float f, float f2, float f3, float f4, float f5) {
        return (f - f2) * (f5 - f4) / (f3 - f2) + f4;
    }

    public abstract float[] calculate(float[] var1);

    public float[] getDomain() {
        return this.domain;
    }

    public float[] getRange() {
        return this.range;
    }
}

