/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg12;

import javax.media.Buffer;

public class DisplayOutput {
    private int[] luminance;
    private int[] red;
    private int[] blue;
    private int[] nextPLuminance;
    private int[] nextPRed;
    private int[] nextPBlue;
    private int[] oldLuminance;
    private int[] oldRed;
    private int[] oldBlue;
    private int screenX;
    private int screenY;
    private int chromX;
    private int chromY;
    private static final int W1 = 22725;
    private static final int W2 = 21407;
    private static final int W3 = 19266;
    private static final int W4 = 16383;
    private static final int W5 = 12873;
    private static final int W6 = 8867;
    private static final int W7 = 4520;
    private static final int ROW_SHIFT = 11;
    private static final int COL_SHIFT = 20;
    private int block0;
    private int block1;
    private int block2;
    private int block3;
    private int block4;
    private int block5;
    private int block6;
    private int block7;
    private int a0;
    private int a1;
    private int a2;
    private int a3;
    private int b0;
    private int b1;
    private int b2;
    private int b3;
    private int displayX;
    private int displayY;
    private int[] displayArray;

    private final void idctRowCondDC(int[] nArray, int n) {
        this.block0 = nArray[n];
        this.block1 = nArray[n + 1];
        this.block2 = nArray[n + 2];
        this.block3 = nArray[n + 3];
        this.block4 = nArray[n + 4];
        this.block5 = nArray[n + 5];
        this.block6 = nArray[n + 6];
        this.block7 = nArray[n + 7];
        if ((this.block1 | this.block2 | this.block3 | this.block4 | this.block5 | this.block6 | this.block7) == 0) {
            this.block0 <<= 3;
            nArray[n] = this.block0;
            nArray[n + 1] = this.block0;
            nArray[n + 2] = this.block0;
            nArray[n + 3] = this.block0;
            nArray[n + 4] = this.block0;
            nArray[n + 5] = this.block0;
            nArray[n + 6] = this.block0;
            nArray[n + 7] = this.block0;
            return;
        }
        this.a0 = 16383 * this.block0 + 1024;
        this.a1 = this.a0 + 8867 * this.block2 - 16383 * this.block4 - 21407 * this.block6;
        this.a2 = this.a0 - 8867 * this.block2 - 16383 * this.block4 + 21407 * this.block6;
        this.a3 = this.a0 - 21407 * this.block2 + 16383 * this.block4 - 8867 * this.block6;
        this.a0 += 21407 * this.block2 + 16383 * this.block4 + 8867 * this.block6;
        this.b0 = 22725 * this.block1 + 19266 * this.block3 + 12873 * this.block5 + 4520 * this.block7;
        this.b1 = 19266 * this.block1 - 4520 * this.block3 - 22725 * this.block5 - 12873 * this.block7;
        this.b2 = 12873 * this.block1 - 22725 * this.block3 + 4520 * this.block5 + 19266 * this.block7;
        this.b3 = 4520 * this.block1 - 12873 * this.block3 + 19266 * this.block5 - 22725 * this.block7;
        nArray[n + 0] = this.a0 + this.b0 >> 11;
        nArray[n + 7] = this.a0 - this.b0 >> 11;
        nArray[n + 1] = this.a1 + this.b1 >> 11;
        nArray[n + 6] = this.a1 - this.b1 >> 11;
        nArray[n + 2] = this.a2 + this.b2 >> 11;
        nArray[n + 5] = this.a2 - this.b2 >> 11;
        nArray[n + 3] = this.a3 + this.b3 >> 11;
        nArray[n + 4] = this.a3 - this.b3 >> 11;
    }

    private final void idctSparseColAdd(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        this.block0 = nArray[n];
        this.block1 = nArray[n + 8];
        this.block2 = nArray[n + 16];
        this.block3 = nArray[n + 24];
        this.block4 = nArray[n + 32];
        this.block5 = nArray[n + 40];
        this.block6 = nArray[n + 48];
        this.block7 = nArray[n + 56];
        this.a0 = 16383 * this.block0 + 524288;
        this.a1 = this.a0 + 8867 * this.block2 - 16383 * this.block4 - 21407 * this.block6;
        this.a2 = this.a0 - 8867 * this.block2 - 16383 * this.block4 + 21407 * this.block6;
        this.a3 = this.a0 - 21407 * this.block2 + 16383 * this.block4 - 8867 * this.block6;
        this.a0 += 21407 * this.block2 + 16383 * this.block4 + 8867 * this.block6;
        this.b0 = 22725 * this.block1 + 19266 * this.block3 + 12873 * this.block5 + 4520 * this.block7;
        this.b1 = 19266 * this.block1 - 4520 * this.block3 - 22725 * this.block5 - 12873 * this.block7;
        this.b2 = 12873 * this.block1 - 22725 * this.block3 + 4520 * this.block5 + 19266 * this.block7;
        this.b3 = 4520 * this.block1 - 12873 * this.block3 + 19266 * this.block5 - 22725 * this.block7;
        nArray2[n2 += n] = DisplayOutput.crop(nArray2[n2] + (this.a0 + this.b0 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a1 + this.b1 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a2 + this.b2 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a3 + this.b3 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a3 - this.b3 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a2 - this.b2 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a1 - this.b1 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (this.a0 - this.b0 >> 20));
    }

    public final void idctAdd(int[] nArray, int[] nArray2, int n, int n2) {
        this.idctRowCondDC(nArray, 0);
        this.idctRowCondDC(nArray, 8);
        this.idctRowCondDC(nArray, 16);
        this.idctRowCondDC(nArray, 24);
        this.idctRowCondDC(nArray, 32);
        this.idctRowCondDC(nArray, 40);
        this.idctRowCondDC(nArray, 48);
        this.idctRowCondDC(nArray, 56);
        this.idctSparseColAdd(nArray, 0, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 1, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 2, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 3, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 4, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 5, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 6, nArray2, n, n2);
        this.idctSparseColAdd(nArray, 7, nArray2, n, n2);
    }

    private final void idctSparseColPut(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        this.block0 = nArray[n];
        this.block1 = nArray[n + 8];
        this.block2 = nArray[n + 16];
        this.block3 = nArray[n + 24];
        this.block4 = nArray[n + 32];
        this.block5 = nArray[n + 40];
        this.block6 = nArray[n + 48];
        this.block7 = nArray[n + 56];
        this.a0 = 16383 * this.block0 + 524288;
        this.a1 = this.a0 + 8867 * this.block2 - 16383 * this.block4 - 21407 * this.block6;
        this.a2 = this.a0 - 8867 * this.block2 - 16383 * this.block4 + 21407 * this.block6;
        this.a3 = this.a0 - 21407 * this.block2 + 16383 * this.block4 - 8867 * this.block6;
        this.a0 += 21407 * this.block2 + 16383 * this.block4 + 8867 * this.block6;
        this.b0 = 22725 * this.block1 + 19266 * this.block3 + 12873 * this.block5 + 4520 * this.block7;
        this.b1 = 19266 * this.block1 - 4520 * this.block3 - 22725 * this.block5 - 12873 * this.block7;
        this.b2 = 12873 * this.block1 - 22725 * this.block3 + 4520 * this.block5 + 19266 * this.block7;
        this.b3 = 4520 * this.block1 - 12873 * this.block3 + 19266 * this.block5 - 22725 * this.block7;
        nArray2[n2 += n] = DisplayOutput.crop(this.a0 + this.b0 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a1 + this.b1 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a2 + this.b2 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a3 + this.b3 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a3 - this.b3 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a2 - this.b2 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a1 - this.b1 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(this.a0 - this.b0 >> 20);
    }

    public final void idctPut(int[] nArray, int[] nArray2, int n, int n2) {
        this.idctRowCondDC(nArray, 0);
        this.idctRowCondDC(nArray, 8);
        this.idctRowCondDC(nArray, 16);
        this.idctRowCondDC(nArray, 24);
        this.idctRowCondDC(nArray, 32);
        this.idctRowCondDC(nArray, 40);
        this.idctRowCondDC(nArray, 48);
        this.idctRowCondDC(nArray, 56);
        this.idctSparseColPut(nArray, 0, nArray2, n, n2);
        this.idctSparseColPut(nArray, 1, nArray2, n, n2);
        this.idctSparseColPut(nArray, 2, nArray2, n, n2);
        this.idctSparseColPut(nArray, 3, nArray2, n, n2);
        this.idctSparseColPut(nArray, 4, nArray2, n, n2);
        this.idctSparseColPut(nArray, 5, nArray2, n, n2);
        this.idctSparseColPut(nArray, 6, nArray2, n, n2);
        this.idctSparseColPut(nArray, 7, nArray2, n, n2);
    }

    public DisplayOutput(int n, int n2) {
        this.displayX = n * 16;
        this.displayY = n2 * 16;
        this.screenX = this.displayX + 32;
        this.screenY = this.displayY + 32;
        this.chromX = this.screenX / 2;
        this.chromY = this.screenY / 2;
        this.luminance = new int[(n += 2) * 16 * (n2 += 2) * 16];
        this.red = new int[n * 8 * n2 * 8];
        this.blue = new int[n * 8 * n2 * 8];
        this.nextPLuminance = new int[n * 16 * n2 * 16];
        this.nextPRed = new int[n * 8 * n2 * 8];
        this.nextPBlue = new int[n * 8 * n2 * 8];
        this.oldLuminance = new int[n * 16 * n2 * 16];
        this.oldRed = new int[n * 8 * n2 * 8];
        this.oldBlue = new int[n * 8 * n2 * 8];
        for (int i = 0; i < this.blue.length; ++i) {
            this.blue[i] = 1024;
        }
        System.arraycopy(this.blue, 0, this.red, 0, this.blue.length);
        System.arraycopy(this.blue, 0, this.luminance, 0, this.blue.length);
        System.arraycopy(this.blue, 0, this.luminance, this.blue.length, this.blue.length);
        System.arraycopy(this.blue, 0, this.luminance, this.blue.length * 2, this.blue.length);
        System.arraycopy(this.blue, 0, this.luminance, this.blue.length * 3, this.blue.length);
    }

    private static final int crop(int n) {
        if ((n & 0xFF) == n) {
            return n;
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public final void putLuminanceIdct(int n, int n2, int[] nArray, boolean bl) {
        int n3 = bl ? n * 8 + 16 + ((n2 & 0xFFFFFFFE) * 8 + 16 + (n2 & 1)) * this.screenX : n * 8 + 16 + (n2 * 8 + 16) * this.screenX;
        this.idctPut(nArray, this.luminance, n3, bl ? this.screenX * 2 : this.screenX);
    }

    public final void putRedIdct(int n, int n2, int[] nArray) {
        this.idctPut(nArray, this.red, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void putBlueIdct(int n, int n2, int[] nArray) {
        this.idctPut(nArray, this.blue, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void addLuminanceIdct(int n, int n2, int[] nArray, boolean bl) {
        int n3 = bl ? n * 8 + 16 + ((n2 & 0xFFFFFFFE) * 8 + 16 + (n2 & 1)) * this.screenX : n * 8 + 16 + (n2 * 8 + 16) * this.screenX;
        this.idctAdd(nArray, this.luminance, n3, bl ? this.screenX * 2 : this.screenX);
    }

    public final void addRedIdct(int n, int n2, int[] nArray) {
        this.idctAdd(nArray, this.red, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void addBlueIdct(int n, int n2, int[] nArray) {
        this.idctAdd(nArray, this.blue, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    private final void blitBlock0Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n2;
        while (n8 < n3) {
            for (int i = n4; i < n5; ++i) {
                nArray2[i + n8] = nArray[i + n6 + n7];
            }
            n8 += n;
            n7 += n;
        }
    }

    private final void blitBlock1Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n4 + n6;
        int n9 = n6 + 1;
        int n10 = n2;
        while (n10 < n3) {
            int n11 = nArray[n8 + n7];
            int n12 = n9 + n7;
            for (int i = n4; i < n5; ++i) {
                int n13 = n11;
                n11 = nArray[i + n12];
                nArray2[i + n10] = (n13 | n11) - ((n13 ^ n11) >> 1);
            }
            n10 += n;
            n7 += n;
        }
    }

    private final void blitBlock2Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        int n9 = n6 + n;
        for (int i = n4; i < n5; ++i) {
            int n10 = nArray[i + n8];
            int n11 = i + n9 + n7;
            for (int j = n2; j < n3; j += n) {
                int n12 = n10;
                n10 = nArray[n11 + j];
                nArray2[i + j] = (n12 | n10) - ((n12 ^ n10) >> 1);
            }
        }
    }

    private final void blitBlock3Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        n7 += n;
        for (int i = n4; i < n5; ++i) {
            int n9 = nArray[i + n8] + nArray[i + n8 + 1];
            int n10 = i + n6 + n7;
            for (int j = n2; j < n3; j += n) {
                int n11 = n9;
                n9 = nArray[n10 + j] + nArray[n10 + 1 + j];
                nArray2[i + j] = n11 + n9 + 2 >> 2;
            }
        }
    }

    private final void blitBlock0NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n2;
        while (n8 < n3) {
            for (int i = n4; i < n5; ++i) {
                nArray2[i + n8] = nArray[i + n6 + n7];
            }
            n8 += n;
            n7 += n;
        }
    }

    private final void blitBlock1NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n4 + n6;
        int n9 = n6 + 1;
        int n10 = n2;
        while (n10 < n3) {
            int n11 = nArray[n8 + n7];
            int n12 = n9 + n7;
            for (int i = n4; i < n5; ++i) {
                int n13 = n11;
                n11 = nArray[i + n12];
                nArray2[i + n10] = (n13 & n11) + ((n13 ^ n11) >> 1);
            }
            n10 += n;
            n7 += n;
        }
    }

    private final void blitBlock2NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        int n9 = n6 + n;
        for (int i = n4; i < n5; ++i) {
            int n10 = nArray[i + n8];
            int n11 = i + n9 + n7;
            for (int j = n2; j < n3; j += n) {
                int n12 = n10;
                n10 = nArray[n11 + j];
                nArray2[i + j] = (n12 & n10) + ((n12 ^ n10) >> 1);
            }
        }
    }

    private final void blitBlock3NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        n7 += n;
        for (int i = n4; i < n5; ++i) {
            int n9 = nArray[i + n8] + nArray[i + n8 + 1];
            int n10 = i + n6 + n7;
            for (int j = n2; j < n3; j += n) {
                int n11 = n9;
                n9 = nArray[n10 + j] + nArray[n10 + 1 + j];
                nArray2[i + j] = n11 + n9 + 1 >> 2;
            }
        }
    }

    private final void blitBlock(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        n2 *= n;
        n3 *= n;
        n7 *= n;
        if (bl) {
            switch (n8) {
                case 0: {
                    this.blitBlock0Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 1: {
                    this.blitBlock1Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 2: {
                    this.blitBlock2Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                default: {
                    this.blitBlock3Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
            }
        } else {
            switch (n8) {
                case 0: {
                    this.blitBlock0NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 1: {
                    this.blitBlock1NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 2: {
                    this.blitBlock2NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                default: {
                    this.blitBlock3NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                }
            }
        }
    }

    private final void mergeBlock0Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n2;
        while (n8 < n3) {
            for (int i = n4; i < n5; ++i) {
                nArray2[i + n8] = nArray2[i + n8] + nArray[i + n6 + n7] >> 1;
            }
            n8 += n;
            n7 += n;
        }
    }

    private final void mergeBlock1Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n4 + n6;
        int n9 = n6 + 1;
        int n10 = n2;
        while (n10 < n3) {
            int n11 = nArray[n8 + n7];
            int n12 = n9 + n7;
            for (int i = n4; i < n5; ++i) {
                int n13 = n11;
                n11 = nArray[i + n12];
                nArray2[i + n10] = nArray2[i + n10] + (n13 | n11) - ((n13 ^ n11) >> 1) >> 1;
            }
            n10 += n;
            n7 += n;
        }
    }

    private final void mergeBlock2Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        int n9 = n6 + n;
        for (int i = n4; i < n5; ++i) {
            int n10 = nArray[i + n8];
            int n11 = i + n9 + n7;
            for (int j = n2; j < n3; j += n) {
                int n12 = n10;
                n10 = nArray[n11 + j];
                nArray2[i + j] = nArray2[i + j] + (n12 | n10) - ((n12 ^ n10) >> 1) >> 1;
            }
        }
    }

    private final void mergeBlock3Round(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        n7 += n;
        for (int i = n4; i < n5; ++i) {
            int n9 = nArray[i + n8] + nArray[i + n8 + 1];
            int n10 = i + n6 + n7;
            for (int j = n2; j < n3; j += n) {
                int n11 = n9;
                n9 = nArray[n10 + j] + nArray[n10 + 1 + j];
                nArray2[i + j] = nArray2[i + j] + (n11 + n9 + 2 >> 2) >> 1;
            }
        }
    }

    private final void mergeBlock0NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n2;
        while (n8 < n3) {
            for (int i = n4; i < n5; ++i) {
                nArray2[i + n8] = nArray2[i + n8] + nArray[i + n6 + n7] >> 1;
            }
            n8 += n;
            n7 += n;
        }
    }

    private final void mergeBlock1NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n7 += n2;
        int n8 = n4 + n6;
        int n9 = n6 + 1;
        int n10 = n2;
        while (n10 < n3) {
            int n11 = nArray[n8 + n7];
            int n12 = n9 + n7;
            for (int i = n4; i < n5; ++i) {
                int n13 = n11;
                n11 = nArray[i + n12];
                nArray2[i + n10] = nArray2[i + n10] + (n13 & n11) + ((n13 ^ n11) >> 1) >> 1;
            }
            n10 += n;
            n7 += n;
        }
    }

    private final void mergeBlock2NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        int n9 = n6 + n;
        for (int i = n4; i < n5; ++i) {
            int n10 = nArray[i + n8];
            int n11 = i + n9 + n7;
            for (int j = n2; j < n3; j += n) {
                int n12 = n10;
                n10 = nArray[n11 + j];
                nArray2[i + j] = nArray2[i + j] + (n12 & n10) + ((n12 ^ n10) >> 1) >> 1;
            }
        }
    }

    private final void mergeBlock3NoRound(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n6 + n7 + n2;
        n7 += n;
        for (int i = n4; i < n5; ++i) {
            int n9 = nArray[i + n8] + nArray[i + n8 + 1];
            int n10 = i + n6 + n7;
            for (int j = n2; j < n3; j += n) {
                int n11 = n9;
                n9 = nArray[n10 + j] + nArray[n10 + 1 + j];
                nArray2[i + j] = nArray2[i + j] + (n11 + n9 + 1 >> 2) >> 1;
            }
        }
    }

    private final void mergeBlock(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        n2 *= n;
        n3 *= n;
        n7 *= n;
        if (bl) {
            switch (n8) {
                case 0: {
                    this.mergeBlock0Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 1: {
                    this.mergeBlock1Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 2: {
                    this.mergeBlock2Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                default: {
                    this.mergeBlock3Round(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
            }
        } else {
            switch (n8) {
                case 0: {
                    this.mergeBlock0NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 1: {
                    this.mergeBlock1NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 2: {
                    this.mergeBlock2NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                    break;
                }
                default: {
                    this.mergeBlock3NoRound(nArray, nArray2, n, n2, n3, n4, n5, n6, n7);
                }
            }
        }
    }

    private final int clip(int n, int n2, int n3) {
        if (n + n2 < 0) {
            n = -n2;
        }
        if (n + n2 > n3) {
            n = n3 - n2;
        }
        return n;
    }

    public void mpeg_motion(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int n3, boolean bl, int n4, int n5, boolean bl2, boolean bl3, int n6, int n7, int n8) {
        int n9 = bl ? this.screenX * 2 : this.screenX;
        int n10 = n2 * 16 + 16;
        int n11 = n * 16 + 16;
        if (bl) {
            n10 /= 2;
        }
        int n12 = n6 & 1 | (n7 & 1) << 1;
        int n13 = n6 / 2;
        int n14 = n7 / 2;
        if (n6 < 0 && (n12 & 1) == 1) {
            --n13;
        }
        if (n7 < 0 && (n12 & 2) == 2) {
            --n14;
        }
        n11 = this.clip(n11, n13, this.screenX - 16);
        n10 = this.clip(n10, n14, bl ? this.screenY / 2 - 8 : this.screenY - 16);
        int n15 = n11 + 16;
        int n16 = n10 + n8;
        if (n15 + n13 == this.screenX) {
            n12 &= 0xFFFFFFFE;
        }
        if (n16 + n14 == (bl ? this.screenY / 2 : this.screenY)) {
            n12 &= 0xFFFFFFFD;
        }
        if (bl && n5 == 1) {
            n11 += this.screenX;
            n15 += this.screenX;
        }
        if (bl && n4 != n5) {
            n13 += this.screenX * (n4 - n5);
        }
        if (bl3) {
            this.mergeBlock(nArray, this.luminance, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
        } else {
            this.blitBlock(nArray, this.luminance, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
        }
        n9 = bl ? this.chromX * 2 : this.chromX;
        n10 = n2 * 8 + 8;
        n11 = n * 8 + 8;
        if (bl) {
            n10 /= 2;
        }
        if ((n6 & 1) != 0) {
            n6 = n6 < 0 ? --n6 : ++n6;
        }
        if ((n7 & 1) != 0) {
            n7 = n7 < 0 ? --n7 : ++n7;
        }
        n12 = n7 & 2 | (n6 & 2) >> 1;
        n13 = n6 / 4;
        n14 = n7 / 4;
        if (n6 < 0 && (n12 & 1) == 1) {
            --n13;
        }
        if (n7 < 0 && (n12 & 2) == 2) {
            --n14;
        }
        n11 = this.clip(n11, n13, this.chromX - 8);
        n10 = this.clip(n10, n14, bl ? this.chromY / 2 - 4 : this.chromY - 8);
        n15 = n11 + 8;
        n16 = n10 + n8 / 2;
        if (n15 + n13 == this.chromX) {
            n12 &= 0xFFFFFFFE;
        }
        if (n16 + n14 == (bl ? this.chromY / 2 : this.chromY)) {
            n12 &= 0xFFFFFFFD;
        }
        if (bl && n5 == 1) {
            n11 += this.chromX;
            n15 += this.chromX;
        }
        if (bl && n4 != n5) {
            n13 += this.chromX * (n4 - n5);
        }
        if (bl3) {
            this.mergeBlock(nArray3, this.blue, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
            this.mergeBlock(nArray2, this.red, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
        } else {
            this.blitBlock(nArray3, this.blue, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
            this.blitBlock(nArray2, this.red, n9, n10, n16, n11, n15, n13, n14, n12, bl2);
        }
    }

    public void move(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4, int n3, boolean bl, boolean bl2, int n4, boolean[] blArray, int n5) {
        switch (n4) {
            case 0: {
                this.mpeg_motion(nArray, nArray2, nArray3, n, n2, 0, false, 0, 0, bl, bl2, nArray4[n3], nArray4[n3 + 1], 16);
                break;
            }
            case 3: {
                this.mpeg_motion(nArray, nArray2, nArray3, n, n2, 0, true, blArray[n5] ? 1 : 0, 0, bl, bl2, nArray4[n3], nArray4[n3 + 1], 8);
                this.mpeg_motion(nArray, nArray2, nArray3, n, n2, 0, true, blArray[n5 + 1] ? 1 : 0, 1, bl, bl2, nArray4[n3 + 2], nArray4[n3 + 3], 8);
                break;
            }
            default: {
                throw new Error("Unrecognised " + n4);
            }
        }
    }

    private static final int divide2(int n) {
        if (n < 0) {
            return n / 2 - (n & 1);
        }
        return n / 2 + (n & 1);
    }

    public final void moveFromLast(int n, int n2, int[] nArray, int n3, boolean bl, boolean bl2, int n4, boolean[] blArray, int n5) {
        this.move(this.oldLuminance, this.oldRed, this.oldBlue, n, n2, nArray, n3, bl, bl2, n4, blArray, n5);
    }

    public final void moveFromNext(int n, int n2, int[] nArray, int n3, boolean bl, boolean bl2, int n4, boolean[] blArray, int n5) {
        this.move(this.nextPLuminance, this.nextPRed, this.nextPBlue, n, n2, nArray, n3, bl, bl2, n4, blArray, n5);
    }

    public final void endIPFrame() {
        int[] nArray = this.oldLuminance;
        this.oldLuminance = this.nextPLuminance;
        this.nextPLuminance = this.luminance;
        this.luminance = nArray;
        nArray = this.oldRed;
        this.oldRed = this.nextPRed;
        this.nextPRed = this.red;
        this.red = nArray;
        nArray = this.oldBlue;
        this.oldBlue = this.nextPBlue;
        this.nextPBlue = this.blue;
        this.blue = nArray;
    }

    public final void endBFrame() {
    }

    public final void endFrame() {
        int[] nArray = this.oldLuminance;
        this.oldLuminance = this.luminance;
        this.luminance = nArray;
        nArray = this.oldRed;
        this.oldRed = this.red;
        this.red = nArray;
        nArray = this.oldBlue;
        this.oldBlue = this.blue;
        this.blue = nArray;
    }

    public void showNextScreen(Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        if (nArray == null || nArray.length < this.displayX * this.displayY) {
            nArray = new int[this.displayX * this.displayY];
            buffer.setData((Object)nArray);
        }
        buffer.setLength(nArray.length);
        int n = 0;
        int n2 = this.displayY + 16;
        int n3 = this.displayX + 16;
        for (int i = 16; i < n2; i += 2) {
            int n4 = this.screenX * i;
            int n5 = this.screenX * (i + 1);
            int n6 = i / 2 * this.chromX;
            int n7 = 8;
            for (int j = 16; j < n3; j += 2) {
                int n8 = DisplayOutput.crop(this.nextPRed[n7 + n6]) - 128;
                int n9 = DisplayOutput.crop(this.nextPBlue[n7++ + n6]) - 128;
                int n10 = (int)((float)n9 * 0.21292114f + (float)n8 * 0.5325775f);
                n8 = (int)((float)n8 * 1.7929688f);
                n9 = (int)((float)n9 * 2.1126099f);
                int n11 = (int)((float)(this.nextPLuminance[j + n4] - 16) * 1.1643829f);
                int n12 = (int)((float)(this.nextPLuminance[j + n5] - 16) * 1.1643829f);
                int n13 = (int)((float)(this.nextPLuminance[j + 1 + n4] - 16) * 1.1643829f);
                int n14 = (int)((float)(this.nextPLuminance[j + 1 + n5] - 16) * 1.1643829f);
                nArray[n] = DisplayOutput.crop(n11 + n8) << 16 | DisplayOutput.crop(n11 - n10) << 8 | DisplayOutput.crop(n11 + n9);
                nArray[n + 1] = DisplayOutput.crop(n13 + n8) << 16 | DisplayOutput.crop(n13 - n10) << 8 | DisplayOutput.crop(n13 + n9);
                nArray[n + this.displayX] = DisplayOutput.crop(n12 + n8) << 16 | DisplayOutput.crop(n12 - n10) << 8 | DisplayOutput.crop(n12 + n9);
                nArray[n + this.displayX + 1] = DisplayOutput.crop(n14 + n8) << 16 | DisplayOutput.crop(n14 - n10) << 8 | DisplayOutput.crop(n14 + n9);
                n += 2;
            }
            n += this.displayX;
        }
    }

    public void showScreen(Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        if (nArray == null || nArray.length < this.displayX * this.displayY) {
            nArray = new int[this.displayX * this.displayY];
            buffer.setData((Object)nArray);
        }
        buffer.setLength(nArray.length);
        int n = 0;
        int n2 = this.displayY + 16;
        int n3 = this.displayX + 16;
        for (int i = 16; i < n2; i += 2) {
            int n4 = this.screenX * i;
            int n5 = this.screenX * (i + 1);
            int n6 = i / 2 * this.chromX;
            int n7 = 8;
            for (int j = 16; j < n3; j += 2) {
                int n8 = DisplayOutput.crop(this.red[n7 + n6]) - 128;
                int n9 = DisplayOutput.crop(this.blue[n7++ + n6]) - 128;
                int n10 = (int)((float)n9 * 0.21292114f + (float)n8 * 0.5325775f);
                n8 = (int)((float)n8 * 1.7929688f);
                n9 = (int)((float)n9 * 2.1126099f);
                int n11 = (int)((float)(this.luminance[j + n4] - 16) * 1.1643829f);
                int n12 = (int)((float)(this.luminance[j + n5] - 16) * 1.1643829f);
                int n13 = (int)((float)(this.luminance[j + 1 + n4] - 16) * 1.1643829f);
                int n14 = (int)((float)(this.luminance[j + 1 + n5] - 16) * 1.1643829f);
                nArray[n] = DisplayOutput.crop(n11 + n8) << 16 | DisplayOutput.crop(n11 - n10) << 8 | DisplayOutput.crop(n11 + n9);
                nArray[n + 1] = DisplayOutput.crop(n13 + n8) << 16 | DisplayOutput.crop(n13 - n10) << 8 | DisplayOutput.crop(n13 + n9);
                nArray[n + this.displayX] = DisplayOutput.crop(n12 + n8) << 16 | DisplayOutput.crop(n12 - n10) << 8 | DisplayOutput.crop(n12 + n9);
                nArray[n + this.displayX + 1] = DisplayOutput.crop(n14 + n8) << 16 | DisplayOutput.crop(n14 - n10) << 8 | DisplayOutput.crop(n14 + n9);
                n += 2;
            }
            n += this.displayX;
        }
    }

    public void dumpMB(int n, int n2) {
        int n3;
        int n4;
        System.out.println("x " + n++ + ", y " + n2++);
        for (n4 = n2 * 16; n4 < n2 * 16 + 16; ++n4) {
            for (n3 = n * 16; n3 < n * 16 + 16; ++n3) {
                System.out.print(this.luminance[n3 + n4 * this.screenX] + " ");
            }
            System.out.println();
        }
        System.out.println();
        for (n4 = n2 * 8; n4 < n2 * 8 + 8; n4 += 2) {
            for (n3 = n * 8; n3 < n * 8 + 8; ++n3) {
                System.out.print(this.blue[n3 + n4 * this.chromX] + " ");
            }
            System.out.println();
        }
        System.out.println();
        for (n4 = n2 * 8; n4 < n2 * 8 + 8; n4 += 2) {
            for (n3 = n * 8; n3 < n * 8 + 8; ++n3) {
                System.out.print(this.red[n3 + n4 * this.chromX] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }
}

