/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.Hashtable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private int[][] glyphIndexToChar;
    private int[] glyphToIndex;
    private int winScore = 0;
    private int macScore = 0;
    int segCount = 0;
    int fontMapping = 0;
    int[] endCode;
    int[] startCode;
    int[] idDelta;
    int[] idRangeOffset;
    int[] glyphIdArray;
    int[] f6glyphIdArray;
    int[] offset;
    private int[] CMAPformats;
    int[] platformID;
    private static Hashtable exceptions = new Hashtable();
    private int formatToUse;
    private int encodingToUse = 0;
    private static boolean WINchecked;

    public CMAP(FontFile2 fontFile2, int n, Glyf glyf) {
        if (n == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            int n2;
            fontFile2.getNextUint16();
            int n3 = fontFile2.getNextUint16();
            int[] nArray = new int[n3];
            this.platformID = new int[n3];
            int[] nArray2 = new int[n3];
            this.CMAPformats = new int[n3];
            this.glyphIndexToChar = new int[n3][256];
            this.glyphToIndex = new int[256];
            for (n2 = 0; n2 < n3; ++n2) {
                this.platformID[n2] = fontFile2.getNextUint16();
                nArray2[n2] = fontFile2.getNextUint16();
                nArray[n2] = fontFile2.getNextUint32();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                int n5;
                int n6;
                fontFile2.selectTable(2);
                fontFile2.skip(nArray[n2]);
                this.CMAPformats[n2] = fontFile2.getNextUint16();
                int n7 = fontFile2.getNextUint16();
                fontFile2.getNextUint16();
                if (this.CMAPformats[n2] == 0 && n7 == 262) {
                    StandardFonts.checkLoaded(2);
                    StandardFonts.checkLoaded(0);
                    for (n6 = 0; n6 < 256; ++n6) {
                        this.glyphIndexToChar[n2][n6] = n5 = fontFile2.getNextUint8();
                        this.glyphToIndex[n5] = n6;
                        if (n5 <= 0) continue;
                        if (StandardFonts.isValidMacEncoding(n6)) {
                            ++this.macScore;
                        }
                        if (!StandardFonts.isValidWinEncoding(n6)) continue;
                        ++this.winScore;
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 4) {
                    this.segCount = fontFile2.getNextUint16() / 2;
                    fontFile2.getNextUint16();
                    fontFile2.getNextUint16();
                    fontFile2.getNextUint16();
                    this.endCode = new int[this.segCount];
                    for (n6 = 0; n6 < this.segCount; ++n6) {
                        this.endCode[n6] = fontFile2.getNextUint16();
                    }
                    fontFile2.getNextUint16();
                    this.startCode = new int[this.segCount];
                    for (n6 = 0; n6 < this.segCount; ++n6) {
                        this.startCode[n6] = fontFile2.getNextUint16();
                    }
                    this.idDelta = new int[this.segCount];
                    for (n6 = 0; n6 < this.segCount; ++n6) {
                        this.idDelta[n6] = fontFile2.getNextUint16();
                    }
                    this.idRangeOffset = new int[this.segCount];
                    for (n6 = 0; n6 < this.segCount; ++n6) {
                        this.idRangeOffset[n6] = fontFile2.getNextUint16();
                    }
                    this.offset = new int[this.segCount];
                    n6 = 0;
                    n5 = 0;
                    for (n4 = 0; n4 < this.segCount; ++n4) {
                        if (this.idDelta[n4] != 0 || this.startCode[n4] == this.endCode[n4]) continue;
                        this.offset[n4] = n5;
                        n6 = 1 + this.endCode[n4] - this.startCode[n4];
                        n5 += n6;
                    }
                    n4 = (n7 - 16 - this.segCount * 8) / 2;
                    this.glyphIdArray = new int[n4];
                    for (int i = 0; i < n4; ++i) {
                        this.glyphIdArray[i] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                if (this.CMAPformats[n2] == 6) {
                    n6 = fontFile2.getNextUint16();
                    n5 = fontFile2.getNextUint16();
                    this.f6glyphIdArray = new int[n6 + n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.f6glyphIdArray[n4 + n6] = fontFile2.getNextUint16();
                    }
                    continue;
                }
                this.CMAPformats[n2] = -1;
            }
        }
    }

    public int convertIndexToCharacterCode(String string, int n, boolean bl, boolean bl2) {
        int n2 = -1;
        if ((this.fontMapping == 1 || !bl && this.fontMapping == 4) && string != null && !string.equals("notdef")) {
            n = StandardFonts.getAdobeMap(string);
        } else if (this.fontMapping == 2) {
            StandardFonts.checkLoaded(this.encodingToUse);
            if (this.encodingToUse == 0) {
                Object var7_6 = null;
                if (string != null) {
                    var7_6 = exceptions.get(string);
                }
                if (var7_6 == null) {
                    if (string != null && !bl2) {
                        n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
                    }
                } else {
                    try {
                        n = Integer.parseInt(var7_6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null) {
                    if (!WINchecked) {
                        StandardFonts.checkLoaded(2);
                        WINchecked = true;
                    }
                    n2 = StandardFonts.lookupCharacterIndex(string, 2);
                }
            } else if (string != null) {
                n = StandardFonts.lookupCharacterIndex(string, this.encodingToUse);
            }
        }
        int n3 = -1;
        int n4 = this.CMAPformats[this.formatToUse];
        if (bl & n4 > 0 && n4 != 6) {
            n += 61440;
        }
        if (n4 == 0) {
            if (n > 255) {
                n = 0;
            }
            if ((n3 = this.glyphIndexToChar[this.formatToUse][n]) == 0 & n2 != -1) {
                n3 = this.glyphIndexToChar[this.formatToUse][n2];
            }
        } else if (n4 == 4) {
            for (int i = 0; i < this.segCount; ++i) {
                if (this.endCode[i] < n || this.startCode[i] > n) continue;
                int n5 = 0;
                if (this.idRangeOffset[i] == 0) {
                    n3 = (this.idDelta[i] + n) % 65536;
                    i = this.segCount;
                    continue;
                }
                n5 = this.offset[i] + (n - this.startCode[i]);
                n3 = this.glyphIdArray[n5];
                i = this.segCount;
            }
        } else if (n4 == 6) {
            n3 = n >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[n];
        } else {
            System.err.println("Cmap " + n4 + "not supported");
            n3 = n;
        }
        return n3;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        this.formatToUse = -1;
        int n4 = this.platformID.length;
        if (!(bl2 || this.macScore >= 207 || this.glyphToIndex != null && this.macScore > 205 && this.glyphToIndex[138] != 0 && this.glyphToIndex[228] == 0)) {
            if (n4 > 0 && this.winScore > this.macScore) {
                this.encodingToUse = 2;
            }
            if (this.macScore > 80 && bl && n == 2 && this.winScore >= this.macScore) {
                this.encodingToUse = 2;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.platformID[n3] != 3 || this.CMAPformats[n3] != 1) continue;
            this.formatToUse = n3;
            this.fontMapping = 1;
            n3 = n4;
        }
        if (this.formatToUse == -1 && !bl3 && !bl2) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.platformID[n3] != 1 || this.CMAPformats[n3] != 0) continue;
                this.formatToUse = n3;
                this.fontMapping = bl || n == 2 ? 2 : 3;
                n3 = n4;
            }
        }
        n3 = 0;
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 6) continue;
                this.formatToUse = n2;
                if (!bl && n == 2) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                n3 = 1;
                n2 = n4;
            }
        }
        if (this.formatToUse == -1 || n3 != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 4) continue;
                this.formatToUse = n2;
                this.fontMapping = 4;
                n2 = n4;
            }
        }
        if (n == 5) {
            this.fontMapping = 2;
        }
    }

    static {
        String[] stringArray = new String[]{"notequal", "173", "infinity", "176", "lessequal", "178", "greaterequal", "179", "partialdiff", "182", "summation", "183", "product", "184", "pi", "185", "integral", "186", "Omega", "189", "radical", "195", "approxequal", "197", "Delta", "198", "lozenge", "215", "Euro", "219", "apple", "240"};
        for (int i = 0; i < stringArray.length; i += 2) {
            exceptions.put(stringArray[i], stringArray[i + 1]);
        }
    }
}

