/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateConverter {
    private static final SimpleDateFormat PDF_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public String toString(Calendar date) {
        return "D:" + PDF_DATE_FORMAT.format(date.getTime());
    }

    public Calendar toCalendar(String date) throws IOException {
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            if (date.startsWith("D:")) {
                date = date.substring(2, date.length());
            }
            if (date.length() < 4) {
                throw new IOException("Error: Invalid date format '" + date + "'");
            }
            year = Integer.parseInt(date.substring(0, 4));
            if (date.length() >= 6) {
                month = Integer.parseInt(date.substring(4, 6));
            }
            if (date.length() >= 8) {
                day = Integer.parseInt(date.substring(6, 8));
            }
            if (date.length() >= 10) {
                hour = Integer.parseInt(date.substring(8, 10));
            }
            if (date.length() >= 12) {
                minute = Integer.parseInt(date.substring(10, 12));
            }
            if (date.length() >= 14) {
                second = Integer.parseInt(date.substring(12, 14));
            }
            return new GregorianCalendar(year, month - 1, day, hour, minute, second);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toISO8601(Calendar cal) {
        StringBuffer retval = new StringBuffer();
        retval.append(ISO_8601_DATE_FORMAT.format(cal.getTime()));
        int timeZone = cal.get(15);
        if (timeZone < 0) {
            retval.append("-");
        } else {
            retval.append("+");
        }
        timeZone = Math.abs(timeZone);
        int hours = timeZone / 1000 / 60 / 60;
        int minutes = (timeZone - hours * 1000 * 60 * 60) / 1000 / 1000;
        if (hours < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(hours));
        retval.append(":");
        if (minutes < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(minutes));
        return retval.toString();
    }
}

