/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.searchengine.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.HTMLDocument;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.pdfbox.searchengine.lucene.LucenePDFDocument;

public class IndexFiles {
    private boolean deleting = false;
    private IndexReader reader;
    private IndexWriter writer;
    private TermEnum uidIter;

    public static void main(String[] argv) {
        String index = "index";
        boolean create = false;
        File root = null;
        String usage = "org.pdfbox.searchengine.lucene.IndexFiles [-create] [-index <index>] <root_directory>";
        if (argv.length == 0) {
            System.err.println("Usage: " + usage);
            return;
        }
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-index")) {
                index = argv[++i];
                continue;
            }
            if (argv[i].equals("-create")) {
                create = true;
                continue;
            }
            if (i != argv.length - 1) {
                System.err.println("Usage: " + usage);
                return;
            }
            System.out.println("root=" + argv[i]);
            root = new File(argv[i]);
        }
        IndexFiles indexer = new IndexFiles();
        indexer.index(root, create, index);
    }

    public void index(File root, boolean create, String index) {
        try {
            Date start = new Date();
            this.writer = new IndexWriter(index, (Analyzer)new StandardAnalyzer(), create);
            this.writer.maxFieldLength = 1000000;
            if (!create) {
                this.deleting = true;
                this.indexDocs(root, index, create);
            }
            this.indexDocs(root, index, create);
            System.out.println("Optimizing index...");
            this.writer.optimize();
            this.writer.close();
            Date end = new Date();
            System.out.print(end.getTime() - start.getTime());
            System.out.println(" total milliseconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void indexDocs(File file, String index, boolean create) throws Exception {
        if (!create) {
            this.reader = IndexReader.open((String)index);
            this.uidIter = this.reader.terms(new Term("uid", ""));
            this.indexDocs(file);
            if (this.deleting) {
                while (this.uidIter.term() != null && this.uidIter.term().field().equals("uid")) {
                    System.out.println("deleting " + HTMLDocument.uid2url((String)this.uidIter.term().text()));
                    this.reader.delete(this.uidIter.term());
                    this.uidIter.next();
                }
                this.deleting = false;
            }
            this.uidIter.close();
            this.reader.close();
        } else {
            this.indexDocs(file);
        }
    }

    private void indexDocs(File file) throws Exception {
        block6: {
            block7: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    Object[] files = file.list();
                    Arrays.sort(files);
                    for (int i = 0; i < files.length; ++i) {
                        this.indexDocs(new File(file, (String)files[i]));
                    }
                    break block6;
                }
                if (this.uidIter == null) break block7;
                String uid = HTMLDocument.uid((File)file);
                while (this.uidIter.term() != null && this.uidIter.term().field().equals("uid") && this.uidIter.term().text().compareTo(uid) < 0) {
                    if (this.deleting) {
                        System.out.println("deleting " + HTMLDocument.uid2url((String)this.uidIter.term().text()));
                        this.reader.delete(this.uidIter.term());
                    }
                    this.uidIter.next();
                }
                if (this.uidIter.term() == null || !this.uidIter.term().field().equals("uid") || this.uidIter.term().text().compareTo(uid) != 0) break block6;
                System.out.println("Next uid=" + this.uidIter);
                this.uidIter.next();
                break block6;
            }
            try {
                this.addDocument(file);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void addDocument(File file) throws IOException, InterruptedException {
        String path = file.getName().toUpperCase();
        Document doc = null;
        if (path.endsWith(".HTML") || path.endsWith(".HTM") || path.endsWith(".TXT")) {
            System.out.println("Indexing Text document: " + file);
            doc = HTMLDocument.Document((File)file);
        } else if (path.endsWith(".PDF")) {
            System.out.println("Indexing PDF document: " + file);
            doc = LucenePDFDocument.getDocument(file);
        } else {
            System.out.println("Skipping " + file);
        }
        if (doc != null) {
            this.writer.addDocument(doc);
        }
    }
}

