/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLRangeEvent;
import oracle.xml.parser.v2.XMLRangeException;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

class XMLRange
implements Range,
EventListener {
    XMLNode startContainer;
    XMLNode endContainer;
    XMLDocument ownerDoc;
    int startOffset;
    int endOffset;
    int difOffset;
    boolean isTextNodeInserted;
    boolean collapsed;
    XMLNode commonAncestorContainer;
    boolean valid;
    XMLRange next;
    XMLRange previous;
    boolean mutation;

    XMLRange() {
    }

    void init(Node node, Node node2, int n, int n2, Document document) {
        this.startContainer = (XMLNode)node;
        this.endContainer = (XMLNode)node2;
        this.startOffset = n;
        this.endOffset = n2;
        this.difOffset = n2 - n;
        this.isTextNodeInserted = false;
        this.ownerDoc = (XMLDocument)document;
        this.valid = true;
        this.setCommonAncestorContainer(true);
        this.next = null;
        this.previous = null;
        this.collapsed = true;
        this.mutation = true;
    }

    public void setStart(Node node, int n) throws DOMException, RangeException {
        this.validateBoundary(node, n);
        this.startContainer = (XMLNode)node;
        this.startOffset = n;
        this.setCommonAncestorContainer(true);
    }

    public void setEnd(Node node, int n) {
        this.validateBoundary(node, n);
        this.endContainer = (XMLNode)node;
        this.endOffset = n;
        this.setCommonAncestorContainer(false);
    }

    void validateBoundary(Node node, int n) {
        short s = node.getNodeType();
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.checkType((XMLNode)node);
        this.validateBoundaryPoint(node, n);
    }

    void validateBoundaryPoint(Node node, int n) {
        short s = node.getNodeType();
        int n2 = 0;
        if (s == 3 || s == 8 || s == 7) {
            n2 = ((CharData)node).getLength();
        } else {
            NodeList nodeList = node.getChildNodes();
            n2 = nodeList.getLength();
        }
        if (n < 0 || n > n2) {
            throw new XMLDOMException(1, 21001, XMLDocument.defErr, String.valueOf(n), String.valueOf(n2));
        }
    }

    void checkAncestorType(XMLNode xMLNode) {
        XMLNode xMLNode2;
        short s = xMLNode.getNodeType();
        if (s == 9 || s == 11 || s == 2 || s == 6 || s == 12) {
            throw new XMLRangeException(2);
        }
        XMLNode xMLNode3 = xMLNode2 = (XMLNode)xMLNode.getParentNode();
        while (xMLNode2 != null) {
            xMLNode3 = xMLNode2;
            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
        }
        s = xMLNode3.getNodeType();
        if (s != 9 && s != 11 && s != 2 && s != 6 && s != 12) {
            throw new XMLRangeException(2);
        }
    }

    int getPosition(Node node) {
        XMLNode xMLNode = (XMLNode)node.getParentNode();
        NodeList nodeList = xMLNode.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        for (Node node2 = nodeList.item(0); node2 != null; node2 = node2.getNextSibling()) {
            if (node == node2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void set(Node node, int n, boolean bl) throws DOMException, RangeException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.checkAncestorType((XMLNode)node);
        int n2 = this.getPosition(node);
        int n3 = n2 + n;
        Node node2 = node.getParentNode();
        this.validateBoundaryPoint(node2, n3);
        if (bl) {
            this.startContainer = (XMLNode)node2;
            this.startOffset = n3;
            this.setCommonAncestorContainer(true);
        } else {
            this.endContainer = (XMLNode)node2;
            this.endOffset = n3;
            this.setCommonAncestorContainer(false);
        }
    }

    public void setStartBefore(Node node) throws DOMException, RangeException {
        this.set(node, 0, true);
    }

    public void setStartAfter(Node node) throws DOMException, RangeException {
        this.set(node, 1, true);
    }

    public void setEndBefore(Node node) throws DOMException, RangeException {
        this.set(node, 0, false);
    }

    public void setEndAfter(Node node) throws DOMException, RangeException {
        this.set(node, 1, false);
    }

    public void detach() {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        this.valid = false;
        this.startContainer = null;
        this.endContainer = null;
        this.commonAncestorContainer = null;
        this.ownerDoc = null;
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        this.next = null;
        this.previous = null;
    }

    public void collapse(boolean bl) {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (bl) {
            this.endContainer = this.startContainer;
            this.endOffset = this.startOffset;
        } else {
            this.startContainer = this.endContainer;
            this.startOffset = this.endOffset;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = true;
    }

    public Range cloneRange() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        XMLRange xMLRange = (XMLRange)this.ownerDoc.createRange();
        xMLRange.setStart(this.startContainer, this.startOffset);
        xMLRange.setEnd(this.endContainer, this.endOffset);
        return xMLRange;
    }

    public void deleteContents() throws DOMException {
        this.deleteContents(null);
    }

    void delete_when_StartEqualToEnd(DocumentFragment documentFragment) {
        short s = this.startContainer.getNodeType();
        if (s == 3 || s == 8 || s == 7) {
            this.mutation = false;
            String string = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(string.substring(0, this.startOffset) + string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLText xMLText = (XMLText)this.startContainer.cloneNode(true);
                xMLText.setNodeValue(string.substring(this.startOffset, this.endOffset));
                documentFragment.appendChild(xMLText);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.startContainer.getChildNodes();
            int n = this.startOffset;
            Node node = nodeList.item(n);
            Node node2 = node.getNextSibling();
            while (n < this.endOffset) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                if ((node = node2) == null) break;
                node2 = node2.getNextSibling();
            }
        }
        this.collapse(true);
    }

    void delete_when_StartAncestorOfEnd(DocumentFragment documentFragment) {
        Object object;
        Object object2;
        short s = this.startContainer.getNodeType();
        Node node = null;
        Node node2 = null;
        if (s == 3 || s == 8 || s == 7) {
            this.mutation = false;
            object2 = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object2).substring(0, this.startOffset));
            if (documentFragment != null) {
                object = (XMLNode)this.startContainer.cloneNode(true);
                ((XMLNode)object).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
                documentFragment.appendChild((Node)object);
            }
            this.mutation = true;
        } else {
            object2 = this.startContainer.getChildNodes();
            node = object2.item(this.startOffset);
            node2 = node.getNextSibling();
            while (this.selectivity((XMLNode)node) < 1) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = node2;
                node2 = node2.getNextSibling();
            }
        }
        object2 = null;
        object = null;
        Node node3 = null;
        if (node != this.endContainer) {
            for (node2 = this.endContainer.getParentNode(); node2 != node; node2 = node2.getParentNode()) {
                object = object2 = node2.getPreviousSibling();
                if (object2 != null) {
                    node3 = object2.getPreviousSibling();
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    if (documentFragment != null) {
                        documentFragment.appendChild((Node)object2);
                    }
                }
                object2 = node3;
                if (node3 != null) {
                    node3 = node3.getPreviousSibling();
                }
                while (object2 != null) {
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    documentFragment.insertBefore((Node)object2, (Node)object);
                    object2 = node3;
                    if (node3 == null) continue;
                    node3 = node3.getPreviousSibling();
                }
            }
        }
        if ((s = this.endContainer.getNodeType()) == 3 || s == 8 || s == 7) {
            this.mutation = false;
            String string = this.endContainer.getNodeValue();
            this.endContainer.setNodeValue(string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
                xMLNode.setNodeValue(string.substring(0, this.endOffset));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n = this.endOffset - 1;
            node = nodeList.item(n);
            node2 = node.getPreviousSibling();
            while (node != null) {
                node = node.getParentNode().removeChild(node);
                documentFragment.appendChild(node);
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getPreviousSibling();
            }
        }
        this.collapse(true);
    }

    void delete_when_EndAncestorOfStart(DocumentFragment documentFragment) {
        Object object;
        short s = this.startContainer.getNodeType();
        Node node = null;
        Object object2 = null;
        Object object3 = null;
        if (s == 3 || s == 8 || s == 7) {
            this.mutation = false;
            object = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object).substring(0, this.startOffset));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.startContainer.cloneNode(true);
                xMLNode.setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            object = this.startContainer.getChildNodes();
            node = object.item(this.startOffset);
            if (node != null) {
                object2 = node.getNextSibling();
            }
            while (node != null) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = object2;
                if (object2 == null) continue;
                object2 = object2.getNextSibling();
            }
        }
        node = this.startContainer;
        object3 = null;
        object = null;
        for (object2 = this.startContainer.getParentNode(); object2 != this.commonAncestorContainer; object2 = object2.getParentNode()) {
            object3 = node.getNextSibling();
            if (object3 != null) {
                object = object3.getNextSibling();
            }
            while (object3 != null) {
                object3.getParentNode().removeChild((Node)object3);
                if (documentFragment != null) {
                    documentFragment.appendChild((Node)object3);
                }
                object3 = object;
                if (object == null) continue;
                object = object.getNextSibling();
            }
            node = node.getParentNode();
        }
        int n = this.getPosition(node) + 1;
        if ((object2 = object2.getNextSibling()) != null) {
            object = object2.getNextSibling();
        }
        while (n < this.endOffset) {
            object2.getParentNode().removeChild((Node)object2);
            if (documentFragment != null) {
                documentFragment.appendChild((Node)object2);
            }
            object2 = object;
            if (object == null) continue;
            object = object.getNextSibling();
        }
        this.collapse(true);
    }

    void delete(DocumentFragment documentFragment) {
        Object object;
        Object object2;
        short s = this.startContainer.getNodeType();
        Node node = null;
        Node node2 = null;
        if (s == 3 || s == 8 || s == 7) {
            this.mutation = false;
            object2 = this.startContainer.getNodeValue();
            this.startContainer.setNodeValue(((String)object2).substring(0, this.startOffset));
            if (documentFragment != null) {
                object = (XMLNode)this.startContainer.cloneNode(true);
                ((XMLNode)object).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
                documentFragment.appendChild((Node)object);
            }
            this.mutation = true;
        } else {
            object2 = this.startContainer.getChildNodes();
            node = object2.item(this.startOffset);
            node2 = node.getNextSibling();
            while (node != null) {
                this.startContainer.removeChild(node);
                if (documentFragment != null) {
                    documentFragment.appendChild(node);
                }
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getNextSibling();
            }
        }
        node = this.startContainer;
        object2 = null;
        object = null;
        for (node2 = this.startContainer.getParentNode(); node2 != this.commonAncestorContainer; node2 = node2.getParentNode()) {
            object2 = node.getNextSibling();
            if (object2 != null) {
                object = object2.getNextSibling();
            }
            while (object2 != null) {
                object2.getParentNode().removeChild((Node)object2);
                if (documentFragment != null) {
                    documentFragment.appendChild((Node)object2);
                }
                object2 = object;
                if (object == null) continue;
                object = object.getNextSibling();
            }
            node = node.getParentNode();
        }
        Node node3 = null;
        if (node != this.endContainer) {
            for (node2 = this.endContainer.getParentNode(); node2 != node; node2 = node2.getParentNode()) {
                object = object2 = node2.getPreviousSibling();
                if (object2 != null) {
                    node3 = object2.getPreviousSibling();
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    if (documentFragment != null) {
                        documentFragment.appendChild((Node)object2);
                    }
                }
                object2 = node3;
                if (node3 != null) {
                    node3 = node3.getPreviousSibling();
                }
                while (object2 != null) {
                    object2 = object2.getParentNode().removeChild((Node)object2);
                    documentFragment.insertBefore((Node)object2, (Node)object);
                    object2 = node3;
                    if (node3 == null) continue;
                    node3 = node3.getPreviousSibling();
                }
            }
        }
        if ((s = this.endContainer.getNodeType()) == 3 || s == 8 || s == 7) {
            this.mutation = false;
            String string = this.endContainer.getNodeValue();
            this.endContainer.setNodeValue(string.substring(this.endOffset, string.length()));
            if (documentFragment != null) {
                XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
                xMLNode.setNodeValue(string.substring(0, this.endOffset));
                documentFragment.appendChild(xMLNode);
            }
            this.mutation = true;
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n = this.endOffset - 1;
            node = nodeList.item(n);
            node2 = node.getPreviousSibling();
            while (node != null) {
                node = node.getParentNode().removeChild(node);
                documentFragment.appendChild(node);
                node = node2;
                if (node2 == null) continue;
                node2 = node2.getPreviousSibling();
            }
        }
        this.collapse(true);
    }

    void deleteContents(DocumentFragment documentFragment) throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (this.collapsed) {
            return;
        }
        if (this.startContainer == this.endContainer) {
            this.delete_when_StartEqualToEnd(documentFragment);
            return;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.delete_when_StartAncestorOfEnd(documentFragment);
            return;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.delete_when_EndAncestorOfStart(documentFragment);
            return;
        }
        this.delete(documentFragment);
    }

    int selectivity(XMLNode xMLNode) {
        XMLNode xMLNode2;
        int n = 0;
        for (xMLNode2 = this.startContainer; xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getParentNode()) {
            if (xMLNode != xMLNode2) continue;
            ++n;
            break;
        }
        for (xMLNode2 = this.endContainer; xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getParentNode()) {
            if (xMLNode != xMLNode2) continue;
            ++n;
            break;
        }
        return n;
    }

    public DocumentFragment extractContents() {
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.ownerDoc.createDocumentFragment();
        this.deleteContents(xMLDocumentFragment);
        return xMLDocumentFragment;
    }

    int depth(Node node) {
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            if ((node2 = node2.getParentNode()) != null) {
                this.checkType((XMLNode)node2);
            }
            ++n;
        }
        return n;
    }

    void setCommonAncestorContainer_when_StartEqualToEnd(boolean bl) {
        if (this.startOffset >= this.endOffset) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer_when_StartAncestorOfEnd(boolean bl) {
        Node node = this.endContainer;
        for (Node node2 = this.endContainer.getParentNode(); node2 != this.startContainer; node2 = node2.getParentNode()) {
            node = node2;
        }
        int n = this.getPosition(node);
        if (n < this.startOffset) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.startContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer_when_EndAncestorOfStart(boolean bl) {
        Node node = this.startContainer;
        for (Node node2 = this.startContainer.getParentNode(); node2 != this.endContainer; node2 = node2.getParentNode()) {
            node = node2;
        }
        int n = this.getPosition(node);
        if (n > this.endOffset - 1) {
            this.collapse(bl);
            return;
        }
        this.commonAncestorContainer = this.endContainer;
        this.collapsed = false;
    }

    void setCommonAncestorContainer(boolean bl) throws RangeException, DOMException {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.startContainer == this.endContainer) {
            this.setCommonAncestorContainer_when_StartEqualToEnd(bl);
            return;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.setCommonAncestorContainer_when_StartAncestorOfEnd(bl);
            return;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.setCommonAncestorContainer_when_EndAncestorOfStart(bl);
            return;
        }
        XMLNode xMLNode = this.startContainer;
        XMLNode xMLNode2 = this.endContainer;
        XMLNode xMLNode3 = null;
        XMLNode xMLNode4 = null;
        int n5 = this.depth(this.startContainer);
        if (n5 > (n4 = this.depth(this.endContainer))) {
            n3 = n5 - n4;
            n2 = n4;
            xMLNode = this.startContainer;
            xMLNode2 = this.endContainer;
            for (n = 0; n < n3; ++n) {
                xMLNode3 = xMLNode;
                xMLNode = (XMLNode)xMLNode.getParentNode();
            }
        } else if (n5 < n4) {
            n3 = n4 - n5;
            n2 = n5;
            xMLNode2 = this.endContainer;
            xMLNode = this.startContainer;
            for (n = 0; n < n3; ++n) {
                xMLNode4 = xMLNode2;
                xMLNode2 = (XMLNode)xMLNode2.getParentNode();
            }
        } else {
            xMLNode = this.startContainer;
            xMLNode2 = this.endContainer;
            n2 = n5;
        }
        n = 0;
        while (n <= n2) {
            if (xMLNode == xMLNode2) {
                if (this.getPosition(xMLNode3) > this.getPosition(xMLNode4)) {
                    this.collapse(bl);
                    return;
                }
                this.commonAncestorContainer = xMLNode;
                this.collapsed = false;
                return;
            }
            ++n;
            xMLNode3 = xMLNode;
            xMLNode4 = xMLNode2;
            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
            xMLNode = (XMLNode)xMLNode.getParentNode();
        }
        this.collapse(bl);
    }

    public Node getCommonAncestorContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.commonAncestorContainer;
    }

    public boolean getCollapsed() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.collapsed;
    }

    public Node getEndContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.endContainer;
    }

    public Node getStartContainer() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.startContainer;
    }

    public int getStartOffset() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.startOffset;
    }

    public int getEndOffset() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        return this.endOffset;
    }

    public short compareBoundaryPoints(short s, Range range) {
        XMLNode xMLNode = null;
        XMLNode xMLNode2 = null;
        int n = 0;
        int n2 = 0;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (this.getRootContainer() != ((XMLRange)range).getRootContainer()) {
            throw new XMLDOMException(4, 21006, XMLDocument.defErr);
        }
        if (s == 0) {
            xMLNode2 = this.startContainer;
            xMLNode = ((XMLRange)range).startContainer;
            n = this.startOffset;
            n2 = ((XMLRange)range).startOffset;
        } else if (s == 1) {
            xMLNode2 = this.startContainer;
            xMLNode = ((XMLRange)range).endContainer;
            n = this.startOffset;
            n2 = ((XMLRange)range).endOffset;
        } else if (s == 2) {
            xMLNode2 = this.endContainer;
            xMLNode = ((XMLRange)range).endContainer;
            n = this.endOffset;
            n2 = ((XMLRange)range).endOffset;
        } else if (s == 3) {
            xMLNode2 = this.endContainer;
            xMLNode = ((XMLRange)range).startContainer;
            n = this.endOffset;
            n2 = ((XMLRange)range).startOffset;
        }
        if (xMLNode2 == xMLNode) {
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
        XMLNode xMLNode3 = xMLNode2;
        XMLNode xMLNode4 = null;
        while (xMLNode3 != null) {
            xMLNode4 = xMLNode3;
            if ((xMLNode3 = (XMLNode)xMLNode3.getParentNode()) != xMLNode) continue;
            int n3 = this.getPosition(xMLNode4);
            if (n3 < n2) {
                return -1;
            }
            return 1;
        }
        xMLNode3 = xMLNode;
        while (xMLNode3 != null) {
            xMLNode4 = xMLNode3;
            if ((xMLNode3 = (XMLNode)xMLNode3.getParentNode()) != xMLNode2) continue;
            int n4 = this.getPosition(xMLNode4);
            if (n <= n4) {
                return -1;
            }
            return 1;
        }
        xMLNode3 = xMLNode2;
        while (xMLNode3 != null) {
            if ((xMLNode3 = (XMLNode)xMLNode3.getSuccessor(this.getRootContainer(), true)) != xMLNode) continue;
            return -1;
        }
        return 1;
    }

    public void insertNode(Node node) throws DOMException, RangeException {
        XMLNode xMLNode = null;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        short s = node.getNodeType();
        if (s == 2 || s == 12 || s == 11 || s == 9) {
            throw new XMLRangeException(2);
        }
        s = this.startContainer.getNodeType();
        if (s == 3) {
            this.mutation = false;
            this.difOffset = this.endOffset - this.startOffset;
            XMLText xMLText = (XMLText)((XMLText)this.startContainer).splitText(this.startOffset);
            xMLNode = (XMLNode)xMLText.getParentNode();
            xMLNode.insertBefore(node, xMLText);
            this.startContainer = (XMLNode)xMLText.getPreviousSibling();
            this.startOffset = 0;
            this.mutation = true;
            this.isTextNodeInserted = true;
            this.collapsed = false;
        } else {
            NodeList nodeList = this.startContainer.getChildNodes();
            this.startContainer.insertBefore(node, nodeList.item(this.startOffset));
        }
    }

    public void selectNodeContents(Node node) throws DOMException, RangeException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        if (node.getNodeType() == 9) {
            throw new XMLRangeException(2);
        }
        for (XMLNode xMLNode = (XMLNode)node.getParentNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            this.checkType(xMLNode);
        }
        this.commonAncestorContainer = (XMLNode)node;
        this.startContainer = (XMLNode)node;
        this.endContainer = (XMLNode)node;
        this.startOffset = 0;
        short s = node.getNodeType();
        if (s == 3 || s == 8 || s == 7) {
            this.endOffset = ((CharData)node).getLength();
        } else {
            NodeList nodeList = node.getChildNodes();
            this.endOffset = nodeList.getLength();
        }
        this.collapsed = this.startOffset == this.endOffset;
    }

    public void selectNode(Node node) throws RangeException, DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        for (XMLNode xMLNode = (XMLNode)node; xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            this.checkType(xMLNode);
        }
        this.endContainer = this.startContainer = (XMLNode)node.getParentNode();
        this.commonAncestorContainer = this.startContainer;
        this.startOffset = this.getPosition(node);
        this.endOffset = this.startOffset + 1;
    }

    public String toString() throws DOMException {
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.cloneContents();
        if (xMLDocumentFragment != null) {
            return xMLDocumentFragment.getText();
        }
        return null;
    }

    void checkType(XMLNode xMLNode) throws RangeException {
        short s = xMLNode.getNodeType();
        if (s == 6 || s == 12 || s == 10) {
            throw new XMLRangeException(2);
        }
    }

    XMLNode getRootContainer() {
        XMLNode xMLNode;
        XMLNode xMLNode2 = xMLNode = this.startContainer;
        while (xMLNode != null) {
            xMLNode2 = xMLNode;
            xMLNode = (XMLNode)xMLNode.getParentNode();
        }
        return xMLNode2;
    }

    boolean isAncestor(XMLNode xMLNode, XMLNode xMLNode2) {
        for (XMLNode xMLNode3 = (XMLNode)xMLNode2.getParentNode(); xMLNode3 != null; xMLNode3 = (XMLNode)xMLNode3.getParentNode()) {
            if (xMLNode3 != xMLNode) continue;
            return true;
        }
        return false;
    }

    void clone_when_StartEqualToEnd(DocumentFragment documentFragment) {
        short s = this.startContainer.getNodeType();
        if (s == 3 || s == 8 || s == 7) {
            String string = this.startContainer.getNodeValue();
            XMLText xMLText = (XMLText)this.startContainer.cloneNode(true);
            xMLText.setNodeValue(string.substring(this.startOffset, this.endOffset));
            documentFragment.appendChild(xMLText);
        } else {
            int n;
            NodeList nodeList = this.startContainer.getChildNodes();
            Node node = nodeList.item(n);
            for (n = this.startOffset; n < this.endOffset; ++n) {
                documentFragment.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
        }
    }

    void clone_when_StartAncestorOfEnd(DocumentFragment documentFragment) {
        Node node;
        Object object;
        short s = this.startContainer.getNodeType();
        Node node2 = null;
        if (s == 3 || s == 8 || s == 7) {
            object = this.startContainer.getNodeValue();
            node = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node).setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
            documentFragment.appendChild(node);
        } else {
            object = this.startContainer.getChildNodes();
            node2 = object.item(this.startOffset);
            while (this.selectivity((XMLNode)node2) < 1) {
                documentFragment.appendChild(node2.cloneNode(true));
                node2 = node2.getNextSibling();
            }
        }
        node = null;
        Node node3 = null;
        if (node2 != this.endContainer) {
            for (object = this.endContainer.getParentNode(); object != node2; object = object.getParentNode()) {
                node3 = node = object.getPreviousSibling();
                if (node != null) {
                    documentFragment.appendChild(node.cloneNode(true));
                }
                for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
                    node3 = documentFragment.insertBefore(node.cloneNode(true), node3);
                }
            }
        }
        if ((s = this.endContainer.getNodeType()) == 3 || s == 8 || s == 7) {
            String string = this.endContainer.getNodeValue();
            XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
            xMLNode.setNodeValue(string.substring(0, this.endOffset));
            documentFragment.appendChild(xMLNode);
        } else {
            NodeList nodeList = this.endContainer.getChildNodes();
            int n = 0;
            for (Node node4 = nodeList.item(n); n < this.endOffset && node4 != null; node4 = node4.getNextSibling(), ++n) {
                documentFragment.appendChild(node4.cloneNode(true));
            }
        }
    }

    void clone_when_EndAncestorOfStart(DocumentFragment documentFragment) {
        Node node;
        Node node2;
        Object object;
        short s = this.startContainer.getNodeType();
        if (s == 3 || s == 8 || s == 7) {
            object = this.startContainer.getNodeValue();
            node2 = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node2).setNodeValue(((String)object).substring(this.startOffset, ((String)object).length()));
            documentFragment.appendChild(node2);
        } else {
            object = this.startContainer.getChildNodes();
            for (node = object.item(this.startOffset); node != null; node = node.getNextSibling()) {
                documentFragment.appendChild(node.cloneNode(true));
            }
        }
        node = this.startContainer;
        node2 = null;
        for (object = this.startContainer.getParentNode(); object != this.commonAncestorContainer; object = object.getParentNode()) {
            for (node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
                documentFragment.appendChild(node2.cloneNode(true));
            }
            node = node.getParentNode();
        }
        object = object.getNextSibling();
        for (int i = this.getPosition(node) + 1; i < this.endOffset; ++i) {
            documentFragment.appendChild(object.cloneNode(true));
            object = object.getNextSibling();
        }
    }

    void clone(DocumentFragment documentFragment) {
        Object object;
        Node node;
        Node node2;
        Object object2;
        short s = this.startContainer.getNodeType();
        if (s == 3 || s == 8 || s == 7) {
            object2 = this.startContainer.getNodeValue();
            node2 = (XMLNode)this.startContainer.cloneNode(true);
            ((XMLNode)node2).setNodeValue(((String)object2).substring(this.startOffset, ((String)object2).length()));
            documentFragment.appendChild(node2);
        } else {
            object2 = this.startContainer.getChildNodes();
            for (node = object2.item(this.startOffset); node != null; node = node.getNextSibling()) {
                documentFragment.appendChild(node.cloneNode(true));
            }
        }
        node = this.startContainer;
        node2 = null;
        for (object2 = this.startContainer.getParentNode(); object2 != this.commonAncestorContainer; object2 = object2.getParentNode()) {
            if (node != null) {
                node2 = node.getNextSibling();
            }
            while (node2 != null) {
                documentFragment.appendChild(node2.cloneNode(true));
                node2 = node2.getNextSibling();
            }
            node = node.getParentNode();
        }
        int n = this.getPosition(node) + 1;
        node = node.getNextSibling();
        while (this.selectivity((XMLNode)node) < 1) {
            documentFragment.appendChild(node.cloneNode(true));
            node = node.getNextSibling();
        }
        if (node != this.endContainer) {
            node2 = null;
            object = null;
            for (object2 = this.endContainer.getParentNode(); object2 != node; object2 = object2.getParentNode()) {
                node2 = object2.getPreviousSibling();
                object = node2;
                if (node2 != null) {
                    documentFragment.appendChild(node2.cloneNode(true));
                    node2 = node2.getPreviousSibling();
                }
                while (node2 != null) {
                    object = documentFragment.insertBefore(node2.cloneNode(true), (Node)object);
                    node2 = node2.getPreviousSibling();
                }
            }
        }
        if ((s = this.endContainer.getNodeType()) == 3 || s == 8 || s == 7) {
            object = this.endContainer.getNodeValue();
            XMLNode xMLNode = (XMLNode)this.endContainer.cloneNode(true);
            xMLNode.setNodeValue(((String)object).substring(0, this.endOffset));
            documentFragment.appendChild(xMLNode);
        } else {
            object = this.endContainer.getChildNodes();
            Node node3 = object.item(n);
            for (n = 0; n < this.endOffset; ++n) {
                documentFragment.appendChild(node3.cloneNode(true));
                node3 = node3.getNextSibling();
            }
        }
    }

    void clone_when_StartInsertedEnd_Text(DocumentFragment documentFragment) {
        short s = this.startContainer.getNodeType();
        if (s == 3) {
            XMLText xMLText;
            String string;
            XMLText xMLText2;
            for (xMLText2 = (XMLText)this.startContainer; xMLText2 != this.endContainer; xMLText2 = (XMLText)xMLText2.getNextSibling()) {
                string = xMLText2.getNodeValue();
                xMLText = (XMLText)xMLText2.cloneNode(true);
                xMLText.setNodeValue(string);
                documentFragment.appendChild(xMLText);
            }
            string = xMLText2.getNodeValue();
            xMLText = (XMLText)xMLText2.cloneNode(true);
            xMLText.setNodeValue(string.substring(0, this.difOffset));
            documentFragment.appendChild(xMLText);
        }
    }

    public DocumentFragment cloneContents() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        DocumentFragment documentFragment = this.ownerDoc.createDocumentFragment();
        if (this.collapsed) {
            return null;
        }
        if (this.startContainer == this.endContainer) {
            this.clone_when_StartEqualToEnd(documentFragment);
            return documentFragment;
        }
        if (this.isAncestor(this.startContainer, this.endContainer)) {
            this.clone_when_StartAncestorOfEnd(documentFragment);
            return documentFragment;
        }
        if (this.isAncestor(this.endContainer, this.startContainer)) {
            this.clone_when_EndAncestorOfStart(documentFragment);
            return documentFragment;
        }
        if (this.isTextNodeInserted) {
            this.clone_when_StartInsertedEnd_Text(documentFragment);
            return documentFragment;
        }
        this.clone(documentFragment);
        return documentFragment;
    }

    public void surroundContents(Node node) throws DOMException, RangeException {
        short s;
        XMLNode xMLNode;
        if (!this.valid) {
            throw new XMLDOMException(11, 21019, XMLDocument.defErr, "range");
        }
        for (xMLNode = (XMLNode)this.startContainer.getParentNode(); xMLNode != this.commonAncestorContainer && xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            s = xMLNode.getNodeType();
            if (this.selectivity(xMLNode) != 1 || s == 3 || s == 8 || s == 7) continue;
            throw new XMLRangeException(1);
        }
        for (xMLNode = (XMLNode)this.endContainer.getParentNode(); xMLNode != this.commonAncestorContainer && xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            s = xMLNode.getNodeType();
            if (this.selectivity(xMLNode) != 1 || s == 3 || s == 8 || s == 7) continue;
            throw new XMLRangeException(1);
        }
        s = node.getNodeType();
        if (s == 2 || s == 10 || s == 12 || s == 9 || s == 11) {
            throw new XMLRangeException(2);
        }
        XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)this.extractContents();
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        NodeList nodeList = node.getChildNodes();
        Node node2 = nodeList.item(0);
        Node node3 = null;
        if (node2 != null) {
            node3 = node2.getNextSibling();
        }
        while (node2 != null) {
            node.removeChild(node2);
            node2 = node3;
            if (node3 == null) continue;
            node3 = node3.getNextSibling();
        }
        node.appendChild(xMLDocumentFragment);
        this.insertNode(node);
    }

    public void handleEvent(Event event) {
        XMLRangeEvent xMLRangeEvent = (XMLRangeEvent)event;
        String string = xMLRangeEvent.getType();
        if (string.equals("RANGE_SETTEXT_EVENT")) {
            this.setTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getNewValue());
        } else if (string.equals("RANGE_INSERTTEXT_EVENT")) {
            this.insertTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getOffset(), xMLRangeEvent.getLength());
        } else if (string.equals("RANGE_DELETETEXT_EVENT")) {
            this.deleteTextNotify((XMLNode)xMLRangeEvent.getRelatedNode(), xMLRangeEvent.getOffset(), xMLRangeEvent.getLength());
        } else if (string.equals("RANGE_INSERT_EVENT")) {
            this.insertNotify((XMLNode)xMLRangeEvent.getRelatedNode());
        } else if (string.equals("RANGE_DELETE_EVENT")) {
            this.deleteNotify((XMLNode)xMLRangeEvent.getRelatedNode());
        } else if (string.equals("RANGE_REPLACE_EVENT")) {
            this.replaceNotify((XMLNode)xMLRangeEvent.getRelatedNode(), (XMLNode)xMLRangeEvent.getReplacingNode());
        }
        xMLRangeEvent.stopPropagation();
        event.preventDefault();
    }

    void setTextNotify(XMLNode xMLNode, String string) {
        int n = 0;
        if (this.mutation) {
            if (xMLNode == this.startContainer && (n = string.length()) - 1 < this.startOffset) {
                this.startOffset = n - 1;
            }
            if (xMLNode == this.endContainer && (n = string.length()) - 1 < this.endOffset) {
                this.endOffset = n - 1;
            }
        }
    }

    void insertTextNotify(XMLNode xMLNode, int n, int n2) {
        if (xMLNode == this.startContainer && --n < this.startOffset) {
            this.startOffset += n2;
        }
        if (xMLNode == this.endContainer && n < this.endOffset) {
            this.endOffset += n2;
        }
    }

    void deleteTextNotify(XMLNode xMLNode, int n, int n2) {
        if (xMLNode == this.startContainer && --n <= this.startOffset) {
            this.startOffset = n + n2 >= this.startOffset ? n : (this.startOffset -= n2);
        }
        if (xMLNode == this.endContainer && n <= this.startOffset) {
            this.endOffset = n + n2 >= this.endOffset ? n : (this.endOffset -= n2);
        }
    }

    void insertNotify(XMLNode xMLNode) {
        NodeList nodeList = null;
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        if (xMLNode2 == this.startContainer) {
            nodeList = xMLNode2.getChildNodes();
            int n = 0;
            int n2 = nodeList.getLength();
            for (Node node = nodeList.item(n); n < n2 && node != xMLNode; ++n, node = node.getNextSibling()) {
            }
            if (n <= this.startOffset) {
                ++this.startOffset;
            }
            if (n < this.endOffset && this.startContainer == this.endContainer) {
                ++this.endOffset;
            }
            return;
        }
        if (xMLNode2 == this.endContainer) {
            nodeList = xMLNode2.getChildNodes();
            int n = 0;
            int n3 = nodeList.getLength();
            for (Node node = nodeList.item(n); n < n3 && node != xMLNode; ++n, node = node.getNextSibling()) {
            }
            if (n <= this.endOffset) {
                ++this.endOffset;
            }
        }
    }

    void deleteNotify(XMLNode xMLNode) {
        Node node;
        NodeList nodeList = null;
        int n = 0;
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        int n2 = this.selectivity(xMLNode);
        if (n2 == 0 && xMLNode2 != this.startContainer && xMLNode2 != this.endContainer) {
            return;
        }
        if (n2 == 2 || this.commonAncestorContainer == xMLNode) {
            nodeList = xMLNode2.getChildNodes();
            n = 0;
            int n3 = nodeList.getLength();
            for (Node node2 = nodeList.item(n); n < n3 && node2 != xMLNode; node2 = node2.getNextSibling(), ++n) {
            }
            this.startContainer = xMLNode2;
            this.endContainer = xMLNode2;
            this.commonAncestorContainer = xMLNode2;
            this.startOffset = n;
            this.endOffset = n;
            this.collapsed = true;
            return;
        }
        for (node = this.startContainer; node != this.commonAncestorContainer; node = (XMLNode)node.getParentNode()) {
            if (node != xMLNode) continue;
            this.collapse(false);
            return;
        }
        for (node = this.endContainer; node != this.commonAncestorContainer; node = (XMLNode)node.getParentNode()) {
            if (node != xMLNode) continue;
            this.collapse(true);
            return;
        }
        if (xMLNode2 == this.startContainer) {
            nodeList = xMLNode2.getChildNodes();
            n = 0;
            int n4 = nodeList.getLength();
            for (node = nodeList.item(n); n < n4 && node != xMLNode; ++n, node = node.getNextSibling()) {
            }
            if (n < this.startOffset) {
                --this.startOffset;
            }
            if (xMLNode2 == this.endContainer && n <= this.endOffset) {
                --this.endOffset;
            }
            return;
        }
        if (xMLNode2 == this.endContainer) {
            nodeList = xMLNode2.getChildNodes();
            n = 0;
            int n5 = nodeList.getLength();
            for (node = nodeList.item(n); n < n5 && node != xMLNode; ++n, node = node.getNextSibling()) {
            }
            if (n <= this.endOffset) {
                --this.endOffset;
            }
            return;
        }
    }

    void replaceNotify(XMLNode xMLNode, XMLNode xMLNode2) {
        if (this.commonAncestorContainer == xMLNode || this.commonAncestorContainer.isAncestor(xMLNode)) {
            this.commonAncestorContainer = xMLNode2;
            this.startContainer = xMLNode2;
            this.endContainer = xMLNode2;
            this.startOffset = 0;
            this.endOffset = 0;
            this.collapsed = true;
            return;
        }
        if (this.startContainer.isAncestor(xMLNode)) {
            this.collapse(false);
            return;
        }
        if (this.endContainer.isAncestor(xMLNode)) {
            this.collapse(true);
            return;
        }
        if (this.startContainer == xMLNode) {
            this.startContainer = xMLNode2;
            short s = this.startContainer.getNodeType();
            if (s == 3 || s == 8 || s == 7) {
                String string = this.startContainer.getNodeValue();
                if (string.length() - 1 < this.startOffset) {
                    this.startOffset = string.length() - 1;
                }
            } else {
                NodeList nodeList = this.startContainer.getChildNodes();
                int n = nodeList.getLength();
                if (n - 1 < this.startOffset) {
                    this.startOffset = n - 1;
                }
            }
            this.setCommonAncestorContainer(true);
            return;
        }
        if (this.endContainer == xMLNode) {
            this.endContainer = xMLNode2;
            short s = this.endContainer.getNodeType();
            if (s == 3 || s == 8 || s == 7) {
                String string = this.endContainer.getNodeValue();
                if (string.length() - 1 < this.endOffset) {
                    this.startOffset = string.length() - 1;
                }
            } else {
                NodeList nodeList = this.endContainer.getChildNodes();
                int n = nodeList.getLength();
                if (n - 1 < this.startOffset) {
                    this.endOffset = n - 1;
                }
            }
            this.setCommonAncestorContainer(false);
            return;
        }
    }
}

