/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.poifs.property.Parent;
import org.apache.poi.poifs.property.Property;

public class DirectoryProperty
extends Property
implements Parent {
    private List _children = new ArrayList();
    private Set _children_names = new HashSet();

    public DirectoryProperty(String string) {
        this.setName(string);
        this.setSize(0);
        this.setPropertyType((byte)1);
        this.setStartBlock(0);
        this.setNodeColor((byte)1);
    }

    protected DirectoryProperty(int n, byte[] byArray, int n2) {
        super(n, byArray, n2);
    }

    public boolean changeName(Property property, String string) {
        boolean bl;
        String string2 = property.getName();
        property.setName(string);
        String string3 = property.getName();
        if (this._children_names.contains(string3)) {
            property.setName(string2);
            bl = false;
        } else {
            this._children_names.add(string3);
            this._children_names.remove(string2);
            bl = true;
        }
        return bl;
    }

    public boolean deleteChild(Property property) {
        boolean bl = this._children.remove(property);
        if (bl) {
            this._children_names.remove(property.getName());
        }
        return bl;
    }

    public boolean isDirectory() {
        return true;
    }

    protected void preWrite() {
        if (this._children.size() > 0) {
            int n;
            Property[] propertyArray = this._children.toArray(new Property[0]);
            Arrays.sort(propertyArray, new PropertyComparator(this));
            int n2 = propertyArray.length / 2;
            this.setChildProperty(propertyArray[n2].getIndex());
            propertyArray[0].setPreviousChild(null);
            propertyArray[0].setNextChild(null);
            for (n = 1; n < n2; ++n) {
                propertyArray[n].setPreviousChild(propertyArray[n - 1]);
                propertyArray[n].setNextChild(null);
            }
            if (n2 != 0) {
                propertyArray[n2].setPreviousChild(propertyArray[n2 - 1]);
            }
            if (n2 != propertyArray.length - 1) {
                propertyArray[n2].setNextChild(propertyArray[n2 + 1]);
                for (n = n2 + 1; n < propertyArray.length - 1; ++n) {
                    propertyArray[n].setPreviousChild(null);
                    propertyArray[n].setNextChild(propertyArray[n + 1]);
                }
                propertyArray[propertyArray.length - 1].setPreviousChild(null);
                propertyArray[propertyArray.length - 1].setNextChild(null);
            } else {
                propertyArray[n2].setNextChild(null);
            }
        }
    }

    public Iterator getChildren() {
        return this._children.iterator();
    }

    public void addChild(Property property) throws IOException {
        String string = property.getName();
        if (this._children_names.contains(string)) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Duplicate name \"").append(string).append("\""))));
        }
        this._children_names.add(string);
        this._children.add(property);
    }

    private class PropertyComparator
    implements Comparator {
        private PropertyComparator(DirectoryProperty directoryProperty) {
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int compare(Object object, Object object2) {
            String string = ((Property)object).getName();
            String string2 = ((Property)object2).getName();
            int n = string.length() - string2.length();
            if (n == 0) {
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

